/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.searcher.Searcher;
import org.brailleblaster.perspectives.braille.views.tree.BookTree2$firstTextChild$;
import org.brailleblaster.perspectives.braille.views.tree.BookTree2$hasBlocks$;
import org.brailleblaster.perspectives.braille.views.tree.BookTreeDialog;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.util.Notify;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010(\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010)\u001a\u0004\u0018\u00010$2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0006\u0010*\u001a\u00020'J\u0006\u0010+\u001a\u00020\u0018J\u0010\u0010,\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006."}, d2={"Lorg/brailleblaster/perspectives/braille/views/tree/BookTree2;", "", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "dialog", "Lorg/brailleblaster/perspectives/braille/views/tree/BookTreeDialog;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/views/tree/BookTreeDialog;)V", "getManager", "()Lorg/brailleblaster/perspectives/braille/Manager;", "getDialog", "()Lorg/brailleblaster/perspectives/braille/views/tree/BookTreeDialog;", "headings", "", "", "tree", "Lorg/eclipse/swt/widgets/Tree;", "root", "Lorg/eclipse/swt/widgets/TreeItem;", "getRoot", "()Lorg/eclipse/swt/widgets/TreeItem;", "setRoot", "(Lorg/eclipse/swt/widgets/TreeItem;)V", "initializeListeners", "", "e", "Lnu/xom/Element;", "setTree", "item", "setInitialLocation", "n", "Lnu/xom/Node;", "findElement", "getSection", "setNewItemData", "getText", "Lnu/xom/Text;", "getCenteredHeadingText", "isHeading", "", "hasBlocks", "firstTextChild", "navigate", "dispose", "isSection", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nBookTree2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookTree2.kt\norg/brailleblaster/perspectives/braille/views/tree/BookTree2\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,206:1\n479#2:207\n1276#2,2:208\n479#2:210\n184#2,2:211\n*S KotlinDebug\n*F\n+ 1 BookTree2.kt\norg/brailleblaster/perspectives/braille/views/tree/BookTree2\n*L\n167#1:207\n168#1:208,2\n173#1:210\n173#1:211,2\n*E\n"})
public final class BookTree2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager manager;
    @NotNull
    private final BookTreeDialog dialog;
    @Nullable
    private List<String> headings;
    @JvmField
    @NotNull
    public final Tree tree;
    @Nullable
    private TreeItem root;
    @NotNull
    private static final List<String> DEFAULT_HEADING_LIST;

    public BookTree2(@NotNull Manager manager, @NotNull BookTreeDialog dialog) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        this.manager = manager;
        this.dialog = dialog;
        this.tree = new Tree((Composite)this.dialog.getShell(), 0x10000800);
        this.setRoot(this.manager.getDocument().getRootElement());
        this.setInitialLocation(this.manager.getMapList().getCurrent().getNode());
        this.initializeListeners();
    }

    @NotNull
    public final Manager getManager() {
        return this.manager;
    }

    @NotNull
    public final BookTreeDialog getDialog() {
        return this.dialog;
    }

    @Nullable
    public final TreeItem getRoot() {
        return this.root;
    }

    public final void setRoot(@Nullable TreeItem treeItem) {
        this.root = treeItem;
    }

    private final void initializeListeners() {
        this.tree.addKeyListener((KeyListener)new KeyAdapter(this){
            final /* synthetic */ BookTree2 this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                boolean success;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.keyCode == 13 && (success = this.this$0.navigate())) {
                    this.this$0.getDialog().close();
                }
            }
        });
    }

    private final void setRoot(Element e) {
        TreeItem root = new TreeItem(this.tree, 18432);
        this.headings = DEFAULT_HEADING_LIST;
        root.setText(BBXUtils.INSTANCE.getDocumentTitle(this.manager));
        this.setTree(e, root);
        root.setExpanded(true);
    }

    private final void setTree(Element e, TreeItem item) {
        Elements els = e.getChildElements();
        int n = els.size();
        for (int i = 0; i < n; ++i) {
            Element element = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            if (this.isSection(element)) {
                if (this.hasBlocks(e)) {
                    TreeItem childItem = new TreeItem(item, 18432);
                    Element element2 = els.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"get(...)");
                    this.setNewItemData(childItem, element2);
                    Element element3 = els.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"get(...)");
                    this.setTree(element3, childItem);
                    continue;
                }
                Element element4 = els.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"get(...)");
                this.setTree(element4, item);
                continue;
            }
            if (Intrinsics.areEqual((Object)els.get(i).getLocalName(), (Object)"brl")) continue;
            Element element5 = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"get(...)");
            this.setTree(element5, item);
        }
    }

    private final void setInitialLocation(Node n) {
        if (n != null) {
            Element section = this.getSection(n);
            TreeItem treeItem = this.tree.getItem(0);
            Intrinsics.checkNotNullExpressionValue((Object)treeItem, (String)"getItem(...)");
            TreeItem item = this.findElement(section, treeItem);
            if (item != null) {
                this.tree.setSelection(item);
            }
        }
    }

    private final TreeItem findElement(Element e, TreeItem item) {
        int count = item.getItemCount();
        for (int i = 0; i < count; ++i) {
            Text t = this.getText(e);
            if (t != null && Intrinsics.areEqual((Object)item.getItems()[i].getData(), (Object)t)) {
                return item.getItem(i);
            }
            if (Intrinsics.areEqual((Object)item.getItems()[i].getData(), (Object)e)) {
                return item.getItem(i);
            }
            if (item.getItem(i).getItemCount() <= 0) continue;
            TreeItem treeItem = item.getItem(i);
            Intrinsics.checkNotNullExpressionValue((Object)treeItem, (String)"getItem(...)");
            TreeItem item2 = this.findElement(e, treeItem);
            if (item2 == null) continue;
            return item2;
        }
        return null;
    }

    private final Element getSection(Node n) {
        ParentNode p = n.getParent();
        while (!BBX.SECTION.isA((Node)p)) {
            p = p.getParent();
        }
        ParentNode parentNode = p;
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        return (Element)parentNode;
    }

    private final void setNewItemData(TreeItem item, Element e) {
        Text t = this.getText(e);
        if (t != null) {
            item.setData((Object)t);
            item.setText(t.getValue());
        } else {
            item.setData((Object)e);
            item.setText("SECTION");
        }
    }

    private final Text getText(Element e) {
        Elements els = e.getChildElements();
        int count = els.size();
        for (int i = 0; i < count; ++i) {
            if (!BBX.BLOCK.isA((Node)els.get(i))) continue;
            Element element = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            if (!this.isHeading(element)) continue;
            Element element2 = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"get(...)");
            return this.getCenteredHeadingText(element2);
        }
        return null;
    }

    private final Text getCenteredHeadingText(Element e) {
        int count = e.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = e.getChild(i);
            if (child instanceof Element && !Intrinsics.areEqual((Object)((Element)child).getLocalName(), (Object)"brl")) {
                Text t;
                Text text = t = this.getCenteredHeadingText((Element)child);
                if (text == null) continue;
                return text;
            }
            if (!(child instanceof Text)) continue;
            return (Text)child;
        }
        return null;
    }

    private final boolean isHeading(Element e) {
        Attribute atr = e.getAttribute("overrideStyle", "http://brailleblaster.org/ns/utd");
        if (atr != null) {
            List<String> list = this.headings;
            Intrinsics.checkNotNull(list);
            return list.contains(atr.getValue());
        }
        return false;
    }

    private final boolean hasBlocks(Element e) {
        boolean bl;
        block1: {
            Sequence $this$filterIsInstance$iv = FastXPath.descendant((Node)((Node)e));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)hasBlocks$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$any$iv = sequence;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Element node = (Element)element$iv;
                boolean bl2 = false;
                if (!(BBX.BLOCK.isA((Node)node) || BBX.CONTAINER.isA((Node)node) && this.firstTextChild(node) != null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final Text firstTextChild(Element e) {
        Object v1;
        block1: {
            Sequence $this$filterIsInstance$iv = FastXPath.descendant((Node)((Node)e));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)firstTextChild$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$firstOrNull$iv = sequence;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Text node = (Text)element$iv;
                boolean bl = false;
                if (!Searcher.Filters.noUTDAncestor((Node)node)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public final boolean navigate() {
        TreeItem item = this.tree.getSelection()[0];
        if (item != null && item.getData() != null) {
            if (item.getData() instanceof Text) {
                Object object = item.getData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type nu.xom.Text");
                Text t = (Text)object;
                this.manager.getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.TREE, new XMLTextCaret(t, 0, null, 4, null), null, 4, null));
                return true;
            }
            Notify.showMessage("Section has no text to navigate to, please select another", new Object[0]);
            return false;
        }
        return false;
    }

    public final void dispose() {
        this.tree.removeAll();
        this.tree.dispose();
    }

    private final boolean isSection(Element e) {
        return BBX.SECTION.isA((Node)e);
    }

    static {
        Object[] objectArray = new String[]{"Centered Heading", "Cell 5 Heading", "Cell 7 Heading", "h4", "h5", "h6"};
        DEFAULT_HEADING_LIST = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/perspectives/braille/views/tree/BookTree2$Companion;", "", "<init>", "()V", "DEFAULT_HEADING_LIST", "", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

