/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.tree;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.BBIni;
import org.brailleblaster.abstractClasses.AbstractView;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ImagePlaceholderTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.views.tree.BBTree;
import org.brailleblaster.perspectives.braille.views.tree.BookTree;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.utils.PropertyFileManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u001bj\b\u0012\u0004\u0012\u00020\u0012`\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lorg/brailleblaster/perspectives/braille/views/tree/TreeView;", "Lorg/brailleblaster/abstractClasses/AbstractView;", "Lorg/brailleblaster/perspectives/braille/views/tree/BBTree;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "parent", "Lorg/eclipse/swt/widgets/Composite;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/eclipse/swt/widgets/Composite;)V", "tree", "Lorg/eclipse/swt/widgets/Tree;", "getTree", "()Lorg/eclipse/swt/widgets/Tree;", "determineEvent", "Lorg/brailleblaster/perspectives/mvc/XMLNodeCaret;", "t", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "pos", "", "setViewData", "", "dispose", "findPageNode", "Lnu/xom/Text;", "e", "Lnu/xom/Element;", "itemPath", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getItemPath", "()Ljava/util/ArrayList;", "Companion", "brailleblaster-core"})
public abstract class TreeView
extends AbstractView
implements BBTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Tree tree;
    @NotNull
    private static final Logger logger;

    public TreeView(@NotNull Manager manager, @NotNull Composite parent) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(manager, parent);
        this.parent = parent;
        this.tree = new Tree(parent, 0x10000800);
    }

    @Override
    @NotNull
    public final Tree getTree() {
        return this.tree;
    }

    @NotNull
    protected final XMLNodeCaret determineEvent(@NotNull TextMapElement t, int pos) {
        XMLNodeCaret xMLNodeCaret;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        TextMapElement textMapElement = t;
        if (textMapElement instanceof BoxLineTextMapElement) {
            xMLNodeCaret = new XMLNodeCaret((Node)((BoxLineTextMapElement)t).getNodeParent(), null, 2, null);
        } else if (textMapElement instanceof ImagePlaceholderTextMapElement) {
            Node node = ((ImagePlaceholderTextMapElement)t).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            xMLNodeCaret = new XMLNodeCaret(node, null, 2, null);
        } else if (textMapElement instanceof WhiteSpaceElement) {
            TextMapElement textMapElement2 = this.getManager().getMapList().getClosest(pos, true);
            Intrinsics.checkNotNullExpressionValue((Object)textMapElement2, (String)"getClosest(...)");
            xMLNodeCaret = this.determineEvent(textMapElement2, 0);
        } else {
            Node node = t.getNode();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
            xMLNodeCaret = new XMLTextCaret((Text)node, pos, null, 4, null);
        }
        return xMLNodeCaret;
    }

    @Override
    protected void setViewData() {
    }

    @Override
    public void dispose() {
        this.tree.removeAll();
        this.tree.dispose();
    }

    @Nullable
    protected final Text findPageNode(@NotNull Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getChildCount() > 1 && e.getChild(1) instanceof Element) {
            Node node = e.getChild(1);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element brlNode = (Element)node;
            Node node2 = e.getChild(1);
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
            if (Intrinsics.areEqual((Object)((Element)node2).getLocalName(), (Object)"brl") && brlNode.getChildCount() > 0 && brlNode.getChild(0) instanceof Element) {
                Node node3 = brlNode.getChild(0);
                Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element spanNode = (Element)node3;
                if (Intrinsics.areEqual((Object)spanNode.getLocalName(), (Object)"span") && spanNode.getChild(0) instanceof Text) {
                    Node node4 = spanNode.getChild(0);
                    Intrinsics.checkNotNull((Object)node4, (String)"null cannot be cast to non-null type nu.xom.Text");
                    return (Text)node4;
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    public ArrayList<Integer> getItemPath() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        TreeItem[] treeItemArray = this.tree.getSelection();
        Intrinsics.checkNotNullExpressionValue((Object)treeItemArray, (String)"getSelection(...)");
        if (!(((Object[])treeItemArray).length == 0)) {
            TreeItem item = this.tree.getSelection()[0];
            int first = 0;
            while (item.getParentItem() != null) {
                list.add(first, item.getParentItem().indexOf(item));
                item = item.getParentItem();
            }
        }
        return list;
    }

    static {
        Logger logger = LoggerFactory.getLogger(TreeView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        TreeView.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ(\u0010\f\u001a\u0004\u0018\u00010\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/perspectives/braille/views/tree/TreeView$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "loadTree", "Lorg/brailleblaster/perspectives/braille/views/tree/BBTree;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "sash", "Lorg/eclipse/swt/custom/SashForm;", "createTree", "clss", "Ljava/lang/Class;", "manager", "sashform", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BBTree loadTree(@Nullable Manager m, @Nullable SashForm sash) {
            PropertyFileManager prop = BBIni.getPropertyFileManager();
            String tree = prop.getProperty("tree");
            if (tree == null) {
                String string = BookTree.class.getCanonicalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
                prop.save("tree", string);
                return new BookTree(m, sash);
            }
            if (Intrinsics.areEqual((Object)tree, (Object)"empty")) {
                return null;
            }
            try {
                Class<?> clss = Class.forName(tree);
                Intrinsics.checkNotNull(clss);
                return this.createTree(clss, m, sash);
            }
            catch (ClassNotFoundException e) {
                logger.error("Class Not Found Exception", (Throwable)e);
                return null;
            }
        }

        @Nullable
        public final BBTree createTree(@NotNull Class<?> clss, @Nullable Manager manager, @Nullable SashForm sashform) {
            Intrinsics.checkNotNullParameter(clss, (String)"clss");
            try {
                Class[] classArray = new Class[]{Manager.class, SashForm.class};
                Constructor<?> constructor = clss.getConstructor(classArray);
                Object[] objectArray = new Object[]{manager, sashform};
                Object obj = constructor.newInstance(objectArray);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.views.tree.BBTree");
                return (BBTree)obj;
            }
            catch (NoSuchMethodException e) {
                logger.error("No Such Method Exception", (Throwable)e);
            }
            catch (SecurityException e) {
                logger.error("Security Exception", (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error("Instantiation Exception", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("Illegal Access Exception", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error("Illegal Argument Exception", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error("Invocation Exception", (Throwable)e);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

