/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.math.ascii.ASCII2MathML;
import org.brailleblaster.math.mathml.MathAction;
import org.brailleblaster.math.mathml.MathMLElement;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.mathml.MathSubject;
import org.brailleblaster.math.mathml.MathUtils;
import org.brailleblaster.math.mathml.MathVerb;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TabTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.views.wp.MathEditHandler$makeMathFromTextViewSelection$;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.modules.misc.TableSelectionModule;
import org.brailleblaster.perspectives.mvc.modules.views.TextViewModule;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.Utils;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/MathEditHandler;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "makeMathFromTextViewSelection", "", "insertNew", "o", "Lorg/brailleblaster/math/mathml/MathSubject;", "addMathTextToExistingMathText", "", "Lnu/xom/Node;", "text", "", "translateAndReplaceAtCursor", "translateAndReplace", "mathNode", "replaceMathAtCursor", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nMathEditHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathEditHandler.kt\norg/brailleblaster/perspectives/braille/views/wp/MathEditHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,269:1\n1807#2,3:270\n1807#2,3:273\n1586#2:276\n1661#2,3:277\n479#3:280\n*S KotlinDebug\n*F\n+ 1 MathEditHandler.kt\norg/brailleblaster/perspectives/braille/views/wp/MathEditHandler\n*L\n60#1:270,3\n63#1:273,3\n69#1:276\n69#1:277,3\n77#1:280\n*E\n"})
public final class MathEditHandler {
    @NotNull
    public static final MathEditHandler INSTANCE = new MathEditHandler();
    private static final Logger log = LoggerFactory.getLogger(MathEditHandler.class);

    private MathEditHandler() {
    }

    /*
     * WARNING - void declaration
     */
    public final void makeMathFromTextViewSelection() {
        Node[] nodeArray;
        int n;
        void $this$mapTo$iv$iv;
        boolean bl;
        Object it;
        Set<TextMapElement> mapElements;
        Manager m;
        block17: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block16: {
                m = WPManager.Companion.getInstance().getController();
                log.debug("Make math from text view selection");
                mapElements = m.getMapList().getElementsOneByOne(m.getTextView().getSelection().x, m.getTextView().getSelection().y);
                Intrinsics.checkNotNull(mapElements);
                $this$any$iv = mapElements;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (TextMapElement)element$iv;
                        boolean bl3 = false;
                        if (!((TextMapElement)it).isReadOnly()) continue;
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                TableSelectionModule.Companion.displayInvalidTableMessage(m.getWpManager().getShell());
                return;
            }
            $this$any$iv = mapElements;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TextMapElement)element$iv;
                    boolean bl4 = false;
                    if (!BBXUtilsKt.isTOCText(((TextMapElement)it).getNode())) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            Notify.notify$default(Notify.INSTANCE, "Cannot insert math into TOC", Notify.ALERT_SHELL_NAME, false, 4, null);
            return;
        }
        List array = CollectionsKt.toList((Iterable)mapElements);
        Iterable $this$map$iv = array;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            TextMapElement textMapElement = (TextMapElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)m.getTextView().getText(), (String)"getText(...)");
            n = it2.getStart(m.getMapList());
            int n2 = it2.getEnd(m.getMapList());
            String string = nodeArray.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(TuplesKt.to((Object)it2, (Object)string));
        }
        List arrayWithStrings = (List)destination$iv$iv;
        int selectionStart = m.getTextView().getSelection().x;
        int selectionEnd = m.getTextView().getSelection().y;
        List<Node> blocks = MathUtils.INSTANCE.getBlocksFromTextMapElements(array);
        for (Node block : blocks) {
            int index = 0;
            List actions = new ArrayList();
            List toDetach = new ArrayList();
            Sequence $this$filterIsInstance$iv = FastXPath.descendant((Node)block);
            boolean $i$f$filterIsInstance = false;
            Intrinsics.checkNotNull((Object)SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)makeMathFromTextViewSelection$$inlined$filterIsInstance$1.INSTANCE), (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            for (Pair pair : arrayWithStrings) {
                Sequence textNodes;
                TextMapElement k = (TextMapElement)pair.component1();
                String s = (String)pair.component2();
                if (k instanceof TabTextMapElement) {
                    Node node = ((TabTextMapElement)k).getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                    toDetach.add(node);
                } else if (k instanceof MathMLElement) {
                    Node node = ((MathMLElement)k).getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                    actions.add(new MathAction(new MathSubject(node), MathVerb.Verb.MakeMath));
                    Node node2 = ((MathMLElement)k).getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
                    toDetach.add(node2);
                }
                for (Text j : textNodes) {
                    if (k.getNode() != j || k instanceof MathMLElement) continue;
                    Node node = k.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                    index = BBXUtils.INSTANCE.getIndexInBlock(node);
                    int start = k.getStart(m.getMapList());
                    int startOffset = selectionStart - start > 0 ? selectionStart - start : 0;
                    int endOffset = selectionEnd - start < s.length() ? selectionEnd - start : s.length();
                    actions.addAll((Collection)MathUtils.INSTANCE.wrapInMath(startOffset, endOffset, s));
                    toDetach.add(j);
                }
            }
            MathAction.Companion.execute(actions, block, index);
            n = ((Collection)toDetach).size();
            for (int l = 0; l < n; ++l) {
                ((Node)toDetach.get(l)).detach();
            }
            nodeArray = new Node[]{block};
            m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.MATH, true, nodeArray));
        }
    }

    public final void insertNew(@NotNull MathSubject o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Manager m = WPManager.Companion.getInstance().getController();
        TextMapElement textMapElement = m.getMapList().getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        TextMapElement mapElement = textMapElement;
        if (!MathModuleUtils.isMath(mapElement.getNode())) {
            Object s;
            if (mapElement.isReadOnly()) {
                TableSelectionModule.Companion.displayInvalidTableMessage(m.getWpManager().getShell());
                return;
            }
            Node block = null;
            int index = 0;
            int offset = 0;
            int newBlockIndex = 0;
            String before = null;
            String after = null;
            if (mapElement.getNode() == null || mapElement instanceof LineBreakElement) {
                if (m.getSimpleManager().getCurrentCaret().getCursorPosition() == XMLNodeCaret.CursorPosition.BEFORE) {
                    TextMapElement previousTme = m.getMapList().findPreviousNonWhitespace(m.getMapList().indexOf(mapElement));
                    if (previousTme != null) {
                        Node node = previousTme.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                        Node previousBlock = (Node)BBXUtilsKt.findBlockOrContainer(node);
                        ParentNode blockParent = previousBlock.getParent();
                        newBlockIndex = blockParent.indexOf(previousBlock);
                        Element element = BBX.BLOCK.DEFAULT.create();
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
                        block = (Node)element;
                        Intrinsics.checkNotNull((Object)blockParent);
                        Utils.insertChildCountSafe(blockParent, block, newBlockIndex);
                    } else {
                        ParentNode blockParent = BBXUtilsKt.findBlockOrContainer(m.getSimpleManager().getCurrentCaret().getNode()).getParent();
                        Element element = BBX.BLOCK.DEFAULT.create();
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
                        block = (Node)element;
                        Intrinsics.checkNotNull((Object)blockParent);
                        Utils.insertChildCountSafe(blockParent, block, 0);
                    }
                } else {
                    TextMapElement nextTme = m.getMapList().findNextNonWhitespace(m.getMapList().indexOf(mapElement));
                    if (nextTme != null) {
                        Node node = nextTme.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                        Node nextBlock = (Node)BBXUtilsKt.findBlockOrContainer(node);
                        ParentNode blockParent = nextBlock.getParent();
                        newBlockIndex = blockParent.indexOf(nextBlock);
                        Element element = BBX.BLOCK.DEFAULT.create();
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
                        block = (Node)element;
                        Intrinsics.checkNotNull((Object)blockParent);
                        Utils.insertChildCountSafe(blockParent, block, newBlockIndex);
                    } else {
                        Element blockOrContainer = BBXUtilsKt.findBlockOrContainer(m.getSimpleManager().getCurrentCaret().getNode());
                        ParentNode blockParent = blockOrContainer.getParent();
                        int indexOfBlock = blockParent.indexOf((Node)blockOrContainer);
                        Element element = BBX.BLOCK.DEFAULT.create();
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
                        block = (Node)element;
                        Intrinsics.checkNotNull((Object)blockParent);
                        Utils.insertChildCountSafe(blockParent, block, indexOfBlock + 2);
                    }
                }
                index = 0;
                before = after = "";
            } else {
                if (BBXUtilsKt.isTOCText(mapElement.getNode())) {
                    Notify.notify$default(Notify.INSTANCE, "Cannot insert math into TOC", Notify.ALERT_SHELL_NAME, false, 4, null);
                    return;
                }
                Node node = mapElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                block = (Node)BBXUtilsKt.findBlock(node);
                Node node2 = mapElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
                index = BBXUtils.INSTANCE.getIndexInBlock(node2);
                if (mapElement instanceof MathMLElement) {
                    before = after = "";
                    if (m.getTextView().getCaretOffset() >= mapElement.getEnd(m.getMapList())) {
                        ++index;
                    }
                } else {
                    int length = mapElement.getText().length();
                    offset = m.getTextView().getCaretOffset() - mapElement.getStart(m.getMapList()) < length ? m.getTextView().getCaretOffset() - mapElement.getStart(m.getMapList()) : length;
                    String string = m.getTextView().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    CharSequence charSequence = string;
                    int n = mapElement.getStart(m.getMapList());
                    int n2 = mapElement.getEnd(m.getMapList());
                    String string2 = charSequence.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    s = string2;
                    charSequence = StringsKt.take((String)s, (int)offset);
                    Regex regex = new Regex("\n");
                    String string3 = "";
                    charSequence = regex.replace(charSequence, string3);
                    regex = new Regex("\r");
                    string3 = "";
                    before = regex.replace(charSequence, string3);
                    String string4 = ((String)s).substring(offset);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    charSequence = string4;
                    regex = new Regex("\n");
                    string3 = "";
                    charSequence = regex.replace(charSequence, string3);
                    regex = new Regex("\r");
                    string3 = "";
                    after = regex.replace(charSequence, string3);
                    mapElement.getNode().detach();
                }
            }
            ArrayList<MathAction> array = MathUtils.INSTANCE.wrapInMath(before, o, after);
            MathAction.Companion.execute((List<MathAction>)array, block, index);
            s = new Node[]{block};
            m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.MATH, true, (Node[])s));
            String translatedText = o.getString();
            Node node = o.getNode();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            if (((Element)node).getAttributeValue("alttext") != null) {
                translatedText = MathModuleUtils.getMathText(o.getNode());
            }
            TextViewModule.Companion.setCursorAfterInsert(m, translatedText.length(), Sender.MATH);
        } else {
            String text = o.getString();
            int offset = m.getTextView().getCaretOffset();
            int mapStart = mapElement.getStart(m.getMapList());
            String string = mapElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String mapElementText = string;
            int index = offset - mapStart;
            if (index < 0) {
                index = 0;
            } else if (index > mapElementText.length()) {
                index = mapElementText.length();
            }
            String firstHalf = StringsKt.take((String)mapElementText, (int)index);
            String string5 = mapElementText.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String lastHalf = string5;
            this.addMathTextToExistingMathText(firstHalf + text + lastHalf);
        }
    }

    private final List<Node> addMathTextToExistingMathText(String text) {
        Manager m = WPManager.Companion.getInstance().getController();
        if (((CharSequence)text).length() == 0) {
            return new ArrayList();
        }
        TextMapElement textMapElement = m.getMapList().getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        TextMapElement mapElement = textMapElement;
        ParentNode block = null;
        if (mapElement.getNode() instanceof ParentNode) {
            Node node = mapElement.getNode();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            UTDHelper.stripUTDRecursive((Element)((Element)node));
        }
        Node mathNode = ASCII2MathML.translate(text);
        Element element = mapElement.getNodeParent();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
        Node parent = (Node)element;
        ((ParentNode)parent).replaceChild(mapElement.getNode(), mathNode);
        block = (ParentNode)BBXUtilsKt.findBlock(mathNode);
        Node[] nodeArray = new Node[]{parent};
        m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.MATH, true, nodeArray));
        ArrayList<ParentNode> array = new ArrayList<ParentNode>();
        array.add(block);
        return array;
    }

    public final void translateAndReplaceAtCursor(@NotNull MathSubject o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Node node = WPManager.Companion.getInstance().getController().getMapList().getCurrent().getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        this.translateAndReplace(o, node);
    }

    public final void translateAndReplace(@NotNull MathSubject o, @NotNull Node mathNode) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)mathNode, (String)"mathNode");
        Manager m = WPManager.Companion.getInstance().getController();
        ParentNode block = (ParentNode)BBXUtilsKt.findBlock(mathNode);
        int index = BBXUtils.INSTANCE.getIndexInBlock(mathNode);
        Node math = o.getNode();
        Node parent = block.getChild(index);
        block.replaceChild(parent, math);
        Element element = BBX.INLINE.MATHML.create();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        XMLHandler.Companion.wrapNodeWithElement(math, element);
        Node[] nodeArray = new Node[]{block};
        m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.MATH, true, nodeArray));
    }

    public final void replaceMathAtCursor(@NotNull MathSubject o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Manager m = WPManager.Companion.getInstance().getController();
        if (MathModuleUtils.isMath(m.getMapList().getCurrent().getNode())) {
            this.translateAndReplaceAtCursor(o);
        } else {
            this.insertNew(o);
        }
    }
}

