/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathMLElement;
import org.brailleblaster.math.mathml.MathMLTableElement;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BraillePageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BrlOnlyBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.GuideDotsTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.GuideWordBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ImagePlaceholderTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.LineNumberBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.NewPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageBreakWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PaintedWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PrintPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.RunningHeadBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TabTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableCellTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.UncontractedWordTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.views.wp.Renderer;
import org.brailleblaster.perspectives.braille.views.wp.RendererState;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Utils;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u000b\u0018\u0000 K2\u00020\u0001:\u0001KB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%J\u0016\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020(2\u0006\u0010$\u001a\u00020%J\u000e\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u001eJ\u0016\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020 2\u0006\u0010$\u001a\u00020%J\u0010\u0010-\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%J \u0010.\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020%H\u0002J(\u00101\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u0002032\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00104\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002J \u00105\u001a\u00020\"2\u0006\u0010#\u001a\u0002062\u0006\u00107\u001a\u0002002\u0006\u0010$\u001a\u00020%H\u0002J \u00108\u001a\u00020\"2\u0006\u0010#\u001a\u0002062\u0006\u00107\u001a\u0002002\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020<H\u0002J\u0018\u0010=\u001a\u00020\"2\u0006\u00107\u001a\u0002002\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010>\u001a\u0004\u0018\u0001002\u0006\u0010?\u001a\u000203H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u000200H\u0002J\u0012\u0010C\u001a\u0004\u0018\u0001002\u0006\u0010D\u001a\u000203H\u0002J\b\u0010E\u001a\u00020\"H\u0002J\b\u0010F\u001a\u00020\"H\u0002J\b\u0010G\u001a\u00020\"H\u0002J\u0018\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/TextRenderer;", "Lorg/brailleblaster/perspectives/braille/views/wp/Renderer;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "textView", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/views/wp/TextView;)V", "state", "Lorg/brailleblaster/perspectives/braille/views/wp/RendererState;", "getState", "()Lorg/brailleblaster/perspectives/braille/views/wp/RendererState;", "setState", "(Lorg/brailleblaster/perspectives/braille/views/wp/RendererState;)V", "emphasisList", "", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "getEmphasisList", "()Ljava/util/List;", "setEmphasisList", "(Ljava/util/List;)V", "lineNumberList", "", "Lkotlin/Pair;", "", "Lorg/brailleblaster/perspectives/braille/mapping/elements/LineNumberBrlMapElement;", "pastFirstNewPage", "", "pastLastNewPage", "lastTab", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TabTextMapElement;", "lastPageBreak", "Lorg/brailleblaster/perspectives/braille/mapping/elements/PageBreakWhiteSpaceElement;", "add", "", "t", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "appendToView", "addTable", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TableTextMapElement;", "addTab", "tab", "addPageBreak", "pb", "finishRendering", "renderBrailleList", "brl", "Lnu/xom/Element;", "checkForMoveTo", "brlText", "Lnu/xom/Node;", "setLastPageBreakPos", "adjustTableSpacing", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TableCellTextMapElement;", "moveTo", "checkTableStartOffsets", "handleBrlOnlyMapElement", "tme", "bme", "Lorg/brailleblaster/perspectives/braille/mapping/elements/BrailleMapElement;", "onNewLine", "getEmphasisNode", "node", "getIndexArray", "", "e", "getBrlNode", "n", "renderEmphasis", "renderNewPages", "renderLineNumbers", "handleLineNumber", "g", "insertPos", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nTextRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRenderer.kt\norg/brailleblaster/perspectives/braille/views/wp/TextRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,565:1\n812#2,12:566\n231#2,2:578\n812#2,12:581\n742#2,9:593\n1#3:580\n37#4,2:602\n37#4,2:604\n*S KotlinDebug\n*F\n+ 1 TextRenderer.kt\norg/brailleblaster/perspectives/braille/views/wp/TextRenderer\n*L\n111#1:566,12\n111#1:578,2\n179#1:581,12\n444#1:593,9\n444#1:602,2\n496#1:604,2\n*E\n"})
public final class TextRenderer
extends Renderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextView textView;
    @NotNull
    private RendererState state;
    @NotNull
    private List<? extends TextMapElement> emphasisList;
    @NotNull
    private final List<Pair<Integer, LineNumberBrlMapElement>> lineNumberList;
    private boolean pastFirstNewPage;
    private boolean pastLastNewPage;
    @Nullable
    private TabTextMapElement lastTab;
    @Nullable
    private PageBreakWhiteSpaceElement lastPageBreak;
    public static final char NON_BREAKING_SPACE = '\u00a0';
    public static final int NON_BREAKING_SPACE_COLOR = 2;

    public TextRenderer(@NotNull Manager manager, @NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        super(manager, textView);
        this.textView = textView;
        this.state = new RendererState(manager.getSimpleManager().getUtdManager().getEngine());
        this.emphasisList = new ArrayList();
        this.lineNumberList = new ArrayList();
        this.pastFirstNewPage = false;
        this.pastLastNewPage = false;
    }

    @NotNull
    public final RendererState getState() {
        return this.state;
    }

    public final void setState(@NotNull RendererState rendererState) {
        Intrinsics.checkNotNullParameter((Object)rendererState, (String)"<set-?>");
        this.state = rendererState;
    }

    @NotNull
    public final List<TextMapElement> getEmphasisList() {
        return this.emphasisList;
    }

    public final void setEmphasisList(@NotNull List<? extends TextMapElement> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.emphasisList = list;
    }

    public final void add(@NotNull TextMapElement t, @NotNull MapList list) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        TextMapElement textMapElement = t;
        if (textMapElement instanceof TableTextMapElement) {
            this.addTable((TableTextMapElement)t, list);
        } else {
            if (textMapElement instanceof LineBreakElement) {
                if (!this.pastFirstNewPage || this.pastLastNewPage) {
                    ((LineBreakElement)t).setFullyVisible(false);
                } else {
                    this.addLineBreak((LineBreakElement)t, this.state, list);
                }
                return;
            }
            if (textMapElement instanceof TabTextMapElement) {
                this.addTab((TabTextMapElement)t);
            } else if (textMapElement instanceof PageBreakWhiteSpaceElement) {
                this.addPageBreak((PageBreakWhiteSpaceElement)t, list);
            } else {
                if (textMapElement instanceof ImagePlaceholderTextMapElement || textMapElement instanceof WhiteSpaceElement) {
                    return;
                }
                this.appendToView(t, list);
            }
        }
        t.setEnd(this.state.getCharCount());
        if (t.getStart(list) == -1) {
            t.setStart(t.getEnd(list));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void appendToView(@NotNull TextMapElement t, @NotNull MapList list) {
        block14: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Node n = t.getNode();
            Intrinsics.checkNotNull((Object)n);
            Element brl = this.getBrlNode(n);
            if (brl == null) {
                Element element;
                TextMapElement textMapElement = t;
                if (textMapElement instanceof BoxLineTextMapElement && UTDElements.BRL.isA(((BoxLineTextMapElement)t).getNode())) {
                    Node node = ((BoxLineTextMapElement)t).getNode();
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                    element = (Element)node;
                } else if (textMapElement instanceof GuideDotsTextMapElement && UTDElements.BRLONLY.isA(((GuideDotsTextMapElement)t).getNode())) {
                    element = t.getNodeParent();
                } else if (textMapElement instanceof MathMLElement) {
                    Node node = MathModuleUtils.INSTANCE.getBrl(n);
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                    element = (Element)node;
                } else if (textMapElement instanceof PageIndicatorTextMapElement) {
                    Object element$iv2;
                    block13: {
                        void $this$first$iv;
                        Iterator $this$filterIsInstanceTo$iv$iv;
                        Node node = ((PageIndicatorTextMapElement)t).getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                        Iterable $this$filterIsInstance$iv = NodeUtilsKt.getChildNodes((Node)node);
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv$iv = iterator.next();
                            if (!(element$iv$iv instanceof Element)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            Element it = (Element)element$iv2;
                            boolean bl = false;
                            if (!UTDElements.BRL.isA((Node)it)) continue;
                            break block13;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    element = (Element)element$iv2;
                } else if (textMapElement instanceof UncontractedWordTextMapElement && UTDElements.BRLONLY.isA(((UncontractedWordTextMapElement)t).getNode())) {
                    element = t.getNodeParent();
                } else {
                    throw new NullPointerException("No brl found");
                }
                brl = element;
            }
            Element element = brl;
            if (element == null) break block14;
            Element it = element;
            boolean bl = false;
            this.renderBrailleList(t, it, list);
        }
    }

    public final void addTable(@NotNull TableTextMapElement t, @NotNull MapList list) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.state.setTableMode(true);
        t.tableElements.forEach(arg_0 -> TextRenderer.addTable$lambda$0(this, list, arg_0));
        this.state.setTableMode(false);
    }

    public final void addTab(@NotNull TabTextMapElement tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        this.lastTab = tab;
        tab.setStart(this.state.getCharCount());
    }

    public final void addPageBreak(@NotNull PageBreakWhiteSpaceElement pb, @NotNull MapList list) {
        int index;
        Intrinsics.checkNotNullParameter((Object)pb, (String)"pb");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        if (list.indexOf(pb) == 0) {
            pb.setStart(0);
            this.lastPageBreak = pb;
            return;
        }
        if (this.lastTab != null) {
            TabTextMapElement tabTextMapElement = this.lastTab;
            Intrinsics.checkNotNull((Object)tabTextMapElement);
            tabTextMapElement.setOffsets(this.state.getCharCount(), this.state.getCharCount());
            this.lastTab = null;
        }
        for (index = list.indexOf(pb) - 1; index > 0 && list.get(index) instanceof PaintedWhiteSpaceElement; --index) {
        }
        pb.setStart(((TextMapElement)list.get(index)).getEnd(list) + ConstantsKt.getLINE_BREAK().length());
        this.lastPageBreak = pb;
    }

    public final void finishRendering(@Nullable MapList list) {
        this.state.finishPage();
        this.textView.getView().setText(this.state.getText());
        this.renderLineIndents(this.state.getLineIndents(), this.textView);
        this.renderEmphasis();
        this.renderNewPages();
        this.renderLineNumbers();
        MapList mapList = list;
        Intrinsics.checkNotNull((Object)mapList);
        this.addLastPageIndicator(mapList, this.textView);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderBrailleList(TextMapElement t, Element brl, MapList list) {
        Iterator $this$filterIsInstanceTo$iv$iv;
        Element element;
        int start = 0;
        int end = 0;
        int totalLength = 0;
        boolean firstText = true;
        int[] indexes = this.getIndexArray(brl);
        if (UTDElements.BRL.isA(t.getNode())) {
            element = null;
        } else {
            Node node = t.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            element = this.getEmphasisNode(node);
        }
        Element emphasisNode = element;
        Iterable $this$filterIsInstance$iv = NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)brl));
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof Text)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        int n = 0;
        for (Object object : $this$filterIsInstance$iv) {
            void it;
            Text $i$f$filterIsInstanceTo2 = (Text)object;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getValue().length();
            n = n2 + n3;
        }
        int brlTextLength = n;
        boolean mathAdded = false;
        if (t.brailleList.isEmpty()) {
            String string = t.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.state.addToLine(string);
        } else {
            Iterator iterator2 = t.brailleList.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object object;
                BrailleMapElement bme = (BrailleMapElement)iterator3.next();
                object = bme;
                if (object instanceof NewPageBrlMapElement) {
                    if (bme == this.firstPage) {
                        this.pastFirstNewPage = true;
                    }
                    if (bme == this.lastPage) {
                        this.pastLastNewPage = true;
                    }
                    Node node = ((NewPageBrlMapElement)bme).getNode();
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                    this.state.newPage((Element)node);
                    continue;
                }
                if (object instanceof PrintPageBrlMapElement || object instanceof BraillePageBrlMapElement || object instanceof RunningHeadBrlMapElement || object instanceof GuideWordBrlMapElement) continue;
                if (object instanceof LineNumberBrlMapElement) {
                    this.handleBrlOnlyMapElement(t, bme);
                    continue;
                }
                if (!this.pastFirstNewPage) {
                    if (t.getNode() instanceof Text && !(bme instanceof BrlOnlyBrlMapElement)) {
                        totalLength += bme.getText().length();
                        if (indexes != null) {
                            end = indexes[totalLength - 1] + 1;
                            if (totalLength == indexes.length) {
                                String string = t.getNode().getValue();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                                String string2 = string.substring(start);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                                t.appendInvisibleText(string2);
                            } else {
                                String string = t.getNode().getValue();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                                String string3 = string.substring(start, end);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                                t.appendInvisibleText(string3);
                            }
                            start = end;
                        }
                    }
                    t.setFullyVisible(false);
                    continue;
                }
                if (this.pastLastNewPage) {
                    t.setFullyVisible(false);
                    if (this.lastPageBreak != null) {
                        PageBreakWhiteSpaceElement pageBreakWhiteSpaceElement = this.lastPageBreak;
                        Intrinsics.checkNotNull((Object)pageBreakWhiteSpaceElement);
                        pageBreakWhiteSpaceElement.setEnd(this.state.getCharCount());
                        this.lastPageBreak = null;
                    }
                    if (indexes == null) continue;
                    if (totalLength != indexes.length) {
                        String string = t.getNode().getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        String string4 = string.substring(end);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        t.appendInvisibleText(string4);
                    }
                    totalLength = indexes.length;
                    continue;
                }
                Node node = bme.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                this.checkForMoveTo(t, brl, node, list);
                if (t.getStart(list) == -1) {
                    t.setStart(this.state.getCharCountWithPendingSpaces());
                }
                if (emphasisNode != null) {
                    Node node2 = t.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
                    this.state.applyEmphasis(this.getEmphasisNode(node2));
                }
                if (bme instanceof BrlOnlyBrlMapElement) {
                    this.handleBrlOnlyMapElement(t, bme);
                    continue;
                }
                totalLength += bme.getText().length();
                if (t instanceof MathMLElement || t instanceof MathMLTableElement) {
                    if (!mathAdded) {
                        String string = t.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        this.state.addToLine(string);
                        mathAdded = true;
                    } else {
                        this.state.applyEmphasis(null);
                    }
                } else if (indexes != null) {
                    String string;
                    if (firstText) {
                        for (int i = 0; i < t.getText().length(); ++i) {
                            boolean brlMatchesIndexesLength;
                            String string5 = bme.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                            if (!(((CharSequence)string5).length() > 0)) break;
                            boolean bl = brlMatchesIndexesLength = indexes.length > brlTextLength;
                            if (t.getText().charAt(i) != ' ' || bme.getText().charAt(0) == ' ' || !brlMatchesIndexesLength) break;
                            ++totalLength;
                        }
                        firstText = false;
                    }
                    end = indexes[totalLength - 1] + 1;
                    if (totalLength == indexes.length) {
                        String string6 = t.getNode().getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getValue(...)");
                        String string7 = string6.substring(start);
                        string = string7;
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                    } else {
                        String string8 = t.getNode().getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getValue(...)");
                        String string9 = string8.substring(start, end);
                        string = string9;
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                    }
                    String lineContent = string;
                    this.state.addToLine(lineContent);
                }
                start = end;
            }
        }
    }

    private final void checkForMoveTo(TextMapElement t, Element brl, Node brlText, MapList list) {
        int brlIndex = brl.indexOf(brlText);
        if (brlIndex > 0 && UTDElements.MOVE_TO.isA(brl.getChild(brlIndex - 1))) {
            Node node = brl.getChild(brlIndex - 1);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element moveTo = (Element)node;
            if (t instanceof TableCellTextMapElement) {
                this.adjustTableSpacing((TableCellTextMapElement)t, moveTo, list);
            } else {
                int index = brl.getParent().indexOf((Node)brl);
                if (index - 2 > 0 && BBX.SPAN.PROSE_LINE_NUMBER.isA(brl.getParent().getChild(index - 2))) {
                    this.state.setLineNumber(true);
                }
                if (Utils.INSTANCE.vPosToLines(this.manager, this.getVPos(moveTo)) != this.state.getY()) {
                    this.onNewLine(moveTo, list);
                }
                this.state.moveTo(this.getHPos(moveTo), this.getVPos(moveTo));
                if (this.lastTab != null && this.lastPageBreak != null) {
                    TabTextMapElement tabTextMapElement = this.lastTab;
                    Intrinsics.checkNotNull((Object)tabTextMapElement);
                    tabTextMapElement.setOffsets(this.state.getCharCount(), this.state.getCharCount());
                    this.lastTab = null;
                }
            }
            if (this.lastTab != null) {
                TabTextMapElement tabTextMapElement = this.lastTab;
                Intrinsics.checkNotNull((Object)tabTextMapElement);
                tabTextMapElement.setEnd(this.state.getCharCountWithPendingSpaces());
                int n = t.getStart(list);
                TabTextMapElement tabTextMapElement2 = this.lastTab;
                Intrinsics.checkNotNull((Object)tabTextMapElement2);
                if (n < tabTextMapElement2.getEnd(list)) {
                    TabTextMapElement tabTextMapElement3 = this.lastTab;
                    Intrinsics.checkNotNull((Object)tabTextMapElement3);
                    t.setStart(tabTextMapElement3.getEnd(list));
                }
                this.lastTab = null;
            }
            if (this.lastPageBreak != null) {
                this.setLastPageBreakPos(list);
            }
        }
    }

    private final void setLastPageBreakPos(MapList list) {
        MapList mapList = list;
        PageBreakWhiteSpaceElement pageBreakWhiteSpaceElement = this.lastPageBreak;
        if (pageBreakWhiteSpaceElement == null) {
            MapList mapList2 = mapList;
            boolean $i$a$-requireNotNull-TextRenderer$setLastPageBreakPos$index$22 = false;
            MapList mapList3 = mapList2;
            String $i$a$-requireNotNull-TextRenderer$setLastPageBreakPos$index$22 = "No last page break.";
            throw new IllegalArgumentException($i$a$-requireNotNull-TextRenderer$setLastPageBreakPos$index$22.toString());
        }
        int index = mapList.indexOf(pageBreakWhiteSpaceElement);
        if (!(index != -1)) {
            boolean $i$a$-require-TextRenderer$setLastPageBreakPos$22 = false;
            String $i$a$-require-TextRenderer$setLastPageBreakPos$22 = "PageBreak not in MapList";
            throw new IllegalArgumentException($i$a$-require-TextRenderer$setLastPageBreakPos$22.toString());
        }
        List followingLineBreaks = new ArrayList();
        int lineBreakIndex = index;
        while (lineBreakIndex + 1 < list.size() && list.get(lineBreakIndex + 1) instanceof LineBreakElement) {
            Object e = list.get(lineBreakIndex + 1);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement");
            followingLineBreaks.add((LineBreakElement)e);
            ++lineBreakIndex;
        }
        int pageBreakEnd = this.state.getCharCount() - ConstantsKt.getLINE_BREAK().length() - followingLineBreaks.size() * System.lineSeparator().length();
        PageBreakWhiteSpaceElement pageBreakWhiteSpaceElement2 = this.lastPageBreak;
        Intrinsics.checkNotNull((Object)pageBreakWhiteSpaceElement2);
        pageBreakWhiteSpaceElement2.setEnd(pageBreakEnd);
        PageBreakWhiteSpaceElement pageBreakWhiteSpaceElement3 = this.lastPageBreak;
        Intrinsics.checkNotNull((Object)pageBreakWhiteSpaceElement3);
        int n = pageBreakWhiteSpaceElement3.getEnd(list);
        PageBreakWhiteSpaceElement pageBreakWhiteSpaceElement4 = this.lastPageBreak;
        Intrinsics.checkNotNull((Object)pageBreakWhiteSpaceElement4);
        if (n <= pageBreakWhiteSpaceElement4.getStart(list)) {
            PageBreakWhiteSpaceElement pageBreakWhiteSpaceElement5 = this.lastPageBreak;
            Intrinsics.checkNotNull((Object)pageBreakWhiteSpaceElement5);
            PageBreakWhiteSpaceElement pageBreakWhiteSpaceElement6 = this.lastPageBreak;
            Intrinsics.checkNotNull((Object)pageBreakWhiteSpaceElement6);
            pageBreakWhiteSpaceElement5.setEnd(pageBreakWhiteSpaceElement6.getStart(list));
        }
        this.lastPageBreak = null;
    }

    private final void adjustTableSpacing(TableCellTextMapElement t, Element moveTo, MapList list) {
        int column = t.getCol();
        TableTextMapElement parent = t.getParentTableMapElement();
        this.checkTableStartOffsets(t, moveTo, list);
        int colWidth = 0;
        for (int col = 0; col < column; ++col) {
            colWidth += parent.getColumns()[col].getPrintWidth();
            colWidth += 2;
        }
        this.state.moveTo(this.cell.getWidthForCells(colWidth).doubleValue(), this.getVPos(moveTo));
    }

    private final void checkTableStartOffsets(TableCellTextMapElement t, Element moveTo, MapList list) {
        this.state.moveTo(0.0, this.getVPos(moveTo));
        int charCountAtOffset = this.state.getCharCountToVPos(this.cell.getLinesForHeight(new BigDecimal(String.valueOf(this.getVPos(moveTo)))));
        if (t.getParentTableMapElement().getStart(list) == -1 || t.getParentTableMapElement().getStart(list) > charCountAtOffset) {
            t.getParentTableMapElement().setStart(charCountAtOffset);
        }
    }

    private final void handleBrlOnlyMapElement(TextMapElement tme, BrailleMapElement bme) {
        if (bme instanceof LineNumberBrlMapElement) {
            this.lineNumberList.add((Pair<Integer, LineNumberBrlMapElement>)TuplesKt.to((Object)this.state.getCharCount(), (Object)bme));
        } else if (!(bme instanceof GuideWordBrlMapElement) && !(bme instanceof RunningHeadBrlMapElement)) {
            if (bme instanceof BoxLineBrlMapElement || bme instanceof PageIndicatorBrlMapElement) {
                String string = tme.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.state.addToLine(string);
            } else if (!(tme instanceof TableCellTextMapElement)) {
                String string = bme.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.state.addToLine(string);
            }
        }
    }

    private final void onNewLine(Element moveTo, MapList list) {
        if (this.lastTab != null) {
            TabTextMapElement tabTextMapElement = this.lastTab;
            Intrinsics.checkNotNull((Object)tabTextMapElement);
            tabTextMapElement.setStart(this.state.getCharCount());
            if (Utils.INSTANCE.vPosToLines(this.manager, this.getVPos(moveTo)) == this.state.getY() + 1) {
                TabTextMapElement tabTextMapElement2 = this.lastTab;
                Intrinsics.checkNotNull((Object)tabTextMapElement2);
                tabTextMapElement2.setEnd(this.state.getCharCount() + System.lineSeparator().length());
            } else {
                TabTextMapElement tabTextMapElement3 = this.lastTab;
                Intrinsics.checkNotNull((Object)tabTextMapElement3);
                TabTextMapElement tabTextMapElement4 = this.lastTab;
                Intrinsics.checkNotNull((Object)tabTextMapElement4);
                tabTextMapElement3.setEnd(tabTextMapElement4.getStart(list));
            }
            this.lastTab = null;
        }
    }

    private final Element getEmphasisNode(Node node) {
        ParentNode parent = node.getParent();
        while (!BBX.BLOCK.isA((Node)parent) && !BBX.SECTION.isA((Node)parent)) {
            if (BBX.INLINE.EMPHASIS.isA((Node)parent) || BBX.INLINE.MATHML.isA((Node)parent) || BBX.INLINE.LINK.isA((Node)parent)) {
                ParentNode parentNode = parent;
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                return (Element)parentNode;
            }
            parent = parent.getParent();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final int[] getIndexArray(Element e) {
        Attribute atr = e.getAttribute("index");
        if (atr != null) {
            String arr = atr.getValue();
            Intrinsics.checkNotNull((Object)arr);
            if (((CharSequence)arr).length() > 0) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                Object object = arr;
                Regex regex = new Regex(" ");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] tokens = thisCollection$iv.toArray(new String[0]);
                int[] indexArray = new int[tokens.length];
                int n2 = tokens.length;
                for (int i = 0; i < n2; ++i) {
                    indexArray[i] = Integer.parseInt(tokens[i]);
                }
                return indexArray;
            }
        }
        return null;
    }

    private final Element getBrlNode(Node n) {
        int index = 0;
        ParentNode parentNode = n.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element e = (Element)parentNode;
        index = e.indexOf(n);
        if (index != e.getChildCount() - 1 && UTDElements.BRL.isA(e.getChild(index + 1))) {
            Node node = e.getChild(index + 1);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            return (Element)node;
        }
        return null;
    }

    private final void renderEmphasis() {
        this.textView.getRanges().clear();
        List<RendererState.Emphasis> emphasisList = this.state.getEmphasis();
        for (RendererState.Emphasis e : emphasisList) {
            if (BBX.INLINE.MATHML.isA((Node)e.getInlineNode())) {
                this.textView.addMathHighlights(e.getStart(), e.getEnd() - e.getStart(), e.getInlineNode());
                continue;
            }
            if (BBX.INLINE.LINK.isA((Node)e.getInlineNode())) {
                this.textView.addLinkStyleRange(e.getStart(), e.getEnd() - e.getStart(), e.getInlineNode());
                continue;
            }
            this.textView.setFontStyleRange(e.getStart(), e.getEnd() - e.getStart(), this.manager.getAction((Node)e.getInlineNode()), e.getInlineNode());
        }
        Collection $this$toTypedArray$iv = this.textView.getRanges();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.textView.getView().setStyleRanges(thisCollection$iv.toArray(new StyleRange[0]));
        for (StyleRange curStyleRange : Companion.setNonBreakingSpaceEmphasis(this.textView.getView(), 0, this.textView.getView().getCharCount())) {
            this.textView.getView().setStyleRange(curStyleRange);
        }
    }

    private final void renderNewPages() {
        List<Pair<Integer, Element>> newPages = this.state.getNewPages();
        for (Pair<Integer, Element> pair : newPages) {
            this.handleNewPageElement(((Number)pair.getFirst()).intValue(), (Element)pair.getSecond(), this.textView);
        }
    }

    private final void renderLineNumbers() {
        for (Pair<Integer, LineNumberBrlMapElement> lineNumber : this.lineNumberList) {
            this.handleLineNumber((LineNumberBrlMapElement)lineNumber.getSecond(), ((Number)lineNumber.getFirst()).intValue());
        }
    }

    private final void handleLineNumber(LineNumberBrlMapElement g, int insertPos) {
        this.textView.paintedElements.add(g);
        g.startListener(this.manager, this.textView, insertPos);
    }

    private static final void addTable$lambda$0(TextRenderer this$0, MapList $list, TableCellTextMapElement tcme) {
        Intrinsics.checkNotNullParameter((Object)tcme, (String)"tcme");
        this$0.appendToView(tcme, $list);
    }

    @JvmStatic
    public static final void setNonBreakingSpaceStyleRange(@NotNull StyleRange sr) {
        Companion.setNonBreakingSpaceStyleRange(sr);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/TextRenderer$Companion;", "", "<init>", "()V", "NON_BREAKING_SPACE", "", "NON_BREAKING_SPACE_COLOR", "", "setNonBreakingSpaceEmphasis", "", "Lorg/eclipse/swt/custom/StyleRange;", "view", "Lorg/eclipse/swt/custom/StyledText;", "viewTextStart", "viewTextLength", "(Lorg/eclipse/swt/custom/StyledText;II)[Lorg/eclipse/swt/custom/StyleRange;", "setNonBreakingSpaceStyleRange", "", "sr", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nTextRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRenderer.kt\norg/brailleblaster/perspectives/braille/views/wp/TextRenderer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,565:1\n1#2:566\n37#3,2:567\n*S KotlinDebug\n*F\n+ 1 TextRenderer.kt\norg/brailleblaster/perspectives/braille/views/wp/TextRenderer$Companion\n*L\n554#1:567,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StyleRange[] setNonBreakingSpaceEmphasis(@NotNull StyledText view, int viewTextStart, int viewTextLength) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            List results = new ArrayList();
            String text = view.getTextRange(viewTextStart, viewTextLength);
            int start = 0;
            while (true) {
                int n;
                Intrinsics.checkNotNull((Object)text);
                int it = n = StringsKt.indexOf$default((CharSequence)text, (char)'\u00a0', (int)start, (boolean)false, (int)4, null);
                boolean bl = false;
                start = it;
                if (n == -1) break;
                int len = 1;
                while (text.length() > start + len && text.charAt(start + len) == '\u00a0') {
                    ++len;
                }
                StyleRange nbspRange = new StyleRange();
                nbspRange.start = viewTextStart + start;
                nbspRange.length = len;
                this.setNonBreakingSpaceStyleRange(nbspRange);
                results.add(nbspRange);
                start += len;
            }
            Collection $this$toTypedArray$iv = results;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new StyleRange[0]);
        }

        @JvmStatic
        public final void setNonBreakingSpaceStyleRange(@NotNull StyleRange sr) {
            Intrinsics.checkNotNullParameter((Object)sr, (String)"sr");
            sr.borderColor = Display.getCurrent().getSystemColor(2);
            sr.borderStyle = 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

