/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.exceptions.CursorMovementException;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.FormattingWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.GuideDotsBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicator;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PaintedWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyTableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.interfaces.Uneditable;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.AdjustRangeMessage;
import org.brailleblaster.perspectives.braille.messages.InsertNodeMessage;
import org.brailleblaster.perspectives.braille.messages.Message;
import org.brailleblaster.perspectives.braille.messages.SelectionMessage;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.messages.UpdateMessage;
import org.brailleblaster.perspectives.braille.messages.WhitespaceMessage;
import org.brailleblaster.perspectives.braille.views.style.BreadcrumbsToolbar;
import org.brailleblaster.perspectives.braille.views.wp.Selection;
import org.brailleblaster.perspectives.braille.views.wp.SixKeyHandler;
import org.brailleblaster.perspectives.braille.views.wp.TextVerifyKeyListener;
import org.brailleblaster.perspectives.braille.views.wp.ViewStateObject;
import org.brailleblaster.perspectives.braille.views.wp.WPView;
import org.brailleblaster.perspectives.braille.views.wp.formatters.EditRecorder;
import org.brailleblaster.perspectives.braille.views.wp.listeners.ImageDisposeListener;
import org.brailleblaster.perspectives.braille.views.wp.listeners.ImagePaintListener;
import org.brailleblaster.perspectives.braille.views.wp.listeners.WPPaintListener;
import org.brailleblaster.perspectives.braille.views.wp.listeners.WPScrollListener;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.actions.GenericBlockAction;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.FormUIUtils;
import org.brailleblaster.utils.swt.AccessibilityUtils;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedAdapter;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u00a0\u00012\u00020\u0001:\u0002\u00a0\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\b\u0010:\u001a\u000208H\u0002J\u000e\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020\u0014J\b\u0010=\u001a\u000208H\u0002J\u0006\u0010>\u001a\u000208J\u000e\u0010?\u001a\u0002082\u0006\u0010@\u001a\u00020\u000fJ\u000e\u0010A\u001a\u0002082\u0006\u0010@\u001a\u00020\u000fJ\u0018\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020+H\u0002J\u0018\u0010E\u001a\u0002082\u0006\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020\u000fH\u0002J\u0010\u0010H\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020+H\u0002J\u0010\u0010I\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u000fH\u0002J\u0010\u0010K\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u000fH\u0002J\u0018\u0010L\u001a\u0002082\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u000fH\u0002J\b\u0010P\u001a\u000208H\u0014J\u0010\u0010Q\u001a\u0002082\u0006\u0010C\u001a\u00020\u000fH\u0002J\u0010\u0010R\u001a\u0002082\u0006\u0010C\u001a\u00020\u000fH\u0002J\u0010\u0010S\u001a\u0002082\u0006\u0010C\u001a\u00020\u000fH\u0002J\u000e\u0010T\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000fJ\u0010\u0010U\u001a\u0002082\u0006\u0010V\u001a\u00020WH\u0002J\u0010\u0010X\u001a\u0002082\u0006\u0010V\u001a\u00020WH\u0002J\u0010\u0010Y\u001a\u0002082\u0006\u0010V\u001a\u00020WH\u0002J\u000e\u0010Z\u001a\u0002082\u0006\u0010[\u001a\u00020\u000fJ\u0018\u0010\\\u001a\u0002082\u0006\u0010V\u001a\u00020W2\u0006\u0010]\u001a\u00020\u0014H\u0002J\u0016\u0010^\u001a\u00020N2\u0006\u0010_\u001a\u00020\u000f2\u0006\u0010`\u001a\u00020\u000fJ\u0006\u0010a\u001a\u000208J\u001e\u0010b\u001a\u0002082\u0006\u0010c\u001a\u00020N2\u0006\u0010_\u001a\u00020\u000f2\u0006\u0010d\u001a\u00020\u000fJ\u000e\u0010e\u001a\u0002082\u0006\u0010f\u001a\u00020\u000fJ\u0012\u0010j\u001a\u0002082\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0006\u0010k\u001a\u000208J\u0018\u0010l\u001a\u0002082\u0006\u0010_\u001a\u00020\u000f2\u0006\u0010`\u001a\u00020\u000fH\u0002J\u0016\u0010m\u001a\u0002082\u0006\u0010_\u001a\u00020\u000f2\u0006\u0010d\u001a\u00020\u000fJ\u001f\u0010n\u001a\u0002082\b\u0010o\u001a\u0004\u0018\u00010p2\b\u0010@\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010qJ\u0010\u0010r\u001a\u0002082\u0006\u0010s\u001a\u00020\u0005H\u0016J\u0006\u0010t\u001a\u000208J\u0016\u0010y\u001a\u0002082\u0006\u0010_\u001a\u00020\u000f2\u0006\u0010d\u001a\u00020\u000fJ\u0006\u0010z\u001a\u000208J\b\u0010l\u001a\u000208H\u0002J\u001e\u0010{\u001a\u0002082\u0006\u0010_\u001a\u00020\u000f2\u0006\u0010`\u001a\u00020\u000f2\u0006\u0010c\u001a\u00020NJ\b\u0010|\u001a\u000208H\u0002J\u0006\u0010}\u001a\u000208J\u0010\u0010~\u001a\u00020\u00142\u0006\u0010\u007f\u001a\u00020\u000fH\u0002J\u0011\u0010\u0080\u0001\u001a\u00020\u00142\u0006\u0010\u007f\u001a\u00020\u000fH\u0002J\t\u0010\u0081\u0001\u001a\u00020\u0014H\u0002J\t\u0010\u0082\u0001\u001a\u00020\u0014H\u0002J\t\u0010\u0083\u0001\u001a\u00020\u0014H\u0002J\u0011\u0010\u0084\u0001\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u000fH\u0002J\t\u0010\u0085\u0001\u001a\u00020\u0014H\u0002J\u0011\u0010\u0086\u0001\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u000fH\u0002J\u0015\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\u0007\u0010\u0089\u0001\u001a\u00020\u000fH\u0002J\u0015\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u0088\u00012\u0007\u0010\u0089\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u008b\u0001\u001a\u000208H\u0002J\u0011\u0010\u008c\u0001\u001a\u0002082\u0006\u0010@\u001a\u00020\u000fH\u0002J\u0007\u0010\u0099\u0001\u001a\u000208J\u0007\u0010\u009a\u0001\u001a\u000208J\u000f\u0010\u009b\u0001\u001a\u0002082\u0006\u00102\u001a\u00020\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010,\u001a\u0004\u0018\u00010+2\b\u0010\u000e\u001a\u0004\u0018\u00010+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00100\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010g\u001a\u0004\u0018\u00010\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bh\u0010iR\u0011\u0010u\u001a\u00020v8F\u00a2\u0006\u0006\u001a\u0004\bw\u0010xR\u0013\u0010\u008d\u0001\u001a\u00020\u000f8F\u00a2\u0006\u0007\u001a\u0005\b\u008e\u0001\u0010\u0012R\u0013\u0010\u008f\u0001\u001a\u00020\u000f8F\u00a2\u0006\u0007\u001a\u0005\b\u0090\u0001\u0010\u0012R/\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0091\u00012\t\u0010V\u001a\u0005\u0018\u00010\u0091\u00018F@FX\u0086\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0093\u0001\u0010\u0094\u0001\"\u0006\b\u0095\u0001\u0010\u0096\u0001R\u0017\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0091\u00018F\u00a2\u0006\b\u001a\u0006\b\u0098\u0001\u0010\u0094\u0001R)\u0010\u009c\u0001\u001a\u00020\u00142\u0007\u0010\u009c\u0001\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\u000f\u001a\u0005\b\u009d\u0001\u00101\"\u0006\b\u009e\u0001\u0010\u009f\u0001\u00a8\u0006\u00a1\u0001"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "Lorg/brailleblaster/perspectives/braille/views/wp/WPView;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "sash", "Lorg/eclipse/swt/widgets/Composite;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/eclipse/swt/widgets/Composite;)V", "state", "Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;", "getState", "()Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;", "selection", "Lorg/brailleblaster/perspectives/braille/views/wp/Selection;", "value", "", "currentChanges", "getCurrentChanges", "()I", "textChanged", "", "range", "Lorg/eclipse/swt/custom/StyleRange;", "selectionListener", "Lorg/eclipse/swt/events/SelectionAdapter;", "scrollbarListener", "Lorg/brailleblaster/perspectives/braille/views/wp/listeners/WPScrollListener;", "verifyKeyListener", "Lorg/eclipse/swt/custom/VerifyKeyListener;", "modListener", "Lorg/eclipse/swt/custom/ExtendedModifyListener;", "focusListener", "Lorg/eclipse/swt/events/FocusAdapter;", "caretListener", "Lorg/eclipse/swt/custom/CaretListener;", "mouseListener", "Lorg/eclipse/swt/events/MouseAdapter;", "paintObjListener", "Lorg/eclipse/swt/custom/PaintObjectListener;", "paintListener", "Lorg/eclipse/swt/events/PaintListener;", "menuKeyListener", "Lorg/eclipse/swt/widgets/Listener;", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "currentElement", "getCurrentElement", "()Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "currentIndex", "isMultiSelected", "()Z", "focusListenerLock", "editRecorder", "Lorg/brailleblaster/perspectives/braille/views/wp/formatters/EditRecorder;", "keyHandler", "Lorg/brailleblaster/perspectives/braille/views/wp/SixKeyHandler;", "initializeListeners", "", "removeListeners", "addAccessibilityListener", "update", "forceUpdate", "sendUpdate", "scrollToCursor", "setCurrentElement", "pos", "setCurrent", "calculateTextOffset", "offset", "tme", "setSelectionElements", "startPos", "endPos", "lengthOfGuideDotsInTME", "isLastInView", "index", "isFirstInView", "sendAdjustRangeMessage", "type", "", "position", "setViewData", "makeTextChange", "incrementNext", "shiftLeft", "setCursor", "handleTextEdit", "e", "Lorg/eclipse/swt/custom/ExtendedModifyEvent;", "handleTextDeletion", "deleteSelection", "adjustCurrentElementValues", "changes", "recordEvent", "edit", "getString", "start", "length", "cut", "copyAndPaste", "text", "end", "updateCursor", "offsetFromTMEStart", "styleRange", "getStyleRange", "()Lorg/eclipse/swt/custom/StyleRange;", "checkStyleRange", "resetSelectionObject", "setSelection", "highlight", "insertNewNode", "m", "Lorg/brailleblaster/perspectives/braille/messages/InsertNodeMessage;", "(Lorg/brailleblaster/perspectives/braille/messages/InsertNodeMessage;Ljava/lang/Integer;)V", "resetView", "parent", "resetOffsets", "selectedText", "", "getSelectedText", "()[I", "setCurrentSelection", "clearSelection", "undoEdit", "reapplyStyle", "updateContextMenu", "isArrowKey", "keyCode", "isNavKey", "atRunningHeadLine", "atGuideWordLine", "atPrintPageLine", "offsetIsPrintPageNumberLine", "atBraillePageLine", "offsetIsBraillePageNumberLine", "getPreviousPageIndicator", "Lorg/brailleblaster/perspectives/braille/mapping/elements/PageIndicator;", "caretOffset", "getNextPageIndicator", "setStateObject", "setLocalState", "currentStart", "getCurrentStart", "currentEnd", "getCurrentEnd", "Lnu/xom/Element;", "selectionElement", "getSelectionElement", "()Lnu/xom/Element;", "setSelectionElement", "(Lnu/xom/Element;)V", "previousSelection", "getPreviousSelection", "addFocusListener", "removeFocusListener", "setFocusListenerLock", "sixKeyMode", "getSixKeyMode", "setSixKeyMode", "(Z)V", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nTextView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextView.kt\norg/brailleblaster/perspectives/braille/views/wp/TextView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1172:1\n1#2:1173\n*E\n"})
public final class TextView
extends WPView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewStateObject state;
    @NotNull
    private final Selection selection;
    private int currentChanges;
    @JvmField
    public boolean textChanged;
    @Nullable
    private StyleRange range;
    @Nullable
    private SelectionAdapter selectionListener;
    @Nullable
    private WPScrollListener scrollbarListener;
    @Nullable
    private VerifyKeyListener verifyKeyListener;
    @Nullable
    private ExtendedModifyListener modListener;
    @Nullable
    private FocusAdapter focusListener;
    @Nullable
    private CaretListener caretListener;
    @Nullable
    private MouseAdapter mouseListener;
    @Nullable
    private PaintObjectListener paintObjListener;
    @Nullable
    private PaintListener paintListener;
    @Nullable
    private Listener menuKeyListener;
    @Nullable
    private TextMapElement currentElement;
    private int currentIndex;
    private boolean isMultiSelected;
    private boolean focusListenerLock;
    @NotNull
    private EditRecorder editRecorder;
    @Nullable
    private SixKeyHandler keyHandler;
    private static final Logger logger = LoggerFactory.getLogger(TextView.class);
    @NotNull
    private static final String NAME = "Text View";

    public TextView(@NotNull Manager manager, @NotNull Composite sash) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)sash, (String)"sash");
        super(manager, sash);
        this.state = new ViewStateObject(0, 0, 0, 0, 0, 0, 0, 0, 0, 511, null);
        this.selection = new Selection();
        this.editRecorder = new EditRecorder(manager, this);
        this.isMultiSelected = false;
        this.focusListenerLock = false;
        this.addAccessibilityListener();
    }

    @NotNull
    public final ViewStateObject getState() {
        return this.state;
    }

    public final int getCurrentChanges() {
        return this.currentChanges;
    }

    @Nullable
    public final TextMapElement getCurrentElement() {
        return this.currentElement;
    }

    public final boolean isMultiSelected() {
        return this.isMultiSelected;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initializeListeners() {
        Object it;
        void it2;
        SelectionAdapter selectionAdapter;
        super.initializeListeners();
        Object object = selectionAdapter = new SelectionAdapter(this){
            final /* synthetic */ TextView this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.x != e.y) {
                    TextView.access$setSelection(this.this$0);
                } else {
                    TextView.access$setSelection(this.this$0);
                }
            }
        };
        StyledText styledText = this.getView();
        boolean $i$a$-also-TextView$initializeListeners$42 = false;
        this.selectionListener = (SelectionAdapter)it2;
        styledText.addSelectionListener((SelectionListener)selectionAdapter);
        TextVerifyKeyListener vkl = new TextVerifyKeyListener(this.getManager(), this, this.state, this.selection, this.getValidator(), this.editRecorder);
        this.keyHandler = new SixKeyHandler(null, vkl, Boolean.getBoolean("sixKey"));
        Object $i$a$-also-TextView$initializeListeners$42 = object = this.keyHandler;
        styledText = this.getView();
        boolean bl = false;
        this.verifyKeyListener = (VerifyKeyListener)it;
        styledText.addVerifyKeyListener((VerifyKeyListener)object);
        this.getView().addKeyListener((KeyListener)this.keyHandler);
        it = object = arg_0 -> TextView.initializeListeners$lambda$2(this, arg_0);
        styledText = this.getView();
        boolean bl2 = false;
        this.modListener = it;
        styledText.addExtendedModifyListener((ExtendedModifyListener)object);
        this.addFocusListener();
        it = object = arg_0 -> TextView.initializeListeners$lambda$4(this, arg_0);
        int n = 35;
        styledText = this.getView();
        boolean bl3 = false;
        this.menuKeyListener = it;
        Unit unit = Unit.INSTANCE;
        styledText.addListener(n, (Listener)object);
        it = object = arg_0 -> TextView.initializeListeners$lambda$6(this, arg_0);
        styledText = this.getView();
        boolean bl4 = false;
        this.caretListener = it;
        styledText.addCaretListener((CaretListener)object);
        it = object = new MouseAdapter(this){
            final /* synthetic */ TextView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseDown(MouseEvent e) {
                block28: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.button == 1 && e.stateMask == SWT.MOD1) {
                        TextMapElement textMapElement = TextView.access$getManager(this.this$0).getMapList().getCurrent();
                        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
                        TextMapElement current = textMapElement;
                        if (BBX.INLINE.LINK.isA((Node)current.getNodeParent())) {
                            ParentNode parentNode = current.getNode().getParent();
                            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                            Element el = (Element)parentNode;
                            boolean isExternal = Boolean.parseBoolean(el.getAttributeValue("external", "http://brailleblaster.org/ns/bb"));
                            String href = el.getAttributeValue("href", "http://brailleblaster.org/ns/bb");
                            try {
                                CharSequence charSequence = href;
                                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                                    if (isExternal) {
                                        Desktop.getDesktop().browse(new URI(href));
                                        break block28;
                                    }
                                    String xpath = "//*[@*[local-name() = 'linkID']]";
                                    Nodes nodes = TextView.access$getManager(this.this$0).getSimpleManager().getDoc().query(xpath);
                                    Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"query(...)");
                                    List internalLinkNodes = CollectionsKt.toList((Iterable)((Iterable)nodes));
                                    for (Node node : internalLinkNodes) {
                                        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                                        Element np = (Element)node;
                                        String linkID = np.getAttributeValue("linkID", "http://brailleblaster.org/ns/bb").toString();
                                        if (!Intrinsics.areEqual((Object)linkID, (Object)href)) continue;
                                        TextView.access$getManager(this.this$0).getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.GO_TO_PAGE, new XMLNodeCaret((Node)np, null, 2, null), null, 4, null));
                                        break block28;
                                    }
                                    break block28;
                                }
                                TextView.access$getLogger$cp().warn("Tried to open a link with no href attribute");
                            }
                            catch (Exception xpath) {}
                        } else if (BBX.BLOCK.IMAGE_PLACEHOLDER.isA((Node)current.getNodeParent())) {
                            String src = current.getNodeParent().getAttributeValue("src", "http://brailleblaster.org/ns/utd");
                            try {
                                CharSequence isExternal = src;
                                if (!(isExternal == null || isExternal.length() == 0)) {
                                    System.out.println((Object)("Opening image placeholder with src: " + src));
                                    Desktop.getDesktop().open(new File(src));
                                }
                            }
                            catch (Exception ex) {
                                TextView.access$getLogger$cp().warn("Error opening image placeholder: " + ex.getMessage());
                            }
                        }
                    }
                }
                if (e.button == 2) {
                    return;
                }
                if (e.button == 3 && !this.this$0.getView().isTextSelected()) {
                    try {
                        int offsetPoint = this.this$0.getView().getOffsetAtPoint((Point)new Point.WithMonitor(e.x, e.y, Display.getCurrent().getPrimaryMonitor()));
                        this.this$0.getView().setCaretOffset(offsetPoint);
                        if (offsetPoint < 0) {
                            int line = this.this$0.getView().getLineIndex(e.y);
                            int offsetStart = this.this$0.getView().getOffsetAtLine(line);
                            int offsetAmount = this.this$0.getView().getLine(line).length();
                            int offsetEnd = offsetStart + offsetAmount;
                            this.this$0.getView().setCaretOffset(offsetStart);
                            Point myCaret = this.this$0.getView().getCaret().getLocation();
                            int estEndPoint = myCaret.x + offsetAmount * 10;
                            if (e.x > myCaret.x && e.x > estEndPoint) {
                                this.this$0.getView().setCaretOffset(offsetEnd);
                            }
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        int line = this.this$0.getView().getLineIndex(e.y);
                        this.this$0.getView().setCaretOffset(this.this$0.getView().getOffsetAtLine(line));
                    }
                }
                int currentStart = this.this$0.getState().getCurrentStart();
                int currentEnd = this.this$0.getState().getCurrentEnd();
                int offsetStart = this.this$0.getView().getCaretOffset();
                if (!(currentStart <= offsetStart ? offsetStart <= currentEnd : false)) {
                    if (this.this$0.textChanged) {
                        TextView.access$sendUpdate(this.this$0);
                    }
                    if (this.this$0.getView().isTextSelected() && this.this$0.getView().getSelectionRanges()[1] > 0) {
                        TextView.access$setSelectionElements(this.this$0, TextView.access$getSelection$p((TextView)this.this$0).selectionStart, TextView.access$getSelection$p(this.this$0).getSelectionEnd());
                    } else {
                        this.this$0.setCurrent(this.this$0.getView().getCaretOffset());
                    }
                    this.this$0.sendStatusBarUpdate(this.this$0.getView().getLineAtOffset(this.this$0.getView().getCaretOffset()));
                } else if (!this.this$0.textChanged && this.this$0.getView().getCaretOffset() >= this.this$0.getState().getOriginalStart() && this.this$0.getView().getCaretOffset() < this.this$0.getState().getOriginalEnd()) {
                    if (this.this$0.getView().isTextSelected() && TextView.access$getSelection$p(this.this$0).getSelectionLength() > 0) {
                        TextView.access$setSelectionElements(this.this$0, TextView.access$getSelection$p((TextView)this.this$0).selectionStart, TextView.access$getSelection$p(this.this$0).getSelectionEnd());
                    } else {
                        this.this$0.setCurrent(this.this$0.getView().getCaretOffset());
                    }
                    this.this$0.sendStatusBarUpdate(this.this$0.getView().getLineAtOffset(this.this$0.getView().getCaretOffset()));
                }
                if (TextView.access$atRunningHeadLine(this.this$0) || TextView.access$atGuideWordLine(this.this$0)) {
                    int line = this.this$0.getView().getLineAtOffset(this.this$0.getView().getCaretOffset());
                    this.this$0.getView().setCaretOffset(line < this.this$0.getView().getLineCount() ? this.this$0.getView().getOffsetAtLine(line + 1) : (line == 0 ? this.this$0.getView().getLineAtOffset(1) : this.this$0.getView().getOffsetAtLine(line - 1)));
                    return;
                }
                this.this$0.updateContextMenu();
                if (this.this$0.getView().getSelectionRange().y == 0) {
                    TextView.access$getSelection$p(this.this$0).setSelectionLength(0);
                }
            }
        };
        styledText = this.getView();
        boolean bl5 = false;
        this.mouseListener = (MouseAdapter)it;
        styledText.addMouseListener((MouseListener)object);
        it = object = new WPScrollListener(this.getManager(), this, Sender.TEXT);
        styledText = this.getView().getVerticalBar();
        boolean bl6 = false;
        this.scrollbarListener = it;
        styledText.addSelectionListener((SelectionListener)object);
        this.getView().getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        it = object = new ImagePaintListener();
        styledText = this.getView();
        boolean bl7 = false;
        this.paintObjListener = (PaintObjectListener)it;
        styledText.addPaintObjectListener((PaintObjectListener)object);
        this.getView().addListener(12, (Listener)new ImageDisposeListener(this.getView()));
        it = object = new WPPaintListener(this, Sender.TEXT);
        styledText = this.getView();
        boolean bl8 = false;
        this.paintListener = (PaintListener)it;
        styledText.addPaintListener((PaintListener)object);
        this.getView().addModifyListener(this.getViewMod());
        AccessibilityUtils.setName((Control)((Control)this.getView()), (String)NAME);
    }

    @Override
    public void removeListeners() {
        if (this.selectionListener != null) {
            super.removeListeners();
            this.getView().removeModifyListener(this.getViewMod());
            this.getView().removeSelectionListener((SelectionListener)this.selectionListener);
            this.getView().removeExtendedModifyListener(this.modListener);
            this.getView().removeFocusListener((FocusListener)this.focusListener);
            this.getView().removeKeyListener((KeyListener)this.keyHandler);
            this.getView().removeVerifyKeyListener(this.verifyKeyListener);
            this.getView().removeMouseListener((MouseListener)this.mouseListener);
            this.getView().removeCaretListener(this.caretListener);
            this.getView().getVerticalBar().removeSelectionListener((SelectionListener)this.scrollbarListener);
            this.getView().removePaintObjectListener(this.paintObjListener);
            this.getView().removePaintListener(this.paintListener);
            this.getView().removeListener(35, this.menuKeyListener);
            this.removeAllPaintedElements(this);
        }
    }

    private final void addAccessibilityListener() {
        this.getView().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.result = BreadcrumbsToolbar.Companion.getEnabled() ? BreadcrumbsToolbar.Companion.getCrumb_string() : "";
            }
        });
        this.getView().getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextExtendedAdapter(this){
            final /* synthetic */ TextView this$0;
            {
                this.this$0 = $receiver;
            }

            public void getText(AccessibleTextEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int line = this.this$0.getView().getLineAtOffset(e.start);
                if (e.end == this.this$0.getView().getOffsetAtLine(line) + this.this$0.getView().getLine(line).length() || e.end == this.this$0.getView().getOffsetAtLine(line) + this.this$0.getView().getLine(line).length() + ConstantsKt.getLINE_BREAK().length()) {
                    if (TextView.access$offsetIsPrintPageNumberLine(this.this$0, e.start)) {
                        PageIndicator pageIndicator = TextView.access$getPreviousPageIndicator(this.this$0, e.start);
                        Intrinsics.checkNotNull((Object)pageIndicator);
                        String pageNum = pageIndicator.getPrintPageNum();
                        if (pageNum != null) {
                            e.result = e.result + " " + pageNum;
                        }
                    } else if (TextView.access$offsetIsBraillePageNumberLine(this.this$0, e.start)) {
                        PageIndicator pageIndicator = TextView.access$getNextPageIndicator(this.this$0, e.start);
                        Intrinsics.checkNotNull((Object)pageIndicator);
                        String pageNum = pageIndicator.getBraillePageNum();
                        if (pageNum != null) {
                            e.result = e.result + " " + pageNum;
                        }
                    }
                }
            }
        });
    }

    public final void update(boolean forceUpdate) {
        if (this.textChanged || forceUpdate) {
            this.sendUpdate();
        }
    }

    private final void sendUpdate() {
        int currentStart = this.state.getCurrentStart();
        int currentEnd = this.state.getCurrentEnd();
        TextMapElement nextTMEFromCurrent = null;
        if (this.getView().getCaretOffset() > this.state.getCurrentEnd()) {
            nextTMEFromCurrent = this.getManager().getMapList().getNext(true);
            while (nextTMEFromCurrent instanceof Uneditable) {
                nextTMEFromCurrent = this.getManager().getMapList().getNext(this.getManager().getMapList().indexOf(nextTMEFromCurrent), true);
            }
        }
        int changedTextLength = this.state.getOriginalEnd() - this.state.getOriginalStart() - (currentEnd - currentStart);
        Message updateMessage = this.currentElement instanceof WhiteSpaceElement ? (Message)new WhitespaceMessage(this.currentIndex, this.getView().getCaretOffset(), StringsKt.replace$default((String)this.getString(currentStart, currentEnd - currentStart), (String)ConstantsKt.getLINE_BREAK(), (String)"", (boolean)false, (int)4, null), this.state.getOriginalEnd() - this.state.getOriginalStart()) : (Message)new UpdateMessage(this.getView().getCaretOffset(), this.getString(currentStart, currentEnd - currentStart), this.state.getOriginalEnd() - this.state.getOriginalStart());
        try {
            this.getManager().dispatch(updateMessage);
        }
        catch (Exception e) {
            this.getManager().handleEditingException(e);
        }
        this.currentChanges = 0;
        this.textChanged = false;
        try {
            int newOffset;
            TextMapElement oldTMEInNewMapList;
            if (nextTMEFromCurrent != null && (oldTMEInNewMapList = this.getManager().getMapList().findNode(nextTMEFromCurrent.getNode())) != null && (newOffset = this.getView().getCaretOffset() + (oldTMEInNewMapList.getStart(this.getManager().getMapList()) - (nextTMEFromCurrent.getStart(this.getManager().getMapList()) - changedTextLength))) > 0 && newOffset < this.getView().getCharCount()) {
                EasySWT.INSTANCE.setCaretAfterLineBreaks(this.getView(), newOffset);
            }
        }
        catch (RuntimeException e) {
            throw new CursorMovementException("Attempted to move cursor after an update", (Throwable)e);
        }
    }

    public final void scrollToCursor() {
        EasySWT.INSTANCE.scrollViewToCursor(this.getView());
    }

    public final void setCurrentElement(int pos) {
        int newPos = this.setCursor(pos);
        this.setCurrent(newPos);
    }

    public final void setCurrent(int pos) {
        int tmeIndex = this.getManager().getMapList().findClosest(pos, this.getManager().getMapList().getCurrent(), 0, this.getManager().getMapList().size() - 1);
        Object e = this.getManager().getMapList().get(tmeIndex);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        TextMapElement tme = (TextMapElement)e;
        if (this.isLastInView(tmeIndex)) {
            this.getManager().bufferForward();
            if (this.selection.getSelectionLength() > 0) {
                this.setSelection(-1, -1);
            }
            TextMapElement nTme = this.getManager().getMapList().getCurrent();
            while (nTme instanceof TableTextMapElement || nTme instanceof ReadOnlyTableTextMapElement || nTme instanceof FormattingWhiteSpaceElement) {
                nTme = this.getManager().getMapList().getNext(this.getManager().getMapList().indexOf(nTme), true);
            }
            while (nTme instanceof PaintedWhiteSpaceElement || nTme instanceof WhiteSpaceElement || nTme instanceof PageIndicatorTextMapElement) {
                nTme = this.getManager().getMapList().getNext(this.getManager().getMapList().indexOf(nTme), true);
            }
            TextMapElement textMapElement = nTme;
            if (textMapElement == null) {
                boolean $i$a$-requireNotNull-TextView$setCurrent$22 = false;
                String $i$a$-requireNotNull-TextView$setCurrent$22 = "Problem finding tme";
                throw new IllegalArgumentException($i$a$-requireNotNull-TextView$setCurrent$22.toString());
            }
            tme = textMapElement;
            int insertPos = this.calculateTextOffset(tme.getStart(this.getManager().getMapList()), tme);
            this.getManager().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.TREE, this.createNodeCaret(tme, insertPos), null, 4, null));
            this.setLocalState(this.getView().getCaretOffset());
        } else if (this.isFirstInView(tmeIndex)) {
            this.getManager().decrementView();
            if (this.selection.getSelectionLength() > 0) {
                this.setSelection(-1, -1);
            }
            TextMapElement textMapElement = this.getManager().getMapList().getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
            tme = textMapElement;
            while (tme instanceof TableTextMapElement || tme instanceof ReadOnlyTableTextMapElement || tme instanceof FormattingWhiteSpaceElement) {
                Intrinsics.checkNotNullExpressionValue((Object)this.getManager().getMapList().getPrevious(this.getManager().getMapList().indexOf(tme), true), (String)"getPrevious(...)");
            }
            int insertPos = this.calculateTextOffset(tme.getStart(this.getManager().getMapList()), tme);
            this.getManager().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.TREE, this.createNodeCaret(tme, insertPos), null, 4, null));
            this.setLocalState(this.getView().getCaretOffset());
        } else {
            int insertPos = pos - tme.getStart(this.getManager().getMapList());
            logger.trace("textView setCurrent tme.start " + tme.getStart(this.getManager().getMapList()) + " pos " + pos + " viewLength " + this.getView().getCharCount() + " insertPos " + insertPos);
            if (tme.getStart(this.getManager().getMapList()) != pos || pos != this.getView().getCharCount()) {
                insertPos = this.calculateTextOffset(pos, tme);
            }
            this.getManager().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.TEXT, this.createNodeCaret(tme, insertPos), null, 4, null));
            this.setLocalState(pos);
        }
    }

    private final int calculateTextOffset(int offset, TextMapElement tme) {
        int noLineBreakOffset = 0;
        if (tme.getStart(this.getManager().getMapList()) != offset || offset != this.getView().getCharCount()) {
            int textPos;
            int n = textPos = offset == this.getView().getCharCount() ? offset - 1 : offset;
            if (textPos - 1 >= tme.getStart(this.getManager().getMapList())) {
                --textPos;
            }
            String text = this.getView().getText(tme.getStart(this.getManager().getMapList()), textPos);
            Intrinsics.checkNotNull((Object)text);
            String textWithoutLineBreaks = StringsKt.replace$default((String)text, (String)ConstantsKt.getLINE_BREAK(), (String)"", (boolean)false, (int)4, null);
            noLineBreakOffset = text.length() - textWithoutLineBreaks.length();
            return offset - tme.getStart(this.getManager().getMapList()) - noLineBreakOffset;
        }
        return 0;
    }

    private final void setSelectionElements(int startPos, int endPos) {
        MapList list = this.getManager().getMapList();
        int tmeIndex1 = list.findClosest(startPos, list.getCurrent(), 0, list.size() - 1);
        int tmeIndex2 = list.findClosest(endPos, list.getCurrent(), 0, list.size() - 1);
        int noLineBreakOffset = 0;
        Object e = list.get(tmeIndex1);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        TextMapElement tme1 = (TextMapElement)e;
        Object e2 = list.get(tmeIndex2);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
        TextMapElement tme2 = (TextMapElement)e2;
        if (tme2.getStart(list) != endPos || endPos != this.getView().getCharCount()) {
            String text = this.getView().getTextRange(tme1.getStart(list), startPos - tme1.getStart(list));
            int n = text.length();
            Intrinsics.checkNotNull((Object)text);
            noLineBreakOffset = n - StringsKt.replace$default((String)text, (String)ConstantsKt.getLINE_BREAK(), (String)"", (boolean)false, (int)4, null).length();
        }
        int startOffset = this.selection.selectionStart - tme1.getStart(list) - noLineBreakOffset;
        if (this.lengthOfGuideDotsInTME(tme1) > 0) {
            startOffset = this.selection.selectionStart - (tme1.getEnd(list) - tme1.getNode().getValue().length());
        }
        XMLNodeCaret start = this.createNodeCaret(tme1, startOffset);
        noLineBreakOffset = 0;
        if (tme2.getStart(list) != endPos || endPos != this.getView().getCharCount()) {
            String text = this.getView().getTextRange(tme2.getStart(list), endPos - tme2.getStart(list));
            int n = text.length();
            Intrinsics.checkNotNull((Object)text);
            noLineBreakOffset = n - StringsKt.replace$default((String)text, (String)ConstantsKt.getLINE_BREAK(), (String)"", (boolean)false, (int)4, null).length();
        }
        int endOffset = endPos - tme2.getStart(list) - noLineBreakOffset;
        if (this.lengthOfGuideDotsInTME(tme2) > 0) {
            startOffset = this.selection.selectionStart - (tme2.getEnd(list) - tme2.getNode().getValue().length());
        }
        XMLNodeCaret end = this.createNodeCaret(tme2, endOffset);
        this.getManager().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.TEXT, start, end));
    }

    private final int lengthOfGuideDotsInTME(TextMapElement tme) {
        int guideDotLength = 0;
        Iterator iterator = tme.brailleList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            BrailleMapElement bme = (BrailleMapElement)iterator2.next();
            if (!(bme instanceof GuideDotsBrlMapElement)) continue;
            guideDotLength += ((GuideDotsBrlMapElement)bme).getText().length();
        }
        return guideDotLength;
    }

    private final boolean isLastInView(int index) {
        return index == this.getManager().getMapList().size() - 1 && !this.getManager().getViewInitializer().getSectionList().get(this.getManager().getViewInitializer().getSectionList().size() - 1).isVisible();
    }

    private final boolean isFirstInView(int index) {
        return index == 0 && !this.getManager().getViewInitializer().getSectionList().get(0).isVisible();
    }

    private final void sendAdjustRangeMessage(String type, int position) {
        AdjustRangeMessage adjustmentMessage = new AdjustRangeMessage(type, position);
        this.getManager().dispatch(adjustmentMessage);
        if (Intrinsics.areEqual((Object)type, (Object)"start")) {
            this.state.adjustStart(-position);
            ViewStateObject viewStateObject = this.state;
            viewStateObject.setOriginalStart(viewStateObject.getOriginalStart() - position);
        } else {
            this.state.adjustEnd(position);
            this.state.adjustNextStart(position);
        }
    }

    @Override
    protected void setViewData() {
    }

    private final void makeTextChange(int offset) {
        this.state.adjustEnd(offset);
        this.incrementNext(offset);
        this.currentChanges += offset;
        this.textChanged = true;
    }

    private final void incrementNext(int offset) {
        if (this.state.getNextStart() != -1) {
            this.state.adjustNextStart(offset);
        }
    }

    private final void shiftLeft(int offset) {
        this.state.adjustStart(offset);
        this.state.adjustEnd(offset);
        this.state.adjustNextStart(offset);
    }

    public final int setCursor(int offset) {
        int offset2 = offset;
        if (ConstantsKt.getLINE_BREAK().length() == 2 && offset2 + 1 < this.getView().getCharCount()) {
            String string = this.getView().getTextRange(offset2, 1);
            String string2 = ConstantsKt.getLINE_BREAK().substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            if (Intrinsics.areEqual((Object)string, (Object)string2)) {
                ++offset2;
            }
        }
        this.getView().setCaretOffset(offset2);
        return offset2;
    }

    private final void handleTextEdit(ExtendedModifyEvent e) {
        int changes = e.length;
        String string = e.replacedText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replacedText");
        if (((CharSequence)string).length() > 0) {
            if (e.start < this.state.getCurrentStart()) {
                this.setCurrent(e.start);
            }
            if (e.start + e.replacedText.length() > this.state.getCurrentEnd()) {
                this.deleteSelection(e);
            } else if (this.selection.selectionStart < this.state.getCurrentStart()) {
                this.sendAdjustRangeMessage("start", this.state.getCurrentStart() - this.selection.selectionStart);
                this.makeTextChange(changes -= e.replacedText.length());
                this.sendUpdate();
                this.setCurrent(this.getView().getCaretOffset());
            } else if (e.start + e.replacedText.length() == this.state.getCurrentEnd()) {
                this.makeTextChange(changes -= e.replacedText.length());
                this.recordEvent(e, true);
            } else {
                changes = e.length - this.selection.getSelectionLength();
                this.makeTextChange(changes);
                this.recordEvent(e, true);
            }
        } else {
            if (this.state.getOldCursorPosition() > this.state.getCurrentEnd()) {
                this.sendAdjustRangeMessage("end", this.state.getOldCursorPosition() - this.state.getCurrentEnd());
            }
            if (this.state.getOldCursorPosition() < this.state.getCurrentStart()) {
                this.sendAdjustRangeMessage("start", this.state.getCurrentStart() - this.state.getOldCursorPosition());
            }
            this.makeTextChange(changes);
            this.recordEvent(e, true);
        }
        this.checkStyleRange(this.range);
        this.setSelection(-1, -1);
    }

    private final void handleTextDeletion(ExtendedModifyEvent e) {
        int offset = this.getView().getCaretOffset() - this.state.getOldCursorPosition();
        if (e.replacedText.length() > 1 && (e.replacedText.length() != 2 || this.selection.getSelectionLength() > 0)) {
            this.deleteSelection(e);
        } else if (this.state.getCurrentChar() == 8) {
            if (this.state.getOldCursorPosition() == this.state.getCurrentStart() && this.getView().getCaretOffset() < this.state.getPreviousEnd()) {
                if (this.textChanged) {
                    this.shiftLeft(offset);
                    this.sendUpdate();
                }
                this.setCurrent(this.getView().getCaretOffset());
                this.makeTextChange(offset);
                this.sendUpdate();
            } else {
                this.makeTextChange(offset);
                this.recordEvent(e, false);
            }
        } else if (this.state.getCurrentChar() == 127) {
            String string = e.replacedText;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replacedText");
            int n = offset = ((CharSequence)string).length() > 0 ? -e.replacedText.length() : -1;
            if (this.state.getOldCursorPosition() == this.state.getCurrentEnd() && this.getView().getCaretOffset() == this.state.getNextStart()) {
                if (this.textChanged) {
                    this.sendUpdate();
                    this.shiftLeft(-offset);
                    this.makeTextChange(offset);
                    this.sendUpdate();
                } else {
                    this.getManager().incrementCurrent();
                    this.makeTextChange(offset);
                    if (this.state.getCurrentStart() == this.state.getCurrentEnd()) {
                        this.sendUpdate();
                    }
                }
            } else {
                this.makeTextChange(offset);
                this.recordEvent(e, false);
            }
        }
    }

    private final void deleteSelection(ExtendedModifyEvent e) {
        TextMapElement curElement = this.currentElement;
        if (curElement instanceof PageIndicatorTextMapElement) {
            ParentNode parentNode = ((PageIndicatorTextMapElement)curElement).getNodeParent().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
            Node parent = (Node)parentNode;
            ((PageIndicatorTextMapElement)curElement).getNodeParent().detach();
            try {
                Node[] nodeArray = new Node[]{parent};
                this.getManager().getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
            }
            catch (Exception ex) {
                this.getManager().handleEditingException(ex);
            }
            return;
        }
        if (this.selection.selectionStart >= this.state.getCurrentStart() && this.selection.getSelectionEnd() <= this.state.getCurrentEnd()) {
            this.makeTextChange(-this.selection.getSelectionLength());
            this.recordEvent(e, false);
        } else {
            try {
                Manager manager = this.getManager();
                String string = e.replacedText;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replacedText");
                String string2 = this.getView().getTextRange(e.start, e.length);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextRange(...)");
                manager.dispatch(new SelectionMessage(string, string2, this.selection.selectionStart, this.selection.getSelectionEnd()));
            }
            catch (Exception ex) {
                this.getManager().handleEditingException(ex);
            }
        }
        this.setSelection(-1, -1);
    }

    public final void adjustCurrentElementValues(int changes) {
        this.currentChanges = changes;
        this.state.adjustEnd(changes);
        this.state.adjustNextStart(changes);
        this.textChanged = this.currentChanges != 0;
    }

    private final void recordEvent(ExtendedModifyEvent e, boolean edit) {
        this.editRecorder.recordEvent(e);
    }

    @NotNull
    public final String getString(int start, int length) {
        String string = this.getView().getTextRange(start, length);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextRange(...)");
        return string;
    }

    public final void cut() {
        if (this.selection.getSelectionLength() > 0) {
            this.editRecorder.recordLine(this.selection.selectionStart, this.selection.getSelectionEnd());
        } else {
            this.editRecorder.recordLine(this.getView().getLine(this.getView().getLineAtOffset(this.getView().getCaretOffset())), this.getView().getLineAtOffset(this.getView().getCaretOffset()));
        }
        if (this.getValidator().validCut(this.currentElement, this.state, this.selection.selectionStart, this.selection.getSelectionLength())) {
            this.getView().cut();
        }
    }

    public final void copyAndPaste(@NotNull String text, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.getView().setCaretOffset(start);
        this.setCurrent(this.getView().getCaretOffset());
        this.getView().setSelection(start, end);
        this.setSelection(start, end - start);
        Clipboard cb = new Clipboard(this.getView().getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        if (((CharSequence)text).length() > 0) {
            Object[] objectArray = new Object[]{text};
            Object[] objectArray2 = objectArray;
            objectArray = new Transfer[1];
            Intrinsics.checkNotNull((Object)textTransfer);
            objectArray[0] = textTransfer;
            cb.setContents(objectArray2, (Transfer[])objectArray);
            this.getView().paste();
        } else {
            this.cut();
        }
        cb.dispose();
        this.sendUpdate();
    }

    public final void updateCursor(int offsetFromTMEStart) {
        this.setListenerLock(true);
        TextView $this$updateCursor_u24lambda_u240 = this;
        boolean bl = false;
        $this$updateCursor_u24lambda_u240.setStateObject();
        if ($this$updateCursor_u24lambda_u240.state.getCurrentStart() < $this$updateCursor_u24lambda_u240.getView().getCharCount()) {
            $this$updateCursor_u24lambda_u240.range = $this$updateCursor_u24lambda_u240.getStyleRange();
        }
        $this$updateCursor_u24lambda_u240.currentElement = $this$updateCursor_u24lambda_u240.getManager().getMapList().getCurrent();
        TextView $this$updateCursor_u24lambda_u241 = this;
        boolean bl2 = false;
        StyledText styledText = $this$updateCursor_u24lambda_u241.getView();
        TextMapElement textMapElement = $this$updateCursor_u24lambda_u241.currentElement;
        Intrinsics.checkNotNull((Object)textMapElement);
        FormUIUtils.INSTANCE.setCaretAtTextNodeOffset(styledText, textMapElement, offsetFromTMEStart, $this$updateCursor_u24lambda_u241.getManager());
        this.setListenerLock(false);
        this.sendStatusBarUpdate(this.getView().getLineAtOffset(this.getView().getCaretOffset()));
    }

    private final StyleRange getStyleRange() {
        int currentStart = this.state.getCurrentStart();
        return currentStart < this.getView().getCharCount() ? this.getView().getStyleRangeAtOffset(currentStart) : null;
    }

    private final void checkStyleRange(StyleRange range) {
        int currentStart = this.state.getCurrentStart();
        int currentEnd = this.state.getCurrentEnd();
        if (range != null) {
            this.setFontStyleRange(currentStart, currentEnd - currentStart, range);
        }
    }

    public final void resetSelectionObject() {
        this.selection.selectionStart = -1;
        this.selection.setSelectionLength(-1);
    }

    private final void setSelection(int start, int length) {
        this.selection.selectionStart = start;
        this.selection.setSelectionLength(length);
    }

    public final void highlight(int start, int end) {
        this.getView().setSelection(start, end);
        this.setSelection();
    }

    public final void insertNewNode(@Nullable InsertNodeMessage m, @Nullable Integer pos) {
        this.getManager().dispatch(m);
        if (pos != null) {
            this.getView().setCaretOffset(pos.intValue());
            this.setCurrent(pos);
        }
    }

    @Override
    public void resetView(@NotNull Composite parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.recreateView(parent);
        this.editRecorder = new EditRecorder(this.getManager(), this);
        this.state.setOldCursorPosition(-1);
        this.currentChanges = 0;
        this.textChanged = false;
    }

    public final void resetOffsets() {
        this.setViewData();
    }

    @NotNull
    public final int[] getSelectedText() {
        int[] temp = new int[2];
        if (this.selection.getSelectionLength() > 0) {
            temp[0] = this.selection.selectionStart;
            temp[1] = this.selection.getSelectionLength();
        }
        return temp;
    }

    public final void setCurrentSelection(int start, int end) {
        this.getView().setSelection(start, end);
        this.setSelection(start, end - start);
    }

    public final void clearSelection() {
        this.getView().setSelection(-1, -1);
        this.setSelection(-1, -1);
    }

    private final void setSelection() {
        int[] selectionArray = this.getView().getSelectionRanges();
        if (selectionArray[1] > 0) {
            this.setSelection(selectionArray[0], selectionArray[1]);
            this.isMultiSelected = true;
            this.state.setCurrentChar(32);
            this.state.setCurrentStateMask(-1);
            if (this.textChanged) {
                this.sendUpdate();
            }
            this.setSelectionElements(selectionArray[0], selectionArray[0] + selectionArray[1]);
        } else {
            this.isMultiSelected = false;
            this.selection.setSelectionElement(null);
            this.setCurrent(this.getView().getCaretOffset());
        }
    }

    public final void undoEdit(int start, int length, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int changes = text.length() - length;
        this.replaceTextRange(start, length, text);
        this.makeTextChange(changes);
        if (this.currentChanges == 0) {
            this.textChanged = false;
        }
        this.reapplyStyle();
    }

    private final void reapplyStyle() {
        TextMapElement curElement = this.currentElement;
        if (curElement != null && !(curElement instanceof WhiteSpaceElement)) {
            int i;
            IStyle iStyle = this.getManager().getStyle(curElement.getNode());
            Intrinsics.checkNotNull((Object)iStyle);
            IStyle style = iStyle;
            int startLine = this.getView().getLineAtOffset(curElement.getStart(this.getManager().getMapList()));
            int endLine = curElement.getEnd(this.getManager().getMapList()) + this.currentChanges > this.getView().getCharCount() ? this.getView().getLineAtOffset(this.getView().getCharCount()) : this.getView().getLineAtOffset(curElement.getEnd(this.getManager().getMapList()) + this.currentChanges);
            Integer firstLineIndent = style.getFirstLineIndent();
            Integer indent = style.getIndent();
            if (this.isFirstInBlock(curElement) && style.getAlign() != null && style.getAlign() == Align.LEFT) {
                boolean first = true;
                int i2 = startLine;
                if (i2 <= endLine) {
                    while (true) {
                        if (first) {
                            if (firstLineIndent != null) {
                                this.getView().setLineIndent(i2, 1, firstLineIndent * this.getCharWidth());
                            } else if (indent != null) {
                                this.getView().setLineIndent(i2, 1, indent * this.getCharWidth());
                            }
                            first = false;
                        } else if (indent != null) {
                            this.getView().setLineIndent(i2, 1, indent * this.getCharWidth());
                        }
                        if (i2 != endLine) {
                            ++i2;
                            continue;
                        }
                        break;
                    }
                }
            } else if (style.getAlign() != null && style.getAlign() == Align.LEFT && (i = startLine) <= endLine) {
                while (true) {
                    if (i == startLine && firstLineIndent != null) {
                        this.getView().setLineIndent(i, 1, firstLineIndent * this.getCharWidth());
                    } else if (indent != null) {
                        this.getView().setLineIndent(i, 1, indent * this.getCharWidth());
                    }
                    if (i == endLine) break;
                    ++i;
                }
            }
            if (!(this.getManager().getAction((Node)curElement.getNodeParent()) instanceof GenericBlockAction)) {
                this.setFontStyleRange(curElement.getStart(this.getManager().getMapList()), curElement.getEnd(this.getManager().getMapList()) + this.currentChanges - curElement.getStart(this.getManager().getMapList()), this.getManager().getAction((Node)curElement.getNodeParent()), curElement.getNodeParent());
            }
        }
    }

    public final void updateContextMenu() {
    }

    private final boolean isArrowKey(int keyCode) {
        return keyCode == 0x1000002 || keyCode == 0x1000003 || keyCode == 0x1000004 || keyCode == 0x1000001;
    }

    private final boolean isNavKey(int keyCode) {
        return keyCode == 0x1000007 || keyCode == 0x1000008;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean atRunningHeadLine() {
        if (!this.atPrintPageLine()) return false;
        if (this.getPreviousPageIndicator(this.getView().getCaretOffset()) == null) return false;
        PageIndicator pageIndicator = this.getPreviousPageIndicator(this.getView().getCaretOffset());
        Intrinsics.checkNotNull((Object)pageIndicator);
        if (!pageIndicator.hasRunningHead()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean atGuideWordLine() {
        if (!this.atBraillePageLine()) return false;
        if (this.getNextPageIndicator(this.getView().getCaretOffset()) == null) return false;
        PageIndicator pageIndicator = this.getNextPageIndicator(this.getView().getCaretOffset());
        Intrinsics.checkNotNull((Object)pageIndicator);
        if (!pageIndicator.hasGuideWord()) return false;
        return true;
    }

    private final boolean atPrintPageLine() {
        return this.offsetIsPrintPageNumberLine(this.getView().getCaretOffset());
    }

    private final boolean offsetIsPrintPageNumberLine(int offset) {
        boolean bl;
        if (this.getPreviousPageIndicator(offset) != null) {
            PageIndicator pageIndicator = this.getPreviousPageIndicator(offset);
            Intrinsics.checkNotNull((Object)pageIndicator);
            bl = pageIndicator.getLine() == RangesKt.coerceAtLeast((int)(this.getView().getLineAtOffset(offset) - 1), (int)0) && this.getView().getLineAtOffset(offset) != 1;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean atBraillePageLine() {
        return this.offsetIsBraillePageNumberLine(this.getView().getCaretOffset());
    }

    private final boolean offsetIsBraillePageNumberLine(int offset) {
        boolean bl;
        if (this.getNextPageIndicator(offset) != null) {
            PageIndicator pageIndicator = this.getNextPageIndicator(offset);
            Intrinsics.checkNotNull((Object)pageIndicator);
            bl = pageIndicator.getLine() == this.getView().getLineAtOffset(offset);
        } else {
            bl = false;
        }
        return bl;
    }

    private final PageIndicator getPreviousPageIndicator(int caretOffset) {
        int line = this.getView().getLineAtOffset(caretOffset);
        PageIndicator prevIndicator = !((Collection)this.getManager().getText().paintedElements.getPageIndicators()).isEmpty() ? this.getManager().getText().paintedElements.getPageIndicators().get(0) : null;
        for (PageIndicator pi : this.getManager().getText().paintedElements.getPageIndicators()) {
            if (pi.getLine() >= line) {
                return prevIndicator;
            }
            prevIndicator = pi;
        }
        return prevIndicator;
    }

    private final PageIndicator getNextPageIndicator(int caretOffset) {
        int line = this.getView().getLineAtOffset(caretOffset);
        for (PageIndicator pi : this.getManager().getText().paintedElements.getPageIndicators()) {
            if (pi.getLine() < line) continue;
            return pi;
        }
        return null;
    }

    private final void setStateObject() {
        this.state.setCurrentStart(this.getManager().getMapList().getCurrent().getStart(this.getManager().getMapList()));
        this.state.setCurrentEnd(this.getManager().getMapList().getCurrent().getEnd(this.getManager().getMapList()));
        this.state.setPreviousEnd(this.getManager().getMapList().getPrevEnd());
        this.state.setNextStart(this.getManager().getMapList().getNextStart());
        this.state.setOriginalPositions(this.state.getCurrentStart(), this.state.getCurrentEnd());
    }

    private final void setLocalState(int pos) {
        TextMapElement currentElement;
        MapList list = this.getManager().getMapList();
        this.currentIndex = list.findClosest(pos, this.getManager().getMapList().getCurrent(), 0, list.size() - 1);
        Object e = list.get(this.currentIndex);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        this.currentElement = currentElement = (TextMapElement)e;
        list.setCurrent(this.currentIndex);
        int prevEnd = this.currentIndex > 0 && list.getPrevious(this.currentIndex, false) != null ? list.getPrevious(this.currentIndex, false).getEnd(list) : -1;
        TextMapElement textMapElement = list.getNext(this.currentIndex, false);
        int nextStart = textMapElement != null ? textMapElement.getStart(list) : -1;
        this.state.setCurrentStart(currentElement.getStart(list));
        this.state.setCurrentEnd(currentElement.getEnd(list));
        this.state.setPreviousEnd(prevEnd);
        this.state.setNextStart(nextStart);
        this.state.setOriginalPositions(this.state.getCurrentStart(), this.state.getCurrentEnd());
        this.range = this.getStyleRange();
    }

    public final int getCurrentStart() {
        return this.state.getCurrentStart();
    }

    public final int getCurrentEnd() {
        return this.state.getCurrentEnd();
    }

    @Nullable
    public final Element getSelectionElement() {
        return this.selection.getSelectionElement();
    }

    public final void setSelectionElement(@Nullable Element e) {
        this.selection.setSelectionElement(e);
    }

    @Nullable
    public final Element getPreviousSelection() {
        return this.selection.previousElement();
    }

    public final void addFocusListener() {
        this.removeFocusListener();
        if (!this.focusListenerLock) {
            this.focusListener = new FocusAdapter(this){
                final /* synthetic */ TextView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusGained(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.sendStatusBarUpdate(this.this$0.getView().getLineAtOffset(this.this$0.getView().getCaretOffset()));
                }

                public void focusLost(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (this.this$0.textChanged) {
                        TextView.access$sendUpdate(this.this$0);
                        this.this$0.setCurrent(this.this$0.getView().getCaretOffset());
                    }
                }
            };
            this.getView().addFocusListener((FocusListener)this.focusListener);
        }
    }

    public final void removeFocusListener() {
        if (this.focusListener != null) {
            this.getView().removeFocusListener((FocusListener)this.focusListener);
        }
    }

    public final void setFocusListenerLock(boolean focusListenerLock) {
        if (focusListenerLock) {
            this.removeFocusListener();
        }
        this.focusListenerLock = focusListenerLock;
        if (!focusListenerLock) {
            this.addFocusListener();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getSixKeyMode() {
        if (this.keyHandler == null) return false;
        SixKeyHandler sixKeyHandler = this.keyHandler;
        Intrinsics.checkNotNull((Object)sixKeyHandler);
        if (!sixKeyHandler.getSixKeyMode()) return false;
        return true;
    }

    public final void setSixKeyMode(boolean sixKeyMode) {
        if (this.keyHandler != null) {
            SixKeyHandler sixKeyHandler = this.keyHandler;
            Intrinsics.checkNotNull((Object)sixKeyHandler);
            sixKeyHandler.setSixKeyMode(sixKeyMode);
        }
    }

    private static final void initializeListeners$lambda$2(TextView this$0, ExtendedModifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this$0.getLock()) {
            if (e.length > 0) {
                this$0.handleTextEdit(e);
            } else {
                this$0.handleTextDeletion(e);
            }
        }
    }

    private static final void initializeListeners$lambda$4(TextView this$0, Event it) {
        this$0.updateContextMenu();
    }

    private static final void initializeListeners$lambda$6(TextView this$0, CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this$0.getLock()) {
            if (this$0.getView().getSelectionCount() == 0) {
                this$0.isMultiSelected = false;
            }
            if (this$0.getManager().getStylePane().getUpdateStylePane() && !this$0.getManager().getTextView().isDisposed()) {
                this$0.getManager().getStylePane().updateCursor(this$0.getManager().getTextView().getLineAtOffset(this$0.getManager().getTextView().getCaretOffset()));
            }
            Object[] objectArray = new Object[]{this$0.getView().getCaretOffset(), e.caretOffset, this$0.state.getCurrentChar(), new RuntimeException("CaretEVent")};
            logger.debug("Current char '{}' event {} stateObj {}", objectArray);
            if (this$0.atRunningHeadLine() || this$0.atGuideWordLine()) {
                int newOffset;
                int oldLine;
                int line = this$0.getView().getLineAtOffset(e.caretOffset);
                int n = oldLine = this$0.state.getOldCursorPosition() < 0 || this$0.state.getOldCursorPosition() > this$0.getView().getCharCount() ? 0 : this$0.getView().getLineAtOffset(this$0.state.getOldCursorPosition());
                if (oldLine < line) {
                    v1 = this$0.getView().getOffsetAtLine(line == this$0.getView().getLineCount() - 1 ? line - 1 : line + 1);
                } else {
                    int expectedLine = line == 0 ? 1 : line - 1;
                    v1 = newOffset = this$0.getView().getOffsetAtLine(expectedLine) + this$0.getView().getLine(expectedLine).length();
                }
                if (this$0.getView().getSelectionRanges()[1] == 0 && (this$0.state.getCurrentStateMask() & 0x20000) == 0) {
                    this$0.getView().setCaretOffset(newOffset);
                }
            }
            int currentStart = this$0.state.getCurrentStart();
            int currentEnd = this$0.state.getCurrentEnd();
            if (this$0.isArrowKey(this$0.state.getCurrentChar()) || this$0.isNavKey(this$0.state.getCurrentChar())) {
                int n = currentStart + 1;
                int n2 = e.caretOffset;
                if (!(n <= n2 ? n2 < currentEnd : false)) {
                    if (this$0.textChanged) {
                        this$0.sendUpdate();
                    }
                    if (this$0.getView().getSelectionRanges()[1] > 0) {
                        this$0.setSelectionElements(this$0.selection.selectionStart, this$0.selection.getSelectionEnd());
                    } else {
                        this$0.setCurrent(this$0.getView().getCaretOffset());
                    }
                    this$0.state.setCurrentChar(32);
                    this$0.state.setCurrentStateMask(-1);
                } else if (!this$0.textChanged && e.caretOffset >= this$0.state.getOriginalStart() && e.caretOffset < this$0.state.getOriginalEnd()) {
                    if (this$0.getView().getSelectionRanges()[1] > 0) {
                        this$0.setSelectionElements(this$0.selection.selectionStart, this$0.selection.getSelectionEnd());
                    } else {
                        this$0.setCurrent(this$0.getView().getCaretOffset());
                    }
                }
                this$0.sendStatusBarUpdate(this$0.getView().getLineAtOffset(this$0.getView().getCaretOffset()));
            }
            if (this$0.getView().getLineAtOffset(this$0.getView().getCaretOffset()) != WPView.currentLine) {
                this$0.sendStatusBarUpdate(this$0.getView().getLineAtOffset(this$0.getView().getCaretOffset()));
            }
            this$0.updateContextMenu();
        }
    }

    public static final /* synthetic */ void access$setSelection(TextView $this) {
        $this.setSelection();
    }

    public static final /* synthetic */ Manager access$getManager(TextView $this) {
        return $this.getManager();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$sendUpdate(TextView $this) {
        $this.sendUpdate();
    }

    public static final /* synthetic */ void access$setSelectionElements(TextView $this, int startPos, int endPos) {
        $this.setSelectionElements(startPos, endPos);
    }

    public static final /* synthetic */ Selection access$getSelection$p(TextView $this) {
        return $this.selection;
    }

    public static final /* synthetic */ boolean access$atRunningHeadLine(TextView $this) {
        return $this.atRunningHeadLine();
    }

    public static final /* synthetic */ boolean access$atGuideWordLine(TextView $this) {
        return $this.atGuideWordLine();
    }

    public static final /* synthetic */ boolean access$offsetIsPrintPageNumberLine(TextView $this, int offset) {
        return $this.offsetIsPrintPageNumberLine(offset);
    }

    public static final /* synthetic */ PageIndicator access$getPreviousPageIndicator(TextView $this, int caretOffset) {
        return $this.getPreviousPageIndicator(caretOffset);
    }

    public static final /* synthetic */ boolean access$offsetIsBraillePageNumberLine(TextView $this, int offset) {
        return $this.offsetIsBraillePageNumberLine(offset);
    }

    public static final /* synthetic */ PageIndicator access$getNextPageIndicator(TextView $this, int caretOffset) {
        return $this.getNextPageIndicator(caretOffset);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/TextView$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "NAME", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

