/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.AbstractMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.interfaces.Uneditable;
import org.brailleblaster.perspectives.braille.views.wp.ViewStateObject;
import org.brailleblaster.perspectives.mvc.modules.misc.TableSelectionModule;
import org.brailleblaster.utd.actions.GenericBlockAction;
import org.brailleblaster.util.ConstantsKt;
import org.eclipse.swt.custom.StyledText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ(\u0010\u001c\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ(\u0010\u001d\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ(\u0010\u001e\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/Validator;", "", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "view", "Lorg/eclipse/swt/custom/StyledText;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/eclipse/swt/custom/StyledText;)V", "getManager", "()Lorg/brailleblaster/perspectives/braille/Manager;", "setManager", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "getView", "()Lorg/eclipse/swt/custom/StyledText;", "setView", "(Lorg/eclipse/swt/custom/StyledText;)V", "isFirstElement", "", "childElement", "Lnu/xom/Element;", "validCut", "currentElement", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "stateObj", "Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;", "selectionStart", "", "selectionLength", "validPaste", "validDelete", "validBackspace", "brailleblaster-core"})
public final class Validator {
    @NotNull
    private Manager manager;
    @NotNull
    private StyledText view;

    public Validator(@NotNull Manager manager, @NotNull StyledText view) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.manager = manager;
        this.view = view;
    }

    @NotNull
    public final Manager getManager() {
        return this.manager;
    }

    public final void setManager(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"<set-?>");
        this.manager = manager;
    }

    @NotNull
    public final StyledText getView() {
        return this.view;
    }

    public final void setView(@NotNull StyledText styledText) {
        Intrinsics.checkNotNullParameter((Object)styledText, (String)"<set-?>");
        this.view = styledText;
    }

    public final boolean isFirstElement(@NotNull Element childElement) {
        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
        Element child = childElement;
        ParentNode parentNode = child.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        while (!(this.manager.getAction((Node)parent) instanceof GenericBlockAction)) {
            if (parent.indexOf((Node)child) != 0) {
                return false;
            }
            child = parent;
            ParentNode parentNode2 = parent.getParent();
            Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
            parent = (Element)parentNode2;
        }
        return parent.indexOf((Node)child) == 0;
    }

    public final boolean validCut(@Nullable TextMapElement currentElement, @NotNull ViewStateObject stateObj, int selectionStart, int selectionLength) {
        Intrinsics.checkNotNullParameter((Object)stateObj, (String)"stateObj");
        if (this.manager.isTableSelected()) {
            TableSelectionModule.Companion.displayInvalidTableMessage(this.manager.getWpManager().getShell());
            return false;
        }
        int currentStart = stateObj.getCurrentStart();
        int currentEnd = stateObj.getCurrentEnd();
        int nextStart = stateObj.getNextStart();
        if (currentElement instanceof PageIndicatorTextMapElement || currentElement instanceof BoxLineTextMapElement) {
            return selectionStart == currentStart && selectionLength == currentEnd - currentStart ? false : ((currentStart <= selectionStart ? selectionStart < currentEnd : false) && selectionLength <= currentEnd - selectionStart ? false : selectionStart != currentEnd || selectionLength != 1 || selectionStart + selectionLength != nextStart);
        }
        if (selectionLength > 0) {
            TextMapElement t = this.manager.getMapList().getElementInRange(selectionStart);
            return !(t instanceof BoxLineTextMapElement) && !(t instanceof PageIndicatorTextMapElement) || selectionStart != ((AbstractMapElement)t).getEnd(this.manager.getMapList()) || selectionLength != 1;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validPaste(@Nullable TextMapElement currentElement, @NotNull ViewStateObject stateObj, int selectionStart, int selectionLength) {
        Intrinsics.checkNotNullParameter((Object)stateObj, (String)"stateObj");
        if (this.manager.isTableSelected()) {
            TableSelectionModule.Companion.displayInvalidTableMessage(this.manager.getWpManager().getShell());
            return false;
        }
        int currentStart = stateObj.getCurrentStart();
        int currentEnd = stateObj.getCurrentEnd();
        if (currentElement instanceof PageIndicatorTextMapElement || currentElement instanceof BoxLineTextMapElement) {
            if (selectionStart == currentStart && selectionLength == currentEnd - currentStart) {
                return false;
            }
            boolean bl = currentStart <= selectionStart ? selectionStart < currentEnd : false;
            if (bl && selectionLength <= currentEnd - selectionStart) {
                return false;
            }
            if (this.view.getSelectionRanges()[1] == 0) return false;
            if (currentStart > selectionStart) return true;
            if (selectionStart > currentEnd) return true;
            return false;
        }
        if (selectionLength <= 0) return true;
        TextMapElement t = this.manager.getMapList().getElementInRange(selectionStart);
        if (!(t instanceof BoxLineTextMapElement)) {
            if (!(t instanceof PageIndicatorTextMapElement)) return true;
        }
        if (selectionStart != ((AbstractMapElement)t).getEnd(this.manager.getMapList())) return true;
        if (selectionLength == 1) return false;
        return true;
    }

    public final boolean validDelete(@Nullable TextMapElement currentElement, @NotNull ViewStateObject stateObj, int selectionStart, int selectionLength) {
        Intrinsics.checkNotNullParameter((Object)stateObj, (String)"stateObj");
        int currentStart = stateObj.getCurrentStart();
        int currentEnd = stateObj.getCurrentEnd();
        int nextStart = stateObj.getNextStart();
        if (currentElement instanceof Uneditable) {
            return selectionStart >= currentStart && selectionStart + selectionLength <= currentEnd || selectionLength == 0 ? false : (selectionLength <= 0 && this.view.getCaretOffset() == currentEnd ? false : selectionStart != currentEnd || selectionStart + selectionLength != nextStart || selectionLength != ConstantsKt.getLINE_BREAK().length());
        }
        if (selectionLength <= 0 && this.manager.getMapList().inPrintPageRange(this.view.getCaretOffset() + ConstantsKt.getLINE_BREAK().length()) || selectionLength <= 0 && this.manager.getMapList().getElementInRange(this.view.getCaretOffset() + ConstantsKt.getLINE_BREAK().length()) instanceof BoxLineTextMapElement) {
            return false;
        }
        if (selectionLength > 0) {
            TextMapElement t = this.manager.getMapList().getElementInRange(selectionStart);
            return !(t instanceof Uneditable) || selectionStart != ((AbstractMapElement)t).getEnd(this.manager.getMapList()) || selectionLength != ConstantsKt.getLINE_BREAK().length();
        }
        return true;
    }

    public final boolean validBackspace(@Nullable TextMapElement currentElement, @NotNull ViewStateObject stateObj, int selectionStart, int selectionLength) {
        Intrinsics.checkNotNullParameter((Object)stateObj, (String)"stateObj");
        int currentStart = stateObj.getCurrentStart();
        int currentEnd = stateObj.getCurrentEnd();
        int nextStart = stateObj.getNextStart();
        if (currentElement instanceof Uneditable) {
            return selectionStart >= currentStart && selectionStart + selectionLength <= currentEnd ? false : (selectionLength <= 0 ? false : selectionStart != currentEnd || selectionStart + selectionLength != nextStart || selectionLength != 1);
        }
        if (selectionLength <= 0 && !(currentElement instanceof WhiteSpaceElement) && (this.manager.getMapList().inPrintPageRange(this.view.getCaretOffset() - 1) || this.manager.getMapList().getElementInRange(this.view.getCaretOffset() - 1) instanceof Uneditable)) {
            return false;
        }
        if (selectionLength > 0) {
            TextMapElement t = this.manager.getMapList().getElementInRange(selectionStart);
            return !(t instanceof Uneditable) || selectionStart != ((AbstractMapElement)t).getEnd(this.manager.getMapList()) || selectionLength != 1;
        }
        return true;
    }
}

