/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp.tableEditor;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.ITable;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.TableType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b$\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR \u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u001d\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000fR$\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR$\u0010!\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR$\u0010$\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001dR \u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000fR(\u0010*\u001a\u0004\u0018\u00010\t2\b\u0010)\u001a\u0004\u0018\u00010\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/tableEditor/InternalFacingTable;", "Lorg/brailleblaster/perspectives/braille/views/wp/tableEditor/ITable;", "nodes", "", "Lnu/xom/Node;", "split", "", "captions", "", "Lnu/xom/Element;", "type", "Lorg/brailleblaster/perspectives/braille/views/wp/tableEditor/TableType;", "<init>", "(Ljava/util/List;ILjava/util/List;Lorg/brailleblaster/perspectives/braille/views/wp/tableEditor/TableType;)V", "getNodes", "()Ljava/util/List;", "getCaptions", "getType", "()Lorg/brailleblaster/perspectives/braille/views/wp/tableEditor/TableType;", "setType", "(Lorg/brailleblaster/perspectives/braille/views/wp/tableEditor/TableType;)V", "leftNodes", "getLeftNodes", "rightNodes", "getRightNodes", "rows", "getRows", "()I", "setRows", "(I)V", "cols", "getCols", "setCols", "displayedRows", "getDisplayedRows", "setDisplayedRows", "displayedCols", "getDisplayedCols", "setDisplayedCols", "displayedNodes", "getDisplayedNodes", "_", "tNContainer", "getTNContainer", "()Lnu/xom/Element;", "setTNContainer", "(Lnu/xom/Element;)V", "brailleblaster-core"})
public final class InternalFacingTable
implements ITable {
    @NotNull
    private final List<List<Node>> nodes;
    @JvmField
    public int split;
    @NotNull
    private final List<Element> captions;
    @NotNull
    private TableType type;

    public InternalFacingTable(@NotNull List<List<Node>> nodes, int split, @NotNull List<? extends Element> captions, @NotNull TableType type) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(captions, (String)"captions");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.nodes = nodes;
        this.split = split;
        this.captions = captions;
        this.type = type;
    }

    @Override
    @NotNull
    public List<List<Node>> getNodes() {
        return this.nodes;
    }

    @Override
    @NotNull
    public List<Element> getCaptions() {
        return this.captions;
    }

    @Override
    @NotNull
    public TableType getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull TableType tableType) {
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"<set-?>");
        this.type = tableType;
    }

    @NotNull
    public final List<List<Node>> getLeftNodes() {
        List returnList = new ArrayList();
        for (List<Node> row : this.getNodes()) {
            List cellList = CollectionsKt.take((Iterable)row, (int)this.split);
            returnList.add(cellList);
        }
        return returnList;
    }

    @NotNull
    public final List<List<Node>> getRightNodes() {
        List returnList = new ArrayList();
        for (List<Node> row : this.getNodes()) {
            List cellList = new ArrayList();
            int n = row.size();
            for (int j = this.split; j < n; ++j) {
                cellList.add(row.get(j));
            }
            returnList.add(cellList);
        }
        return returnList;
    }

    @Override
    public int getRows() {
        return this.getNodes().size();
    }

    @Override
    public void setRows(int rows) {
        ITable.super.setRows(rows);
    }

    @Override
    public int getCols() {
        if (this.getNodes().isEmpty()) {
            return 0;
        }
        int maxCol = 0;
        for (List<Node> row : this.getNodes()) {
            maxCol = (int)Math.max((double)row.size(), (double)maxCol);
        }
        return maxCol;
    }

    @Override
    public void setCols(int cols) {
        ITable.super.setCols(cols);
    }

    @Override
    public int getDisplayedRows() {
        return this.getRows();
    }

    @Override
    public void setDisplayedRows(int displayedRows) {
        if (displayedRows > this.getRows()) {
            this.setRows(displayedRows);
        }
    }

    @Override
    public int getDisplayedCols() {
        return this.getCols();
    }

    @Override
    public void setDisplayedCols(int displayedCols) {
        if (displayedCols > this.getCols()) {
            this.setCols(displayedCols);
        }
    }

    @Override
    @NotNull
    public List<List<Node>> getDisplayedNodes() {
        return new ArrayList(this.getNodes());
    }

    @Override
    @Nullable
    public Element getTNContainer() {
        return null;
    }

    @Override
    public void setTNContainer(@Nullable Element element) {
        throw new UnsupportedOperationException("TN Container not supported with facing tables yet");
    }
}

