/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.text.WordUtils;
import org.brailleblaster.BBIni;
import org.brailleblaster.abstractClasses.BBEditorView;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.views.style.StylePane;
import org.brailleblaster.perspectives.braille.views.wp.BrailleView;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.events.BBViewListener;
import org.brailleblaster.perspectives.mvc.modules.misc.ToggleViewsModule;
import org.brailleblaster.util.ColorManager;
import org.brailleblaster.utils.PropertyFileManager;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0006\u0010\u001d\u001a\u00020\u001aJ\u0006\u0010\u001e\u001a\u00020\u001aJ\u0006\u0010\u001f\u001a\u00020\u001aJ\u0006\u0010 \u001a\u00020\u001aJ\u0006\u0010!\u001a\u00020\u001aJ\u0010\u0010\"\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\nJ\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/brailleblaster/perspectives/mvc/ViewManager;", "", "folder", "Lorg/eclipse/swt/custom/CTabFolder;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/eclipse/swt/custom/CTabFolder;Lorg/brailleblaster/perspectives/braille/Manager;)V", "views", "", "Lorg/brailleblaster/abstractClasses/BBEditorView;", "containerSash", "Lorg/eclipse/swt/custom/SashForm;", "textView", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "getTextView", "()Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "brailleView", "Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "getBrailleView", "()Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "stylePane", "Lorg/brailleblaster/perspectives/braille/views/style/StylePane;", "windowedViewCurrent", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Views;", "reparent", "", "getView", "view", "setViewSizes", "setTabList", "saveScreenProperties", "initializeListeners", "removeListeners", "initializeModuleListeners", "removeModuleListeners", "mainShellViewCount", "", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewManager.kt\norg/brailleblaster/perspectives/mvc/ViewManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,439:1\n1807#2,3:440\n*S KotlinDebug\n*F\n+ 1 ViewManager.kt\norg/brailleblaster/perspectives/mvc/ViewManager\n*L\n270#1:440,3\n*E\n"})
public final class ViewManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager m;
    @NotNull
    private final List<BBEditorView> views;
    @JvmField
    @NotNull
    public final SashForm containerSash;
    @NotNull
    private final TextView textView;
    @NotNull
    private final BrailleView brailleView;
    @JvmField
    @NotNull
    public final StylePane stylePane;
    @Nullable
    private ToggleViewsModule.Views windowedViewCurrent;
    private static final Logger log = LoggerFactory.getLogger(ViewManager.class);
    private static final int DEFAULT_SIZE = 1000;
    private static final int DEFAULT_STYLE_PANE_SIZE = 100;
    private static final int DEFAULT_BRAILLE_SIZE = 450;
    private static final int DEFAULT_PRINT_SIZE = 450;
    @NotNull
    private static final String SETTING_WEIGHT_STYLE = "viewManager.weightStyle";
    @NotNull
    private static final String SETTING_WEIGHT_PRINT = "viewManager.weightPrint";
    @NotNull
    private static final String SETTING_WEIGHT_BRAILLE = "viewManager.weightBraille";
    @NotNull
    public static final String SETTING_DARK_THEME = "viewManager.darkTheme";
    @NotNull
    private static final String SETTING_WINDOWED_VIEW = "viewManager.windowedView";
    @Nullable
    private static Shell windowedShell;

    /*
     * WARNING - void declaration
     */
    public ViewManager(@Nullable CTabFolder folder, @NotNull Manager m) {
        void $this$containerSash_u24lambda_u240;
        SashForm sashForm;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.m = m;
        this.views = new ArrayList();
        SashForm sashForm2 = sashForm = new SashForm((Composite)folder, 256);
        ViewManager viewManager = this;
        boolean bl = false;
        $this$containerSash_u24lambda_u240.setLayout((Layout)new FormLayout());
        viewManager.containerSash = sashForm;
        this.textView = new TextView(this.m, (Composite)this.containerSash);
        this.brailleView = new BrailleView(this.m, (Composite)this.containerSash);
        this.stylePane = new StylePane((Composite)this.containerSash, this.m);
        this.reparent();
        this.views.add(this.textView);
        this.views.add(this.brailleView);
        this.views.add(this.stylePane);
    }

    @NotNull
    public final TextView getTextView() {
        return this.textView;
    }

    @NotNull
    public final BrailleView getBrailleView() {
        return this.brailleView;
    }

    public final void reparent() {
        BBEditorView windowedEditor;
        ToggleViewsModule.Views windowedViewNew = Companion.getWindowedView();
        boolean redrawMainContainer = false;
        List<ToggleViewsModule.Views> visibleViews = ToggleViewsModule.Companion.loadSettings();
        boolean viewVisible = CollectionsKt.contains((Iterable)visibleViews, (Object)((Object)windowedViewNew));
        Object[] objectArray = new Object[]{this.windowedViewCurrent, windowedViewNew, viewVisible, visibleViews};
        log.info("reparent current {} new {} visible {} {}", objectArray);
        if (this.windowedViewCurrent != null) {
            ToggleViewsModule.Views views = this.windowedViewCurrent;
            Intrinsics.checkNotNull((Object)((Object)views));
            windowedEditor = this.getView(views);
            windowedEditor.getView().setParent((Composite)this.containerSash);
            log.info("resetting container sash of " + windowedEditor);
            redrawMainContainer = true;
        }
        if (!(windowedShell == null || windowedViewNew != null && viewVisible)) {
            Shell shell = windowedShell;
            Intrinsics.checkNotNull((Object)shell);
            shell.dispose();
            windowedShell = null;
        }
        if (!viewVisible) {
            return;
        }
        if (windowedViewNew != null) {
            if (windowedShell == null) {
                BBEditorView $this$reparent_u24lambda_u240 = windowedEditor = EasySWT.INSTANCE.makeDialogFloating(this.m.getWpManager().getShell());
                boolean bl = false;
                $this$reparent_u24lambda_u240.setLayout((Layout)new GridLayout(1, true));
                $this$reparent_u24lambda_u240.open();
                windowedShell = windowedEditor;
            }
            windowedEditor = this.getView(windowedViewNew);
            windowedEditor.getView().setParent((Composite)windowedShell);
            EasySWT.INSTANCE.setGridDataVertical((Control)windowedEditor.getView());
            Shell shell = windowedShell;
            Intrinsics.checkNotNull((Object)shell);
            shell.layout(true);
            Shell shell2 = windowedShell;
            Intrinsics.checkNotNull((Object)shell2);
            shell2.setRedraw(true);
            Shell shell3 = windowedShell;
            Intrinsics.checkNotNull((Object)shell3);
            shell3.setText(WordUtils.capitalizeFully((String)windowedViewNew.name()) + " View");
            redrawMainContainer = true;
        }
        this.windowedViewCurrent = windowedViewNew;
        if (redrawMainContainer) {
            this.containerSash.layout(true);
            this.containerSash.setRedraw(true);
        }
    }

    private final BBEditorView getView(ToggleViewsModule.Views view) {
        BBEditorView bBEditorView;
        if (view == ToggleViewsModule.Views.PRINT) {
            bBEditorView = this.textView;
        } else if (view == ToggleViewsModule.Views.BRAILLE) {
            bBEditorView = this.brailleView;
        } else if (view == ToggleViewsModule.Views.STYLE) {
            bBEditorView = this.stylePane;
        } else {
            throw new UnsupportedOperationException("Unhandled " + view);
        }
        return bBEditorView;
    }

    public final void setViewSizes() {
        List<ToggleViewsModule.Views> viewOrder = ToggleViewsModule.Companion.loadSettings();
        Companion.removeWindowedView(viewOrder);
        PropertyFileManager pfm = BBIni.getPropertyFileManager();
        int mainShellViewCount = this.mainShellViewCount();
        log.debug("mainShellViewCount {} actual {}", (Object)mainShellViewCount, (Object)this.containerSash.getChildren());
        int[] weights = new int[mainShellViewCount];
        int weightCounter = 0;
        int totalSize = 1000;
        int styleSize = 100;
        int printSize = 450;
        int brailleSize = 450;
        boolean style = viewOrder.contains((Object)ToggleViewsModule.Views.STYLE);
        boolean braille = viewOrder.contains((Object)ToggleViewsModule.Views.BRAILLE);
        boolean text = viewOrder.contains((Object)ToggleViewsModule.Views.PRINT);
        if (style) {
            int weightStyle = pfm.getPropertyAsInt(SETTING_WEIGHT_STYLE, 0);
            if (weightStyle != 0) {
                styleSize = weightStyle;
            }
            if (braille) {
                if (text) {
                    int weightPrint;
                    int weightBraille = pfm.getPropertyAsInt(SETTING_WEIGHT_BRAILLE, 0);
                    if (weightBraille != 0) {
                        brailleSize = weightBraille;
                    }
                    if ((weightPrint = pfm.getPropertyAsInt(SETTING_WEIGHT_PRINT, 0)) != 0) {
                        printSize = weightPrint;
                    }
                    if (printSize + brailleSize + styleSize > totalSize) {
                        brailleSize = printSize = (totalSize - styleSize) / 2;
                    }
                } else {
                    boolean bl = 1 <= styleSize ? styleSize < totalSize : false;
                    if (bl) {
                        brailleSize = totalSize - styleSize;
                    } else {
                        brailleSize = 800;
                        styleSize = 100;
                    }
                    printSize = 0;
                }
            } else {
                if (text) {
                    boolean bl = 1 <= styleSize ? styleSize < totalSize : false;
                    if (bl) {
                        printSize = totalSize - styleSize;
                    } else {
                        printSize = 800;
                        styleSize = 100;
                    }
                } else {
                    styleSize = 1000;
                    printSize = 0;
                }
                brailleSize = 0;
            }
        } else if (braille) {
            if (text) {
                int weightPrint;
                int weightBraille = pfm.getPropertyAsInt(SETTING_WEIGHT_BRAILLE, 0);
                if (weightBraille != 0) {
                    brailleSize = weightBraille;
                }
                if ((weightPrint = pfm.getPropertyAsInt(SETTING_WEIGHT_PRINT, 0)) != 0) {
                    printSize = weightPrint;
                }
                if (printSize + brailleSize > totalSize) {
                    brailleSize = printSize = totalSize / 2;
                }
            } else {
                brailleSize = 1000;
                printSize = 0;
            }
            styleSize = 0;
        } else {
            printSize = 1000;
            styleSize = 0;
            brailleSize = 0;
        }
        Control[] controlArray = this.containerSash.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)controlArray, (String)"getChildren(...)");
        for (Control curChild : controlArray) {
            if (curChild == this.stylePane.getView()) {
                weights[weightCounter++] = styleSize;
                continue;
            }
            if (curChild == this.textView.getView()) {
                weights[weightCounter++] = printSize;
                continue;
            }
            if (curChild != this.brailleView.getView()) continue;
            weights[weightCounter++] = brailleSize;
        }
        log.trace("Weightsarr: {} | Sizer {}", (Object)weights, (Object)weights.length);
        this.containerSash.setWeights(Arrays.copyOf(weights, weights.length));
    }

    public final void setTabList() {
        List<ToggleViewsModule.Views> viewOrder = ToggleViewsModule.Companion.loadSettings();
        Companion.removeWindowedView(viewOrder);
        Control[] tabList = new Control[viewOrder.size()];
        if (viewOrder.contains((Object)ToggleViewsModule.Views.STYLE)) {
            tabList[viewOrder.indexOf((Object)((Object)ToggleViewsModule.Views.STYLE))] = this.stylePane.getView();
        }
        if (viewOrder.contains((Object)ToggleViewsModule.Views.PRINT)) {
            tabList[viewOrder.indexOf((Object)((Object)ToggleViewsModule.Views.PRINT))] = this.textView.getView();
        }
        if (viewOrder.contains((Object)ToggleViewsModule.Views.BRAILLE)) {
            tabList[viewOrder.indexOf((Object)((Object)ToggleViewsModule.Views.BRAILLE))] = this.brailleView.getView();
        }
        this.containerSash.setTabList(tabList);
    }

    public final void saveScreenProperties() {
        PropertyFileManager pfm = BBIni.getPropertyFileManager();
        int[] weights = this.containerSash.getWeights();
        int weightCounter = 0;
        Control[] controlArray = this.containerSash.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)controlArray, (String)"getChildren(...)");
        for (Control curChild : controlArray) {
            int weight;
            if (weights.length <= weightCounter) break;
            if (weights[weightCounter] != 0) {
                boolean bl;
                block8: {
                    Iterable $this$any$iv = this.views;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            BBEditorView curView = (BBEditorView)element$iv;
                            boolean bl2 = false;
                            if (!(curView.getView() == curChild)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    ++weightCounter;
                    continue;
                }
            }
            if (curChild == this.stylePane.getView()) {
                int weight2;
                if ((weight2 = weights[weightCounter++]) == 0) continue;
                pfm.saveAsInt(SETTING_WEIGHT_STYLE, weight2);
                continue;
            }
            if (curChild == this.textView.getView()) {
                int weight3;
                if ((weight3 = weights[weightCounter++]) == 0) continue;
                pfm.saveAsInt(SETTING_WEIGHT_PRINT, weight3);
                continue;
            }
            if (curChild != this.brailleView.getView() || (weight = weights[weightCounter++]) == 0) continue;
            pfm.saveAsInt(SETTING_WEIGHT_BRAILLE, weight);
        }
    }

    public final void initializeListeners() {
        for (BBEditorView view : this.views) {
            view.initializeListeners();
        }
    }

    public final void removeListeners() {
        for (BBEditorView view : this.views) {
            view.removeListeners();
        }
    }

    public final void initializeModuleListeners(@Nullable BBEditorView view) {
        for (BBSimpleManager.SimpleListener curListener : this.m.getSimpleManager().getListeners()) {
            if (!(curListener instanceof BBViewListener)) continue;
            BBViewListener bBViewListener = (BBViewListener)((Object)curListener);
            BBEditorView bBEditorView = view;
            Intrinsics.checkNotNull((Object)bBEditorView);
            bBViewListener.initializeListener(bBEditorView);
        }
    }

    public final void removeModuleListeners(@NotNull BBEditorView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        for (BBSimpleManager.SimpleListener curListener : this.m.getSimpleManager().getListeners()) {
            if (!(curListener instanceof BBViewListener)) continue;
            ((BBViewListener)((Object)curListener)).removeListener(view);
        }
    }

    public final int mainShellViewCount() {
        int count = 0;
        Control[] controlArray = this.containerSash.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)controlArray, (String)"getChildren(...)");
        for (Control child : controlArray) {
            if (!(child instanceof StyledText)) continue;
            ++count;
        }
        return count;
    }

    @JvmStatic
    public static final void colorizeCompositeRecursive(@NotNull Composite composite) {
        Companion.colorizeCompositeRecursive(composite);
    }

    @JvmStatic
    public static final void colorizeToolbarHolder(@NotNull Composite composite) {
        Companion.colorizeToolbarHolder(composite);
    }

    @JvmStatic
    public static final void colorizeIconToolbars(@NotNull ToolBar bar) {
        Companion.colorizeIconToolbars(bar);
    }

    @JvmStatic
    public static final void colorizeCustomToolbars(@NotNull Composite composite) {
        Companion.colorizeCustomToolbars(composite);
    }

    @Nullable
    public static final ToggleViewsModule.Views getWindowedView() {
        return Companion.getWindowedView();
    }

    public static final void setWindowedView(@Nullable ToggleViewsModule.Views view) {
        Companion.setWindowedView(view);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0014\u0010+\u001a\u00020\u00152\f\u0010,\u001a\b\u0012\u0004\u0012\u00020$0-R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R.\u0010%\u001a\u0004\u0018\u00010$2\b\u0010#\u001a\u0004\u0018\u00010$8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b&\u0010\u0003\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006."}, d2={"Lorg/brailleblaster/perspectives/mvc/ViewManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "DEFAULT_SIZE", "", "DEFAULT_STYLE_PANE_SIZE", "DEFAULT_BRAILLE_SIZE", "DEFAULT_PRINT_SIZE", "SETTING_WEIGHT_STYLE", "", "SETTING_WEIGHT_PRINT", "SETTING_WEIGHT_BRAILLE", "SETTING_DARK_THEME", "SETTING_WINDOWED_VIEW", "windowedShell", "Lorg/eclipse/swt/widgets/Shell;", "colorizeCompositeRecursive", "", "composite", "Lorg/eclipse/swt/widgets/Composite;", "colorizeControl", "control", "Lorg/eclipse/swt/widgets/Control;", "colorizeToolbarHolder", "colorizeIconToolbars", "bar", "Lorg/eclipse/swt/widgets/ToolBar;", "colorizeCustomToolbars", "isDarkMode", "", "()Z", "view", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Views;", "windowedView", "getWindowedView$annotations", "getWindowedView", "()Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Views;", "setWindowedView", "(Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Views;)V", "removeWindowedView", "views", "", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewManager.kt\norg/brailleblaster/perspectives/mvc/ViewManager$Companion\n+ 2 PropertyFileManager.kt\norg/brailleblaster/utils/PropertyFileManager\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,439:1\n87#2:440\n1#3:441\n*S KotlinDebug\n*F\n+ 1 ViewManager.kt\norg/brailleblaster/perspectives/mvc/ViewManager$Companion\n*L\n422#1:440\n422#1:441\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void colorizeCompositeRecursive(@NotNull Composite composite) {
            Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
            if (!this.isDarkMode()) {
                return;
            }
            log.info("colorize " + composite);
            composite.setBackground(ColorManager.INSTANCE.getColor("1e1f1c", (Control)composite));
            Control[] controlArray = composite.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)controlArray, (String)"getChildren(...)");
            for (Control control : controlArray) {
                if (control instanceof Composite) {
                    this.colorizeCompositeRecursive((Composite)control);
                    continue;
                }
                Intrinsics.checkNotNull((Object)control);
                this.colorizeControl(control);
            }
        }

        public final void colorizeControl(@NotNull Control control) {
            Intrinsics.checkNotNullParameter((Object)control, (String)"control");
            if (!this.isDarkMode()) {
                return;
            }
            log.info("colorize control " + control);
            if (control instanceof StyledText) {
                ((StyledText)control).setBackground(ColorManager.INSTANCE.getColor("272822", control));
                ((StyledText)control).setForeground(ColorManager.INSTANCE.getColor("f8f8f2", control));
            }
        }

        @JvmStatic
        public final void colorizeToolbarHolder(@NotNull Composite composite) {
            Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        }

        @JvmStatic
        public final void colorizeIconToolbars(@NotNull ToolBar bar) {
            Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        }

        @JvmStatic
        public final void colorizeCustomToolbars(@NotNull Composite composite) {
            Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        }

        public final boolean isDarkMode() {
            return BBIni.getPropertyFileManager().getPropertyAsBoolean(ViewManager.SETTING_DARK_THEME, false);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ToggleViewsModule.Views getWindowedView() {
            Enum enum_;
            void this_$iv;
            PropertyFileManager propertyFileManager = BBIni.getPropertyFileManager();
            String property$iv = ViewManager.SETTING_WINDOWED_VIEW;
            boolean $i$f$getPropertyAsEnumOrNull = false;
            String string = this_$iv.getProperty(property$iv);
            if (string != null) {
                String it$iv = string;
                boolean bl = false;
                enum_ = ToggleViewsModule.Views.valueOf(it$iv);
            } else {
                enum_ = null;
            }
            return (ToggleViewsModule.Views)enum_;
        }

        public final void setWindowedView(@Nullable ToggleViewsModule.Views view) {
            if (view == null) {
                BBIni.getPropertyFileManager().removeProperty(ViewManager.SETTING_WINDOWED_VIEW);
            } else {
                BBIni.getPropertyFileManager().saveAsEnum(ViewManager.SETTING_WINDOWED_VIEW, (Enum)view);
            }
        }

        @JvmStatic
        public static /* synthetic */ void getWindowedView$annotations() {
        }

        public final void removeWindowedView(@NotNull List<ToggleViewsModule.Views> views) {
            Intrinsics.checkNotNullParameter(views, (String)"views");
            ToggleViewsModule.Views windowedView = this.getWindowedView();
            if (windowedView != null) {
                views.remove((Object)windowedView);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

