/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.views.wp.BrailleView;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.SharedItem;
import org.brailleblaster.perspectives.mvc.modules.misc.AlphabeticReferenceModule;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u001f !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ContextMenuModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "tv", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "bv", "Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "items", "", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ContextMenuModule$ContextItem;", "moduleInitialized", "", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "buildItems", "createMenu", "Lorg/brailleblaster/perspectives/mvc/events/XMLCaretEvent;", "parent", "Lorg/eclipse/swt/widgets/Control;", "disposeExistingMenus", "isMultiSelected", "isInTable", "checkTable", "node", "Lnu/xom/Node;", "isGuideWord", "Items", "ContextItem", "ContextSubItem", "brailleblaster-core"})
public final class ContextMenuModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    private final Manager manager;
    @NotNull
    private final TextView tv;
    @NotNull
    private final BrailleView bv;
    @Nullable
    private List<? extends ContextItem> items;
    private boolean moduleInitialized;

    public ContextMenuModule(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        TextView textView = this.manager.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"getText(...)");
        this.tv = textView;
        BrailleView brailleView = this.manager.getBraille();
        Intrinsics.checkNotNullExpressionValue((Object)brailleView, (String)"getBraille(...)");
        this.bv = brailleView;
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent) {
            this.items = this.buildItems();
            this.moduleInitialized = true;
        }
        if (event instanceof XMLCaretEvent && this.moduleInitialized) {
            this.disposeExistingMenus();
            if (this.manager.getWpManager().isClosed()) {
                return;
            }
            this.createMenu((XMLCaretEvent)event, (Control)this.tv.getView());
            this.createMenu((XMLCaretEvent)event, (Control)this.bv.getView());
        }
    }

    private final List<ContextItem> buildItems() {
        Object[] objectArray = new ContextItem[]{new ContextItem(Items.COPY.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)ContextMenuModule::buildItems$lambda$0), MenuManager.getSharedSelection(SharedItem.COPY)), new ContextItem(Items.COPY_UNICODE.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)ContextMenuModule::buildItems$lambda$1), MenuManager.getSharedSelection(SharedItem.COPY_UNICODE)), new ContextItem(Items.CUT.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)arg_0 -> ContextMenuModule.buildItems$lambda$2(this, arg_0)), MenuManager.getSharedSelection(SharedItem.CUT)), new ContextItem(Items.PASTE.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)arg_0 -> ContextMenuModule.buildItems$lambda$3(this, arg_0)), MenuManager.getSharedSelection(SharedItem.PASTE)), new ContextItem(Items.PASTE_AS_MATH.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)arg_0 -> ContextMenuModule.buildItems$lambda$4(this, arg_0)), MenuManager.getSharedSelection(SharedItem.PASTE_AS_MATH)), new ContextSubItem(Items.CHANGE_TRANSLATION.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)arg_0 -> ContextMenuModule.buildItems$lambda$5(this, arg_0)), SharedItem.CHANGE_TRANSLATION), new ContextItem(Items.EDIT_PAGE_NUMBER.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)ContextMenuModule::buildItems$lambda$6), MenuManager.getSharedSelection(SharedItem.EDIT_PAGE_NUMBER)), new ContextItem(Items.EDIT_TABLE.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)arg_0 -> ContextMenuModule.buildItems$lambda$7(this, arg_0)), MenuManager.getSharedSelection(SharedItem.EDIT_TABLE)), new ContextItem(Items.MATH_TOGGLE.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)ContextMenuModule::buildItems$lambda$8), MenuManager.getSharedSelection(SharedItem.MATH_TOGGLE)), new ContextItem(Items.NUMBER_LINE.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)ContextMenuModule::buildItems$lambda$9), MenuManager.getSharedSelection(SharedItem.NUMBER_LINE)), new ContextItem(Items.MATRIX.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)ContextMenuModule::buildItems$lambda$10), MenuManager.getSharedSelection(SharedItem.MATRIX)), new ContextItem(Items.SPATIAL_COMBO.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)ContextMenuModule::buildItems$lambda$11), MenuManager.getSharedSelection(SharedItem.SPATIAL_COMBO)), new ContextItem(AlphabeticReferenceModule.EDIT_GUIDE_WORD, (Function1<? super XMLCaretEvent, Boolean>)((Function1)arg_0 -> ContextMenuModule.buildItems$lambda$12(this, arg_0)), MenuManager.getSharedSelection(SharedItem.EDIT_GUIDE_WORD)), new ContextItem(Items.INSERT_LINK.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)arg_0 -> ContextMenuModule.buildItems$lambda$13(this, arg_0)), MenuManager.getSharedSelection(SharedItem.INSERT_LINK)), new ContextItem(Items.INSERT_BOOKMARK.getLabel(), (Function1<? super XMLCaretEvent, Boolean>)((Function1)ContextMenuModule::buildItems$lambda$14), MenuManager.getSharedSelection(SharedItem.INSERT_BOOKMARK))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void createMenu(XMLCaretEvent event, Control parent) {
        Menu newMenu = new Menu(parent);
        List<? extends ContextItem> list = this.items;
        Intrinsics.checkNotNull(list);
        for (ContextItem contextItem : list) {
            if (contextItem instanceof ContextSubItem) {
                SharedItem sharedItem = ((ContextSubItem)contextItem).getMenuSource();
                Intrinsics.checkNotNull((Object)((Object)sharedItem));
                Menu subMenu = MenuManager.createSharedSubMenu(sharedItem, parent.getShell(), false);
                MenuItem smItem = new MenuItem(newMenu, 64);
                smItem.setText(contextItem.getName());
                smItem.setEnabled(contextItem.test(event));
                smItem.setMenu(subMenu);
                continue;
            }
            MenuItem newItem = new MenuItem(newMenu, 8);
            newItem.setText(contextItem.getName());
            newItem.setEnabled(contextItem.test(event));
            newItem.addSelectionListener((SelectionListener)new SelectionAdapter(contextItem, newItem){
                final /* synthetic */ ContextItem $menuItem;
                final /* synthetic */ MenuItem $newItem;
                {
                    this.$menuItem = $menuItem;
                    this.$newItem = $newItem;
                }

                public void widgetSelected(SelectionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$menuItem.execute(new BBSelectionData((Widget)this.$newItem, WPManager.Companion.getInstance()));
                }
            });
        }
        parent.setMenu(newMenu);
    }

    private final void disposeExistingMenus() {
        if (this.tv.getView().getMenu() != null) {
            this.tv.getView().getMenu().dispose();
        }
        if (this.bv.getView().getMenu() != null) {
            this.bv.getView().getMenu().dispose();
        }
    }

    private final boolean isMultiSelected(XMLCaretEvent event) {
        boolean bl;
        if (event.start.getNode() != event.end.getNode()) {
            return true;
        }
        if (event.start instanceof XMLTextCaret) {
            int n = ((XMLTextCaret)event.start).getOffset();
            XMLNodeCaret xMLNodeCaret = event.end;
            Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
            bl = n != ((XMLTextCaret)xMLNodeCaret).getOffset();
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isInTable(XMLCaretEvent event) {
        if (this.checkTable(event.start.getNode())) {
            return true;
        }
        return event.start != event.end ? this.checkTable(event.end.getNode()) : false;
    }

    private final boolean checkTable(Node node) {
        return node instanceof Element && Manager.getTableParent(node) != null ? true : Manager.getTableParent((Node)node.getParent()) != null;
    }

    private final boolean isGuideWord(XMLCaretEvent event) {
        UTDTranslationEngine engine = event.getManager().getUtdManager().getEngine();
        IStyle style = engine.getStyle(event.start.getNode());
        return style != null && style.isGuideWords();
    }

    private static final boolean buildItems$lambda$0(XMLCaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean buildItems$lambda$1(XMLCaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean buildItems$lambda$2(ContextMenuModule this$0, XMLCaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this$0.isMultiSelected(event);
    }

    private static final boolean buildItems$lambda$3(ContextMenuModule this$0, XMLCaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return !this$0.isInTable(e);
    }

    private static final boolean buildItems$lambda$4(ContextMenuModule this$0, XMLCaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return !this$0.isInTable(e);
    }

    private static final boolean buildItems$lambda$5(ContextMenuModule this$0, XMLCaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this$0.isMultiSelected(event);
    }

    private static final boolean buildItems$lambda$6(XMLCaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean buildItems$lambda$7(ContextMenuModule this$0, XMLCaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this$0.isInTable(event);
    }

    private static final boolean buildItems$lambda$8(XMLCaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean buildItems$lambda$9(XMLCaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NumberLine.Companion.currentIsNumberLine();
    }

    private static final boolean buildItems$lambda$10(XMLCaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Matrix.Companion.currentIsMatrix();
    }

    private static final boolean buildItems$lambda$11(XMLCaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SpatialMathUtils.currentIsSpatialGrid();
    }

    private static final boolean buildItems$lambda$12(ContextMenuModule this$0, XMLCaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this$0.isGuideWord(event);
    }

    private static final boolean buildItems$lambda$13(ContextMenuModule this$0, XMLCaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.manager.getSimpleManager().getCurrentSelection().isTextNoSelection() || this$0.manager.getMapList().getCurrent().getNodeParent() != null && BBX.INLINE.LINK.isA((Node)this$0.manager.getMapList().getCurrent().getNodeParent());
    }

    private static final boolean buildItems$lambda$14(XMLCaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0012\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\tH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ContextMenuModule$ContextItem;", "", "name", "", "enable", "Lkotlin/Function1;", "Lorg/brailleblaster/perspectives/mvc/events/XMLCaretEvent;", "", "onSelect", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "test", "event", "execute", "brailleblaster-core"})
    private static class ContextItem {
        @NotNull
        private String name;
        @NotNull
        private final Function1<XMLCaretEvent, Boolean> enable;
        @NotNull
        private final Function1<BBSelectionData, Unit> onSelect;

        public ContextItem(@NotNull String name, @NotNull Function1<? super XMLCaretEvent, Boolean> enable, @NotNull Function1<? super BBSelectionData, Unit> onSelect) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(enable, (String)"enable");
            Intrinsics.checkNotNullParameter(onSelect, (String)"onSelect");
            this.name = name;
            this.enable = enable;
            this.onSelect = onSelect;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        public final boolean test(@NotNull XMLCaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return (Boolean)this.enable.invoke((Object)event);
        }

        public void execute(@NotNull BBSelectionData event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.onSelect.invoke((Object)event);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ContextMenuModule$ContextSubItem;", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ContextMenuModule$ContextItem;", "name", "", "enable", "Lkotlin/Function1;", "Lorg/brailleblaster/perspectives/mvc/events/XMLCaretEvent;", "", "menuSource", "Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;)V", "getMenuSource", "()Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;", "setMenuSource", "(Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;)V", "execute", "", "event", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "brailleblaster-core"})
    private static final class ContextSubItem
    extends ContextItem {
        @Nullable
        private SharedItem menuSource;

        public ContextSubItem(@NotNull String name, @NotNull Function1<? super XMLCaretEvent, Boolean> enable, @Nullable SharedItem menuSource) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(enable, (String)"enable");
            super(name, enable, (Function1<? super BBSelectionData, Unit>)((Function1)ContextSubItem::_init_$lambda$0));
            this.menuSource = menuSource;
        }

        public /* synthetic */ ContextSubItem(String string, Function1 function1, SharedItem sharedItem, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                sharedItem = null;
            }
            this(string, (Function1<? super XMLCaretEvent, Boolean>)function1, sharedItem);
        }

        @Nullable
        public final SharedItem getMenuSource() {
            return this.menuSource;
        }

        public final void setMenuSource(@Nullable SharedItem sharedItem) {
            this.menuSource = sharedItem;
        }

        @Override
        public void execute(@NotNull BBSelectionData event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        private static final Unit _init_$lambda$0(BBSelectionData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ContextMenuModule$Items;", "", "label", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "COPY", "COPY_UNICODE", "CUT", "PASTE", "PASTE_AS_MATH", "HIDE", "EDIT_PAGE_NUMBER", "EDIT_TABLE", "CHANGE_TRANSLATION", "MATH_TOGGLE", "NUMBER_LINE", "MATRIX", "SPATIAL_COMBO", "INSERT_LINK", "INSERT_BOOKMARK", "brailleblaster-core"})
    public static final class Items
    extends Enum<Items> {
        @NotNull
        private final String label;
        public static final /* enum */ Items COPY = new Items(StringsKt.replace$default((String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("&Copy"), (String)"&", (String)"", (boolean)false, (int)4, null));
        public static final /* enum */ Items COPY_UNICODE = new Items(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("CopyUnicode"));
        public static final /* enum */ Items CUT = new Items(StringsKt.replace$default((String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("&Cut"), (String)"&", (String)"", (boolean)false, (int)4, null));
        public static final /* enum */ Items PASTE = new Items(StringsKt.replace$default((String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("&Paste"), (String)"&", (String)"", (boolean)false, (int)4, null));
        public static final /* enum */ Items PASTE_AS_MATH = new Items(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("PasteAsMath"));
        public static final /* enum */ Items HIDE = new Items(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("Hide"));
        public static final /* enum */ Items EDIT_PAGE_NUMBER = new Items("Edit Page Number");
        public static final /* enum */ Items EDIT_TABLE = new Items(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("editTable"));
        public static final /* enum */ Items CHANGE_TRANSLATION = new Items(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("ChangeTranslation"));
        public static final /* enum */ Items MATH_TOGGLE = new Items(MathModuleUtils.MATH_TOGGLE);
        public static final /* enum */ Items NUMBER_LINE = new Items(MathModuleUtils.INSTANCE.getNUMBER_LINE());
        public static final /* enum */ Items MATRIX = new Items(MathModuleUtils.INSTANCE.getMATRIX());
        public static final /* enum */ Items SPATIAL_COMBO = new Items(MathModuleUtils.SPATIAL_COMBO);
        public static final /* enum */ Items INSERT_LINK = new Items(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("InsertLink"));
        public static final /* enum */ Items INSERT_BOOKMARK = new Items(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("BookmarksMenu"));
        private static final /* synthetic */ Items[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Items(String label) {
            this.label = label;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public static Items[] values() {
            return (Items[])$VALUES.clone();
        }

        public static Items valueOf(String value) {
            return Enum.valueOf(Items.class, value);
        }

        @NotNull
        public static EnumEntries<Items> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = itemsArray = new Items[]{Items.COPY, Items.COPY_UNICODE, Items.CUT, Items.PASTE, Items.PASTE_AS_MATH, Items.HIDE, Items.EDIT_PAGE_NUMBER, Items.EDIT_TABLE, Items.CHANGE_TRANSLATION, Items.MATH_TOGGLE, Items.NUMBER_LINE, Items.MATRIX, Items.SPATIAL_COMBO, Items.INSERT_LINK, Items.INSERT_BOOKMARK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

