/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.BBIni;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.ArchiverFactory;
import org.brailleblaster.archiver2.ArchiverRecoverThread;
import org.brailleblaster.archiver2.BBZArchiver;
import org.brailleblaster.archiver2.SaveOptions;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.SubMenuBuilder;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.tools.BraillePreviewTool;
import org.brailleblaster.tools.CloseTool;
import org.brailleblaster.tools.EmbossTool;
import org.brailleblaster.tools.ExitTool;
import org.brailleblaster.tools.ExportMenuTool;
import org.brailleblaster.tools.NewFileTool;
import org.brailleblaster.tools.OpenFileTool;
import org.brailleblaster.tools.PrintTool;
import org.brailleblaster.tools.SaveAsTool;
import org.brailleblaster.tools.SaveTool;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.wordprocessor.BBFileDialog;
import org.brailleblaster.wordprocessor.RecentDocs;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/FileModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "<init>", "()V", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "buildSubMenu", "Lorg/brailleblaster/perspectives/mvc/menu/SubMenuBuilder;", "buildSubMenuAutoSave", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nFileModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/FileModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n1915#2,2:206\n1915#2,2:208\n*S KotlinDebug\n*F\n+ 1 FileModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/FileModule\n*L\n86#1:206,2\n99#1:208,2\n*E\n"})
public final class FileModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(FileModule.class);

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent) {
            MenuManager.INSTANCE.add(NewFileTool.INSTANCE);
            MenuManager.INSTANCE.add(OpenFileTool.INSTANCE);
            MenuManager.INSTANCE.add(this.buildSubMenu().build());
            MenuManager.INSTANCE.add(this.buildSubMenuAutoSave().build());
            MenuManager.INSTANCE.add(SaveTool.INSTANCE);
            MenuManager.INSTANCE.add(SaveAsTool.INSTANCE);
            MenuManager.INSTANCE.add(ExportMenuTool.INSTANCE);
            MenuManager.INSTANCE.add(PrintTool.INSTANCE);
            MenuManager.INSTANCE.add(EmbossTool.INSTANCE);
            MenuManager.INSTANCE.add(BraillePreviewTool.INSTANCE);
            MenuManager.INSTANCE.add(CloseTool.INSTANCE);
            MenuManager.INSTANCE.add(ExitTool.INSTANCE);
        }
    }

    private final SubMenuBuilder buildSubMenu() {
        SubMenuBuilder smb = new SubMenuBuilder(TopMenu.FILE, "Recent Document");
        List<Path> recentDocs = RecentDocs.Companion.getDefaultRecentDocs().getRecentDocs();
        Iterable $this$forEach$iv = recentDocs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path curPath = (Path)element$iv;
            boolean bl = false;
            String itemText = curPath.getFileName() + "  [" + curPath + "]";
            SubMenuBuilder.addItem$default(smb, itemText, 0, 0, null, arg_0 -> FileModule.buildSubMenu$lambda$0$0(curPath, arg_0), 12, null);
        }
        return smb;
    }

    private final SubMenuBuilder buildSubMenuAutoSave() {
        SubMenuBuilder smb = new SubMenuBuilder(TopMenu.FILE, "Recent Auto Saves");
        List<Path> recentSaves = ArchiverRecoverThread.Companion.getRecentSaves();
        Iterable $this$forEach$iv = recentSaves;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path curPath = (Path)element$iv;
            boolean bl = false;
            String fileName = ((Object)curPath.getFileName()).toString();
            String itemText = fileName + "  [" + curPath + "]";
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(curPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(curPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
            SubMenuBuilder.addItem$default(smb, itemText, 0, 0, null, arg_0 -> FileModule.buildSubMenuAutoSave$lambda$0$0(curPath, arg_0), 12, null);
        }
        return smb;
    }

    private static final void buildSubMenu$lambda$0$0(Path $curPath, BBSelectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WPManager.Companion.getInstance().addDocumentManager($curPath);
    }

    private static final void buildSubMenuAutoSave$lambda$0$0(Path $curPath, BBSelectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WPManager.Companion.getInstance().addDocumentManager($curPath);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/FileModule$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "fileSave", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "saveAs", "save", "", "arch", "Lorg/brailleblaster/archiver2/Archiver2;", "filePath", "Ljava/nio/file/Path;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nFileModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/FileModule$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,205:1\n37#2,2:206\n37#2,2:208\n*S KotlinDebug\n*F\n+ 1 FileModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/FileModule$Companion\n*L\n161#1:206,2\n162#1:208,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean fileSave(@NotNull Manager m) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            log.debug("Saving file");
            m.checkForUpdatedViews();
            m.waitForFormatting(true);
            Archiver2 archiver2 = m.getArchiver();
            Intrinsics.checkNotNullExpressionValue((Object)archiver2, (String)"<get-archiver>(...)");
            Archiver2 arch = archiver2;
            String pathToRemove = ((Object)arch.getPath().getFileName()).toString();
            boolean isNewFile = Intrinsics.areEqual((Object)arch.getPath(), (Object)Manager.DEFAULT_FILE);
            boolean isImported = arch.isImported();
            boolean isRecoveryFile = StringsKt.contains$default((CharSequence)((Object)arch.getPath()).toString(), (CharSequence)((Object)BBIni.getAutoSavePath()).toString(), (boolean)false, (int)2, null);
            boolean isNotWritable = !arch.getPath().toFile().canWrite();
            Object[] objectArray = new Object[]{isNewFile, isImported, isRecoveryFile, isNotWritable};
            log.debug("isNewFile {} isImported {} isRecoveryFile {} isNotWritable {}", objectArray);
            if (isNewFile || isImported || isRecoveryFile || isNotWritable) {
                boolean success = this.saveAs(m);
                if (success) {
                    log.error("Setting as not imported");
                    arch.setNotImported();
                }
                log.debug("Saved file");
                bl = success;
            } else {
                this.save(m, arch, arch.getPath());
                Path path = Paths.get(pathToRemove, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                ArchiverRecoverThread.Companion.removeFile(path);
                log.debug("Saved file");
                bl = true;
            }
            return bl;
        }

        public final boolean saveAs(@NotNull Manager m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            log.debug("Saving as");
            m.waitForFormatting(true);
            Archiver2 archiver2 = m.getArchiver();
            Intrinsics.checkNotNullExpressionValue((Object)archiver2, (String)"<get-archiver>(...)");
            Archiver2 arch = archiver2;
            String pathToRemove = ((Object)arch.getPath().getFileName()).toString();
            String filePath = null;
            if (!BBIni.getDebugging()) {
                Path path = arch.getNewPath();
                if (path == null) {
                    path = arch.getPath();
                }
                Path path2 = path.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getFileName(...)");
                String fileName = PathsKt.getNameWithoutExtension((Path)path2);
                Collection<String> $this$toTypedArray$iv = ArchiverFactory.INSTANCE.getSupportedDescriptions(arch);
                boolean $i$f$toTypedArray = false;
                Collection<String> thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = ArchiverFactory.INSTANCE.getSupportedExtensions(arch);
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                BBFileDialog dialog = new BBFileDialog(m.getWpManager().getShell(), 8192, fileName, thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]), 0, null, 96, null);
                filePath = dialog.open();
            } else {
                filePath = String.valueOf(BBIni.getDebugSavePath());
            }
            if (filePath == null) {
                log.debug("User cancelled save as");
                return false;
            }
            Path path = Paths.get(filePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            this.save(m, arch, path);
            Path path3 = Paths.get(pathToRemove, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            ArchiverRecoverThread.Companion.removeFile(path3);
            arch.setNotImported();
            log.debug("File saved");
            return true;
        }

        private final void save(Manager m, Archiver2 arch, Path filePath) {
            m.checkForUpdatedViews();
            UTDTranslationEngine engine = m.getDocument().getEngine();
            if (Intrinsics.areEqual((Object)filePath, (Object)arch.getPath())) {
                Object[] objectArray = new SaveOptions[]{BBZArchiver.BBZSaveOptions.IncludeBRF, BBZArchiver.BBZSaveOptions.IncludePEF};
                arch.save(filePath, arch.getBbxDocument(), engine, SetsKt.setOf((Object[])objectArray));
            } else {
                Object[] objectArray = new SaveOptions[]{BBZArchiver.BBZSaveOptions.IncludeBRF, BBZArchiver.BBZSaveOptions.IncludePEF};
                arch.saveAs(filePath, arch.getBbxDocument(), engine, SetsKt.setOf((Object[])objectArray));
                m.setTabTitle(((Object)filePath.getFileName()).toString());
                RecentDocs.Companion.getDefaultRecentDocs().addRecentDoc(arch.getPath());
            }
            m.getText().hasChanged = false;
            m.getBraille().hasChanged = false;
            m.setDocumentEdited(false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

