/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.HexFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.utils.swt.EasyListeners;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/InsertUnicode;", "Lorg/eclipse/swt/widgets/Dialog;", "Lorg/brailleblaster/tools/MenuToolModule;", "parent", "Lorg/eclipse/swt/widgets/Shell;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;)V", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "addUnicodeChar", "char", "", "convertUnicodeChar", "text", "base", "", "Companion", "brailleblaster-core"})
public final class InsertUnicode
extends Dialog
implements MenuToolModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TopMenu topMenu;
    @NotNull
    private final String title;
    @NotNull
    public static final String MENU_NAME = "Unicode Character";
    @NotNull
    public static final String SHELL_NAME = "Insert Unicode";
    @NotNull
    public static final String BUTTON_NAME = "Copy to Clipboard";
    public static final int GRID_SIZE = 5;
    @NotNull
    public static final String TOOLTIP_TEXT = "Enter a 4-digit Unicode key in Hexadecimal (0-F)";
    @NotNull
    public static final String UNICODE_LABEL = "U+";
    @NotNull
    public static final String COMMON_SYMBOLS = "Common Symbols:";
    @NotNull
    private static final int[] commonSymbols;

    public InsertUnicode(@NotNull Shell parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent, 0);
        this.topMenu = TopMenu.INSERT;
        this.title = SHELL_NAME;
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return this.topMenu;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        Shell shell = new Shell(this.getParent().getDisplay(), 16779376);
        shell.setText(SHELL_NAME);
        shell.setLayout((Layout)new GridLayout(1, false));
        Group inputComp = EasySWT.makeGroup((Composite)((Composite)shell), (int)0x1000000, (int)4, (boolean)false);
        Label unicodeLabel = new Label((Composite)inputComp, 131072);
        unicodeLabel.setText(UNICODE_LABEL);
        Text entryText = EasySWT.makeText((Composite)((Composite)inputComp), (int)40, (int)1);
        entryText.setToolTipText(TOOLTIP_TEXT);
        entryText.setTextLimit(4);
        Text displayText = new Text((Composite)inputComp, 0x1000808);
        entryText.addModifyListener(arg_0 -> InsertUnicode.onRun$lambda$0(this, entryText, displayText, arg_0));
        EasySWT.INSTANCE.addEnterListener((Control)entryText, arg_0 -> InsertUnicode.onRun$lambda$1(this, entryText, arg_0));
        EasyListeners.INSTANCE.verifyHexadecimal(entryText);
        EasySWT.makePushButton((Composite)((Composite)inputComp), (String)BUTTON_NAME, (int)1, arg_0 -> InsertUnicode.onRun$lambda$2(this, entryText, arg_0));
        Group buttonGrid = EasySWT.makeGroup((Composite)((Composite)shell), (int)0x1000000, (int)5, (boolean)true);
        buttonGrid.setLayout((Layout)new GridLayout(5, true));
        buttonGrid.setText(COMMON_SYMBOLS);
        for (int s : commonSymbols) {
            Button pb = EasySWT.makePushButton((Composite)((Composite)buttonGrid), (String)(" " + (char)s + " "), (int)1, arg_0 -> InsertUnicode.onRun$lambda$3(s, entryText, arg_0));
            pb.setToolTipText(Character.getName(s));
        }
        EasySWT.INSTANCE.addEscapeCloseListener(shell);
        shell.pack();
        shell.open();
    }

    private final void addUnicodeChar(char c) {
        TextTransfer tt = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        clipboard.clearContents();
        if (c != ' ') {
            Object[] objectArray = new String[]{String.valueOf(c)};
            Object[] objectArray2 = objectArray;
            objectArray = new Transfer[1];
            Intrinsics.checkNotNull((Object)tt);
            objectArray[0] = tt;
            clipboard.setContents(objectArray2, (Transfer[])objectArray);
        }
    }

    private final char convertUnicodeChar(String text, int base) {
        char c;
        try {
            c = (char)Integer.parseInt(text, CharsKt.checkRadix((int)base));
        }
        catch (NumberFormatException nfe) {
            c = ' ';
        }
        char convertedChar = c;
        return convertedChar;
    }

    static /* synthetic */ char convertUnicodeChar$default(InsertUnicode insertUnicode, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 16;
        }
        return insertUnicode.convertUnicodeChar(string, n);
    }

    private static final void onRun$lambda$0(InsertUnicode this$0, Text $entryText, Text $displayText, ModifyEvent it) {
        String string = $entryText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char newText = InsertUnicode.convertUnicodeChar$default(this$0, string, 0, 2, null);
        $displayText.setText(String.valueOf(newText));
        $displayText.setToolTipText(Character.getName(newText));
    }

    private static final void onRun$lambda$1(InsertUnicode this$0, Text $entryText, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $entryText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.addUnicodeChar(InsertUnicode.convertUnicodeChar$default(this$0, string, 0, 2, null));
        $entryText.setText("");
        $entryText.forceFocus();
    }

    private static final void onRun$lambda$2(InsertUnicode this$0, Text $entryText, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $entryText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.addUnicodeChar(InsertUnicode.convertUnicodeChar$default(this$0, string, 0, 2, null));
        $entryText.setText("");
        $entryText.forceFocus();
    }

    private static final void onRun$lambda$3(int $s, Text $entryText, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String hexVal = "0x" + HexFormat.of().toHexDigits($s);
        String string = hexVal.substring(6);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        $entryText.setText(string);
        $entryText.forceFocus();
    }

    static {
        int[] nArray = new int[]{36, 162, 163, 8364, 165, 8216, 8217, 191, 161, 8211, 174, 169, 8482, 176, 8212};
        commonSymbols = nArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/InsertUnicode$Companion;", "", "<init>", "()V", "MENU_NAME", "", "SHELL_NAME", "BUTTON_NAME", "GRID_SIZE", "", "TOOLTIP_TEXT", "UNICODE_LABEL", "COMMON_SYMBOLS", "commonSymbols", "", "getCommonSymbols", "()[I", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getCommonSymbols() {
            return commonSymbols;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

