/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLSelection;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/TableSelectionModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "value", "", "isTableSelected", "()Z", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "Companion", "brailleblaster-core"})
public final class TableSelectionModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager manager;
    private boolean isTableSelected;
    @NotNull
    public static final String TABLE_WARNING_DIALOG_TITLE = "Table Warning";
    @NotNull
    private static final String TABLE_WARNING_DIALOG = "This element is read-only because it is inside a table. To edit it, right-click and select \"Edit Table\".";
    private static final Logger log = LoggerFactory.getLogger(TableSelectionModule.class);

    public TableSelectionModule(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
    }

    public final boolean isTableSelected() {
        return this.isTableSelected;
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof XMLCaretEvent) {
            XMLSelection selection = this.manager.getSimpleManager().getCurrentSelection();
            List<Element> blocks = selection.getSelectedBlocks();
            boolean previouslyLocked = this.isTableSelected;
            this.isTableSelected = false;
            if (selection.start != selection.end || selection.start.getCursorPosition() == XMLNodeCaret.CursorPosition.ALL) {
                for (Element block : blocks) {
                    if (!Companion.isInsideTable((Node)block)) continue;
                    this.isTableSelected = true;
                    break;
                }
            }
            if (previouslyLocked && !this.isTableSelected) {
                log.debug("No longer inside table");
            } else if (this.isTableSelected && !previouslyLocked) {
                log.debug("Now entering table");
            }
        }
    }

    @JvmStatic
    public static final void displayInvalidTableMessage(@Nullable Shell parent) {
        Companion.displayInvalidTableMessage(parent);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/TableSelectionModule$Companion;", "", "<init>", "()V", "TABLE_WARNING_DIALOG_TITLE", "", "TABLE_WARNING_DIALOG", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isInsideTable", "", "n", "Lnu/xom/Node;", "displayInvalidTableMessage", "", "parent", "Lorg/eclipse/swt/widgets/Shell;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isInsideTable(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            if (BBX.BLOCK.TABLE_CELL.isA(n) || BBX.CONTAINER.TABLE_ROW.isA(n) || BBX.CONTAINER.TABLE.isA(n)) {
                return true;
            }
            if (BBX.CONTAINER.isA(n) || BBX.SECTION.isA(n) || n instanceof Document) {
                return false;
            }
            return BBX.CONTAINER.TABLE.isA((Node)(n instanceof Text || BBX.SPAN.isA(n) || BBX.INLINE.isA(n) ? (Node)SequencesKt.last((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)n, Companion::isInsideTable$lambda$0), Companion::isInsideTable$lambda$1)) : n).getParent());
        }

        @JvmStatic
        public final void displayInvalidTableMessage(@Nullable Shell parent) {
            EasySWT.makeEasyOkDialog((String)TableSelectionModule.TABLE_WARNING_DIALOG_TITLE, (String)TableSelectionModule.TABLE_WARNING_DIALOG, (Shell)parent);
        }

        private static final Node isInsideTable$lambda$0(Node it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Node)it.getParent();
        }

        private static final boolean isInsideTable$lambda$1(Node it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !BBX.BLOCK.isA(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

