/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.views;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.perspectives.mvc.modules.views.AbstractModule;
import org.brailleblaster.perspectives.mvc.modules.views.BrailleViewModuleKt;
import org.brailleblaster.tools.CheckMenuTool;
import org.brailleblaster.wordprocessor.FontManager;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/views/BrailleViewModule;", "Lorg/brailleblaster/perspectives/mvc/modules/views/AbstractModule;", "Lorg/brailleblaster/tools/CheckMenuTool;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "active", "", "getActive", "()Z", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "onEvent", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "brailleblaster-core"})
public final class BrailleViewModule
extends AbstractModule
implements CheckMenuTool,
BBSimpleManager.SimpleListener {
    @NotNull
    private final Manager manager;
    @NotNull
    private final TopMenu topMenu;
    @NotNull
    private final String title;
    private final boolean active;

    public BrailleViewModule(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.sender = Sender.BRAILLE;
        this.topMenu = TopMenu.VIEW;
        this.title = BrailleViewModuleKt.access$getLocaleHandler$p().get("&ViewBraille");
        this.active = FontManager.Companion.isShowBraille();
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return this.topMenu;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        FontManager fontManager = bbData.getManager().getFontManager();
        Widget widget = bbData.getWidget();
        Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type org.eclipse.swt.widgets.MenuItem");
        fontManager.toggleBrailleFont(((MenuItem)widget).getSelection());
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof XMLCaretEvent) {
            if (!(((XMLCaretEvent)event).start instanceof XMLTextCaret)) {
                return;
            }
            XMLNodeCaret caret = ((XMLCaretEvent)event).start;
            MapList mapList = this.manager.getMapList();
            int tmeIndex = mapList.findNodeIndex((Node)((XMLTextCaret)caret).getNode(), 0);
            if (this.manager.needsMapListUpdate() && tmeIndex < 0) {
                this.manager.waitForFormatting(true);
                tmeIndex = mapList.findNodeIndex((Node)((XMLTextCaret)caret).getNode(), 0);
            }
            if (tmeIndex >= 0) {
                Object e = mapList.get(tmeIndex);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                TextMapElement tme = (TextMapElement)e;
                this.manager.checkView(tme);
                mapList.setCurrent(tmeIndex);
                if (event.getSender() != Sender.BRAILLE) {
                    this.manager.getBraille().setPositionFromStart(0);
                    this.manager.getBraille().cursorOffset = 0;
                    this.manager.getBraille().updateCursor(tme, ((XMLTextCaret)caret).getOffset());
                }
            }
        }
        if (event instanceof BuildMenuEvent) {
            MenuManager.INSTANCE.add(this);
        }
    }
}

