/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.views;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.mvc.XMLSelection;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.modules.views.EmphasisModule;
import org.brailleblaster.perspectives.mvc.modules.views.EmphasisModuleKt$getFinalTextNode$;
import org.brailleblaster.perspectives.mvc.modules.views.EmphasisModuleKt$getFirstTextNode$;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.internal.xml.XMLHandlerKt;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\u000eH\u0002\u001a6\u0010\u0018\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\nH\u0002\u001a\u001e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u001a\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001aH\u0002\u001a\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u001aH\u0002\u001a8\u0010$\u001a\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010\u00102\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a.\u0010'\u001a\u00020\u00102\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0001H\u0002\u001a.\u0010,\u001a\u00020\u000e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a.\u0010-\u001a\u00020\u000e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"NO_OFFSET", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "processNotice", "Lorg/eclipse/swt/widgets/Shell;", "label", "", "isGuideWordItem", "", "node", "Lnu/xom/Node;", "stripEmphasis", "Lnu/xom/Text;", "emphasis", "Lnu/xom/Element;", "normalizeTextNode", "isListItem", "validateEmphasis", "nodeLength", "start", "end", "getEmphasisInline", "emphasize", "Ljava/util/EnumSet;", "Lorg/brailleblaster/utd/properties/EmphasisType;", "remove", "hasEmphasis", "emphasisTypes", "isAllEmphasized", "selection", "Lorg/brailleblaster/perspectives/mvc/XMLSelection;", "emphasisType", "getFirstTextNode", "getFinalTextNode", "toggleWithPreviousEmphasis", "inlineElement", "emphasisToSet", "processEmphasis", "emphasisBits", "text", "parent", "index", "applyEmphasis", "toggleNoPreviousEmphasis", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nEmphasisModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmphasisModule.kt\norg/brailleblaster/perspectives/mvc/modules/views/EmphasisModuleKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,789:1\n1#2:790\n479#3:791\n479#3:792\n*S KotlinDebug\n*F\n+ 1 EmphasisModule.kt\norg/brailleblaster/perspectives/mvc/modules/views/EmphasisModuleKt\n*L\n610#1:791\n617#1:792\n*E\n"})
public final class EmphasisModuleKt {
    private static final int NO_OFFSET = -1;
    private static final Logger log = LoggerFactory.getLogger(EmphasisModule.class);

    private static final Shell processNotice(String label) {
        Shell process = new Shell(WPManager.Companion.getInstance().getShell(), 32);
        process.setSize(350, 60);
        process.setText("Working...");
        Label notice = new Label((Composite)process, 0x1000000);
        notice.setText(label);
        notice.pack();
        process.open();
        return process;
    }

    private static final boolean isGuideWordItem(Node node) {
        ParentNode parentNode = node.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element e = (Element)parentNode;
        return BBX.SPAN.DEFINITION_TERM.isA((Node)e) ? true : e.getAttribute("utd-style") != null && Intrinsics.areEqual((Object)e.getAttributeValue("utd-style"), (Object)"Guide Word");
    }

    private static final Text stripEmphasis(Element emphasis) {
        if (!BBX.INLINE.EMPHASIS.isA((Node)emphasis)) {
            boolean $i$a$-require-EmphasisModuleKt$stripEmphasis$22 = false;
            String $i$a$-require-EmphasisModuleKt$stripEmphasis$22 = "Element must be emphasis";
            throw new IllegalArgumentException($i$a$-require-EmphasisModuleKt$stripEmphasis$22.toString());
        }
        ParentNode parent = emphasis.getParent();
        Text text = new Text(emphasis.getValue());
        parent.replaceChild((Node)emphasis, (Node)text);
        text = EmphasisModuleKt.normalizeTextNode(text);
        return text;
    }

    private static final Text normalizeTextNode(Text node) {
        String tempValue;
        ParentNode parent = node.getParent();
        int index = parent.indexOf((Node)node);
        if (index != 0 && parent.getChild(index - 1) instanceof Text) {
            tempValue = parent.getChild(index - 1).getValue() + node.getValue();
            parent.removeChild(index - 1);
            parent.replaceChild(parent.getChild(index - 1), (Node)new Text(tempValue));
            --index;
        }
        if (index != parent.getChildCount() - 1 && parent.getChild(index + 1) instanceof Text) {
            tempValue = parent.getChild(index).getValue() + parent.getChild(index + 1).getValue();
            parent.removeChild(index + 1);
            parent.replaceChild(parent.getChild(index), (Node)new Text(tempValue));
        }
        Node node2 = parent.getChild(index);
        Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Text");
        return (Text)node2;
    }

    private static final boolean isListItem(Node node) {
        boolean bl;
        ParentNode parentNode = node.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element e = (Element)parentNode;
        if (BBX.BLOCK.LIST_ITEM.isA((Node)e)) {
            bl = true;
        } else {
            String string = e.getAttributeValue("utd-style");
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = StringsKt.startsWith$default((String)it, (String)"L", (boolean)false, (int)2, null) && Character.isDigit(it.charAt(1));
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean validateEmphasis(int nodeLength, int start, int end) {
        if (start == -1 && end == -1) {
            return true;
        }
        if (start == -1) {
            return end > 0;
        }
        return end == -1 ? start < nodeLength : start != end;
    }

    private static final Element getEmphasisInline(Text node) {
        return (Element)XMLHandler.Companion.ancestorVisitor((Node)node, EmphasisModuleKt::getEmphasisInline$lambda$0);
    }

    private static final Text emphasize(EnumSet<EmphasisType> emphasis, Text node, int start, int end, boolean remove) {
        if (BBXUtilsKt.isPageNumAncestor((Node)node) || MathModuleUtils.isMath((Node)node) || !EmphasisModuleKt.validateEmphasis(node.getValue().length(), start, end)) {
            return node;
        }
        return remove == EmphasisModuleKt.hasEmphasis(node, emphasis) ? (remove ? EmphasisModuleKt.toggleWithPreviousEmphasis(EmphasisModuleKt.getEmphasisInline(node), emphasis, node, start, end) : EmphasisModuleKt.applyEmphasis(emphasis, node, start, end)) : node;
    }

    private static final boolean hasEmphasis(Text node, EnumSet<EmphasisType> emphasisTypes) {
        Element parent = EmphasisModuleKt.getEmphasisInline(node);
        return parent != null && ((EnumSet)BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.get(parent)).containsAll((Collection)emphasisTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAllEmphasized(XMLSelection selection, EmphasisType emphasisType) {
        boolean endNodeSelected;
        Node startNode = EmphasisModuleKt.getFirstTextNode(selection.start.getNode());
        Node endNode = EmphasisModuleKt.getFinalTextNode(selection.end.getNode());
        boolean bl = endNodeSelected = !(selection.end instanceof XMLTextCaret) || ((XMLTextCaret)selection.end).getOffset() > 0;
        if (!(!(startNode instanceof Text) || MathModuleUtils.isMath(startNode) || BBX.BLOCK.PAGE_NUM.isA((Node)((Text)startNode).getParent()) || BBX.SPAN.PAGE_NUM.isA((Node)((Text)startNode).getParent()) || EmphasisModuleKt.hasEmphasis((Text)startNode, emphasisType) || MathModuleUtils.isMath(startNode))) {
            return false;
        }
        while (startNode != endNode) {
            Intrinsics.checkNotNull((Object)XMLHandler.Companion.followingVisitor(startNode, arg_0 -> EmphasisModuleKt.isAllEmphasized$lambda$0(endNode, arg_0)));
            if (startNode == endNode || MathModuleUtils.isMath(startNode) || BBX.BLOCK.PAGE_NUM.isA((Node)startNode.getParent()) || BBX.SPAN.PAGE_NUM.isA((Node)startNode.getParent())) continue;
            Node node = startNode;
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
            if (EmphasisModuleKt.hasEmphasis((Text)node, emphasisType)) continue;
            return false;
        }
        if (!endNodeSelected) return true;
        if (!(endNode instanceof Text)) return true;
        if (MathModuleUtils.isMath(startNode)) return true;
        if (BBX.BLOCK.PAGE_NUM.isA((Node)startNode.getParent())) return true;
        if (BBX.SPAN.PAGE_NUM.isA((Node)startNode.getParent())) return true;
        Node node = startNode;
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
        if (!EmphasisModuleKt.hasEmphasis((Text)node, emphasisType)) return false;
        return true;
    }

    private static final Node getFirstTextNode(Node node) {
        if (node instanceof Text) {
            return node;
        }
        Sequence $this$filterIsInstance$iv = FastXPath.descendantOrSelf((Node)node);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getFirstTextNode$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Text text = (Text)SequencesKt.firstOrNull((Sequence)sequence);
        return text != null ? (Node)text : node;
    }

    private static final Node getFinalTextNode(Node node) {
        if (node instanceof Text) {
            return node;
        }
        Sequence $this$filterIsInstance$iv = FastXPath.descendantOrSelf((Node)node);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getFinalTextNode$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Text text = (Text)SequencesKt.lastOrNull((Sequence)sequence);
        return text != null ? (Node)text : node;
    }

    private static final boolean hasEmphasis(Text node, EmphasisType emphasisType) {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)emphasisType);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        return EmphasisModuleKt.hasEmphasis(node, enumSet);
    }

    private static final Text toggleWithPreviousEmphasis(Element inlineElement, EnumSet<EmphasisType> emphasisToSet, Text node, int start, int end) {
        EnumSet emphasisBits = (EnumSet)BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.get(inlineElement);
        EnumSet<EmphasisType> emphasisBitsToggled = EnumSet.copyOf(emphasisBits);
        Iterator iterator = emphasisToSet.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            EmphasisType emphasis = (EmphasisType)iterator2.next();
            boolean toggleOn = !emphasisBits.contains(emphasis);
            boolean bl = toggleOn ? emphasisBitsToggled.add(emphasis) : emphasisBitsToggled.remove(emphasis);
        }
        Text nodeToWrap = null;
        Element element = inlineElement;
        Intrinsics.checkNotNull((Object)element);
        ParentNode parentNode = element.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element inlineElementParent = (Element)parentNode;
        int insertionIndex = inlineElementParent.indexOf((Node)inlineElement);
        int nodeLength = node.getValue().length();
        if (!(start != 0 && start != -1 || end != nodeLength && end != -1)) {
            if (emphasisBitsToggled.isEmpty()) {
                XMLHandler.Companion.unwrapElement(inlineElement);
            } else {
                BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.set(inlineElement, emphasisBitsToggled);
            }
            return node;
        }
        if (start > 0 && end != -1 && end != nodeLength) {
            int[] nArray = new int[]{start, end};
            List splitTextNode = XMLHandlerKt.splitNode((Text)node, (int[])nArray);
            Intrinsics.checkNotNull((Object)emphasisBits);
            EmphasisModuleKt.processEmphasis(emphasisBits, (Text)splitTextNode.get(0), inlineElementParent, ++insertionIndex);
            Intrinsics.checkNotNull(emphasisBitsToggled);
            EmphasisModuleKt.processEmphasis(emphasisBitsToggled, (Text)splitTextNode.get(1), inlineElementParent, ++insertionIndex);
            EmphasisModuleKt.processEmphasis(emphasisBits, (Text)splitTextNode.get(2), inlineElementParent, ++insertionIndex);
            nodeToWrap = (Text)splitTextNode.get(1);
            v4 = Unit.INSTANCE;
        } else if (start > 0) {
            int[] nArray = new int[]{start};
            List splitTextNode = XMLHandlerKt.splitNode((Text)node, (int[])nArray);
            nodeToWrap = (Text)splitTextNode.get(1);
            Intrinsics.checkNotNull((Object)emphasisBits);
            EmphasisModuleKt.processEmphasis(emphasisBits, (Text)splitTextNode.get(0), inlineElementParent, ++insertionIndex);
            Intrinsics.checkNotNull(emphasisBitsToggled);
            v4 = EmphasisModuleKt.processEmphasis(emphasisBitsToggled, (Text)splitTextNode.get(1), inlineElementParent, ++insertionIndex);
        } else {
            int[] nArray = new int[]{end};
            List splitTextNode = XMLHandlerKt.splitNode((Text)node, (int[])nArray);
            nodeToWrap = (Text)splitTextNode.get(0);
            Intrinsics.checkNotNull(emphasisBitsToggled);
            EmphasisModuleKt.processEmphasis(emphasisBitsToggled, (Text)splitTextNode.get(0), inlineElementParent, ++insertionIndex);
            Intrinsics.checkNotNull((Object)emphasisBits);
            v4 = EmphasisModuleKt.processEmphasis(emphasisBits, (Text)splitTextNode.get(1), inlineElementParent, ++insertionIndex);
        }
        return nodeToWrap;
    }

    private static final Element processEmphasis(EnumSet<EmphasisType> emphasisBits, Text text, Element parent, int index) {
        text.detach();
        if (emphasisBits.isEmpty()) {
            parent.insertChild((Node)text, index);
        } else {
            Element newEmphasisWrapper = BBX.INLINE.EMPHASIS.create(emphasisBits);
            newEmphasisWrapper.appendChild((Node)text);
            parent.insertChild((Node)newEmphasisWrapper, index);
        }
        return parent;
    }

    private static final Text applyEmphasis(EnumSet<EmphasisType> emphasisToSet, Text node, int start, int end) {
        if (!(start >= -1)) {
            boolean $i$a$-require-EmphasisModuleKt$applyEmphasis$32 = false;
            String $i$a$-require-EmphasisModuleKt$applyEmphasis$32 = "Unexpected start " + start;
            throw new IllegalArgumentException($i$a$-require-EmphasisModuleKt$applyEmphasis$32.toString());
        }
        if (!(end >= -1)) {
            boolean bl = false;
            String string = "Unexpected end " + end;
            throw new IllegalArgumentException(string.toString());
        }
        ParentNode parentNode = node.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element inlineElement = (Element)parentNode;
        log.debug("Emphasising text {}", (Object)node);
        return !BBX.INLINE.EMPHASIS.isA((Node)inlineElement) ? EmphasisModuleKt.toggleNoPreviousEmphasis(emphasisToSet, node, start, end) : EmphasisModuleKt.toggleWithPreviousEmphasis(inlineElement, emphasisToSet, node, start, end);
    }

    private static final Text toggleNoPreviousEmphasis(EnumSet<EmphasisType> emphasisToSet, Text node, int start, int end) {
        Text text;
        Text nodeToWrap = null;
        int nodeLength = node.getValue().length();
        if (start > 0 && end != -1 && end != nodeLength) {
            var7_6 = new int[]{start, end};
            splitTextNode = XMLHandlerKt.splitNode((Text)node, (int[])var7_6);
            text = (Text)splitTextNode.get(1);
        } else if (start > 0) {
            var7_6 = new int[]{start};
            splitTextNode = XMLHandlerKt.splitNode((Text)node, (int[])var7_6);
            text = (Text)splitTextNode.get(1);
        } else if (end != -1 && end != nodeLength) {
            var7_6 = new int[]{end};
            splitTextNode = XMLHandlerKt.splitNode((Text)node, (int[])var7_6);
            text = (Text)splitTextNode.get(0);
        } else {
            text = node;
        }
        nodeToWrap = text;
        Node node2 = (Node)nodeToWrap;
        Element element = BBX.INLINE.EMPHASIS.create(emphasisToSet);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        XMLHandler.Companion.wrapNodeWithElement(node2, element);
        return nodeToWrap;
    }

    private static final boolean getEmphasisInline$lambda$0(Node node) {
        return BBX.INLINE.EMPHASIS.isA(node);
    }

    private static final boolean isAllEmphasized$lambda$0(Node $endNode, Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return n instanceof Text || n == $endNode;
    }

    public static final /* synthetic */ boolean access$isAllEmphasized(XMLSelection selection, EmphasisType emphasisType) {
        return EmphasisModuleKt.isAllEmphasized(selection, emphasisType);
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ Node access$getFinalTextNode(Node node) {
        return EmphasisModuleKt.getFinalTextNode(node);
    }

    public static final /* synthetic */ Text access$emphasize(EnumSet emphasis, Text node, int start, int end, boolean remove) {
        return EmphasisModuleKt.emphasize(emphasis, node, start, end, remove);
    }

    public static final /* synthetic */ Shell access$processNotice(String label) {
        return EmphasisModuleKt.processNotice(label);
    }

    public static final /* synthetic */ boolean access$validateEmphasis(int nodeLength, int start, int end) {
        return EmphasisModuleKt.validateEmphasis(nodeLength, start, end);
    }

    public static final /* synthetic */ Element access$getEmphasisInline(Text node) {
        return EmphasisModuleKt.getEmphasisInline(node);
    }

    public static final /* synthetic */ Text access$stripEmphasis(Element emphasis) {
        return EmphasisModuleKt.stripEmphasis(emphasis);
    }

    public static final /* synthetic */ boolean access$isListItem(Node node) {
        return EmphasisModuleKt.isListItem(node);
    }

    public static final /* synthetic */ boolean access$isGuideWordItem(Node node) {
        return EmphasisModuleKt.isGuideWordItem(node);
    }
}

