/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.frontmatter.VolumeUtils;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0002#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u001a\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/brailleblaster/search/GoToPageDialog;", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "dialog", "Lorg/eclipse/swt/widgets/Shell;", "pageText", "Lorg/eclipse/swt/widgets/Text;", "rawPageButton", "Lorg/eclipse/swt/widgets/Button;", "getRawPageButton", "()Lorg/eclipse/swt/widgets/Button;", "braillePageButton", "printPageButton", "volumeSelect", "Lorg/eclipse/swt/widgets/Combo;", "volumeData", "", "Lorg/brailleblaster/frontmatter/VolumeUtils$VolumeData;", "onSubmit", "", "findPage", "Lkotlin/Pair;", "", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "page", "", "scrollToVolume", "index", "brlPage", "scrollToTextAfterNode", "nodeToSearchForText", "Lnu/xom/Node;", "PageType", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nGoToPageDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoToPageDialog.kt\norg/brailleblaster/search/GoToPageDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n2802#2:257\n812#2,12:260\n777#2:272\n873#2,2:273\n1#3:258\n1#3:259\n*S KotlinDebug\n*F\n+ 1 GoToPageDialog.kt\norg/brailleblaster/search/GoToPageDialog\n*L\n113#1:257\n203#1:260,12\n204#1:272\n204#1:273,2\n113#1:258\n*E\n"})
public final class GoToPageDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager m;
    @JvmField
    @NotNull
    public final Shell dialog;
    @NotNull
    private final Text pageText;
    @NotNull
    private final Button rawPageButton;
    @JvmField
    @NotNull
    public final Button braillePageButton;
    @JvmField
    @NotNull
    public final Button printPageButton;
    @NotNull
    private final Combo volumeSelect;
    @Nullable
    private List<VolumeUtils.VolumeData> volumeData;
    private static final Logger log = LoggerFactory.getLogger(GoToPageDialog.class);
    @NotNull
    private static final String SETTING_PAGE_TYPE = "goToPage.pageType";

    /*
     * WARNING - void declaration
     */
    public GoToPageDialog(@NotNull Manager m) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                this.m = m;
                this.dialog = EasySWT.INSTANCE.makeDialog(this.m.getWpManager().getShell());
                this.dialog.setText("Go To");
                RowLayout dialogLayout = new RowLayout();
                dialogLayout.center = true;
                this.dialog.setLayout((Layout)dialogLayout);
                this.volumeSelect = new Combo((Composite)this.dialog, 12);
                this.pageText = new Text((Composite)this.dialog, 2048);
                this.printPageButton = new Button((Composite)this.dialog, 16);
                this.printPageButton.setText("Print Page");
                this.braillePageButton = new Button((Composite)this.dialog, 16);
                this.braillePageButton.setText("Braille Page");
                this.rawPageButton = new Button((Composite)this.dialog, 16);
                this.rawPageButton.setText("Ordinal Page");
                Button submitButton = new Button((Composite)this.dialog, 0);
                submitButton.setText("Go to");
                EasySWT.addSelectionListener((Button)this.printPageButton, GoToPageDialog::_init_$lambda$0);
                EasySWT.addSelectionListener((Button)this.braillePageButton, GoToPageDialog::_init_$lambda$1);
                EasySWT.addSelectionListener((Button)this.rawPageButton, GoToPageDialog::_init_$lambda$2);
                EasySWT.INSTANCE.addSelectionListener(this.volumeSelect, arg_0 -> GoToPageDialog._init_$lambda$3(this, arg_0));
                this.pageText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.onSubmit();
                    }
                });
                EasySWT.addSelectionListener((Button)submitButton, arg_0 -> GoToPageDialog._init_$lambda$4(this, arg_0));
                List<Element> volumeElements = VolumeUtils.getVolumeElements(this.m.getDoc());
                if (volumeElements.isEmpty()) {
                    log.trace("Disabling volume nav, no volumes found");
                    this.volumeSelect.setEnabled(false);
                    this.volumeData = null;
                } else {
                    void $this$onEach$iv;
                    void var7_8;
                    log.trace("Enabling volume nav, found " + volumeElements.size());
                    this.volumeSelect.add("");
                    Iterable iterable = VolumeUtils.INSTANCE.getVolumeNames(volumeElements);
                    GoToPageDialog goToPageDialog = this;
                    boolean $i$f$onEach = false;
                    void $this$onEach_u24lambda_u240$iv = var7_8 = $this$onEach$iv;
                    boolean bl = false;
                    for (Object element$iv : $this$onEach_u24lambda_u240$iv) {
                        VolumeUtils.VolumeData vol = (VolumeUtils.VolumeData)element$iv;
                        boolean bl2 = false;
                        this.volumeSelect.add(vol.nameLong);
                    }
                    goToPageDialog.volumeData = (List)var7_8;
                }
                String lastPageType = BBIni.getPropertyFileManager().getProperty(SETTING_PAGE_TYPE);
                if (lastPageType == null) break block8;
                switch (WhenMappings.$EnumSwitchMapping$0[PageType.valueOf(lastPageType).ordinal()]) {
                    case 1: {
                        this.printPageButton.setSelection(true);
                        break block9;
                    }
                    case 2: {
                        this.braillePageButton.setSelection(true);
                        break block9;
                    }
                    case 3: {
                        this.rawPageButton.setSelection(true);
                        break block9;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            this.printPageButton.setSelection(true);
        }
        EasySWT.INSTANCE.setLargeDialogSize(this.dialog);
        this.dialog.open();
        this.pageText.setFocus();
    }

    @NotNull
    public final Button getRawPageButton() {
        return this.rawPageButton;
    }

    /*
     * WARNING - void declaration
     */
    public final void onSubmit() {
        this.m.waitForFormatting(true);
        if (this.volumeSelect.getSelectionIndex() > 0) {
            this.scrollToVolume(this.volumeSelect.getSelectionIndex() - 1, this.pageText.getText());
            return;
        }
        String string = this.pageText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            throw new BBNotifyException("No text entered yet, ignoring");
        }
        String pageTypeText = this.printPageButton.getSelection() ? "print" : (this.braillePageButton.getSelection() ? "braille" : "ordinal");
        String userPage = this.pageText.getText();
        log.debug("Executing Go To Page {}", (Object)userPage);
        Intrinsics.checkNotNull((Object)userPage);
        Pair<Integer, TextMapElement> pair = this.findPage(userPage);
        if (pair == null) {
            String string2;
            String string3 = pageTypeText;
            if (((CharSequence)string3).length() > 0) {
                void it;
                char c = string3.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)it));
                String string4 = string3;
                int n = 1;
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                string2 = stringBuilder2.append(string5).toString();
            } else {
                string2 = string3;
            }
            String string6 = string2 + " Page '" + userPage + "' not found";
            throw new BBNotifyException(string6);
        }
        TextMapElement value = (TextMapElement)pair.component2();
        Node node = value.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        this.scrollToTextAfterNode(node);
        this.m.getTextView().setFocus();
        this.dialog.close();
    }

    @Nullable
    public final Pair<Integer, TextMapElement> findPage(@NotNull String page) {
        Pair<Integer, TextMapElement> pair;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (this.printPageButton.getSelection()) {
            pair = this.m.getPrintPageElement(page);
        } else if (this.braillePageButton.getSelection()) {
            pair = this.m.getBraillePageElementByUntranslatedPage(page, null);
        } else {
            Pair<Integer, TextMapElement> pair2;
            try {
                int index = Integer.parseInt(page) - 1;
                pair2 = this.m.getBraillePageElement(index);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Page '{}' is not a number", (Object)page);
                return null;
            }
            pair = pair2;
        }
        Pair<Integer, TextMapElement> pme = pair;
        return pme;
    }

    public final void scrollToVolume(int index, @Nullable String brlPage) {
        Node node;
        log.debug("scrolling to volume " + index);
        if (index < 0) {
            throw new IllegalArgumentException("must be positive, " + index);
        }
        if (index == 0) {
            Element element = BBX.getRoot(this.m.getDoc());
            Intrinsics.checkNotNull((Object)element);
            node = (Node)element;
        } else {
            List<VolumeUtils.VolumeData> list = this.volumeData;
            Intrinsics.checkNotNull(list);
            VolumeUtils.VolumeData volumeInfo = list.get(index - 1);
            node = (Node)volumeInfo.element;
        }
        Node nodeToSearchForText = node;
        this.scrollToTextAfterNode(nodeToSearchForText, brlPage);
        this.dialog.close();
        this.m.getTextView().setFocus();
    }

    public final void scrollToTextAfterNode(@NotNull Node nodeToSearchForText) {
        Intrinsics.checkNotNullParameter((Object)nodeToSearchForText, (String)"nodeToSearchForText");
        this.scrollToTextAfterNode(nodeToSearchForText, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void scrollToTextAfterNode(Node nodeToSearchForText, String brlPage) {
        CharSequence charSequence = brlPage;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            log.trace("Scrolling to node: " + nodeToSearchForText.toXML());
            this.m.getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.GO_TO_PAGE, nodeToSearchForText instanceof nu.xom.Text ? (XMLNodeCaret)new XMLTextCaret((nu.xom.Text)nodeToSearchForText, 0, null, 4, null) : new XMLNodeCaret(nodeToSearchForText, null, 2, null), null, 4, null));
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Iterable iterable = FastXPath.descendantAndFollowing((Node)nodeToSearchForText);
            boolean $i$f$filterIsInstance = false;
            void var6_7 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof nu.xom.Text)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Node curNode = (Node)element$iv$iv;
                boolean bl = false;
                String string = curNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                if (!(((CharSequence)string).length() > 0 && XMLHandler.Companion.ancestorElementNot(curNode, arg_0 -> GoToPageDialog.scrollToTextAfterNode$lambda$0$0(curNode, arg_0)) && !MathModuleUtils.isMath(curNode))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            nu.xom.Text textAfterVolume = (nu.xom.Text)CollectionsKt.first((List)((List)destination$iv$iv));
            Pair<Integer, TextMapElement> pair = this.m.getBraillePageElementByUntranslatedPage(brlPage, textAfterVolume);
            if (pair == null) {
                throw new BBNotifyException("Braille page " + brlPage + " in " + this.volumeSelect.getItem(this.volumeSelect.getSelectionIndex()) + " not found");
            }
            TextMapElement value = (TextMapElement)pair.component2();
            Node node = value.getNode();
            if (node instanceof nu.xom.Text) {
                log.debug("scrolling to text node for braille page {} {}", (Object)brlPage, (Object)node);
                this.m.getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.GO_TO_PAGE, new XMLTextCaret((nu.xom.Text)node, 0, null, 4, null), null, 4, null));
            } else {
                Intrinsics.checkNotNull((Object)node);
                log.debug("scrolling to node for braille page " + brlPage + " " + XMLHandler.Companion.toXMLSimple(node));
                this.m.getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.GO_TO_PAGE, new XMLNodeCaret(node, null, 2, null), null, 4, null));
            }
        }
    }

    private static final void _init_$lambda$0(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GoToPageDialog.Companion.savePageType(PageType.PRINT);
    }

    private static final void _init_$lambda$1(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GoToPageDialog.Companion.savePageType(PageType.BRAILLE);
    }

    private static final void _init_$lambda$2(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GoToPageDialog.Companion.savePageType(PageType.ORDINAL);
    }

    private static final void _init_$lambda$3(GoToPageDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean isVolumeSelected = this$0.volumeSelect.getSelectionIndex() != 0;
        this$0.printPageButton.setEnabled(!isVolumeSelected);
        this$0.rawPageButton.setEnabled(!isVolumeSelected);
        if (isVolumeSelected) {
            this$0.printPageButton.setSelection(false);
            this$0.braillePageButton.setSelection(true);
            this$0.rawPageButton.setSelection(false);
        }
    }

    private static final void _init_$lambda$4(GoToPageDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onSubmit();
    }

    private static final boolean scrollToTextAfterNode$lambda$0$0(Node $curNode, Element curAncestor) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)curAncestor, (String)"curAncestor");
                if (BBX.BLOCK.VOLUME_END.isA((Node)curAncestor)) break block4;
                String string = curAncestor.getLocalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalName(...)");
                if (UTDElements.Companion.getByName(string) == null) break block5;
            }
            return true;
        }
        Element brl = UTDHelper.getAssociatedBrlElement((Node)$curNode);
        if (brl != null) {
            return brl.getChildCount() == 0;
        }
        return false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/search/GoToPageDialog$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SETTING_PAGE_TYPE", "", "savePageType", "", "type", "Lorg/brailleblaster/search/GoToPageDialog$PageType;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void savePageType(PageType type) {
            BBIni.getPropertyFileManager().save(GoToPageDialog.SETTING_PAGE_TYPE, type.name());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/search/GoToPageDialog$PageType;", "", "<init>", "(Ljava/lang/String;I)V", "PRINT", "BRAILLE", "ORDINAL", "brailleblaster-core"})
    public static final class PageType
    extends Enum<PageType> {
        public static final /* enum */ PageType PRINT = new PageType();
        public static final /* enum */ PageType BRAILLE = new PageType();
        public static final /* enum */ PageType ORDINAL = new PageType();
        private static final /* synthetic */ PageType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PageType[] values() {
            return (PageType[])$VALUES.clone();
        }

        public static PageType valueOf(String value) {
            return Enum.valueOf(PageType.class, value);
        }

        @NotNull
        public static EnumEntries<PageType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pageTypeArray = new PageType[]{PageType.PRINT, PageType.BRAILLE, PageType.ORDINAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PageType.values().length];
            try {
                nArray[PageType.PRINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PageType.BRAILLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PageType.ORDINAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

