/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.stylers.StyleHandler;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.search.Click;
import org.brailleblaster.search.DOMControl;
import org.brailleblaster.search.Find;
import org.brailleblaster.search.SavedSearches;
import org.brailleblaster.search.SearchCriteria;
import org.brailleblaster.search.SearchUtils;
import org.brailleblaster.search.ViewControl;
import org.brailleblaster.search.ViewState;
import org.eclipse.swt.graphics.Point;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/brailleblaster/search/Replace;", "", "<init>", "()V", "replaceClickCount", "", "getReplaceClickCount", "()I", "setReplaceClickCount", "(I)V", "doExtraFind", "", "getDoExtraFind", "()Z", "setDoExtraFind", "(Z)V", "replace", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "click", "Lorg/brailleblaster/search/Click;", "replaceControl", "", "domCon", "Lorg/brailleblaster/search/DOMControl;", "viewCon", "Lorg/brailleblaster/search/ViewControl;", "dealWithReplaceCase", "nodeString", "", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nReplace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Replace.kt\norg/brailleblaster/search/Replace\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,260:1\n37#2,2:261\n*S KotlinDebug\n*F\n+ 1 Replace.kt\norg/brailleblaster/search/Replace\n*L\n82#1:261,2\n*E\n"})
public final class Replace {
    private int replaceClickCount;
    private boolean doExtraFind;

    public final int getReplaceClickCount() {
        return this.replaceClickCount;
    }

    public final void setReplaceClickCount(int n) {
        this.replaceClickCount = n;
    }

    public final boolean getDoExtraFind() {
        return this.doExtraFind;
    }

    public final void setDoExtraFind(boolean bl) {
        this.doExtraFind = bl;
    }

    public final boolean replace(@NotNull Manager m, @NotNull Click click) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        int n = this.replaceClickCount;
        this.replaceClickCount = n + 1;
        DOMControl domCon = new DOMControl(click);
        ViewControl viewCon = new ViewControl(m, click);
        Node node = viewCon.checkToReplaceCurrent();
        if (node != null) {
            if (!SearchUtils.checkUneditable(node)) {
                this.replaceControl(m, click, domCon, viewCon);
                m.waitForFormatting(true);
                ViewState end = viewCon.getCurrentViewState();
                click.setReplaced(end);
                SavedSearches.addToMemory(click);
                Find fm = new Find();
                if (this.doExtraFind) {
                    fm.find(m, click, domCon, viewCon);
                    this.doExtraFind = false;
                }
                return fm.find(m, click, domCon, viewCon);
            }
            return false;
        }
        return false;
    }

    private final void replaceControl(Manager m, Click click, DOMControl domCon, ViewControl viewCon) {
        Point point = m.getTextView().getSelection();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getSelection(...)");
        Point selection = point;
        Set<TextMapElement> set = m.getMapList().getElementsOneByOne(selection.x, selection.y);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getElementsOneByOne(...)");
        Collection $this$toTypedArray$iv = set;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TextMapElement[] array = thisCollection$iv.toArray(new TextMapElement[0]);
        boolean acrossNodes = array.length > 1;
        List nodeList = new ArrayList();
        String replaceString = click.getSettings().replaceString;
        CharSequence charSequence = replaceString;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String findString = click.getSettings().findString;
            if (!click.getSettings().isFindCaseSensitive()) {
                if (StringsKt.equals((String)replaceString, (String)findString, (boolean)true)) {
                    this.doExtraFind = true;
                }
            } else if (Intrinsics.areEqual((Object)replaceString, (Object)findString)) {
                this.doExtraFind = true;
            }
            Node n = null;
            int nodeStart = 0;
            int nodeEnd = 0;
            int selectionStart = 0;
            int selectionEnd = 0;
            if (acrossNodes) {
                n = viewCon.acrossNodeReplace(array, selection.x, selection.y);
                selectionStart = nodeStart = selection.x;
                selectionEnd = nodeEnd = selection.y;
            } else {
                Node node = array[0].getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                n = node;
                nodeStart = array[0].getStart(m.getMapList());
                nodeEnd = array[0].getEnd(m.getMapList());
                selectionStart = selection.x;
                selectionEnd = selection.y;
            }
            String string = m.getTextView().getText(nodeStart, nodeEnd - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String viewText = string;
            String before = StringsKt.take((String)viewText, (int)(selectionStart - nodeStart));
            int textWithControlChars = before.length();
            CharSequence charSequence2 = before;
            Regex regex = new Regex("\n");
            String string2 = "";
            charSequence2 = regex.replace(charSequence2, string2);
            regex = new Regex("\r");
            string2 = "";
            before = regex.replace(charSequence2, string2);
            int textNoControlChars = before.length();
            int controlCharsBeforeText = textWithControlChars - textNoControlChars;
            String string3 = viewText.substring(selectionEnd - nodeStart);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            CharSequence charSequence3 = string3;
            Regex regex2 = new Regex("\n");
            String string4 = "";
            charSequence3 = regex2.replace(charSequence3, string4);
            regex2 = new Regex("\r");
            string4 = "";
            String after = regex2.replace(charSequence3, string4);
            Node node = n;
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
            ((Text)node).setValue(before + click.getSettings().replaceString + after);
            int oldLength = selectionEnd - selectionStart;
            int newLength = replaceString.length();
            selectionEnd = selectionEnd - controlCharsBeforeText + (newLength - oldLength);
            selectionStart = nodeStart + before.length();
            if (click.getSettings().replaceHasAttributes()) {
                n = domCon.split(n, nodeStart, nodeEnd, selectionStart, selectionEnd);
            }
            if (n instanceof Text) {
                String string5 = ((Text)n).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getValue(...)");
                if (((CharSequence)string5).length() == 0) {
                    n = (Node)BBXUtilsKt.findBlock(n);
                }
            }
            nodeList.add(n);
        } else {
            for (TextMapElement textMapElement : array) {
                Node node = textMapElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                nodeList.add(node);
            }
        }
        if (click.getSettings().replaceHasEmphasis()) {
            for (Node node : nodeList) {
                SearchUtils.INSTANCE.modifyEmphasis$brailleblaster_core(node, click.getSettings().replaceEmphasisFormatting);
            }
        }
        SearchCriteria.StyleFormatting styleFormatting = click.getSettings().replaceStyleFormatting;
        if (styleFormatting != null) {
            SearchCriteria.StyleFormatting it = styleFormatting;
            boolean bl = false;
            for (Node value : nodeList) {
                Node node;
                for (node = (Node)value.getParent(); node != null && !BBX.BLOCK.isA(node); node = (Node)node.getParent()) {
                }
                if (node == null) continue;
                StyleHandler.Companion.addStyle((Element)node, it.style, m);
            }
        }
        if (click.getSettings().replaceHasContainer()) {
            SearchUtils.INSTANCE.changeContainer$brailleblaster_core(nodeList, click.getSettings().replaceContainerFormatting, m);
        }
        m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.SEARCH, nodeList, true));
    }

    private final void dealWithReplaceCase(Click click, String nodeString) {
        String string = click.getSettings().findString;
        Intrinsics.checkNotNull((Object)string);
        String findString = string;
        String string2 = nodeString.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        CharSequence charSequence = string2;
        String string3 = findString.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        int start = StringsKt.indexOf$default((CharSequence)charSequence, (String)string3, (int)0, (boolean)false, (int)6, null);
        String string4 = nodeString.substring(start, start + findString.length());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String foundString = string4;
        String string5 = click.getSettings().replaceString;
        Intrinsics.checkNotNull((Object)string5);
        String replaceString = string5;
        StringBuilder newReplaceString = new StringBuilder();
        boolean allcaps = true;
        int stop = RangesKt.coerceAtMost((int)replaceString.length(), (int)foundString.length());
        int n = foundString.length();
        for (int i = 0; i < n; ++i) {
            char element = foundString.charAt(i);
            if (Character.isUpperCase(element) || !Character.isAlphabetic(element)) continue;
            allcaps = false;
            break;
        }
        int i = 0;
        int j = 0;
        while (i < stop) {
            char findChar = foundString.charAt(i);
            char replaceChar = replaceString.charAt(j);
            if (allcaps || i == 0 && Character.isUpperCase(findChar)) {
                converted = Character.toUpperCase(replaceChar);
                v6 = newReplaceString.append(converted);
            } else {
                converted = Character.toLowerCase(replaceChar);
                v6 = newReplaceString.append(converted);
            }
            ++i;
            ++j;
        }
        int leftoverChars = replaceString.length() - foundString.length();
        if (leftoverChars > 0) {
            int k = 0;
            int m = foundString.length();
            while (k < leftoverChars) {
                char leftoverChar = replaceString.charAt(m);
                char converted = allcaps ? Character.toUpperCase(leftoverChar) : Character.toLowerCase(leftoverChar);
                newReplaceString.append(converted);
                ++k;
                ++m;
            }
        }
        click.getSettings().replaceString = newReplaceString.toString();
    }
}

