/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import nu.xom.XPathContext;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.stylers.StyleHandler;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.search.Click;
import org.brailleblaster.search.SearchCriteria;
import org.brailleblaster.search.SearchUtils;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012H\u0002J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/brailleblaster/search/ReplaceAll;", "", "man", "Lorg/brailleblaster/perspectives/braille/Manager;", "click", "Lorg/brailleblaster/search/Click;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/search/Click;)V", "numberReplaceAlls", "", "value", "tableDoubles", "getTableDoubles", "()I", "replaceAll", "replaceAllText", "Ljava/util/ArrayList;", "Lnu/xom/Node;", "Lkotlin/collections/ArrayList;", "replaceAllEmphasis", "", "nodeArray", "replaceAllContainers", "", "replaceAllStyles", "styleFormatting", "Lorg/brailleblaster/search/SearchCriteria$StyleFormatting;", "brailleblaster-core"})
public final class ReplaceAll {
    @NotNull
    private final Manager man;
    @NotNull
    private final Click click;
    private int numberReplaceAlls;
    private int tableDoubles;

    public ReplaceAll(@NotNull Manager man, @NotNull Click click) {
        Intrinsics.checkNotNullParameter((Object)man, (String)"man");
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        this.man = man;
        this.click = click;
    }

    public final int getTableDoubles() {
        return this.tableDoubles;
    }

    public final int replaceAll(@NotNull Click click) {
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        this.numberReplaceAlls = 0;
        List<Node> nodeArray = null;
        nodeArray = this.replaceAllText();
        if (click.getSettings().findHasAttributes() && click.getSettings().replaceHasAttributes()) {
            this.numberReplaceAlls = ((List)nodeArray).size();
        }
        for (Node node : (List)nodeArray) {
            ParentNode parentNode = node.getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            UTDHelper.stripUTDRecursive((Element)((Element)parentNode));
        }
        SearchCriteria.StyleFormatting styleFormatting = click.getSettings().replaceStyleFormatting;
        if (styleFormatting != null) {
            SearchCriteria.StyleFormatting it = styleFormatting;
            boolean bl = false;
            nodeArray = this.replaceAllStyles(it, (List<? extends Node>)nodeArray);
        }
        if (click.getSettings().replaceHasEmphasis()) {
            nodeArray = this.replaceAllEmphasis((List<? extends Node>)nodeArray);
        }
        if (click.getSettings().replaceHasContainer()) {
            this.replaceAllContainers((List<? extends Node>)nodeArray);
        }
        if (((List)nodeArray).isEmpty()) {
            return -1;
        }
        this.man.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.SEARCH, (List<? extends Node>)nodeArray, true));
        this.man.waitForFormatting(true);
        return this.numberReplaceAlls;
    }

    private final ArrayList<Node> replaceAllText() {
        this.tableDoubles = 0;
        if (!this.click.getSettings().replaceHasText() && this.click.getSettings().replaceHasAttributes()) {
            this.click.getSettings().replaceString = this.click.getSettings().findString;
        }
        String namespace = this.man.getDoc().getRootElement().getNamespaceURI();
        XPathContext xpathContext = new XPathContext("dtb", namespace);
        Nodes replaceAllNodes = this.man.getDoc().query("//text()", xpathContext);
        if (replaceAllNodes.size() == 0) {
            return new ArrayList<Node>();
        }
        ArrayList<Node> nodeArray = new ArrayList<Node>();
        int n = replaceAllNodes.size();
        for (int i = 0; i < n; ++i) {
            String nodeValue;
            Node node = replaceAllNodes.get(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
            Text tn = (Text)node;
            Node node2 = replaceAllNodes.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"get(...)");
            if (!SearchUtils.checkCorrectAttributes(node2, this.click)) continue;
            ParentNode parentNode = replaceAllNodes.get(i).getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            if (Intrinsics.areEqual((Object)((Element)parentNode).getLocalName(), (Object)"doctitle")) continue;
            String string = nodeValue = tn.getValue();
            Intrinsics.checkNotNull((Object)string);
            SearchUtils.MatchObject matches = SearchUtils.matchPhrase(string, this.click, false);
            int loops = 0;
            int initialMatches = matches.getIndices().size();
            this.numberReplaceAlls += initialMatches;
            ParentNode parentNode2 = tn.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)parentNode2, (String)"getParent(...)");
            if (XMLHandler.Companion.ancestorVisitor((Node)parentNode2, ReplaceAll::replaceAllText$lambda$0) != null) {
                this.tableDoubles += initialMatches;
                continue;
            }
            if (SearchUtils.INSTANCE.isUneditable$brailleblaster_core((Node)tn)) continue;
            boolean add = false;
            while (matches.hasNext()) {
                add = true;
                if (loops >= initialMatches) break;
                SearchUtils.StartEndPair pair = matches.getNext();
                int start = pair.start;
                int end = pair.end;
                nodeValue = tn.getValue();
                String string2 = replaceAllNodes.get(i).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                SearchUtils.INSTANCE.dealWithReplaceCase$brailleblaster_core(this.click, string2);
                String string3 = nodeValue;
                Intrinsics.checkNotNull((Object)string3);
                String before = StringsKt.take((String)string3, (int)start);
                String string4 = nodeValue;
                Intrinsics.checkNotNull((Object)string4);
                String after = StringsKt.drop((String)string4, (int)end);
                String value = before + this.click.getSettings().replaceString + after;
                tn.setValue(value);
                ++loops;
                Node node3 = replaceAllNodes.get(i);
                Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Text");
                tn = (Text)node3;
                String string5 = nodeValue = tn.getValue();
                Intrinsics.checkNotNull((Object)string5);
                matches = SearchUtils.matchPhrase(string5, this.click, false);
            }
            if (!add) continue;
            nodeArray.add(replaceAllNodes.get(i));
        }
        this.numberReplaceAlls -= this.tableDoubles;
        this.tableDoubles /= 2;
        return nodeArray;
    }

    private final List<Node> replaceAllEmphasis(List<? extends Node> nodeArray) {
        List newArray = new ArrayList();
        EnumSet<EmphasisType> addEmphasisEnum = SearchUtils.INSTANCE.makeEnumFromList$brailleblaster_core(this.click.getSettings().replaceEmphasisFormatting, false);
        EnumSet<EmphasisType> removeEmphasisEnum = SearchUtils.INSTANCE.makeEnumFromList$brailleblaster_core(this.click.getSettings().replaceEmphasisFormatting, true);
        block0: for (Node node : nodeArray) {
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
            Text tn = (Text)node;
            String nodeValue = tn.getValue();
            Intrinsics.checkNotNull((Object)nodeValue);
            SearchUtils.MatchObject matches = SearchUtils.matchPhrase(nodeValue, this.click, true);
            ParentNode element = ((Text)node).getParent();
            if (!(element instanceof Element)) continue;
            if (BBX.INLINE.EMPHASIS.isA((Node)element)) {
                EnumSet existingEnum = (EnumSet)BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.get((Element)element);
                existingEnum.removeAll((Collection)removeEmphasisEnum);
                existingEnum.addAll((Collection)addEmphasisEnum);
                if (existingEnum.isEmpty()) {
                    ParentNode parentNode = ((Element)element).getParent();
                    Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                    Element pn = (Element)parentNode;
                    UTDHelper.stripUTDRecursive((Element)pn);
                    node.detach();
                    pn.replaceChild((Node)element, node);
                } else {
                    BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.set((Element)element, existingEnum);
                }
                newArray.add(node);
                continue;
            }
            while (matches.hasNext()) {
                SearchUtils.StartEndPair pair = matches.getNext();
                int j = 0;
                SearchUtils.EmphasisReturn re = SearchUtils.INSTANCE.addEmphasisNoViews$brailleblaster_core(tn, pair.start, pair.end, addEmphasisEnum);
                int n = re.getIndex();
                if (j <= n) {
                    while (true) {
                        newArray.add(re.getNodes().get(j));
                        if (j == n) break;
                        ++j;
                    }
                }
                if (re.getNodes().size() <= re.getIndex() + 1) continue block0;
                tn = re.getNodes().get(re.getIndex() + 1);
                String string = tn.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                matches = SearchUtils.matchPhrase(string, this.click, true);
            }
        }
        List parents = new ArrayList();
        for (Node node : newArray) {
            ParentNode parentNode = node.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
            parents.add(parentNode);
        }
        return SearchUtils.INSTANCE.cleanEmptyInlineAttributes$brailleblaster_core(parents);
    }

    private final void replaceAllContainers(List<? extends Node> nodeArray) {
        SearchUtils.INSTANCE.changeContainer$brailleblaster_core(nodeArray, this.click.getSettings().replaceContainerFormatting, this.man);
    }

    private final List<Node> replaceAllStyles(SearchCriteria.StyleFormatting styleFormatting, List<? extends Node> nodeArray) {
        List newArray = new ArrayList();
        for (Node node : nodeArray) {
            Node node2;
            for (node2 = (Node)node.getParent(); node2 != null && !BBX.BLOCK.isA(node2); node2 = (Node)node2.getParent()) {
            }
            if (node2 == null) continue;
            StyleHandler.Companion.addStyle((Element)node2, styleFormatting.style, this.man);
            newArray.add(node);
        }
        return newArray;
    }

    private static final boolean replaceAllText$lambda$0(Node node) {
        return BBX.CONTAINER.TABLE.isA(node);
    }
}

