/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004EFGHB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000eJ\u001c\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00152\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bJ\u001c\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00172\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bJ\u001c\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00122\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bJ\u0016\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0015J\u0016\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0017J\u0016\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u0012J\u0014\u00108\u001a\u00020\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bJ\u0006\u00109\u001a\u00020\u0005J\u0006\u0010:\u001a\u00020\u0005J\u0006\u0010;\u001a\u00020\u0005J\u0006\u0010<\u001a\u00020\u0005J\u0006\u0010=\u001a\u00020\u0005J\u0006\u0010>\u001a\u00020\u0005J\u0006\u0010?\u001a\u00020\u0005J\u0006\u0010@\u001a\u00020\u0005J\u0006\u0010A\u001a\u00020\u0005J\u0006\u0010B\u001a\u00020\u0005J\u0006\u0010C\u001a\u00020DR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0006\"\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006I"}, d2={"Lorg/brailleblaster/search/SearchCriteria;", "", "<init>", "()V", "isFindCaseSensitive", "", "()Z", "setFindCaseSensitive", "(Z)V", "isWholeWord", "setWholeWord", "isSearchForward", "setSearchForward", "findString", "", "replaceString", "findContainerFormatting", "", "Lorg/brailleblaster/search/SearchCriteria$ContainerFormatting;", "replaceContainerFormatting", "findStyleFormatting", "Lorg/brailleblaster/search/SearchCriteria$StyleFormatting;", "findEmphasisFormatting", "Lorg/brailleblaster/search/SearchCriteria$EmphasisFormatting;", "replaceStyleFormatting", "replaceEmphasisFormatting", "availableEmphasis", "", "Lorg/brailleblaster/search/SearchCriteria$SearchFormatting;", "getAvailableEmphasis", "()Ljava/util/List;", "getEmphasisFormatting", "not", "type", "Lorg/brailleblaster/utd/properties/EmphasisType;", "getStyleFormatting", "s", "d", "styleFormattingContains", "sf", "sfl", "emphasisFormattingContains", "ef", "efl", "containerFormattingContains", "cf", "cfl", "compareStyleFormatting", "sf1", "sf2", "compareEmphasisFormatting", "ef1", "ef2", "compareContainerFormatting", "cf1", "cf2", "printStyleFormatting", "findHasText", "replaceHasText", "findHasEmphasis", "findHasStyle", "findHasContainer", "replaceHasEmphasis", "replaceHasStyle", "replaceHasContainer", "findHasAttributes", "replaceHasAttributes", "reset", "", "SearchFormatting", "EmphasisFormatting", "StyleFormatting", "ContainerFormatting", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nSearchCriteria.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchCriteria.kt\norg/brailleblaster/search/SearchCriteria\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1586#2:224\n1661#2,3:225\n1807#2,3:228\n1807#2,3:231\n1807#2,3:234\n*S KotlinDebug\n*F\n+ 1 SearchCriteria.kt\norg/brailleblaster/search/SearchCriteria\n*L\n123#1:224\n123#1:225,3\n134#1:228,3\n138#1:231,3\n142#1:234,3\n*E\n"})
public final class SearchCriteria {
    private boolean isFindCaseSensitive;
    private boolean isWholeWord;
    private boolean isSearchForward = true;
    @JvmField
    @Nullable
    public String findString;
    @JvmField
    @Nullable
    public String replaceString;
    @JvmField
    @NotNull
    public final List<ContainerFormatting> findContainerFormatting = new ArrayList();
    @JvmField
    @NotNull
    public final List<ContainerFormatting> replaceContainerFormatting = new ArrayList();
    @JvmField
    @NotNull
    public final List<StyleFormatting> findStyleFormatting = new ArrayList();
    @JvmField
    @NotNull
    public final List<EmphasisFormatting> findEmphasisFormatting = new ArrayList();
    @JvmField
    @Nullable
    public StyleFormatting replaceStyleFormatting;
    @JvmField
    @NotNull
    public final List<EmphasisFormatting> replaceEmphasisFormatting = new ArrayList();

    public final boolean isFindCaseSensitive() {
        return this.isFindCaseSensitive;
    }

    public final void setFindCaseSensitive(boolean bl) {
        this.isFindCaseSensitive = bl;
    }

    public final boolean isWholeWord() {
        return this.isWholeWord;
    }

    public final void setWholeWord(boolean bl) {
        this.isWholeWord = bl;
    }

    public final boolean isSearchForward() {
        return this.isSearchForward;
    }

    public final void setSearchForward(boolean bl) {
        this.isSearchForward = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SearchFormatting> getAvailableEmphasis() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)EmphasisType.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmphasisType emphasisType = (EmphasisType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getEmphasisFormatting(false, (EmphasisType)it));
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final EmphasisFormatting getEmphasisFormatting(boolean not, @NotNull EmphasisType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new EmphasisFormatting(not, type);
    }

    @NotNull
    public final StyleFormatting getStyleFormatting(boolean not, @NotNull String s, @NotNull String d) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return new StyleFormatting(not, s, d);
    }

    public final boolean styleFormattingContains(@NotNull StyleFormatting sf, @NotNull List<StyleFormatting> sfl) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)sf, (String)"sf");
            Intrinsics.checkNotNullParameter(sfl, (String)"sfl");
            Iterable $this$any$iv = sfl;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StyleFormatting it = (StyleFormatting)element$iv;
                    boolean bl2 = false;
                    if (!this.compareStyleFormatting(it, sf)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean emphasisFormattingContains(@NotNull EmphasisFormatting ef, @NotNull List<EmphasisFormatting> efl) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)ef, (String)"ef");
            Intrinsics.checkNotNullParameter(efl, (String)"efl");
            Iterable $this$any$iv = efl;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EmphasisFormatting it = (EmphasisFormatting)element$iv;
                    boolean bl2 = false;
                    if (!this.compareEmphasisFormatting(ef, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean containerFormattingContains(@NotNull ContainerFormatting cf, @NotNull List<ContainerFormatting> cfl) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)cf, (String)"cf");
            Intrinsics.checkNotNullParameter(cfl, (String)"cfl");
            Iterable $this$any$iv = cfl;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ContainerFormatting it = (ContainerFormatting)element$iv;
                    boolean bl2 = false;
                    if (!this.compareContainerFormatting(it, cf)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean compareStyleFormatting(@NotNull StyleFormatting sf1, @NotNull StyleFormatting sf2) {
        Intrinsics.checkNotNullParameter((Object)sf1, (String)"sf1");
        Intrinsics.checkNotNullParameter((Object)sf2, (String)"sf2");
        return sf1.isNot() == sf2.isNot() && Intrinsics.areEqual((Object)sf1.style, (Object)sf2.style) && Intrinsics.areEqual((Object)sf1.display, (Object)sf2.display);
    }

    public final boolean compareEmphasisFormatting(@NotNull EmphasisFormatting ef1, @NotNull EmphasisFormatting ef2) {
        Intrinsics.checkNotNullParameter((Object)ef1, (String)"ef1");
        Intrinsics.checkNotNullParameter((Object)ef2, (String)"ef2");
        return ef1.isNot() == ef2.isNot() && ef1.emphasis == ef2.emphasis;
    }

    public final boolean compareContainerFormatting(@NotNull ContainerFormatting cf1, @NotNull ContainerFormatting cf2) {
        Intrinsics.checkNotNullParameter((Object)cf1, (String)"cf1");
        Intrinsics.checkNotNullParameter((Object)cf2, (String)"cf2");
        return cf1.isNot() == cf2.isNot() && Intrinsics.areEqual((Object)cf1.getName(), (Object)cf2.getName());
    }

    @NotNull
    public final String printStyleFormatting(@NotNull List<StyleFormatting> sfl) {
        Intrinsics.checkNotNullParameter(sfl, (String)"sfl");
        StringBuilder rs = new StringBuilder();
        for (StyleFormatting sf : sfl) {
            rs.append(sf.isNot() ? "Not " : "").append(LocaleHandler.Companion.getBanaStyles$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get(sf.style)).append(" / ").append(sf.style).append(" ");
        }
        String string = rs.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean findHasText() {
        CharSequence charSequence = this.findString;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    public final boolean replaceHasText() {
        CharSequence charSequence = this.replaceString;
        return !(charSequence == null || charSequence.length() == 0);
    }

    public final boolean findHasEmphasis() {
        return !((Collection)this.findEmphasisFormatting).isEmpty();
    }

    public final boolean findHasStyle() {
        return !((Collection)this.findStyleFormatting).isEmpty();
    }

    public final boolean findHasContainer() {
        return !((Collection)this.findContainerFormatting).isEmpty();
    }

    public final boolean replaceHasEmphasis() {
        return !((Collection)this.replaceEmphasisFormatting).isEmpty();
    }

    public final boolean replaceHasStyle() {
        return this.replaceStyleFormatting != null;
    }

    public final boolean replaceHasContainer() {
        return !((Collection)this.replaceContainerFormatting).isEmpty();
    }

    public final boolean findHasAttributes() {
        return this.findHasEmphasis() || this.findHasStyle() || this.findHasContainer();
    }

    public final boolean replaceHasAttributes() {
        return this.replaceHasEmphasis() || this.replaceHasStyle() || this.replaceHasContainer();
    }

    public final void reset() {
        this.findStyleFormatting.clear();
        this.findEmphasisFormatting.clear();
        this.findContainerFormatting.clear();
        this.replaceStyleFormatting = null;
        this.replaceEmphasisFormatting.clear();
        this.replaceContainerFormatting.clear();
        this.replaceString = null;
        this.findString = null;
        this.isFindCaseSensitive = false;
        this.isWholeWord = false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u000b\u001a\u00020\u0005H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/search/SearchCriteria$ContainerFormatting;", "", "isNot", "", "name", "", "<init>", "(ZLjava/lang/String;)V", "()Z", "getName", "()Ljava/lang/String;", "toString", "brailleblaster-core"})
    public static final class ContainerFormatting {
        private final boolean isNot;
        @NotNull
        private final String name;

        public ContainerFormatting(boolean isNot, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.isNot = isNot;
            this.name = name;
        }

        public final boolean isNot() {
            return this.isNot;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return (this.isNot ? "Not " : "") + this.name;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004J\u0012\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0096\u0082\u0004R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/search/SearchCriteria$EmphasisFormatting;", "Lorg/brailleblaster/search/SearchCriteria$SearchFormatting;", "not", "", "emphasis", "Lorg/brailleblaster/utd/properties/EmphasisType;", "<init>", "(ZLorg/brailleblaster/utd/properties/EmphasisType;)V", "toString", "", "compareTo", "", "other", "sortPriority", "getSortPriority", "()I", "brailleblaster-core"})
    public static final class EmphasisFormatting
    extends SearchFormatting {
        @JvmField
        @NotNull
        public final EmphasisType emphasis;

        public EmphasisFormatting(boolean not, @NotNull EmphasisType emphasis) {
            Intrinsics.checkNotNullParameter((Object)emphasis, (String)"emphasis");
            super(not);
            this.emphasis = emphasis;
        }

        @NotNull
        public String toString() {
            return (this.isNot() ? "Not " : "") + this.emphasis.getLongName();
        }

        @Override
        public int compareTo(@NotNull SearchFormatting other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int compared = super.compareTo(other);
            if (compared == 0) {
                int n2;
                try {
                    n2 = this.emphasis.getLongName().compareTo(((EmphasisFormatting)other).emphasis.getLongName());
                }
                catch (NullPointerException npe) {
                    n2 = compared;
                }
                n = n2;
            } else {
                n = compared;
            }
            return n;
        }

        @Override
        public int getSortPriority() {
            return 2;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0082\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0006\"\u0004\b\u0007\u0010\u0005R\u0012\u0010\u000b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/search/SearchCriteria$SearchFormatting;", "", "isNot", "", "<init>", "(Z)V", "()Z", "setNot", "compareTo", "", "other", "sortPriority", "getSortPriority", "()I", "brailleblaster-core"})
    public static abstract class SearchFormatting
    implements Comparable<SearchFormatting> {
        private boolean isNot;

        public SearchFormatting(boolean isNot) {
            this.isNot = isNot;
        }

        public final boolean isNot() {
            return this.isNot;
        }

        public final void setNot(boolean bl) {
            this.isNot = bl;
        }

        @Override
        public int compareTo(@NotNull SearchFormatting other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (Intrinsics.areEqual(this.getClass(), other.getClass())) {
                if (!this.isNot && other.isNot) {
                    return -1;
                }
                if (this.isNot && !other.isNot) {
                    return 1;
                }
                return 0;
            }
            int compared = Intrinsics.compare((int)this.getSortPriority(), (int)other.getSortPriority());
            if (compared != 0) {
                n = compared;
            } else {
                String string = this.getClass().getName();
                String string2 = other.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                n = string.compareTo(string2);
            }
            return n;
        }

        public abstract int getSortPriority();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u00020\u0005H\u0096\u0080\u0004R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/search/SearchCriteria$StyleFormatting;", "Lorg/brailleblaster/search/SearchCriteria$SearchFormatting;", "not", "", "style", "", "display", "<init>", "(ZLjava/lang/String;Ljava/lang/String;)V", "toString", "sortPriority", "", "getSortPriority", "()I", "brailleblaster-core"})
    public static final class StyleFormatting
    extends SearchFormatting {
        @JvmField
        @NotNull
        public final String style;
        @JvmField
        @NotNull
        public final String display;

        public StyleFormatting(boolean not, @NotNull String style, @NotNull String display) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            Intrinsics.checkNotNullParameter((Object)display, (String)"display");
            super(not);
            this.style = style;
            this.display = display;
        }

        @NotNull
        public String toString() {
            return (this.isNot() ? "Not " : "") + this.style;
        }

        @Override
        public int getSortPriority() {
            return 3;
        }
    }
}

