/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.mvc.modules.misc.StylesMenuModule;
import org.brailleblaster.search.Click;
import org.brailleblaster.search.SearchCriteria;
import org.brailleblaster.search.SearchException;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.internal.xml.XMLHandlerKt;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003RSTB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0010J)\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u001c\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001dJ\u001d\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\"J\u001f\u0010#\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b$J\u001d\u0010%\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b&J#\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0005H\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010/\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J5\u00100\u001a\u0002012\u0006\u0010\u0013\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b7J%\u00108\u001a\u00020\u00142\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u000202H\u0000\u00a2\u0006\u0002\b9J#\u0010:\u001a\u00020;2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005H\u0000\u00a2\u0006\u0002\b=J\u001d\u0010>\u001a\u00020;2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010?\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b@J!\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0000\u00a2\u0006\u0002\bCJ\u0010\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020FH\u0007J+\u0010G\u001a\u00020;2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010I\u001a\u00020\u00062\u0006\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0002\bJJ+\u0010K\u001a\u00020;2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010L\u001a\u00020\u00062\u0006\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0002\bMJ1\u0010N\u001a\u00020;2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\f\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u00052\u0006\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0002\bQR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006U"}, d2={"Lorg/brailleblaster/search/SearchUtils;", "", "<init>", "()V", "CONTAINERS", "", "", "getCONTAINERS", "()Ljava/util/List;", "isContainerStyle", "", "s", "matchPhrase", "Lorg/brailleblaster/search/SearchUtils$MatchObject;", "viewString", "click", "Lorg/brailleblaster/search/Click;", "matchReplace", "checkCorrectAttributes", "node", "Lnu/xom/Node;", "hasFindCriteria", "search", "makeEnumFromList", "Ljava/util/EnumSet;", "Lorg/brailleblaster/utd/properties/EmphasisType;", "inputList", "Lorg/brailleblaster/search/SearchCriteria$EmphasisFormatting;", "isNegated", "makeEnumFromList$brailleblaster_core", "utdContainer", "ele", "Lnu/xom/Element;", "so", "utdContainer$brailleblaster_core", "utdEmphasis", "utdEmphasis$brailleblaster_core", "utdStyles", "utdStyles$brailleblaster_core", "hasStyles", "el", "sfl", "Lorg/brailleblaster/search/SearchCriteria$StyleFormatting;", "hasStyles$brailleblaster_core", "isUneditable", "isUneditable$brailleblaster_core", "checkUneditable", "isBraille", "addEmphasisNoViews", "Lorg/brailleblaster/search/SearchUtils$EmphasisReturn;", "Lnu/xom/Text;", "start", "", "end", "et", "addEmphasisNoViews$brailleblaster_core", "wrapNewInEmphasis", "wrapNewInEmphasis$brailleblaster_core", "modifyEmphasis", "", "ef", "modifyEmphasis$brailleblaster_core", "dealWithReplaceCase", "nodeString", "dealWithReplaceCase$brailleblaster_core", "cleanEmptyInlineAttributes", "modifiedNodes", "cleanEmptyInlineAttributes$brailleblaster_core", "inTable", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "removeContainer", "list", "replaceRemoveContainerString", "removeContainer$brailleblaster_core", "addContainer", "replaceAddContainerString", "addContainer$brailleblaster_core", "changeContainer", "cl", "Lorg/brailleblaster/search/SearchCriteria$ContainerFormatting;", "changeContainer$brailleblaster_core", "EmphasisReturn", "MatchObject", "StartEndPair", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nSearchUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchUtils.kt\norg/brailleblaster/search/SearchUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,559:1\n742#2,9:560\n2792#2,3:571\n1915#2:574\n1915#2,2:575\n1916#2:577\n37#3,2:569\n*S KotlinDebug\n*F\n+ 1 SearchUtils.kt\norg/brailleblaster/search/SearchUtils\n*L\n81#1:560,9\n197#1:571,3\n423#1:574\n424#1:575,2\n423#1:577\n81#1:569,2\n*E\n"})
public final class SearchUtils {
    @NotNull
    public static final SearchUtils INSTANCE = new SearchUtils();
    @NotNull
    private static final List<String> CONTAINERS;

    private SearchUtils() {
    }

    @NotNull
    public final List<String> getCONTAINERS() {
        return CONTAINERS;
    }

    @JvmStatic
    public static final boolean isContainerStyle(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        for (String container : CONTAINERS) {
            if (!Intrinsics.areEqual((Object)s, (Object)container)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MatchObject matchPhrase(@NotNull String viewString, @NotNull Click click, boolean matchReplace) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Object object;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)viewString, (String)"viewString");
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        String view = viewString;
        String string = matchReplace ? click.getSettings().replaceString : click.getSettings().findString;
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        String phrase = string;
        if (!click.getSettings().isFindCaseSensitive()) {
            charSequence = view;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = ((String)charSequence).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            view = string3;
            charSequence = phrase;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string4 = ((String)charSequence).toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            phrase = string4;
        }
        if (StringsKt.contains$default((CharSequence)phrase, (char)'\'', (boolean)false, (int)2, null)) {
            charSequence = view;
            Regex regex = new Regex("\u2019");
            object = "'";
            view = regex.replace(charSequence, (String)object);
            charSequence = phrase;
            regex = new Regex("'");
            object = "'";
            phrase = regex.replace(charSequence, (String)object);
        }
        String whitespace = "\\s+";
        object = phrase;
        Regex regex = new Regex("\\s+");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] words = thisCollection$iv.toArray(new String[0]);
        StringBuilder s = null;
        if (StringsKt.contains$default((CharSequence)phrase, (char)'(', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)phrase, (char)')', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)phrase, (char)'*', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)phrase, (char)'$', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)phrase, (char)'.', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)phrase, (char)'+', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)phrase, (char)'?', (boolean)false, (int)2, null)) {
            s = new StringBuilder(Pattern.quote(phrase));
        } else {
            s = new StringBuilder(words[0]);
            for (String word : ArraysKt.drop((Object[])words, (int)1)) {
                s.append(whitespace);
                s.append(word);
            }
            if (phrase.length() > 1 && phrase.charAt(phrase.length() - 1) == ' ') {
                s.append(whitespace);
            }
            if (click.getSettings().isWholeWord()) {
                s = new StringBuilder("\\b" + s + "\\b");
            }
        }
        Pattern pattern = Pattern.compile(s.toString());
        Matcher matcher = pattern.matcher(view);
        MatchObject matches = new MatchObject(view);
        if (matcher.find()) {
            matches.add(new StartEndPair(matcher.start(), matcher.end()));
        }
        while (matcher.find()) {
            matches.add(new StartEndPair(matcher.start(), matcher.end()));
        }
        return matches;
    }

    @JvmStatic
    public static final boolean checkCorrectAttributes(@NotNull Node node, @NotNull Click click) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        if (!(node instanceof Text)) {
            return false;
        }
        if (SearchUtils.isBraille(node)) {
            return false;
        }
        if (XMLHandler.Companion.ancestorVisitorElement(node, SearchUtils::checkCorrectAttributes$lambda$0) != null) {
            return false;
        }
        ParentNode parentNode = ((Text)node).getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element ele = (Element)parentNode;
        return INSTANCE.utdEmphasis$brailleblaster_core(ele, click) && INSTANCE.utdStyles$brailleblaster_core(node, click) && INSTANCE.utdContainer$brailleblaster_core(ele, click);
    }

    public final boolean hasFindCriteria(@NotNull Click search) {
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        return search.getSettings().findHasText() || search.getSettings().findHasAttributes();
    }

    @NotNull
    public final EnumSet<EmphasisType> makeEnumFromList$brailleblaster_core(@NotNull List<SearchCriteria.EmphasisFormatting> inputList, boolean isNegated) {
        Intrinsics.checkNotNullParameter(inputList, (String)"inputList");
        EnumSet<EmphasisType> es = EnumSet.noneOf(EmphasisType.class);
        for (SearchCriteria.EmphasisFormatting ef : inputList) {
            if (ef.isNot() != isNegated) continue;
            es.add(ef.emphasis);
        }
        Intrinsics.checkNotNull(es);
        return es;
    }

    public final boolean utdContainer$brailleblaster_core(@NotNull Element ele, @NotNull Click so) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        Intrinsics.checkNotNullParameter((Object)so, (String)"so");
        if (so.getSettings().findHasContainer()) {
            if (!BBX.CONTAINER.isA((Node)ele.getParent())) {
                return false;
            }
            ParentNode parentNode = ele.getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element n = (Element)parentNode;
            for (SearchCriteria.ContainerFormatting cf : so.getSettings().findContainerFormatting) {
                if (ele.getAttributeValue("utd-style") != null) {
                    boolean rs = Intrinsics.areEqual((Object)n.getAttributeValue("utd-style"), (Object)cf.getName());
                    return cf.isNot() ^ rs;
                }
                if (n.getAttributeValue("overrideStyle") == null) continue;
                boolean rs = Intrinsics.areEqual((Object)n.getAttributeValue("overrideStyle"), (Object)cf.getName());
                return cf.isNot() ^ rs;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean utdEmphasis$brailleblaster_core(@Nullable Element ele, @NotNull Click so) {
        EmphasisType o;
        void $this$none$iv;
        Intrinsics.checkNotNullParameter((Object)so, (String)"so");
        if (!so.getSettings().findHasEmphasis()) return true;
        if (!BBX.INLINE.EMPHASIS.isA((Node)ele)) {
            return false;
        }
        EnumSet emphasisBits = (EnumSet)BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.get(ele);
        EnumSet<EmphasisType> findEmphasis = this.makeEnumFromList$brailleblaster_core(so.getSettings().findEmphasisFormatting, false);
        EnumSet<EmphasisType> findNegatedEmphasis = this.makeEnumFromList$brailleblaster_core(so.getSettings().findEmphasisFormatting, true);
        if (!emphasisBits.containsAll((Collection)findEmphasis)) return false;
        Intrinsics.checkNotNull((Object)emphasisBits);
        Iterable iterable = emphasisBits;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            o = (EmphasisType)element$iv;
            boolean bl = false;
        } while (!findNegatedEmphasis.contains(o));
        return false;
    }

    public final boolean utdStyles$brailleblaster_core(@NotNull Node node, @NotNull Click click) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        if (!click.getSettings().findHasStyle()) {
            return true;
        }
        try {
            Element parent = XMLHandler.Companion.ancestorVisitorElement(node, arg_0 -> SearchUtils.utdStyles$lambda$0(click, arg_0));
            if (parent != null) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new SearchException("Null pointer thrown searching for \"" + click.getSettings().findString + "\" with styles: " + click.getSettings().printStyleFormatting(click.getSettings().findStyleFormatting) + "\nOn node " + node);
        }
        return false;
    }

    public final boolean hasStyles$brailleblaster_core(@NotNull Element el, @NotNull List<SearchCriteria.StyleFormatting> sfl) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        Intrinsics.checkNotNullParameter(sfl, (String)"sfl");
        if (BBX.BLOCK.isA((Node)el)) {
            for (SearchCriteria.StyleFormatting sf : sfl) {
                String utdStyle = el.getAttributeValue("utd-style");
                if (utdStyle != null) {
                    boolean rs = Intrinsics.areEqual((Object)utdStyle, (Object)sf.style);
                    return sf.isNot() ^ rs;
                }
                String overrideStyle = el.getAttributeValue("overrideStyle");
                if (overrideStyle == null) continue;
                boolean rs = Intrinsics.areEqual((Object)overrideStyle, (Object)sf.style);
                return sf.isNot() ^ rs;
            }
        }
        return false;
    }

    public final boolean isUneditable$brailleblaster_core(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return XMLHandler.Companion.ancestorVisitor(node, SearchUtils::isUneditable$lambda$0) != null || MathModuleUtils.isMath(node);
    }

    @JvmStatic
    public static final boolean checkUneditable(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (INSTANCE.isUneditable$brailleblaster_core(node) && INSTANCE.isUneditable$brailleblaster_core(node)) {
            Notify.notify$default(Notify.INSTANCE, "Text is part of an uneditable element.\nPlease use the table editor and/or math editor to edit these instances.", Notify.ALERT_SHELL_NAME, false, 4, null);
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean isBraille(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node curNode = node;
        Document doc = curNode.getDocument();
        while (curNode != doc) {
            if (UTDElements.BRL.isA(curNode)) {
                return true;
            }
            ParentNode parentNode = curNode.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
            curNode = (Node)parentNode;
        }
        return false;
    }

    @NotNull
    public final EmphasisReturn addEmphasisNoViews$brailleblaster_core(@NotNull Text node, int start, int end, @Nullable EnumSet<EmphasisType> et) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int[] nArray = new int[]{start, end};
        List nodesWithEmpty = XMLHandlerKt.splitNode((Text)node, (int[])nArray);
        List splitTextNode = new ArrayList();
        int index = 0;
        for (Text text : nodesWithEmpty) {
            String string = text.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (((CharSequence)string).length() > 0) {
                splitTextNode.add(text);
                continue;
            }
            text.detach();
        }
        if (splitTextNode.size() == 1) {
            this.wrapNewInEmphasis$brailleblaster_core(et, (Text)splitTextNode.get(0));
        } else if (splitTextNode.size() == 2) {
            if (start == 0) {
                v1 = this.wrapNewInEmphasis$brailleblaster_core(et, (Text)splitTextNode.get(0));
            } else {
                index = 1;
                v1 = this.wrapNewInEmphasis$brailleblaster_core(et, (Text)splitTextNode.get(1));
            }
        } else if (splitTextNode.size() == 3) {
            index = 1;
            this.wrapNewInEmphasis$brailleblaster_core(et, (Text)splitTextNode.get(1));
        }
        return new EmphasisReturn(splitTextNode, index);
    }

    @NotNull
    public final Node wrapNewInEmphasis$brailleblaster_core(@Nullable EnumSet<EmphasisType> et, @NotNull Text node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Element newEmphasisWrapper = BBX.INLINE.EMPHASIS.create(et);
        ParentNode parent = node.getParent();
        int index = parent.indexOf((Node)node);
        node.detach();
        newEmphasisWrapper.appendChild((Node)node);
        parent.insertChild((Node)newEmphasisWrapper, index);
        return (Node)node;
    }

    public final void modifyEmphasis$brailleblaster_core(@NotNull Node node, @NotNull List<SearchCriteria.EmphasisFormatting> ef) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(ef, (String)"ef");
        EnumSet<EmphasisType> addEmphasisEnum = this.makeEnumFromList$brailleblaster_core(ef, false);
        EnumSet<EmphasisType> removeEmphasisEnum = this.makeEnumFromList$brailleblaster_core(ef, true);
        ParentNode element = node.getParent();
        if (element instanceof Element) {
            if (BBX.INLINE.EMPHASIS.isA((Node)element)) {
                EnumSet existingEnum = (EnumSet)BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.get((Element)element);
                existingEnum.removeAll((Collection)removeEmphasisEnum);
                existingEnum.addAll((Collection)addEmphasisEnum);
                if (existingEnum.isEmpty()) {
                    ParentNode parentNode = ((Element)element).getParent();
                    Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                    Element pn = (Element)parentNode;
                    UTDHelper.stripUTDRecursive((Element)pn);
                    node.detach();
                    pn.replaceChild((Node)element, node);
                } else {
                    BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.set((Element)element, existingEnum);
                }
            } else {
                this.wrapNewInEmphasis$brailleblaster_core(addEmphasisEnum, (Text)node);
            }
        }
    }

    public final void dealWithReplaceCase$brailleblaster_core(@NotNull Click click, @NotNull String nodeString) {
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        Intrinsics.checkNotNullParameter((Object)nodeString, (String)"nodeString");
        String findString = Objects.requireNonNull(click.getSettings().findString);
        String string = nodeString;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        CharSequence charSequence = string2;
        String string3 = findString;
        Intrinsics.checkNotNull((Object)string3);
        string = string3;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
        String string4 = string.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        int start = StringsKt.indexOf$default((CharSequence)charSequence, (String)string4, (int)0, (boolean)false, (int)6, null);
        String string5 = nodeString.substring(start, start + findString.length());
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        String foundString = string5;
        String replaceString = Objects.requireNonNull(click.getSettings().replaceString);
        StringBuilder newReplaceString = new StringBuilder();
        boolean allcaps = true;
        String string6 = replaceString;
        Intrinsics.checkNotNull((Object)string6);
        int stop = (int)Math.min((double)string6.length(), (double)foundString.length());
        char[] cArray = foundString.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char findchar : cArray) {
            if (Character.isUpperCase(findchar) || !Character.isAlphabetic(findchar)) continue;
            allcaps = false;
            break;
        }
        int i = 0;
        int j = 0;
        while (i < stop) {
            char findChar = foundString.charAt(i);
            char replaceChar = replaceString.charAt(j);
            if (allcaps || i == 0 && Character.isUpperCase(findChar)) {
                converted = Character.toUpperCase(replaceChar);
                v9 = newReplaceString.append(converted);
            } else {
                converted = Character.toLowerCase(replaceChar);
                v9 = newReplaceString.append(converted);
            }
            ++i;
            ++j;
        }
        int leftoverChars = replaceString.length() - foundString.length();
        if (leftoverChars > 0) {
            int k = 0;
            int m = foundString.length();
            while (k < leftoverChars) {
                char leftoverChar = replaceString.charAt(m);
                char converted = allcaps ? Character.toUpperCase(leftoverChar) : Character.toLowerCase(leftoverChar);
                newReplaceString.append(converted);
                ++k;
                ++m;
            }
        }
        click.getSettings().replaceString = newReplaceString.toString();
    }

    @NotNull
    public final List<Node> cleanEmptyInlineAttributes$brailleblaster_core(@NotNull List<? extends Node> modifiedNodes) {
        Intrinsics.checkNotNullParameter(modifiedNodes, (String)"modifiedNodes");
        List newNodes = new ArrayList();
        List toDelete = new ArrayList();
        Iterable $this$forEach$iv = modifiedNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node e = (Node)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = NodeUtilsKt.getChildNodes((Node)e);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                boolean bl2;
                Node child = (Node)element$iv2;
                boolean bl3 = false;
                if (BBX.INLINE.EMPHASIS.isA(e)) {
                    BBX.EnumSetAttribute<EmphasisType> enumSetAttribute = BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS;
                    Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type nu.xom.Element");
                    if (((EnumSet)enumSetAttribute.get((Element)e)).isEmpty()) {
                        Text childText = new Text(child.getValue());
                        ParentNode parent = ((Element)e).getParent();
                        parent.insertChild((Node)childText, parent.indexOf(e));
                        newNodes.add(childText);
                        bl2 = toDelete.add(e);
                        continue;
                    }
                }
                bl2 = newNodes.add(e);
            }
        }
        for (Node node : toDelete) {
            node.detach();
        }
        return newNodes;
    }

    @JvmStatic
    public static final boolean inTable(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return m.getMapList().getCurrent().isReadOnly();
    }

    public final void removeContainer$brailleblaster_core(@NotNull List<? extends Node> list, @NotNull String replaceRemoveContainerString, @NotNull Manager m) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)replaceRemoveContainerString, (String)"replaceRemoveContainerString");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        switch (replaceRemoveContainerString) {
            case "Full Box": 
            case "Color Box": 
            case "Color Full Box": 
            case "Box": {
                Node box = XMLHandler.Companion.ancestorVisitor(list.get(0), SearchUtils::removeContainer$lambda$0);
                if (box == null) break;
                StylesMenuModule stylesMenuModule = m.getSimpleManager().getModule(StylesMenuModule.class);
                Intrinsics.checkNotNull((Object)stylesMenuModule);
                Style style = m.getDocument().getEngine().getStyleDefinitions().getStyleByName(replaceRemoveContainerString);
                Intrinsics.checkNotNull((Object)style);
                stylesMenuModule.applyStyle(style, box, box);
                break;
            }
            case "Poetic Stanza": {
                Node stanza = XMLHandler.Companion.ancestorVisitor(list.get(0), SearchUtils::removeContainer$lambda$1);
                if (stanza == null) break;
                XMLHandler.Companion.unwrapElement((Element)stanza);
                break;
            }
            case "List Tag": {
                Node lnode = XMLHandler.Companion.ancestorVisitor(list.get(0), SearchUtils::removeContainer$lambda$2);
                if (lnode == null) break;
                XMLHandler.Companion.unwrapElement((Element)lnode);
                break;
            }
            default: {
                System.out.println((Object)("Unknown container type " + replaceRemoveContainerString + " was not removed"));
            }
        }
    }

    public final void addContainer$brailleblaster_core(@NotNull List<? extends Node> list, @NotNull String replaceAddContainerString, @NotNull Manager m) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)replaceAddContainerString, (String)"replaceAddContainerString");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        switch (replaceAddContainerString) {
            case "Full Box": 
            case "Color Box": 
            case "Color Full Box": 
            case "Box": {
                Node box = XMLHandler.Companion.ancestorVisitor(list.get(0), SearchUtils::addContainer$lambda$0);
                if (box != null) break;
                StylesMenuModule stylesMenuModule = m.getSimpleManager().getModule(StylesMenuModule.class);
                Intrinsics.checkNotNull((Object)stylesMenuModule);
                Style style = m.getDocument().getEngine().getStyleDefinitions().getStyleByName(replaceAddContainerString);
                Intrinsics.checkNotNull((Object)style);
                stylesMenuModule.applyStyle(style, list.get(0), list.get(list.size() - 1));
                break;
            }
            case "Poetic Stanza": {
                Node stanza = XMLHandler.Companion.ancestorVisitor(list.get(0), SearchUtils::addContainer$lambda$1);
                if (stanza != null) break;
                StylesMenuModule stylesMenuModule = m.getSimpleManager().getModule(StylesMenuModule.class);
                Intrinsics.checkNotNull((Object)stylesMenuModule);
                Style style = m.getDocument().getEngine().getStyleDefinitions().getStyleByName(replaceAddContainerString);
                Intrinsics.checkNotNull((Object)style);
                stylesMenuModule.applyStyle(style, list.get(0), list.get(list.size() - 1));
                break;
            }
            case "List Tag": {
                Node lnode = XMLHandler.Companion.ancestorVisitor(list.get(0), SearchUtils::addContainer$lambda$2);
                if (lnode != null) break;
                StylesMenuModule stylesMenuModule = m.getSimpleManager().getModule(StylesMenuModule.class);
                Intrinsics.checkNotNull((Object)stylesMenuModule);
                Style style = m.getDocument().getEngine().getStyleDefinitions().getStyleByName(replaceAddContainerString);
                Intrinsics.checkNotNull((Object)style);
                stylesMenuModule.applyStyle(style, list.get(0), list.get(list.size() - 1));
                break;
            }
            default: {
                System.out.println((Object)("Unknown container type " + replaceAddContainerString + " was not added"));
            }
        }
    }

    public final void changeContainer$brailleblaster_core(@NotNull List<? extends Node> list, @NotNull List<SearchCriteria.ContainerFormatting> cl, @NotNull Manager m) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(cl, (String)"cl");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        for (SearchCriteria.ContainerFormatting cf : cl) {
            if (cf.isNot()) {
                this.removeContainer$brailleblaster_core(list, cf.getName(), m);
                continue;
            }
            this.addContainer$brailleblaster_core(list, cf.getName(), m);
        }
    }

    private static final boolean checkCorrectAttributes$lambda$0(Element n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return Intrinsics.areEqual((Object)n.getLocalName(), (Object)"head");
    }

    private static final boolean utdStyles$lambda$0(Click $click, Element n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return INSTANCE.hasStyles$brailleblaster_core(n, $click.getSettings().findStyleFormatting);
    }

    private static final boolean isUneditable$lambda$0(Node n) {
        return BBX.CONTAINER.TABLE.isA(n);
    }

    private static final boolean removeContainer$lambda$0(Node node) {
        return BBX.CONTAINER.BOX.isA(node);
    }

    private static final boolean removeContainer$lambda$1(Node n) {
        return n instanceof Element && ((Element)n).getAttributeValue("utd-style") != null && Intrinsics.areEqual((Object)((Element)n).getAttributeValue("utd-style"), (Object)"Poetic Stanza");
    }

    private static final boolean removeContainer$lambda$2(Node node) {
        return BBX.CONTAINER.LIST.isA(node);
    }

    private static final boolean addContainer$lambda$0(Node node) {
        return BBX.CONTAINER.BOX.isA(node);
    }

    private static final boolean addContainer$lambda$1(Node n) {
        return n instanceof Element && ((Element)n).getAttributeValue("utd-style") != null && Intrinsics.areEqual((Object)((Element)n).getAttributeValue("utd-style"), (Object)"Poetic Stanza");
    }

    private static final boolean addContainer$lambda$2(Node node) {
        return BBX.CONTAINER.LIST.isA(node);
    }

    static {
        Object[] objectArray = new String[]{"Box", "Full Box", "Color Box", "Color Full Box"};
        CONTAINERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/search/SearchUtils$EmphasisReturn;", "", "nodes", "", "Lnu/xom/Text;", "index", "", "<init>", "(Ljava/util/List;I)V", "getNodes", "()Ljava/util/List;", "getIndex", "()I", "brailleblaster-core"})
    public static final class EmphasisReturn {
        @NotNull
        private final List<Text> nodes;
        private final int index;

        public EmphasisReturn(@NotNull List<? extends Text> nodes, int index) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            this.nodes = nodes;
            this.index = index;
        }

        @NotNull
        public final List<Text> getNodes() {
            return this.nodes;
        }

        public final int getIndex() {
            return this.index;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/brailleblaster/search/SearchUtils$MatchObject;", "", "view", "", "<init>", "(Ljava/lang/String;)V", "getView", "()Ljava/lang/String;", "indices", "Ljava/util/ArrayList;", "Lorg/brailleblaster/search/SearchUtils$StartEndPair;", "getIndices", "()Ljava/util/ArrayList;", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "isFirstHalf", "", "()Z", "hasNext", "add", "", "indexMatch", "next", "getNext", "()Lorg/brailleblaster/search/SearchUtils$StartEndPair;", "brailleblaster-core"})
    public static final class MatchObject {
        @NotNull
        private final String view;
        @NotNull
        private final ArrayList<StartEndPair> indices;
        private int currentIndex;

        public MatchObject(@NotNull String view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.view = view;
            this.indices = new ArrayList();
        }

        @NotNull
        public final String getView() {
            return this.view;
        }

        @NotNull
        public final ArrayList<StartEndPair> getIndices() {
            return this.indices;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean isFirstHalf() {
            int index = this.indices.get((int)this.currentIndex).start;
            int viewSize = this.view.length();
            return index < viewSize / 2;
        }

        public final boolean hasNext() {
            return this.currentIndex < this.indices.size();
        }

        public final void add(@NotNull StartEndPair indexMatch) {
            Intrinsics.checkNotNullParameter((Object)indexMatch, (String)"indexMatch");
            this.indices.add(indexMatch);
        }

        @NotNull
        public final StartEndPair getNext() {
            int n = this.currentIndex;
            this.currentIndex = n + 1;
            StartEndPair startEndPair = this.indices.get(this.currentIndex - 1);
            Intrinsics.checkNotNullExpressionValue((Object)startEndPair, (String)"get(...)");
            return startEndPair;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/search/SearchUtils$StartEndPair;", "", "start", "", "end", "<init>", "(II)V", "brailleblaster-core"})
    public static final class StartEndPair {
        @JvmField
        public final int start;
        @JvmField
        public final int end;

        public StartEndPair(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

