/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.settings.ui;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.BBIni;
import org.brailleblaster.perspectives.mvc.modules.misc.ExceptionReportingModule;
import org.brailleblaster.settings.ui.SettingsUITab;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/settings/ui/PrivacySettingsTab;", "Lorg/brailleblaster/settings/ui/SettingsUITab;", "shell", "Lorg/eclipse/swt/widgets/Shell;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;)V", "usageSharingCheckBox", "Lorg/eclipse/swt/widgets/Button;", "reportingCombo", "Lorg/eclipse/swt/widgets/Combo;", "recoveryCombo", "uploadCombo", "validate", "", "updateEngine", "", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "brailleblaster-core"})
public final class PrivacySettingsTab
implements SettingsUITab {
    @NotNull
    private Button usageSharingCheckBox;
    @NotNull
    private final Combo reportingCombo;
    @NotNull
    private final Combo recoveryCombo;
    @NotNull
    private final Combo uploadCombo;

    public PrivacySettingsTab(@Nullable Shell shell) {
        LocaleHandler lh = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
        Composite parent = new Composite((Composite)shell, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        Group usageGroup = new Group(parent, 0);
        usageGroup.setLayout((Layout)new GridLayout(1, true));
        usageGroup.setText(lh.get("PrivacySettingsTab.usageGroupText"));
        EasySWT.INSTANCE.setGridDataGroup(usageGroup);
        this.usageSharingCheckBox = (Button)EasySWT.INSTANCE.makeButton(parent, 96).text(lh.get("PrivacySettingsTab.usageDataSharing")).get();
        Group standardsGroup = new Group(parent, 0);
        standardsGroup.setLayout((Layout)new GridLayout(2, true));
        standardsGroup.setText(lh.get("ExceptionSettingsTab.onError"));
        EasySWT.INSTANCE.setGridDataGroup(standardsGroup);
        EasySWT.INSTANCE.newLabel((Composite)standardsGroup, lh.get("ExceptionSettingsTab.notifications"));
        this.reportingCombo = new Combo((Composite)standardsGroup, 12);
        EasySWT.INSTANCE.setGridData((Control)this.reportingCombo);
        this.reportingCombo.add(lh.get("ExceptionSettingsTab.displayErrorInformation"));
        this.reportingCombo.add(lh.get("ExceptionSettingsTab.notifyErrorOccurred"));
        this.reportingCombo.add(lh.get("ExceptionSettingsTab.displayInStatusBar"));
        EasySWT.INSTANCE.newLabel((Composite)standardsGroup, lh.get("ExceptionSettingsTab.errorRecovery"));
        this.recoveryCombo = new Combo((Composite)standardsGroup, 12);
        EasySWT.INSTANCE.setGridData((Control)this.recoveryCombo);
        this.recoveryCombo.add(lh.get("ExceptionSettingsTab.automaticallyRecover"));
        this.recoveryCombo.add(lh.get("ExceptionSettingsTab.doNotRecover"));
        EasySWT.INSTANCE.newLabel((Composite)standardsGroup, lh.get("ExceptionSettingsTab.reportErrors"));
        this.uploadCombo = new Combo((Composite)standardsGroup, 12);
        EasySWT.INSTANCE.setGridData((Control)this.uploadCombo);
        this.uploadCombo.add(lh.get("Common.yes"));
        this.uploadCombo.add(lh.get("Common.no"));
        this.usageSharingCheckBox.setSelection(BBIni.getPropertyFileManager().getPropertyAsBoolean("usageTracking", false));
        this.reportingCombo.select(ExceptionReportingModule.INSTANCE.getExceptionReportingLevel().ordinal());
        this.recoveryCombo.select(ExceptionReportingModule.getExceptionRecoveryLevel().ordinal());
        Boolean reportCurrent = ExceptionReportingModule.INSTANCE.isAutoUploadEnabledOrNull();
        if (reportCurrent != null) {
            this.uploadCombo.select(reportCurrent != false ? 0 : 1);
        }
    }

    @Override
    @Nullable
    public String validate() {
        return null;
    }

    @Override
    public boolean updateEngine(@NotNull UTDTranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        BBIni.getPropertyFileManager().saveAsBoolean("usageTracking", this.usageSharingCheckBox.getSelection());
        int selectedReporting = this.reportingCombo.getSelectionIndex();
        ExceptionReportingModule.INSTANCE.setExceptionReportingLevel((ExceptionReportingModule.ExceptionReportingLevel)((Object)ExceptionReportingModule.ExceptionReportingLevel.getEntries().get(selectedReporting)));
        int selectedRecovery = this.recoveryCombo.getSelectionIndex();
        ExceptionReportingModule.setExceptionRecoveryLevel((ExceptionReportingModule.ExceptionRecoveryLevel)((Object)ExceptionReportingModule.ExceptionRecoveryLevel.getEntries().get(selectedRecovery)));
        int selectedUpload = this.uploadCombo.getSelectionIndex();
        if (selectedUpload != -1) {
            ExceptionReportingModule.INSTANCE.setAutoUploadEnabled(selectedUpload == 0);
        }
        return false;
    }
}

