/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.SharedItem;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.tools.InsertLinkToolKt;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.internal.xml.XMLHandlerKt;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\f2\b\b\u0002\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0&2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/brailleblaster/tools/InsertLinkTool;", "Lorg/eclipse/swt/widgets/Dialog;", "Lorg/brailleblaster/tools/MenuToolModule;", "parent", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "accelerator", "", "getAccelerator", "()I", "sharedItem", "Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;", "getSharedItem", "()Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "makeGUI", "linkText", "startInternal", "", "insertLink", "link", "isExternal", "getBookmarksList", "", "removeLink", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nInsertLinkTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertLinkTool.kt\norg/brailleblaster/tools/InsertLinkTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1915#2,2:279\n1586#2:281\n1661#2,3:282\n*S KotlinDebug\n*F\n+ 1 InsertLinkTool.kt\norg/brailleblaster/tools/InsertLinkTool\n*L\n137#1:279,2\n255#1:281\n255#1:282,3\n*E\n"})
public final class InsertLinkTool
extends Dialog
implements MenuToolModule {
    @NotNull
    private final TopMenu topMenu;
    @NotNull
    private final String title;
    private final int accelerator;
    @NotNull
    private final SharedItem sharedItem;
    private final Logger logger;

    public InsertLinkTool(@NotNull Manager parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent.getWpManager().getShell(), 0);
        this.topMenu = TopMenu.INSERT;
        this.title = InsertLinkToolKt.access$getLocaleHandler$p().get("InsertLink");
        this.accelerator = SWT.MOD1 | 0x4B;
        this.sharedItem = SharedItem.INSERT_LINK;
        this.logger = LoggerFactory.getLogger(TextView.class);
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return this.topMenu;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getAccelerator() {
        return this.accelerator;
    }

    @Override
    @NotNull
    public SharedItem getSharedItem() {
        return this.sharedItem;
    }

    @Override
    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        TextMapElement textMapElement = bbData.getManager().getMapList().getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        TextMapElement current = textMapElement;
        String linkText = "";
        Element el = current.getNodeParent();
        boolean isLink = false;
        boolean startInternal = false;
        if (el != null && BBX.INLINE.LINK.isA((Node)el)) {
            if (Boolean.parseBoolean(el.getAttributeValue("external", "http://brailleblaster.org/ns/bb"))) {
                String string = el.getAttributeValue("href", "http://brailleblaster.org/ns/bb");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                linkText = string;
            } else {
                startInternal = true;
            }
            isLink = true;
        }
        if (bbData.getManager().getSimpleManager().getCurrentSelection().isTextNoSelection() && !isLink) {
            return;
        }
        this.makeGUI(bbData, linkText, startInternal);
    }

    private final void makeGUI(BBSelectionData bbData, String linkText, boolean startInternal) {
        Shell shell = new Shell(this.getParent().getShell());
        shell.setText(InsertLinkToolKt.access$getLocaleHandler$p().get("InsertLink"));
        shell.setLayout((Layout)new FillLayout());
        TabFolder tabs = new TabFolder((Composite)shell, 0);
        TabItem tabExternal = new TabItem(tabs, 0);
        tabExternal.setText("External Links");
        TabItem tabInternal = new TabItem(tabs, 0);
        tabInternal.setText("Internal Links");
        Group externalTabGroup = new Group((Composite)tabs, 0);
        externalTabGroup.setLayout((Layout)new GridLayout(2, false));
        Group internalTabGroup = new Group((Composite)tabs, 0);
        internalTabGroup.setLayout((Layout)new GridLayout(2, false));
        Group internalListGroup = new Group((Composite)internalTabGroup, 0);
        internalListGroup.setLayout((Layout)new GridLayout(1, false));
        Group internalButtonsGroup = new Group((Composite)internalTabGroup, 0);
        internalButtonsGroup.setLayout((Layout)new GridLayout(1, false));
        Text entryText = EasySWT.makeText((Composite)((Composite)externalTabGroup), (int)180, (int)2);
        entryText.setText(linkText);
        entryText.setMessage("Enter URL, email, or file link here");
        EasySWT.INSTANCE.addEnterListener((Control)entryText, arg_0 -> InsertLinkTool.makeGUI$lambda$0(entryText, this, bbData, shell, arg_0));
        EasySWT.makePushButton((Composite)((Composite)externalTabGroup), (String)InsertLinkToolKt.access$getLocaleHandler$p().get("InsertLink"), (int)1, arg_0 -> InsertLinkTool.makeGUI$lambda$1(this, entryText, bbData, shell, arg_0));
        EasySWT.makePushButton((Composite)((Composite)externalTabGroup), (String)InsertLinkToolKt.access$getLocaleHandler$p().get("removeLink"), (int)1, arg_0 -> InsertLinkTool.makeGUI$lambda$2(this, bbData, shell, arg_0));
        EasySWT.makePushButton((Composite)((Composite)externalTabGroup), (String)InsertLinkToolKt.access$getLocaleHandler$p().get("buttonCancel"), (int)1, arg_0 -> InsertLinkTool.makeGUI$lambda$3(shell, arg_0));
        tabExternal.setControl((Control)externalTabGroup);
        GridData gd1 = new GridData();
        gd1.widthHint = 180;
        gd1.heightHint = 90;
        gd1.grabExcessVerticalSpace = true;
        gd1.grabExcessHorizontalSpace = true;
        org.eclipse.swt.widgets.List bookmarkList = new org.eclipse.swt.widgets.List((Composite)internalListGroup, 2564);
        Iterable $this$forEach$iv = this.getBookmarksList(bbData);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            bookmarkList.add(it);
        }
        bookmarkList.setLayoutData((Object)gd1);
        EasySWT.makePushButton((Composite)((Composite)internalButtonsGroup), (String)"Set Internal Link", (int)1, arg_0 -> InsertLinkTool.makeGUI$lambda$5(bookmarkList, this, bbData, shell, arg_0));
        EasySWT.INSTANCE.addEnterListener((Control)bookmarkList, arg_0 -> InsertLinkTool.makeGUI$lambda$6(bookmarkList, this, bbData, shell, arg_0));
        EasySWT.makePushButton((Composite)((Composite)internalButtonsGroup), (String)"Remove Internal Link", (int)1, arg_0 -> InsertLinkTool.makeGUI$lambda$7(this, bbData, shell, arg_0));
        EasySWT.makePushButton((Composite)((Composite)internalButtonsGroup), (String)InsertLinkToolKt.access$getLocaleHandler$p().get("buttonCancel"), (int)1, arg_0 -> InsertLinkTool.makeGUI$lambda$8(shell, arg_0));
        tabInternal.setControl((Control)internalTabGroup);
        EasySWT.INSTANCE.addEscapeCloseListener(shell);
        if (startInternal) {
            tabs.setSelection(tabInternal);
        }
        shell.pack();
        shell.open();
    }

    static /* synthetic */ void makeGUI$default(InsertLinkTool insertLinkTool, BBSelectionData bBSelectionData, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        insertLinkTool.makeGUI(bBSelectionData, string, bl);
    }

    private final void insertLink(String link, boolean isExternal, BBSelectionData bbData) {
        nu.xom.Text text;
        this.logger.info("Inserting link text: " + link + "; isExternal: " + isExternal);
        MapList mapList = bbData.getManager().getMapList();
        TextMapElement textMapElement = mapList.getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        TextMapElement current = textMapElement;
        if (current.getNodeParent() != null && BBX.INLINE.LINK.isA((Node)current.getNodeParent())) {
            if (((CharSequence)link).length() > 0) {
                current.getNodeParent().addAttribute(BBX.INLINE.LINK.ATTRIB_HREF.newAttribute(link));
                BBSimpleManager bBSimpleManager = bbData.getManager().getSimpleManager();
                Node[] nodeArray = new Node[1];
                Intrinsics.checkNotNullExpressionValue((Object)current.getNodeParent(), (String)"getNodeParent(...)");
                bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.TEXT, false, nodeArray));
            }
            return;
        }
        if (current.isReadOnly() || bbData.getManager().getSimpleManager().getCurrentSelection().isTextNoSelection()) {
            this.logger.debug("No selection or read-only area - not creating link");
            return;
        }
        if (!bbData.getManager().getSimpleManager().getCurrentSelection().isSingleNode()) {
            this.logger.debug("Multiple nodes selected - cannot create link");
            return;
        }
        Element newLink = BBX.INLINE.LINK.create();
        newLink.addAttribute(BBX.INLINE.LINK.IS_EXTERNAL.newAttribute(isExternal));
        newLink.addAttribute(BBX.INLINE.LINK.ATTRIB_HREF.newAttribute(link));
        Node currentNode = bbData.getManager().getSimpleManager().getCurrentCaret().getNode();
        if (!(currentNode instanceof nu.xom.Text)) {
            this.logger.debug("Current node is not text - cannot create link");
            return;
        }
        int nodeLength = ((nu.xom.Text)currentNode).getValue().length();
        XMLNodeCaret xMLNodeCaret = bbData.getManager().getSimpleManager().getCurrentSelection().start;
        Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
        int start = ((XMLTextCaret)xMLNodeCaret).getOffset();
        XMLNodeCaret xMLNodeCaret2 = bbData.getManager().getSimpleManager().getCurrentSelection().end;
        Intrinsics.checkNotNull((Object)xMLNodeCaret2, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
        int end = ((XMLTextCaret)xMLNodeCaret2).getOffset();
        this.logger.info("Adding link to Node " + ((nu.xom.Text)currentNode).getValue() + ", length: " + nodeLength + ", start: " + start + ", end: " + end);
        if (start > 0 && end != -1 && end != nodeLength) {
            var13_12 = new int[]{start, end};
            splitTextNode = XMLHandlerKt.splitNode((nu.xom.Text)((nu.xom.Text)currentNode), (int[])var13_12);
            text = (nu.xom.Text)splitTextNode.get(1);
        } else if (start > 0) {
            var13_12 = new int[]{start};
            splitTextNode = XMLHandlerKt.splitNode((nu.xom.Text)((nu.xom.Text)currentNode), (int[])var13_12);
            text = (nu.xom.Text)splitTextNode.get(1);
        } else if (end != -1 && end != nodeLength) {
            var13_12 = new int[]{end};
            splitTextNode = XMLHandlerKt.splitNode((nu.xom.Text)((nu.xom.Text)currentNode), (int[])var13_12);
            text = (nu.xom.Text)splitTextNode.get(0);
        } else {
            text = (nu.xom.Text)currentNode;
        }
        nu.xom.Text nodeToWrap = text;
        Node node = (Node)nodeToWrap;
        Intrinsics.checkNotNull((Object)newLink);
        XMLHandler.Companion.wrapNodeWithElement(node, newLink);
        BBSimpleManager bBSimpleManager = bbData.getManager().getSimpleManager();
        Node[] nodeArray = new Node[1];
        Intrinsics.checkNotNullExpressionValue((Object)nodeToWrap.getParent(), (String)"getParent(...)");
        bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.TEXT, true, nodeArray));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getBookmarksList(BBSelectionData bbData) {
        List elementStrings = CollectionsKt.emptyList();
        try {
            void $this$mapTo$iv$iv;
            String xpath = "//*[@*[local-name() = 'linkID']]";
            Nodes nodes = bbData.getManager().getSimpleManager().getDoc().query(xpath);
            Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"query(...)");
            List results = CollectionsKt.toList((Iterable)((Iterable)nodes));
            Iterable $this$map$iv = results;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Node node = (Node)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element el = (Element)it;
                collection.add(el.getAttributeValue("linkID", "http://brailleblaster.org/ns/bb").toString());
            }
            elementStrings = (List)destination$iv$iv;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return elementStrings;
    }

    private final void removeLink(BBSelectionData bbData) {
        MapList mapList = bbData.getManager().getMapList();
        TextMapElement textMapElement = mapList.getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        TextMapElement current = textMapElement;
        if (current.getNodeParent() != null && BBX.INLINE.LINK.isA((Node)current.getNodeParent())) {
            Element element = current.getNodeParent();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
            XMLHandler.Companion.unwrapElement(element);
            BBSimpleManager bBSimpleManager = bbData.getManager().getSimpleManager();
            Node[] nodeArray = new Node[1];
            Intrinsics.checkNotNullExpressionValue((Object)current.getNodeParent(), (String)"getNodeParent(...)");
            bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.TEXT, false, nodeArray));
        }
    }

    private static final void makeGUI$lambda$0(Text $entryText, InsertLinkTool this$0, BBSelectionData $bbData, Shell $shell, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $entryText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() > 0) {
            String string2 = $entryText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            this$0.insertLink(string2, true, $bbData);
        }
        $shell.close();
    }

    private static final void makeGUI$lambda$1(InsertLinkTool this$0, Text $entryText, BBSelectionData $bbData, Shell $shell, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $entryText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.insertLink(string, true, $bbData);
        $shell.close();
    }

    private static final void makeGUI$lambda$2(InsertLinkTool this$0, BBSelectionData $bbData, Shell $shell, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.removeLink($bbData);
        $shell.close();
    }

    private static final void makeGUI$lambda$3(Shell $shell, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $shell.close();
    }

    private static final void makeGUI$lambda$5(org.eclipse.swt.widgets.List $bookmarkList, InsertLinkTool this$0, BBSelectionData $bbData, Shell $shell, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($bookmarkList.getSelectionIndex() != -1) {
            String bookmarkID = $bookmarkList.getSelection()[0];
            Intrinsics.checkNotNull((Object)bookmarkID);
            this$0.insertLink(bookmarkID, false, $bbData);
        }
        $shell.close();
    }

    private static final void makeGUI$lambda$6(org.eclipse.swt.widgets.List $bookmarkList, InsertLinkTool this$0, BBSelectionData $bbData, Shell $shell, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($bookmarkList.getSelectionIndex() != -1) {
            String bookmarkID = $bookmarkList.getSelection()[0];
            Intrinsics.checkNotNull((Object)bookmarkID);
            this$0.insertLink(bookmarkID, false, $bbData);
        }
        $shell.close();
    }

    private static final void makeGUI$lambda$7(InsertLinkTool this$0, BBSelectionData $bbData, Shell $shell, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.removeLink($bbData);
        $shell.close();
    }

    private static final void makeGUI$lambda$8(Shell $shell, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $shell.close();
    }
}

