/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.usage;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.usage.UsageLogger;
import org.brailleblaster.usage.UsageRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00060\u0002j\u0002`\u00032\u00020\u0004:\u0001\u001aB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0096\u0082\u0004J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/brailleblaster/usage/SqliteUsageLogger;", "Lorg/brailleblaster/usage/UsageLogger;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Ljava/io/Closeable;", "connectionString", "", "<init>", "(Ljava/lang/String;)V", "connection", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "executorService", "Ljava/util/concurrent/ExecutorService;", "close", "", "log", "record", "Lorg/brailleblaster/usage/UsageRecord;", "clear", "iterator", "", "clearTo", "time", "Ljava/time/Instant;", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nUsageLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageLogger.kt\norg/brailleblaster/usage/SqliteUsageLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class SqliteUsageLogger
implements UsageLogger,
AutoCloseable,
Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Connection connection;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private static final String CREATE_TABLE_SQL = "CREATE TABLE IF NOT EXISTS usage (record_id INTEGER PRIMARY KEY, tool TEXT NOT NULL, event TEXT NOT NULL, message TEXT NOT NULL, time INTEGER NOT NULL)";
    @NotNull
    private static final String INSERT_RECORD_SQL = "INSERT INTO usage (tool, event, message, time) VALUES(?, ?, ?, ?)";
    @NotNull
    private static final String CLEAR_TABLE_SQL = "DELETE FROM usage";
    @NotNull
    private static final String SELECT_ALL_RECORDS_SQL = "SELECT tool, event, message, time FROM usage";

    public SqliteUsageLogger(@NotNull String connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Connection connection = DriverManager.getConnection(connectionString);
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        this.connection = connection;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.executorService = executorService;
        this.executorService.submit(() -> SqliteUsageLogger._init_$lambda$0(this));
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        this.connection.close();
    }

    @Override
    public void log(@NotNull UsageRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        this.executorService.submit(() -> SqliteUsageLogger.log$lambda$0(this, record));
    }

    @Override
    public void clear() {
        this.executorService.submit(() -> SqliteUsageLogger.clear$lambda$0(this));
    }

    @Override
    @NotNull
    public Iterator<UsageRecord> iterator() {
        return this.executorService.submit(() -> SqliteUsageLogger.iterator$lambda$0(this)).get().iterator();
    }

    public final void clearTo(@NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.executorService.submit(() -> SqliteUsageLogger.clearTo$lambda$0(this, time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void log$lambda$0(SqliteUsageLogger this$0, UsageRecord $record) {
        AutoCloseable autoCloseable = this$0.connection.prepareStatement(INSERT_RECORD_SQL);
        Throwable throwable = null;
        try {
            PreparedStatement preparedStatement;
            PreparedStatement stmt = (PreparedStatement)autoCloseable;
            boolean bl = false;
            PreparedStatement $this$log_u24lambda_u240_u240_u240 = preparedStatement = stmt;
            boolean bl2 = false;
            $this$log_u24lambda_u240_u240_u240.setString(1, $record.getTool());
            $this$log_u24lambda_u240_u240_u240.setString(2, $record.getEvent());
            $this$log_u24lambda_u240_u240_u240.setString(3, $record.getMessage());
            $this$log_u24lambda_u240_u240_u240.setLong(4, $record.getTime().toEpochMilli());
            preparedStatement.execute();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void clear$lambda$0(SqliteUsageLogger this$0) {
        AutoCloseable autoCloseable = this$0.connection.createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            stmt.execute(CLEAR_TABLE_SQL);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List iterator$lambda$0(SqliteUsageLogger this$0) {
        List list;
        List $this$iterator_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        AutoCloseable autoCloseable = this$0.connection.createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl2 = false;
            AutoCloseable autoCloseable2 = stmt.executeQuery(SELECT_ALL_RECORDS_SQL);
            Throwable throwable2 = null;
            try {
                ResultSet results = (ResultSet)autoCloseable2;
                boolean bl3 = false;
                while (results.next()) {
                    String tool = results.getString("tool");
                    String event = results.getString("event");
                    String message = results.getString("message");
                    Instant time = Instant.ofEpochMilli(results.getLong("time"));
                    Intrinsics.checkNotNull((Object)tool);
                    Intrinsics.checkNotNull((Object)event);
                    Intrinsics.checkNotNull((Object)message);
                    Intrinsics.checkNotNull((Object)time);
                    $this$iterator_u24lambda_u240_u240.add(new UsageRecord(tool, event, message, time));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void clearTo$lambda$0(SqliteUsageLogger this$0, Instant $time) {
        AutoCloseable autoCloseable = this$0.connection.prepareStatement("DELETE FROM usage WHERE time <= ?");
        Throwable throwable = null;
        try {
            PreparedStatement preparedStatement;
            PreparedStatement stmt = (PreparedStatement)autoCloseable;
            boolean bl = false;
            PreparedStatement $this$clearTo_u24lambda_u240_u240_u240 = preparedStatement = stmt;
            boolean bl2 = false;
            $this$clearTo_u24lambda_u240_u240_u240.setLong(1, $time.toEpochMilli());
            preparedStatement.execute();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _init_$lambda$0(SqliteUsageLogger this$0) {
        AutoCloseable autoCloseable = this$0.connection.createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            stmt.execute(CREATE_TABLE_SQL);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/usage/SqliteUsageLogger$Companion;", "", "<init>", "()V", "CREATE_TABLE_SQL", "", "INSERT_RECORD_SQL", "CLEAR_TABLE_SQL", "SELECT_ALL_RECORDS_SQL", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

