/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.userHelp;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.brailleblaster.AppProperties;
import org.brailleblaster.BBIni;
import org.brailleblaster.userHelp.HelpOptions;
import org.brailleblaster.userHelp.VersionInfo;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.BBData;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"helpPath", "", "showHelp", "", "helpChoice", "Lorg/brailleblaster/userHelp/HelpOptions;", "showAbout", "fileName", "brailleblaster-core"})
public final class UserHelpKt {
    @NotNull
    private static final String helpPath = BBIni.INSTANCE.getHelpDocsPath() + FileSystems.getDefault().getSeparator();

    private static final void showHelp(HelpOptions helpChoice) {
        switch (WhenMappings.$EnumSwitchMapping$0[helpChoice.ordinal()]) {
            case 1: {
                Program.launch((String)AppProperties.INSTANCE.getWebsiteUrl());
                break;
            }
            case 2: {
                UserHelpKt.showHelp("manualV2_1.html");
                break;
            }
            case 3: {
                UserHelpKt.showAbout();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void showAbout() {
        String[] stringArray;
        Shell shell = new Shell(133216);
        shell.setText("About " + AppProperties.INSTANCE.getDisplayName());
        shell.setLayout((Layout)new GridLayout(2, false));
        boolean bl = false;
        try {
            stringArray = new String[]{"APH_Logo.png"};
            stringArray = new Image((Device)Display.getCurrent(), Files.newInputStream(BBIni.getProgramDataPath().resolve(Paths.get("images", stringArray)), new OpenOption[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load APH logo", e);
        }
        String[] img = stringArray;
        Label text = new Label((Composite)shell, 8);
        text.setText("APH Logo");
        text.setImage((Image)img);
        EasySWT.INSTANCE.setGridDataVertical((Control)text);
        Composite sidePanel = new Composite((Composite)shell, 0);
        EasySWT.INSTANCE.setGridDataVertical((Control)sidePanel);
        sidePanel.setLayout((Layout)new GridLayout());
        EasySWT.INSTANCE.newLabel(sidePanel, "For more information or to report bugs visit " + AppProperties.INSTANCE.getWebsiteUrl());
        boolean bl2 = false;
        StyledText text2 = new StyledText(sidePanel, 2056);
        text2.setText(VersionInfo.getVersionsSimple());
        EasySWT.INSTANCE.setGridDataVertical((Control)text2);
        Composite bottomPanel = new Composite(sidePanel, 0);
        EasySWT.INSTANCE.setGridDataVertical((Control)bottomPanel);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.center = true;
        bottomPanel.setLayout((Layout)rowLayout);
        Button license = new Button(bottomPanel, 8);
        license.setText("License");
        Button privacyPolicy = new Button(bottomPanel, 8);
        privacyPolicy.setText("APH Privacy Policy");
        EasySWT.addSelectionListener((Button)license, UserHelpKt::showAbout$lambda$2);
        EasySWT.addSelectionListener((Button)privacyPolicy, UserHelpKt::showAbout$lambda$3);
        shell.pack();
        shell.setActive();
        shell.open();
    }

    private static final void showHelp(String fileName) {
        String us = "file:///" + StringsKt.replace$default((String)helpPath, (char)'\\', (char)'/', (boolean)false, (int)4, null) + fileName;
        String uriString = StringsKt.replace$default((String)us, (String)" ", (String)"%20", (boolean)false, (int)4, null);
        Program.launch((String)uriString);
    }

    private static final void showAbout$lambda$2(SelectionEvent it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{"LICENSE.txt"};
        File licensePath = BBData.INSTANCE.getBrailleblasterPath(stringArray);
        try {
            string = FilesKt.readText((File)licensePath, (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to open license at " + licensePath.getAbsolutePath(), ex);
        }
        String text = string;
        Notify.notify$default(Notify.INSTANCE, text, "License", false, 4, null);
    }

    private static final void showAbout$lambda$3(SelectionEvent it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{"APH_Privacy_Policy.txt"};
        File licensePath = BBData.INSTANCE.getBrailleblasterPath(stringArray);
        try {
            string = FilesKt.readText((File)licensePath, (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to open license at " + licensePath.getAbsolutePath(), ex);
        }
        String text = string;
        Notify.notify$default(Notify.INSTANCE, text, "APH Privacy Policy", false, 4, null);
    }

    public static final /* synthetic */ void access$showHelp(HelpOptions helpChoice) {
        UserHelpKt.showHelp(helpChoice);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HelpOptions.values().length];
            try {
                nArray[HelpOptions.GoToSite.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HelpOptions.UserGuide.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HelpOptions.AboutBB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

