/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.brailleblaster.utd.actions.CompBRLAction;
import org.brailleblaster.utd.actions.DirectAction;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.actions.NoContractionAction;
import org.brailleblaster.utd.actions.ScriptAction;
import org.brailleblaster.utd.actions.Trans1Action;
import org.brailleblaster.utd.actions.Trans2Action;
import org.brailleblaster.utd.actions.Trans3Action;
import org.brailleblaster.utd.actions.Trans4Action;
import org.brailleblaster.utd.actions.Trans5Action;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000eJ\"\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/brailleblaster/util/ColorManager;", "", "<init>", "()V", "bbColors", "", "Lorg/brailleblaster/util/ColorManager$BBColor;", "getColor", "Lorg/eclipse/swt/graphics/Color;", "hexCode", "", "control", "Lorg/eclipse/swt/widgets/Control;", "color", "Lorg/brailleblaster/util/ColorManager$Colors;", "r", "", "g", "b", "getColorFromAction", "action", "Lorg/brailleblaster/utd/actions/IAction;", "equals", "", "color1", "color2", "findColor", "Colors", "BBColor", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nColorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorManager.kt\norg/brailleblaster/util/ColorManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class ColorManager {
    @NotNull
    public static final ColorManager INSTANCE = new ColorManager();
    @NotNull
    private static final List<BBColor> bbColors = new ArrayList();

    private ColorManager() {
    }

    @NotNull
    public final Color getColor(@NotNull String hexCode, @NotNull Control control) {
        Intrinsics.checkNotNullParameter((Object)hexCode, (String)"hexCode");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        if (!(hexCode.length() == 6)) {
            boolean $i$a$-require-ColorManager$getColor$22 = false;
            String $i$a$-require-ColorManager$getColor$22 = "Not a valid hex code " + hexCode;
            throw new IllegalArgumentException($i$a$-require-ColorManager$getColor$22.toString());
        }
        int r = Integer.parseInt(StringsKt.take((String)hexCode, (int)2), CharsKt.checkRadix((int)16));
        String string = hexCode.substring(2, 4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int g = Integer.parseInt(string, CharsKt.checkRadix((int)16));
        String string2 = hexCode.substring(4, 6);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int b = Integer.parseInt(string2, CharsKt.checkRadix((int)16));
        return this.getColor(r, g, b, control);
    }

    @NotNull
    public final Color getColor(@NotNull Colors color, @NotNull Control control) {
        Intrinsics.checkNotNullParameter((Object)((Object)color), (String)"color");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        return this.getColor(color.getR(), color.getG(), color.getB(), control);
    }

    @NotNull
    public final Color getColor(int r, int g, int b, @NotNull Control control) {
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        BBColor newColor = this.findColor(r, g, b);
        if (newColor != null) {
            if (!newColor.getControls().contains(control)) {
                newColor.addControl(control);
            }
        } else {
            newColor = new BBColor(r, g, b);
            newColor.addControl(control);
            newColor.initColor();
            bbColors.add(newColor);
        }
        return newColor.getColor();
    }

    @Nullable
    public final Color getColorFromAction(@Nullable IAction action, @NotNull Control control) {
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        IAction iAction = action;
        return iAction instanceof Trans1Action ? this.getColor(Colors.YELLOW, control) : (iAction instanceof Trans2Action ? this.getColor(Colors.ORANGE, control) : (iAction instanceof Trans3Action ? this.getColor(Colors.GREEN, control) : (iAction instanceof Trans4Action ? this.getColor(Colors.BLUE, control) : (iAction instanceof Trans5Action ? this.getColor(Colors.LIGHT_PURPLE, control) : (iAction instanceof CompBRLAction ? this.getColor(Colors.BROWN, control) : (iAction instanceof NoContractionAction ? this.getColor(Colors.SEAGLASS, control) : (iAction instanceof ScriptAction ? this.getColor(Colors.KHAKI, control) : (iAction instanceof DirectAction ? this.getColor(Colors.LAVENDER, control) : null))))))));
    }

    public final boolean equals(@NotNull Color color1, @NotNull Colors color2) {
        Intrinsics.checkNotNullParameter((Object)color1, (String)"color1");
        Intrinsics.checkNotNullParameter((Object)((Object)color2), (String)"color2");
        return color1.getRed() == color2.getR() && color1.getGreen() == color2.getG() && color1.getBlue() == color2.getB();
    }

    private final BBColor findColor(int r, int g, int b) {
        for (BBColor color : bbColors) {
            if (color.getR() != r || color.getG() != g || color.getB() != b) continue;
            return color;
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000eJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0000H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/brailleblaster/util/ColorManager$BBColor;", "", "r", "", "g", "b", "<init>", "(III)V", "getR", "()I", "getG", "getB", "controls", "", "Lorg/eclipse/swt/widgets/Control;", "getControls", "()Ljava/util/List;", "color", "Lorg/eclipse/swt/graphics/Color;", "getColor", "()Lorg/eclipse/swt/graphics/Color;", "setColor", "(Lorg/eclipse/swt/graphics/Color;)V", "initColor", "", "addControl", "control", "onDispose", "Lorg/eclipse/swt/events/DisposeListener;", "self", "brailleblaster-core"})
    private static final class BBColor {
        private final int r;
        private final int g;
        private final int b;
        @NotNull
        private final List<Control> controls;
        public Color color;

        public BBColor(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.controls = new ArrayList();
        }

        public final int getR() {
            return this.r;
        }

        public final int getG() {
            return this.g;
        }

        public final int getB() {
            return this.b;
        }

        @NotNull
        public final List<Control> getControls() {
            return this.controls;
        }

        @NotNull
        public final Color getColor() {
            Color color = this.color;
            if (color != null) {
                return color;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"color");
            return null;
        }

        public final void setColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.color = color;
        }

        public final void initColor() {
            this.setColor(new Color((Device)Display.getCurrent(), this.r, this.g, this.b));
        }

        public final void addControl(@NotNull Control control) {
            Intrinsics.checkNotNullParameter((Object)control, (String)"control");
            this.controls.add(control);
            control.addDisposeListener(this.onDispose(control, this));
        }

        private final DisposeListener onDispose(Control control, BBColor self) {
            return arg_0 -> BBColor.onDispose$lambda$0(this, control, self, arg_0);
        }

        private static final void onDispose$lambda$0(BBColor this$0, Control $control, BBColor $self, DisposeEvent it) {
            this$0.controls.remove($control);
            if (this$0.controls.isEmpty()) {
                bbColors.remove($self);
                this$0.getColor().dispose();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0018\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lorg/brailleblaster/util/ColorManager$Colors;", "", "r", "", "g", "b", "<init>", "(Ljava/lang/String;IIII)V", "getR", "()I", "getG", "getB", "YELLOW", "ORANGE", "GREEN", "BLUE", "DARK_BLUE", "LIGHT_PURPLE", "BROWN", "PURPLE", "KHAKI", "RED", "WHITE", "BLACK", "LAVENDER", "SEAGLASS", "BLUSH", "brailleblaster-core"})
    public static final class Colors
    extends Enum<Colors> {
        private final int r;
        private final int g;
        private final int b;
        public static final /* enum */ Colors YELLOW = new Colors(255, 255, 0);
        public static final /* enum */ Colors ORANGE = new Colors(254, 204, 152);
        public static final /* enum */ Colors GREEN = new Colors(0, 254, 0);
        public static final /* enum */ Colors BLUE = new Colors(0, 254, 254);
        public static final /* enum */ Colors DARK_BLUE = new Colors(0, 0, 255);
        public static final /* enum */ Colors LIGHT_PURPLE = new Colors(254, 152, 204);
        public static final /* enum */ Colors BROWN = new Colors(192, 80, 76);
        public static final /* enum */ Colors PURPLE = new Colors(254, 0, 254);
        public static final /* enum */ Colors KHAKI = new Colors(189, 183, 107);
        public static final /* enum */ Colors RED = new Colors(255, 0, 0);
        public static final /* enum */ Colors WHITE = new Colors(255, 255, 255);
        public static final /* enum */ Colors BLACK = new Colors(0, 0, 0);
        public static final /* enum */ Colors LAVENDER = new Colors(225, 197, 228);
        public static final /* enum */ Colors SEAGLASS = new Colors(198, 240, 220);
        public static final /* enum */ Colors BLUSH = new Colors(241, 190, 191);
        private static final /* synthetic */ Colors[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Colors(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public final int getR() {
            return this.r;
        }

        public final int getG() {
            return this.g;
        }

        public final int getB() {
            return this.b;
        }

        public static Colors[] values() {
            return (Colors[])$VALUES.clone();
        }

        public static Colors valueOf(String value) {
            return Enum.valueOf(Colors.class, value);
        }

        @NotNull
        public static EnumEntries<Colors> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = colorsArray = new Colors[]{Colors.YELLOW, Colors.ORANGE, Colors.GREEN, Colors.BLUE, Colors.DARK_BLUE, Colors.LIGHT_PURPLE, Colors.BROWN, Colors.PURPLE, Colors.KHAKI, Colors.RED, Colors.WHITE, Colors.BLACK, Colors.LAVENDER, Colors.SEAGLASS, Colors.BLUSH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

