/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.BBIni;
import org.brailleblaster.util.Notify;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/util/FileUtils;", "", "<init>", "()V", "create", "", "fileName", "", "copyFile", "inputFileName", "outputFileName", "findInProgramData", "partialPath", "appendToFile", "path", "text", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\norg/brailleblaster/util/FileUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final Logger logger;

    private FileUtils() {
    }

    public final void create(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File f = new File(fileName);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                Notify.showException("Could not create file" + fileName, e);
            }
        }
    }

    public final void copyFile(@NotNull String inputFileName, @NotNull String outputFileName) {
        Intrinsics.checkNotNullParameter((Object)inputFileName, (String)"inputFileName");
        Intrinsics.checkNotNullParameter((Object)outputFileName, (String)"outputFileName");
        logger.debug("COPY input {} output {}", (Object)inputFileName, (Object)outputFileName);
        File inputFile = new File(inputFileName);
        File outputFile = new File(outputFileName);
        try {
            Path path = inputFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Path path2 = path;
            Path path3 = outputFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
            Path path4 = path3;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path4, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to copy file " + inputFile.getAbsolutePath() + " to " + outputFile.getAbsolutePath(), e);
        }
    }

    @Nullable
    public final String findInProgramData(@NotNull String partialPath) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)partialPath, (String)"partialPath");
        Path completePath = BBIni.getUserProgramDataPath().resolve(partialPath);
        Intrinsics.checkNotNull((Object)completePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(completePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return ((Object)completePath).toString();
        }
        Path it = path = BBIni.getProgramDataPath().resolve(partialPath);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        Path path2 = Files.exists(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? path : null;
        return path2 != null ? ((Object)path2).toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendToFile(@NotNull String path, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        File f = new File(path);
        if (f.exists()) {
            try {
                Closeable closeable = new FileWriter(f, true);
                Throwable throwable = null;
                try {
                    FileWriter out = (FileWriter)closeable;
                    boolean bl = false;
                    out.write(text);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                Notify.INSTANCE.showException(e);
            }
        }
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    static {
        Logger logger = LoggerFactory.getLogger(FileUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        FileUtils.logger = logger;
    }
}

