/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.brailleblaster.BBIni;
import org.brailleblaster.utils.PropertyFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\u000f\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\t\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/brailleblaster/util/InstallId;", "", "<init>", "()V", "macAddress", "", "getMacAddress", "()[B", "macAddress$delegate", "Lkotlin/Lazy;", "generateUUID", "Ljava/util/UUID;", "generateAndSaveUUID", "props", "Lorg/brailleblaster/utils/PropertyFileManager;", "id", "getId", "()Ljava/util/UUID;", "id$delegate", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nInstallId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallId.kt\norg/brailleblaster/util/InstallId\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class InstallId {
    @NotNull
    public static final InstallId INSTANCE = new InstallId();
    @NotNull
    private static final Lazy macAddress$delegate = LazyKt.lazy(InstallId::macAddress_delegate$lambda$0);
    @NotNull
    private static final Lazy id$delegate = LazyKt.lazy(InstallId::id_delegate$lambda$0);

    private InstallId() {
    }

    @Nullable
    public final byte[] getMacAddress() {
        Lazy lazy = macAddress$delegate;
        return (byte[])lazy.getValue();
    }

    private final UUID generateUUID() {
        UUID uUID;
        byte[] nodeId = this.getMacAddress();
        if (nodeId != null) {
            String string = System.getProperty("user.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] userName = byArray;
            UUID uUID2 = UUID.nameUUIDFromBytes(ArraysKt.plus((byte[])nodeId, (byte[])userName));
            Intrinsics.checkNotNull((Object)uUID2);
            uUID = uUID2;
        } else {
            UUID uUID3 = UUID.randomUUID();
            Intrinsics.checkNotNull((Object)uUID3);
            uUID = uUID3;
        }
        return uUID;
    }

    private final UUID generateAndSaveUUID(PropertyFileManager props) {
        UUID uuid = this.generateUUID();
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        props.save("installUUID", string);
        return uuid;
    }

    @NotNull
    public final UUID getId() {
        Lazy lazy = id$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (UUID)object;
    }

    private static final byte[] macAddress_delegate$lambda$0() {
        Object object;
        try {
            Object object2;
            block6: {
                block8: {
                    InetAddress localHost = InetAddress.getLocalHost();
                    NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localHost);
                    object2 = networkInterface;
                    if (object2 == null) break block8;
                    byte[] byArray = ((NetworkInterface)object2).getHardwareAddress();
                    object2 = byArray;
                    if (byArray != null) break block6;
                }
                Stream<NetworkInterface> stream = NetworkInterface.networkInterfaces();
                Intrinsics.checkNotNullExpressionValue(stream, (String)"networkInterfaces(...)");
                for (Object it : StreamsKt.asSequence(stream)) {
                    boolean bl = false;
                    if ((it = (Object)((NetworkInterface)it).getHardwareAddress()) == null) continue;
                    object2 = it;
                    break block6;
                }
                object2 = null;
            }
            object = object2;
        }
        catch (UnknownHostException e) {
            byte[] byArray;
            block7: {
                Stream<NetworkInterface> stream = NetworkInterface.networkInterfaces();
                Intrinsics.checkNotNullExpressionValue(stream, (String)"networkInterfaces(...)");
                for (NetworkInterface it : StreamsKt.asSequence(stream)) {
                    boolean bl = false;
                    byte[] byArray2 = it.getHardwareAddress();
                    if (byArray2 == null) continue;
                    byArray = byArray2;
                    break block7;
                }
                byArray = null;
            }
            object = byArray;
        }
        return object;
    }

    private static final UUID id_delegate$lambda$0() {
        UUID uUID;
        String recordedId = BBIni.getPropertyFileManager().getProperty("installUUID");
        if (recordedId != null) {
            UUID uUID2;
            try {
                uUID2 = UUID.fromString(recordedId);
            }
            catch (IllegalArgumentException e) {
                uUID2 = INSTANCE.generateAndSaveUUID(BBIni.getPropertyFileManager());
            }
            uUID = uUID2;
        } else {
            uUID = INSTANCE.generateAndSaveUUID(BBIni.getPropertyFileManager());
        }
        return uUID;
    }
}

