/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.util.Arrays;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.brailleblaster.BBIni;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.mvc.modules.misc.ExceptionReportingModule;
import org.brailleblaster.util.NotifyUtils;
import org.brailleblaster.util.Utils;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.utils.swt.StyledTextBuilder;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\n2\b\b\u0002\u0010\u0014\u001a\u00020\bH\u0007J,\u0010\u0015\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\bH\u0002J/\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001cJ/\u0010\u001d\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u001eJ\"\u0010\u001f\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\u0017J\u0010\u0010!\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001c\u0010!\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u001c\u0010\"\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001c\u0010#\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010$\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001c\u0010%\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/brailleblaster/util/Notify;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "DEBUG_EXCEPTION", "", "EXCEPTION_SHELL_NAME", "", "ALERT_SHELL_NAME", "USER_FRIENDLY_ERROR_MESSAGE", "WARNING", "BRAILLEBLASTER_ERROR", "GENERIC_UNEDITABLE", "notify", "", "message", "shellName", "isFatal", "displayMessage", "exception", "", "formatMessage", "rawmessage", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "showMessage", "(Ljava/lang/String;[Ljava/lang/Object;)V", "handleFatalException", "t", "showException", "showExceptionDialog", "showUserFriendlyExceptionDialog", "showExceptionStatusBar", "generateExceptionMessage", "DebugException", "brailleblaster-core"})
public final class Notify {
    @NotNull
    public static final Notify INSTANCE = new Notify();
    private static final Logger log = LoggerFactory.getLogger(Notify.class);
    @JvmField
    public static boolean DEBUG_EXCEPTION = true;
    @JvmField
    @NotNull
    public static final String EXCEPTION_SHELL_NAME = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("exception");
    @JvmField
    @NotNull
    public static final String ALERT_SHELL_NAME = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("alert");
    @NotNull
    private static final String USER_FRIENDLY_ERROR_MESSAGE = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("userFriendlyErrorMessage");
    @NotNull
    private static final String WARNING = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("warning");
    @NotNull
    private static final String BRAILLEBLASTER_ERROR = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("brailleblasterError");
    @JvmField
    @NotNull
    public static final String GENERIC_UNEDITABLE = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("genericUneditable");

    private Notify() {
    }

    @JvmOverloads
    public final void notify(@Nullable String message, @NotNull String shellName, boolean isFatal) {
        Intrinsics.checkNotNullParameter((Object)shellName, (String)"shellName");
        String preformattedMessage = this.formatMessage(message, new Object[0]);
        this.displayMessage(preformattedMessage, shellName, null, isFatal);
    }

    public static /* synthetic */ void notify$default(Notify notify, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        notify.notify(string, string2, bl);
    }

    private final void displayMessage(String message, String shellName, Throwable exception, boolean isFatal) {
        if (BBIni.getDebugging() && DEBUG_EXCEPTION) {
            throw new DebugException("Notify dialog message: " + message);
        }
        if (WPManager.Companion.getInstanceOrNull() != null && WPManager.display.getThread() != Thread.currentThread()) {
            WPManager.display.syncExec(() -> Notify.displayMessage$lambda$0(message, shellName, exception, isFatal));
            return;
        }
        int shellStyle = isFatal ? 65568 : 133216;
        Shell shell = new Shell(Display.getCurrent(), shellStyle);
        shell.setText(shellName);
        shell.setLayout((Layout)new GridLayout(1, false));
        if (isFatal) {
            shell.addTraverseListener(Notify::displayMessage$lambda$1);
        } else {
            EasySWT.INSTANCE.addEscapeCloseListener(shell);
        }
        StyledTextBuilder styledTextBuilder = EasySWT.INSTANCE.makeStyledText((Composite)shell, 2570);
        String string = message;
        if (string == null) {
            string = "";
        }
        StyledText text = (StyledText)((StyledTextBuilder)((StyledTextBuilder)styledTextBuilder.text(string).gridDataHeightFromGC((Composite)shell, 20)).gridDataHorizontalFill()).get();
        text.setAlwaysShowScrollBars(false);
        Consumer<SelectionEvent> sendCallback = arg_0 -> Notify.displayMessage$lambda$2(shell, arg_0);
        Consumer<SelectionEvent> dontSendCallback = arg_0 -> Notify.displayMessage$lambda$3(shell, isFatal, arg_0);
        String okButtonText = "Send Report";
        String notOkButtonText = "Don't Send Report";
        if (exception != null) {
            EasySWT.makeLabel((Composite)((Composite)shell), (String)NotifyUtils.INSTANCE.getREPORT_COMMENT_TEXT(), (int)1);
            StyledText errorDesc = (StyledText)((StyledTextBuilder)((StyledTextBuilder)EasySWT.INSTANCE.makeStyledText((Composite)shell, 2560).gridDataHorizontalFill()).gridDataHeightFromGC((Composite)shell, 3)).get();
            errorDesc.addTraverseListener(Notify::displayMessage$lambda$4);
            errorDesc.setToolTipText(NotifyUtils.INSTANCE.getREPORT_TEXT());
            sendCallback = arg_0 -> Notify.displayMessage$lambda$5(errorDesc, exception, shell, isFatal, arg_0);
        } else {
            okButtonText = "OK";
            notOkButtonText = "Cancel";
        }
        Button send = EasySWT.makePushButton((Composite)((Composite)shell), (String)okButtonText, (int)2, Notify::displayMessage$lambda$6);
        Button dontSend = EasySWT.makePushButton((Composite)((Composite)shell), (String)notOkButtonText, (int)2, Notify::displayMessage$lambda$7);
        EasySWT.addSelectionListener((Button)send, sendCallback);
        EasySWT.addSelectionListener((Button)dontSend, dontSendCallback);
        EasySWT.INSTANCE.setLargeDialogSize(shell);
        shell.setDefaultButton(send);
        shell.open();
    }

    private final String formatMessage(String rawmessage, Object ... args) {
        String message = Utils.formatMessage(rawmessage, Arrays.copyOf(args, args.length));
        log.error(message);
        String realMessage = message.charAt(0) == '&' ? LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get(message) : message;
        return realMessage;
    }

    @JvmStatic
    public static final void showMessage(@Nullable String rawmessage, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String realMessage = INSTANCE.formatMessage(rawmessage, Arrays.copyOf(args, args.length));
        INSTANCE.displayMessage(realMessage, WARNING, null, false);
    }

    public final void handleFatalException(@Nullable String message, @NotNull String shellName, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)shellName, (String)"shellName");
        this.displayMessage(message, shellName, t, true);
    }

    public final void showException(@Nullable Throwable exception) {
        Notify.showException(null, exception);
    }

    @JvmStatic
    public static final void showException(@Nullable String message, @Nullable Throwable exception) {
        log.error("Encountered Exception: {}", (Object)message, (Object)exception);
        if (BBIni.getDebugging()) {
            throw new DebugException("Notify dialog exception", exception);
        }
        Throwable bbNotifyException = ExceptionUtils.getThrowableList((Throwable)exception).stream().reduce(null, Notify::showException$lambda$0);
        if (bbNotifyException != null) {
            Object[] objectArray = new Object[]{EXCEPTION_SHELL_NAME};
            Notify.showMessage(bbNotifyException.getMessage(), objectArray);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[ExceptionReportingModule.INSTANCE.getExceptionReportingLevel().ordinal()]) {
            case 1: {
                INSTANCE.showExceptionDialog(message, exception);
                break;
            }
            case 2: {
                INSTANCE.showUserFriendlyExceptionDialog(message, exception);
                break;
            }
            case 3: {
                INSTANCE.showExceptionStatusBar(exception);
            }
        }
    }

    private final void showExceptionDialog(String message, Throwable exception) {
        this.displayMessage(this.generateExceptionMessage(message, exception), BRAILLEBLASTER_ERROR, exception, false);
    }

    private final void showUserFriendlyExceptionDialog(String message, Throwable exception) {
        this.displayMessage(message, BRAILLEBLASTER_ERROR, exception, false);
    }

    private final void showExceptionStatusBar(Throwable exception) {
        Manager manager = WPManager.Companion.getInstance().getCurrentManager();
        if (manager != null) {
            manager.setTemporaryStatusBarMessage(USER_FRIENDLY_ERROR_MESSAGE, true);
        }
    }

    private final String generateExceptionMessage(String message, Throwable exception) {
        return NotifyUtils.INSTANCE.generateExceptionMessage(message, exception);
    }

    @JvmOverloads
    public final void notify(@Nullable String message, @NotNull String shellName) {
        Intrinsics.checkNotNullParameter((Object)shellName, (String)"shellName");
        Notify.notify$default(this, message, shellName, false, 4, null);
    }

    private static final void displayMessage$lambda$5$0$0(Display $display, ExceptionReportingModule.ErrorReportResponse $response) {
        Shell activeShell = $display.getActiveShell();
        boolean fakeActiveShell = false;
        if (activeShell == null) {
            fakeActiveShell = true;
            activeShell = new Shell();
        }
        MessageBox messageBox = new MessageBox(activeShell, 33);
        messageBox.setText($response.getTitle());
        messageBox.setMessage($response.getText());
        messageBox.open();
        if (fakeActiveShell) {
            activeShell.dispose();
        }
    }

    private static final void displayMessage$lambda$5$0(Display $display, ExceptionReportingModule.ErrorReportResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!response.getSuccess()) {
            log.info("Exception report failure!");
            $display.asyncExec(() -> Notify.displayMessage$lambda$5$0$0($display, response));
        } else {
            log.info("Exception report received successfully");
        }
    }

    private static final void displayMessage$lambda$0(String $message, String $shellName, Throwable $exception, boolean $isFatal) {
        INSTANCE.displayMessage($message, $shellName, $exception, $isFatal);
    }

    private static final void displayMessage$lambda$1(TraverseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.detail == 2) {
            e.doit = false;
        }
    }

    private static final void displayMessage$lambda$2(Shell $shell, SelectionEvent it) {
        $shell.close();
    }

    private static final void displayMessage$lambda$3(Shell $shell, boolean $isFatal, SelectionEvent it) {
        $shell.close();
        log.info("No Error Report Sent");
        if ($isFatal) {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private static final void displayMessage$lambda$4(TraverseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.detail == 16) {
            e.doit = true;
        }
    }

    private static final void displayMessage$lambda$5(StyledText $errorDesc, Throwable $exception, Shell $shell, boolean $isFatal, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Display display = Display.getCurrent();
        String string = $errorDesc.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() > 0) {
            ExceptionReportingModule.INSTANCE.reportException($exception, $errorDesc.getText(), arg_0 -> Notify.displayMessage$lambda$5$0(display, arg_0));
            $shell.close();
            if ($isFatal) {
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        } else {
            log.info("Empty Report! Nothing sent.");
            $shell.close();
            if ($isFatal) {
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
    }

    private static final void displayMessage$lambda$6(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void displayMessage$lambda$7(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final Throwable showException$lambda$0(Throwable result, Throwable current) {
        if (result != null) {
            return result;
        }
        if (current instanceof BBNotifyException) {
            return current;
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\t\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/util/Notify$DebugException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "<init>", "(Ljava/lang/String;)V", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "brailleblaster-core"})
    public static final class DebugException
    extends RuntimeException {
        public DebugException(@Nullable String message) {
            super(message);
        }

        public DebugException(@Nullable String message, @Nullable Throwable cause) {
            super(message, cause);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExceptionReportingModule.ExceptionReportingLevel.values().length];
            try {
                nArray[ExceptionReportingModule.ExceptionReportingLevel.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionReportingModule.ExceptionReportingLevel.USER_FRIENDLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionReportingModule.ExceptionReportingLevel.STATUS_BAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

