/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/util/XMLDiffTool;", "", "<init>", "()V", "assertEqualRecursive", "", "actualRoot", "Lnu/xom/Element;", "expectedRoot", "assertEqualRecursiveElement", "actualElement", "expectedElement", "assertEqualException", "Lorg/brailleblaster/utd/exceptions/NodeException;", "actualNode", "Lnu/xom/Node;", "expectedNode", "cause", "", "assertEquals", "actual", "expected", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nXMLDiffTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMLDiffTool.kt\norg/brailleblaster/util/XMLDiffTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1205#2,2:136\n1282#2,4:138\n1915#2,2:142\n*S KotlinDebug\n*F\n+ 1 XMLDiffTool.kt\norg/brailleblaster/util/XMLDiffTool\n*L\n103#1:136,2\n103#1:138,4\n105#1:142,2\n*E\n"})
public final class XMLDiffTool {
    @NotNull
    public static final XMLDiffTool INSTANCE = new XMLDiffTool();

    private XMLDiffTool() {
    }

    private final void assertEqualRecursive(Element actualRoot, Element expectedRoot) {
        try {
            this.assertEqualRecursiveElement(actualRoot, expectedRoot);
            if (actualRoot.getChildCount() != expectedRoot.getChildCount()) {
                throw new AssertionError((Object)("Expected " + actualRoot.getChildCount() + " children " + CollectionsKt.joinToString$default((Iterable)NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)actualRoot)), (CharSequence)", ", null, null, (int)0, null, XMLDiffTool::assertEqualRecursive$lambda$0, (int)30, null) + " but found " + expectedRoot.getChildCount() + " children " + CollectionsKt.joinToString$default((Iterable)NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)expectedRoot)), (CharSequence)", ", null, null, (int)0, null, XMLDiffTool::assertEqualRecursive$lambda$1, (int)30, null)));
            }
            this.assertEquals(actualRoot.getChildCount(), expectedRoot.getChildCount());
        }
        catch (Throwable e) {
            throw this.assertEqualException((Node)actualRoot, (Node)expectedRoot, e);
        }
        int n = actualRoot.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node actualChild = actualRoot.getChild(i);
            Node expectedChild = expectedRoot.getChild(i);
            try {
                this.assertEquals(actualChild.getClass(), expectedChild.getClass());
                Node node = actualChild;
                if (node instanceof Element) {
                    Element element = (Element)actualChild;
                    Intrinsics.checkNotNull((Object)expectedChild, (String)"null cannot be cast to non-null type nu.xom.Element");
                    this.assertEqualRecursiveElement(element, (Element)expectedChild);
                    this.assertEqualRecursive((Element)actualChild, (Element)expectedChild);
                    continue;
                }
                if (node instanceof Text) {
                    String string = ((Text)actualChild).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    String string2 = expectedChild.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                    this.assertEquals(string, string2);
                    continue;
                }
                if (node instanceof Comment) {
                    String string = ((Comment)actualChild).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    String string3 = expectedChild.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                    this.assertEquals(string, string3);
                    continue;
                }
                throw new NodeException("Unexpected node type", actualChild, null, 4, null);
            }
            catch (NodeException e) {
                throw e;
            }
            catch (Throwable e) {
                Intrinsics.checkNotNull((Object)actualChild);
                Intrinsics.checkNotNull((Object)expectedChild);
                throw this.assertEqualException(actualChild, expectedChild, e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertEqualRecursiveElement(Element actualElement, Element expectedElement) {
        String string = actualElement.getLocalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalName(...)");
        String string2 = expectedElement.getLocalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalName(...)");
        this.assertEquals(string, string2);
        String string3 = actualElement.getNamespaceURI();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNamespaceURI(...)");
        String string4 = expectedElement.getNamespaceURI();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNamespaceURI(...)");
        this.assertEquals(string3, string4);
        String string5 = actualElement.getNamespacePrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getNamespacePrefix(...)");
        String string6 = expectedElement.getNamespacePrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getNamespacePrefix(...)");
        this.assertEquals(string5, string6);
        for (Attribute actualAttribute : NodeUtilsKt.getAttributes((Element)actualElement)) {
            Attribute expectedAttribute = expectedElement.getAttribute(actualAttribute.getLocalName(), actualAttribute.getNamespaceURI());
            if (expectedAttribute == null) {
                if (!Intrinsics.areEqual((Object)actualAttribute.getLocalName(), (Object)"fuckedBy")) {
                    throw new AssertionError((Object)("Expected missing attribute from actual: " + actualAttribute.getLocalName()));
                }
                continue;
            }
            String string7 = actualAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getValue(...)");
            String string8 = expectedAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getValue(...)");
            this.assertEquals(string7, string8);
        }
        if (actualElement.getAttributeCount() != expectedElement.getAttributeCount()) {
            void $this$forEach$iv;
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = NodeUtilsKt.getAttributes((Element)expectedElement);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Attribute it = (Attribute)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getLocalName(), (Object)it.getValue());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map expectedAttribMap = MapsKt.toMutableMap((Map)destination$iv$iv);
            $this$associate$iv = NodeUtilsKt.getAttributes((Element)actualElement);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Attribute attr = (Attribute)element$iv;
                boolean bl = false;
                expectedAttribMap.remove(attr.getLocalName());
            }
            throw new NodeException("Expected has extra attributes " + String.join((CharSequence)", ", expectedAttribMap.keySet()), (Node)actualElement, null, 4, null);
        }
    }

    private final NodeException assertEqualException(Node actualNode, Node expectedNode, Throwable cause) {
        Document actualDoc = actualNode.getDocument();
        Element expectedRootCopy = expectedNode.getDocument().getRootElement().copy();
        expectedRootCopy.addAttribute(new Attribute("expectedRoot", "true"));
        actualDoc.getRootElement().appendChild((Node)expectedRootCopy);
        throw new NodeException("Expected " + XMLHandler.Companion.toXMLSimple(expectedNode) + " does not match actual " + XMLHandler.Companion.toXMLSimple(actualNode) + " | ", actualNode, cause);
    }

    private final void assertEquals(Object actual, Object expected) {
        if (!Intrinsics.areEqual((Object)actual, (Object)expected)) {
            throw new AssertionError((Object)("Exected '" + expected + "' but found '" + actual + "'"));
        }
    }

    private static final CharSequence assertEqualRecursive$lambda$0(Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return XMLHandler.Companion.toXMLSimple(node);
    }

    private static final CharSequence assertEqualRecursive$lambda$1(Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return XMLHandler.Companion.toXMLSimple(node);
    }
}

