/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.wordprocessor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.BBIni;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\tR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/wordprocessor/LogViewerDialog;", "Lorg/eclipse/swt/widgets/Dialog;", "parent", "Lorg/eclipse/swt/widgets/Shell;", "style", "", "<init>", "(Lorg/eclipse/swt/widgets/Shell;I)V", "result", "", "getResult", "()Z", "setResult", "(Z)V", "open", "Companion", "brailleblaster-core"})
public final class LogViewerDialog
extends Dialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean result;
    private static final Logger log = LoggerFactory.getLogger(LogViewerDialog.class);
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);

    @JvmOverloads
    public LogViewerDialog(@Nullable Shell parent, int style) {
        super(parent, style);
    }

    public /* synthetic */ LogViewerDialog(Shell shell, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(shell, n);
    }

    public final boolean getResult() {
        return this.result;
    }

    public final void setResult(boolean bl) {
        this.result = bl;
    }

    public final boolean open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        Shell dialogShell = new Shell(parent, 68720);
        dialogShell.setText(this.getText());
        FormLayout dialogLayout = new FormLayout();
        dialogShell.setLayout((Layout)dialogLayout);
        Text logText = new Text((Composite)dialogShell, 2626);
        Button saveButton = new Button((Composite)dialogShell, 8);
        Button closeButton = new Button((Composite)dialogShell, 8);
        FormData closeData = new FormData();
        closeData.height = 20;
        closeData.bottom = new FormAttachment(100, -10);
        closeData.right = new FormAttachment(100, -15);
        closeButton.setLayoutData((Object)closeData);
        closeButton.setText(localeHandler.get("buttonClose"));
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, dialogShell){
            final /* synthetic */ LogViewerDialog this$0;
            final /* synthetic */ Shell $dialogShell;
            {
                this.this$0 = $receiver;
                this.$dialogShell = $dialogShell;
            }

            public void widgetSelected(SelectionEvent arg0) {
                Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
                this.this$0.setResult(true);
                this.$dialogShell.dispose();
            }
        });
        FormData saveData = new FormData();
        saveData.height = 20;
        saveData.right = new FormAttachment((Control)closeButton, -10);
        saveData.bottom = new FormAttachment((Control)closeButton, 0, 1024);
        saveButton.setLayoutData((Object)saveData);
        saveButton.setText(localeHandler.get("LogViewer.SaveLog"));
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(dialogShell, logText){
            final /* synthetic */ Shell $dialogShell;
            final /* synthetic */ Text $logText;
            {
                this.$dialogShell = $dialogShell;
                this.$logText = $logText;
            }

            public void widgetSelected(SelectionEvent arg0) {
                Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
                FileDialog saveDialog = new FileDialog(this.$dialogShell, 8192);
                String[] stringArray = new String[]{"Log file (*.log)"};
                saveDialog.setFilterNames(stringArray);
                stringArray = new String[]{"*.log"};
                saveDialog.setFilterExtensions(stringArray);
                saveDialog.setFilterPath(System.getProperty("user.home"));
                saveDialog.setOverwrite(true);
                String saveResult = saveDialog.open();
                if (saveResult != null) {
                    try {
                        File file = new File(saveResult);
                        String string = this.$logText.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        org.brailleblaster.wordprocessor.LogViewerDialog$Companion.access$writeStringToFile(LogViewerDialog.Companion, file, string);
                        MessageBox savedMsg = new MessageBox(this.$dialogShell, 34);
                        savedMsg.setText(LogViewerDialog.access$getLocaleHandler$cp().get("LogViewer.SavedMsgBox.Title"));
                        savedMsg.setMessage(LogViewerDialog.access$getLocaleHandler$cp().get("LogViewer.SavedMsgBox.Message"));
                        savedMsg.open();
                    }
                    catch (IOException iOException) {
                        MessageBox saveErrorMsg = new MessageBox(this.$dialogShell, 33);
                        saveErrorMsg.setText(LogViewerDialog.access$getLocaleHandler$cp().get("LogViewer.SaveErrorMsgBox.Title"));
                        saveErrorMsg.setMessage(LogViewerDialog.access$getLocaleHandler$cp().get("LogViewer.SaveErrorMsgBox.Message"));
                        saveErrorMsg.open();
                    }
                }
            }
        });
        saveButton.pack();
        closeData.width = saveButton.getSize().x;
        FormData logTextData = new FormData();
        logTextData.top = new FormAttachment(0, 5);
        logTextData.left = new FormAttachment(0, 5);
        logTextData.right = new FormAttachment(100, -5);
        logTextData.width = 400;
        logTextData.bottom = new FormAttachment((Control)closeButton, -15);
        logTextData.height = 400;
        logText.setLayoutData((Object)logTextData);
        logText.setEditable(false);
        try {
            File file = BBIni.INSTANCE.getLogFilesPath().resolve("bb.log").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            logText.setText(LogViewerDialog.Companion.readFileToString(file));
        }
        catch (IOException e) {
            log.error("Problem opening the log file", (Throwable)e);
            MessageBox msgBox = new MessageBox(parent, 33);
            msgBox.setText("Unable to open log file");
            msgBox.setMessage("There was a problem in reading the log file, so the log viewer will not be opened.");
            this.result = false;
            return false;
        }
        logText.addKeyListener((KeyListener)new KeyAdapter(logText){
            final /* synthetic */ Text $logText;
            {
                this.$logText = $logText;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.doit = true;
                if (e.stateMask == SWT.MOD1 && e.keyCode == 97) {
                    this.$logText.selectAll();
                    e.doit = false;
                }
            }
        });
        dialogShell.pack();
        dialogShell.open();
        while (!dialogShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    @JvmOverloads
    public LogViewerDialog(@Nullable Shell parent) {
        this(parent, 0, 2, null);
    }

    public static final /* synthetic */ LocaleHandler access$getLocaleHandler$cp() {
        return localeHandler;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/wordprocessor/LogViewerDialog$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "readFileToString", "", "inFile", "Ljava/io/File;", "writeStringToFile", "", "outFile", "content", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nLogViewerDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogViewerDialog.kt\norg/brailleblaster/wordprocessor/LogViewerDialog$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String readFileToString(File inFile) throws IOException {
            StringBuilder buf = new StringBuilder();
            String line = null;
            Closeable closeable = new BufferedReader(new FileReader(inFile));
            Throwable throwable = null;
            try {
                BufferedReader br = (BufferedReader)closeable;
                boolean bl = false;
                while (true) {
                    String string;
                    String it = string = br.readLine();
                    boolean bl2 = false;
                    line = it;
                    if (string == null) break;
                    buf.append(line);
                    buf.append('\n');
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeStringToFile(File outFile, String content) throws IOException {
            Closeable closeable = new BufferedWriter(new FileWriter(outFile));
            Throwable throwable = null;
            try {
                BufferedWriter bw = (BufferedWriter)closeable;
                boolean bl = false;
                bw.write(content);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public static final /* synthetic */ void access$writeStringToFile(Companion $this, File outFile, String content) {
            $this.writeStringToFile(outFile, content);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

