/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.wordprocessor;

import java.awt.SplashScreen;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import nu.xom.XPathException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.brailleblaster.AppProperties;
import org.brailleblaster.BBBootstrap;
import org.brailleblaster.BBIni;
import org.brailleblaster.Main;
import org.brailleblaster.archiver2.ArchiverRecoverThread;
import org.brailleblaster.archiver2.BRFArchiverLoader;
import org.brailleblaster.exceptions.BBException;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.exceptions.CursorMovementException;
import org.brailleblaster.exceptions.EditingException;
import org.brailleblaster.exceptions.FormatterException;
import org.brailleblaster.exceptions.OutdatedMapListException;
import org.brailleblaster.exceptions.TranslationException;
import org.brailleblaster.perspectives.braille.BraillePerspective;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.toolbar.BrailleToolBar;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.ViewManager;
import org.brailleblaster.perspectives.mvc.events.AppStartedEvent;
import org.brailleblaster.perspectives.mvc.events.BuildToolBarEvent;
import org.brailleblaster.perspectives.mvc.modules.misc.ExceptionReportingModule;
import org.brailleblaster.printers.PrintPreview;
import org.brailleblaster.usage.SimpleUsageManager;
import org.brailleblaster.usage.UsageManager;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.Utils;
import org.brailleblaster.util.WorkingDialog;
import org.brailleblaster.util.ui.AutoSaveDialog;
import org.brailleblaster.utils.OS;
import org.brailleblaster.utils.Platform;
import org.brailleblaster.wordprocessor.BBStatusBar;
import org.brailleblaster.wordprocessor.BBToolBar;
import org.brailleblaster.wordprocessor.RecentDocs;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 X2\u00020\u0001:\u0001XB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010!\u001a\u0004\u0018\u00010\u001cJ\u0010\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106J\u0016\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002060:H\u0002J\u0006\u0010;\u001a\u000204J\u0006\u0010<\u001a\u000204J\u0006\u0010=\u001a\u00020*J\u0018\u0010>\u001a\u0002042\u0006\u0010?\u001a\u00020@2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001c\u0010A\u001a\u00020\u001c2\b\u00105\u001a\u0004\u0018\u0001062\b\u0010B\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010C\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106J\u001c\u0010D\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\b\u0010B\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u0010E\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0006\u0010F\u001a\u000204J\u0012\u0010G\u001a\u0002042\b\u0010H\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010I\u001a\u0002042\u0006\u0010H\u001a\u00020\u001cH\u0002J\u0006\u0010J\u001a\u000204J\u0006\u0010K\u001a\u000204J\u0006\u0010L\u001a\u000204J\u000e\u0010M\u001a\u0002042\u0006\u0010N\u001a\u00020\u001cJ\u0006\u0010.\u001a\u00020*J\u0010\u0010Q\u001a\u0002042\u0006\u0010R\u001a\u00020SH\u0002J\b\u0010T\u001a\u000204H\u0002J\u001a\u0010U\u001a\u0002042\u0006\u0010R\u001a\u00020V2\b\u0010W\u001a\u0004\u0018\u00010VH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0013@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0017@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R*\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\"2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u001c0\"@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010+\u001a\u00020*2\u0006\u0010\b\u001a\u00020*8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001e\u0010-\u001a\u00020*2\u0006\u0010\b\u001a\u00020*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010,R\u0016\u0010.\u001a\n\u0018\u00010/j\u0004\u0018\u0001`0X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010O\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u001e\u00a8\u0006Y"}, d2={"Lorg/brailleblaster/wordprocessor/WPManager;", "", "usageManager", "Lorg/brailleblaster/usage/UsageManager;", "<init>", "(Lorg/brailleblaster/usage/UsageManager;)V", "getUsageManager", "()Lorg/brailleblaster/usage/UsageManager;", "value", "Lorg/eclipse/swt/widgets/Shell;", "shell", "getShell", "()Lorg/eclipse/swt/widgets/Shell;", "Lorg/eclipse/swt/custom/CTabFolder;", "folder", "getFolder", "()Lorg/eclipse/swt/custom/CTabFolder;", "bbToolbar", "Lorg/brailleblaster/wordprocessor/BBToolBar;", "Lorg/brailleblaster/wordprocessor/BBStatusBar;", "statusBar", "getStatusBar", "()Lorg/brailleblaster/wordprocessor/BBStatusBar;", "Lorg/brailleblaster/perspectives/braille/BraillePerspective;", "currentPerspective", "getCurrentPerspective", "()Lorg/brailleblaster/perspectives/braille/BraillePerspective;", "controller", "Lorg/brailleblaster/perspectives/braille/Manager;", "getController", "()Lorg/brailleblaster/perspectives/braille/Manager;", "setController", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "getControllerOrNull", "Ljava/util/LinkedList;", "list", "getList", "()Ljava/util/LinkedList;", "folderListener", "Lorg/eclipse/swt/events/SelectionAdapter;", "resizeListener", "Lorg/eclipse/swt/events/ControlListener;", "", "isMenuInitialized", "()Z", "isManagerChanged", "isClosed", "Ljava/lang/Exception;", "Lkotlin/Exception;", "userClosed", "openingDoc", "initialize", "", "fileName", "Ljava/nio/file/Path;", "showAutoSaveDialog", "", "recentSaves", "", "start", "closeCurrentManager", "close", "setShellScreenLocation", "display", "Lorg/eclipse/swt/widgets/Display;", "newManager", "oldManager", "addDocumentManager", "setupDocumentManager", "openBRFFile", "setSelection", "initMenuAndToolbar", "manager", "changeManager", "buildToolBar", "onToolBarExpand", "onToolBarCondense", "removeController", "m", "currentManager", "getCurrentManager", "handleBBException", "e", "Lorg/brailleblaster/exceptions/BBException;", "handleEditingException", "handleFormattingException", "Lorg/brailleblaster/exceptions/FormatterException;", "originalException", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nWPManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WPManager.kt\norg/brailleblaster/wordprocessor/WPManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,666:1\n1#2:667\n*E\n"})
public final class WPManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsageManager usageManager;
    private Shell shell;
    private CTabFolder folder;
    private BBToolBar bbToolbar;
    private BBStatusBar statusBar;
    private BraillePerspective currentPerspective;
    public Manager controller;
    private LinkedList<Manager> list;
    private SelectionAdapter folderListener;
    @Nullable
    private ControlListener resizeListener;
    private boolean isMenuInitialized;
    private boolean isManagerChanged;
    @Nullable
    private Exception isClosed;
    private boolean userClosed;
    private boolean openingDoc;
    @NotNull
    private static final Logger logger;
    @Nullable
    private static WPManager INSTANCE;
    @JvmField
    @NotNull
    public static final Display display;
    private static final int PADDING_AFTER_TOOLBAR = 20;

    private WPManager(UsageManager usageManager) {
        this.usageManager = usageManager;
    }

    @NotNull
    public final UsageManager getUsageManager() {
        return this.usageManager;
    }

    @NotNull
    public final Shell getShell() {
        Shell shell = this.shell;
        if (shell != null) {
            return shell;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
        return null;
    }

    @NotNull
    public final CTabFolder getFolder() {
        CTabFolder cTabFolder = this.folder;
        if (cTabFolder != null) {
            return cTabFolder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
        return null;
    }

    @NotNull
    public final BBStatusBar getStatusBar() {
        BBStatusBar bBStatusBar = this.statusBar;
        if (bBStatusBar != null) {
            return bBStatusBar;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"statusBar");
        return null;
    }

    @NotNull
    public final BraillePerspective getCurrentPerspective() {
        BraillePerspective braillePerspective = this.currentPerspective;
        if (braillePerspective != null) {
            return braillePerspective;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentPerspective");
        return null;
    }

    @NotNull
    public final Manager getController() {
        Manager manager = this.controller;
        if (manager != null) {
            return manager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"controller");
        return null;
    }

    public final void setController(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"<set-?>");
        this.controller = manager;
    }

    @Nullable
    public final Manager getControllerOrNull() {
        return this.controller != null ? this.getController() : null;
    }

    @NotNull
    public final LinkedList<Manager> getList() {
        LinkedList<Manager> linkedList = this.list;
        if (linkedList != null) {
            return linkedList;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"list");
        return null;
    }

    public final boolean isMenuInitialized() {
        boolean bl;
        if (!this.isMenuInitialized) {
            this.isMenuInitialized = true;
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean isManagerChanged() {
        return this.isManagerChanged;
    }

    /*
     * WARNING - void declaration
     */
    public final void initialize(@Nullable Path fileName) {
        void it;
        SplashScreen splash;
        Object mi2;
        long startTime = System.currentTimeMillis();
        Main.deleteExceptionFiles();
        this.list = new LinkedList();
        this.shell = new Shell(display, 1264);
        this.getShell().setText(AppProperties.INSTANCE.getDisplayName());
        this.getShell().setImages(Companion.newShellIcons());
        FormLayout layout = new FormLayout();
        this.getShell().setLayout((Layout)layout);
        this.folder = new CTabFolder((Composite)this.getShell(), 0);
        this.statusBar = new BBStatusBar(this.getShell());
        FormData location = new FormData();
        location.left = new FormAttachment(0);
        location.right = new FormAttachment(100);
        location.top = new FormAttachment(0, 0);
        location.bottom = new FormAttachment(100, -15);
        this.getFolder().setLayoutData((Object)location);
        this.getFolder().addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(this){
            final /* synthetic */ WPManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void close(CTabFolderEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                event.doit = false;
                CTabFolder cTabFolder = this.this$0.getFolder();
                SelectionAdapter selectionAdapter = WPManager.access$getFolderListener$p(this.this$0);
                if (selectionAdapter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"folderListener");
                    selectionAdapter = null;
                }
                cTabFolder.removeSelectionListener((SelectionListener)selectionAdapter);
                int curSelection = this.this$0.getFolder().getSelectionIndex();
                CTabFolder cTabFolder2 = this.this$0.getFolder();
                Widget widget = event.item;
                Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type org.eclipse.swt.custom.CTabItem");
                int closeIndex = cTabFolder2.indexOf((CTabItem)widget);
                if (closeIndex != curSelection) {
                    this.this$0.getFolder().setSelection(closeIndex);
                }
                this.this$0.closeCurrentManager();
            }
        });
        this.getShell().addListener(21, WPManager::initialize$lambda$0);
        this.setShellScreenLocation(display, this.getShell());
        this.getShell().setMaximized(true);
        this.getShell().setActive();
        this.userClosed = false;
        this.getShell().addListener(21, arg_0 -> WPManager.initialize$lambda$1(this, arg_0));
        if (Platform.getOs() == OS.Mac) {
            MenuItem[] menuItemArray = display.getSystemMenu().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)menuItemArray, (String)"getItems(...)");
            for (Object mi2 : menuItemArray) {
                if (mi2.getID() != -6) continue;
                mi2.addListener(13, arg_0 -> WPManager.initialize$lambda$2(this, arg_0));
            }
        }
        this.getShell().addListener(12, arg_0 -> WPManager.initialize$lambda$3(this, arg_0));
        Path path = fileName;
        if (path == null) {
            path = BBIni.getDebugging() && BBIni.getDebugFilePath() != null ? BBIni.getDebugFilePath() : null;
        }
        Path fileToOpen = path;
        this.currentPerspective = new BraillePerspective(this);
        this.addDocumentManager(fileToOpen);
        Manager firstManager = this.getController();
        this.getShell().open();
        SplashScreen splashScreen = splash = SplashScreen.getSplashScreen();
        if (splashScreen != null) {
            splashScreen.close();
        }
        if (firstManager.getText() != null && firstManager.getText().getView().isVisible()) {
            firstManager.getText().getView().setFocus();
        }
        mi2 = new SelectionAdapter(this){
            final /* synthetic */ WPManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int index = this.this$0.getFolder().getSelectionIndex();
                if (!this.this$0.getList().isEmpty()) {
                    Manager manager = this.this$0.getList().get(index);
                    Intrinsics.checkNotNullExpressionValue((Object)manager, (String)"get(...)");
                    WPManager.access$changeManager(this.this$0, manager);
                }
            }
        };
        MenuItem menuItem = mi2;
        CTabFolder cTabFolder = this.getFolder();
        boolean bl2 = false;
        this.folderListener = (SelectionAdapter)it;
        cTabFolder.addSelectionListener((SelectionListener)mi2);
        ViewManager.Companion.colorizeCompositeRecursive((Composite)this.getShell());
        logger.info("Started in {}", (Object)Utils.runtimeToString(startTime));
        List<Path> recentSaves = ArchiverRecoverThread.Companion.getRecentSaves();
        if (!BBIni.getDebugging() && !((Collection)recentSaves).isEmpty()) {
            Path path2 = Paths.get(BBIni.INSTANCE.getAutoSaveCrashPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                this.showAutoSaveDialog(recentSaves);
                try {
                    Files.deleteIfExists(Paths.get(BBIni.INSTANCE.getAutoSaveCrashPath(), new String[0]));
                }
                catch (IOException bl2) {
                    // empty catch block
                }
            }
        }
        for (Exception e : BBBootstrap.RECOVERABLE_BOOT_EXCEPTIONS) {
            Notify.showException("Error when starting", e);
        }
    }

    private final int showAutoSaveDialog(List<? extends Path> recentSaves) {
        AutoSaveDialog dialog = new AutoSaveDialog(this.getShell());
        return dialog.openAutoSaveDialog("Auto Save", (Iterable<? extends Path>)recentSaves);
    }

    public final void start() {
        Object object = this.getCurrentManager();
        if (object != null && (object = ((Manager)object).getSimpleManager()) != null) {
            ((BBSimpleManager)object).dispatchEvent(new AppStartedEvent(Sender.SIMPLEMANAGER));
        }
        while (!this.getShell().isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                try {
                    if (e instanceof BBException && ExceptionReportingModule.getExceptionRecoveryLevel() == ExceptionReportingModule.ExceptionRecoveryLevel.RECOVER) {
                        this.handleBBException((BBException)e);
                    }
                    Notify.showException("", e);
                }
                catch (Throwable e2) {
                    ExceptionsKt.addSuppressed((Throwable)e, (Throwable)e2);
                    if (!BBIni.getDebugging()) {
                        Main.handleFatalException(e);
                        continue;
                    }
                    throw new RuntimeException("Fatal Exception caught by WPManager.start" + ConstantsKt.getLINE_BREAK() + "----------------- First exception ------------------" + ExceptionUtils.getStackTrace((Throwable)e) + ConstantsKt.getLINE_BREAK() + "----------------- Nested exception ------------------", e2);
                }
            }
        }
        display.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeCurrentManager() {
        CTabFolder cTabFolder = this.getFolder();
        SelectionAdapter selectionAdapter = this.folderListener;
        if (selectionAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folderListener");
            selectionAdapter = null;
        }
        cTabFolder.removeSelectionListener((SelectionListener)selectionAdapter);
        int curSelection = this.getFolder().getSelectionIndex();
        int index = this.getFolder().getSelectionIndex();
        this.getList().get(index).close();
        if (this.getList().isEmpty()) {
            AutoCloseable autoCloseable = new WorkingDialog("Opening a new document...");
            Throwable throwable = null;
            try {
                WorkingDialog it = (WorkingDialog)autoCloseable;
                boolean bl = false;
                this.addDocumentManager(null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        CTabFolder cTabFolder2 = this.getFolder();
        SelectionAdapter selectionAdapter2 = this.folderListener;
        if (selectionAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folderListener");
            selectionAdapter2 = null;
        }
        cTabFolder2.addSelectionListener((SelectionListener)selectionAdapter2);
        this.getFolder().setSelection(RangesKt.coerceAtMost((int)curSelection, (int)(this.getFolder().getItemCount() - 1)));
        this.getFolder().notifyListeners(13, new Event());
    }

    public final boolean close() {
        if (this.isClosed != null) {
            logger.error("Last close call", (Throwable)this.isClosed);
            RuntimeException ex = new RuntimeException("close called twice");
            ex.addSuppressed(this.isClosed);
            Main.handleFatalException(ex);
        }
        this.isClosed = new RuntimeException("first close call");
        try {
            CTabFolder cTabFolder = this.getFolder();
            SelectionAdapter selectionAdapter = this.folderListener;
            if (selectionAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folderListener");
                selectionAdapter = null;
            }
            cTabFolder.removeSelectionListener((SelectionListener)selectionAdapter);
            int ex = ((Collection)this.getList()).size() + -1;
            if (0 <= ex) {
                do {
                    Manager temp;
                    int i = ex--;
                    Intrinsics.checkNotNullExpressionValue((Object)this.getList().get(i), (String)"get(...)");
                    if (temp.close()) continue;
                    this.isClosed = null;
                    CTabFolder cTabFolder2 = this.getFolder();
                    SelectionAdapter selectionAdapter2 = this.folderListener;
                    if (selectionAdapter2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"folderListener");
                        selectionAdapter2 = null;
                    }
                    cTabFolder2.addSelectionListener((SelectionListener)selectionAdapter2);
                    return false;
                } while (0 <= ex);
            }
            if (!this.getList().isEmpty()) {
                logger.error("Unable to close {}", (Object)CollectionsKt.joinToString$default((Iterable)this.getList(), (CharSequence)", ", null, null, (int)0, null, WPManager::close$lambda$0, (int)30, null));
            }
            INSTANCE = null;
            this.getShell().dispose();
        }
        catch (Exception e) {
            if (BBIni.getDebugging()) {
                throw e;
            }
            Main.handleFatalException(e);
        }
        return true;
    }

    private final void setShellScreenLocation(Display display, Shell shell) {
        Monitor primary = display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    private final Manager newManager(Path fileName, Manager oldManager) {
        try {
            return new Manager(this, fileName);
        }
        catch (Exception e) {
            if (oldManager != null) {
                this.changeManager(oldManager);
            }
            throw new RuntimeException("Failed to init Manager", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void addDocumentManager(@Nullable Path fileName) {
        block8: {
            block7: {
                if (fileName == null) break block7;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(fileName, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block8;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(fileName, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block8;
            }
            int numberOfTab = 10;
            if (this.getList().size() >= numberOfTab) {
                Notify.showMessage("The number of tabs allowed open is 10.", new Object[0]);
                return;
            }
            this.openingDoc = true;
            if (!BRFArchiverLoader.Companion.isBRF(fileName)) {
                Manager oldManager = this.getCurrentManager();
                this.setupDocumentManager(fileName, oldManager);
                this.openingDoc = false;
                return;
            }
            if (this.getList().isEmpty()) {
                this.addDocumentManager(null);
            }
            this.openBRFFile(fileName);
            this.openingDoc = false;
            return;
        }
        if (RecentDocs.Companion.getDefaultRecentDocs().getRecentDocs().contains(fileName)) {
            MessageBox messageBox;
            MessageBox $this$addDocumentManager_u24lambda_u240 = messageBox = new MessageBox(this.getShell(), 193);
            boolean bl = false;
            $this$addDocumentManager_u24lambda_u240.setText("File unavailable");
            $this$addDocumentManager_u24lambda_u240.setMessage("The file " + fileName + " is unavailable. Would you like to remove it from recent documents?");
            int removeFromRecentDocs = messageBox.open();
            if (removeFromRecentDocs != 64) return;
            RecentDocs.Companion.getDefaultRecentDocs().removeRecentDoc(fileName);
            Manager manager = this.getCurrentManager();
            Object object = manager;
            if (manager == null) return;
            BBSimpleManager bBSimpleManager = ((Manager)object).getSimpleManager();
            object = bBSimpleManager;
            if (bBSimpleManager == null) return;
            ((BBSimpleManager)object).initMenu(this.getShell());
            return;
        }
        Notify.showMessage(fileName.getFileName() + " cannot be opened and may have been relocated.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setupDocumentManager(Path fileName, Manager oldManager) {
        Manager m = this.newManager(fileName, oldManager);
        try {
            m.open();
            this.getList().add(m);
            this.setController(m);
            this.setSelection();
            m.getTextView().setFocus();
            m.setStatusBarText(this.getStatusBar());
        }
        catch (Throwable e) {
            logger.error("Detected an error whilst attempting to open a file, attempting to recover.", e);
            this.openingDoc = false;
            m.closeThreads();
            CTabFolder cTabFolder = this.getFolder();
            SelectionAdapter selectionAdapter = this.folderListener;
            if (selectionAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folderListener");
                selectionAdapter = null;
            }
            cTabFolder.removeSelectionListener((SelectionListener)selectionAdapter);
            int curSelection = this.getFolder().getSelectionIndex();
            if (this.getList().isEmpty()) {
                AutoCloseable autoCloseable = new WorkingDialog("Opening a new document...");
                Throwable throwable = null;
                try {
                    WorkingDialog it = (WorkingDialog)autoCloseable;
                    boolean bl = false;
                    this.addDocumentManager(null);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            CTabFolder cTabFolder2 = this.getFolder();
            SelectionAdapter selectionAdapter2 = this.folderListener;
            if (selectionAdapter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folderListener");
                selectionAdapter2 = null;
            }
            cTabFolder2.addSelectionListener((SelectionListener)selectionAdapter2);
            this.getFolder().setSelection(RangesKt.coerceAtMost((int)curSelection, (int)(this.getFolder().getItemCount() - 1)));
            this.getFolder().notifyListeners(13, new Event());
            Path path = fileName;
            Intrinsics.checkNotNull((Object)path);
            String filenameString = ((Object)path.getFileName()).toString();
            String string = filenameString.substring(StringsKt.lastIndexOf$default((CharSequence)filenameString, (char)'.', (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String fileExt = string;
            if (e instanceof BBNotifyException) {
                Notify.showMessage(e.getMessage(), new Object[0]);
            } else if (e instanceof XPathException) {
                if (Intrinsics.areEqual((Object)fileExt, (Object)".bbz")) {
                    Notify.showMessage(filenameString + " may be a file from an earlier release of BrailleBlaster and is not supported in this version.\n Please use an earlier version of BrailleBlaster to open this file.", new Object[0]);
                } else {
                    Notify.showMessage(filenameString + " is not an archive that can be opened by BrailleBlaster.", new Object[0]);
                }
            } else {
                Notify.showMessage(filenameString + " cannot be opened by BrailleBlaster", new Object[0]);
            }
        }
        finally {
            Manager curManager = this.getCurrentManager();
            this.initMenuAndToolbar(curManager);
            this.isManagerChanged = true;
            this.buildToolBar();
            this.isManagerChanged = false;
        }
        if (this.getList().size() == 2) {
            Manager manager = this.getList().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)manager, (String)"get(...)");
            Manager newDocManager = manager;
            if (newDocManager.isDefaultFile() && !newDocManager.isDocumentEdited() && !m.isDefaultFile()) {
                newDocManager.close();
            }
        }
    }

    private final void openBRFFile(Path fileName) {
        new PrintPreview(this.getShell(), fileName, this);
        RecentDocs recentDocs = RecentDocs.Companion.getDefaultRecentDocs();
        Path path = fileName;
        Intrinsics.checkNotNull((Object)path);
        recentDocs.addRecentDoc(path);
    }

    public final void setSelection() {
        int index = this.getList().size() - 1;
        this.getFolder().setSelection(index);
    }

    /*
     * WARNING - void declaration
     */
    private final void initMenuAndToolbar(Manager manager) {
        void it;
        ControlAdapter controlAdapter;
        if (this.resizeListener != null) {
            this.getShell().removeControlListener(this.resizeListener);
        }
        Manager manager2 = manager;
        Intrinsics.checkNotNull((Object)manager2);
        manager2.getSimpleManager().initMenu(this.getShell());
        this.buildToolBar();
        ControlAdapter controlAdapter2 = controlAdapter = new ControlAdapter(this){
            final /* synthetic */ WPManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void controlResized(ControlEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.buildToolBar();
            }
        };
        Shell shell = this.getShell();
        boolean bl = false;
        this.resizeListener = (ControlListener)it;
        shell.addControlListener((ControlListener)controlAdapter);
    }

    private final void changeManager(Manager manager) {
        this.setController(manager);
        this.initMenuAndToolbar(manager);
        manager.setStatusBarText(this.getStatusBar());
    }

    public final void buildToolBar() {
        this.getCurrentPerspective().rebuildToolBar(this);
        this.bbToolbar = this.getCurrentPerspective().getToolBar();
        this.getController().getSimpleManager().dispatchEvent(new BuildToolBarEvent(Sender.NO_SENDER));
        BBToolBar bBToolBar = this.bbToolbar;
        if (bBToolBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbToolbar");
            bBToolBar = null;
        }
        ((BrailleToolBar)bBToolBar).build();
        Object object = this.getFolder().getLayoutData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.eclipse.swt.layout.FormData");
        FormData formData = (FormData)object;
        BBToolBar bBToolBar2 = this.bbToolbar;
        if (bBToolBar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbToolbar");
            bBToolBar2 = null;
        }
        formData.top = new FormAttachment(0, bBToolBar2.getHeight() + 20);
        this.getShell().layout(true);
    }

    public final void onToolBarExpand() {
        Object object = this.getFolder().getLayoutData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.eclipse.swt.layout.FormData");
        FormData formData = (FormData)object;
        BBToolBar bBToolBar = this.bbToolbar;
        if (bBToolBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbToolbar");
            bBToolBar = null;
        }
        formData.top = new FormAttachment(0, bBToolBar.getHeight() + 40);
        this.getShell().layout(true);
    }

    public final void onToolBarCondense() {
        Object object = this.getFolder().getLayoutData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.eclipse.swt.layout.FormData");
        FormData formData = (FormData)object;
        BBToolBar bBToolBar = this.bbToolbar;
        if (bBToolBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbToolbar");
            bBToolBar = null;
        }
        formData.top = new FormAttachment(0, bBToolBar.getHeight() + 20);
        this.getShell().layout(true);
    }

    public final void removeController(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.isManagerChanged = true;
        if (this.isClosed == null) {
            this.buildToolBar();
        }
        this.isManagerChanged = false;
        this.getList().remove(m);
    }

    @Nullable
    public final Manager getCurrentManager() {
        int index = this.getFolder().getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.getList().get(index);
    }

    public final boolean isClosed() {
        return this.isClosed != null;
    }

    private final void handleBBException(BBException e) {
        BBException bBException = e;
        if (bBException instanceof OutdatedMapListException) {
            this.getController().refresh();
        } else if (bBException instanceof EditingException) {
            this.handleEditingException();
        } else if (!(bBException instanceof CursorMovementException)) {
            if (bBException instanceof FormatterException) {
                this.handleFormattingException((FormatterException)e, null);
            } else if (bBException instanceof TranslationException) {
                this.getController().refresh();
            }
        }
    }

    private final void handleEditingException() {
        this.getController().refresh();
    }

    private final void handleFormattingException(FormatterException e, FormatterException originalException) {
        FormatterException formatterException = originalException;
        if (formatterException == null) {
            formatterException = e;
        }
        FormatterException origException = formatterException;
        FormatterException.Fallback fallback = e.getCurFallback();
        switch (fallback == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fallback.ordinal()]) {
            case -1: {
                logger.error("Reformatting document");
                try {
                    this.getController().reformatDocument(this.getController().getDoc());
                }
                catch (FormatterException e2) {
                    this.handleFormattingException(e2, origException);
                }
                break;
            }
            case 1: {
                logger.error("Refreshing");
                try {
                    this.getController().refresh();
                }
                catch (FormatterException e2) {
                    this.handleFormattingException(e2, origException);
                }
                break;
            }
            case 2: {
                try {
                    logger.error("Escalating to an editing exception");
                    this.handleEditingException();
                }
                catch (RuntimeException runtimeException) {
                    logger.error("Dying");
                    Main.handleFatalException(origException);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void initialize$lambda$0(Event it) {
        logger.info("Main Shell handling Close event, about to dispose the main Display");
    }

    private static final void initialize$lambda$1(WPManager this$0, Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.getFolder().setSelection(this$0.getFolder().getItemCount() - 1);
        if (!this$0.openingDoc) {
            if (!this$0.close()) {
                event.doit = false;
            } else {
                this$0.userClosed = true;
            }
        } else {
            event.doit = false;
        }
    }

    private static final void initialize$lambda$2(WPManager this$0, Event it) {
        it.doit = this$0.close();
    }

    private static final void initialize$lambda$3(WPManager this$0, Event it) {
        if (this$0.isClosed == null && !this$0.userClosed) {
            this$0.close();
        }
    }

    private static final CharSequence close$lambda$0(Manager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    @JvmStatic
    @NotNull
    public static final WPManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final WPManager createInstance(@Nullable Path fileName) {
        return Companion.createInstance(fileName);
    }

    public static final /* synthetic */ SelectionAdapter access$getFolderListener$p(WPManager $this) {
        return $this.folderListener;
    }

    public static final /* synthetic */ void access$changeManager(WPManager $this, Manager manager) {
        $this.changeManager(manager);
    }

    public /* synthetic */ WPManager(UsageManager usageManager, DefaultConstructorMarker $constructor_marker) {
        this(usageManager);
    }

    static {
        Logger logger = LoggerFactory.getLogger(WPManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        WPManager.logger = logger;
        Display.setAppName((String)"BrailleBlaster");
        display = new Display();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0007H\u0007J\b\u0010\t\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0018\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0011\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/wordprocessor/WPManager$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "INSTANCE", "Lorg/brailleblaster/wordprocessor/WPManager;", "getInstance", "getInstanceOrNull", "display", "Lorg/eclipse/swt/widgets/Display;", "PADDING_AFTER_TOOLBAR", "", "createInstance", "fileName", "Ljava/nio/file/Path;", "usageManager", "Lorg/brailleblaster/usage/UsageManager;", "newShellIcons", "", "Lorg/eclipse/swt/graphics/Image;", "()[Lorg/eclipse/swt/graphics/Image;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nWPManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WPManager.kt\norg/brailleblaster/wordprocessor/WPManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,666:1\n1586#2:667\n1661#2,3:668\n37#3,2:671\n*S KotlinDebug\n*F\n+ 1 WPManager.kt\norg/brailleblaster/wordprocessor/WPManager$Companion\n*L\n662#1:667\n662#1:668,3\n662#1:671,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WPManager getInstance() {
            if (INSTANCE != null) {
                WPManager wPManager = INSTANCE;
                Intrinsics.checkNotNull((Object)wPManager);
                return wPManager;
            }
            throw new IllegalStateException("WPManager has not been initialised");
        }

        @Nullable
        public final WPManager getInstanceOrNull() {
            return INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final WPManager createInstance(@Nullable Path fileName) {
            return this.createInstance(fileName, new SimpleUsageManager(null, 1, null));
        }

        @NotNull
        public final synchronized WPManager createInstance(@Nullable Path fileName, @NotNull UsageManager usageManager) {
            Intrinsics.checkNotNullParameter((Object)usageManager, (String)"usageManager");
            if (INSTANCE != null && !BBIni.getDebugging()) {
                throw new RuntimeException("Cannot create multiple WPManager instances");
            }
            WPManager result = new WPManager(usageManager, null);
            INSTANCE = result;
            result.initialize(fileName);
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Image[] newShellIcons() {
            void $this$mapTo$iv$iv;
            Object[] objectArray = new String[]{"large", "medium", "small"};
            Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"toolbar", it, "logo.png"};
                collection.add(new Image((Device)Display.getCurrent(), ((Object)BBIni.getProgramDataPath().resolve(Paths.get("images", stringArray))).toString()));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Image[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormatterException.Fallback.values().length];
            try {
                nArray[FormatterException.Fallback.FORMAT_DOCUMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatterException.Fallback.REFRESH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

