/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.debug;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Serializer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.debug.XMLDebugger$setNode$;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.ColorManager;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0012H\u0002J\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0010J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0012J\b\u0010(\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/brailleblaster/debug/XMLDebugger;", "", "parent", "Lorg/eclipse/swt/widgets/Shell;", "simpleManager", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Lorg/brailleblaster/perspectives/mvc/BBSimpleManager;)V", "dialog", "getDialog", "()Lorg/eclipse/swt/widgets/Shell;", "setDialog", "(Lorg/eclipse/swt/widgets/Shell;)V", "xmlViewer", "Lorg/eclipse/swt/custom/StyledText;", "curNode", "Lnu/xom/Node;", "showBrlValue", "", "formatXML", "warnEmptyText", "colorTagsButton", "Lorg/eclipse/swt/widgets/Button;", "styles", "", "Lorg/eclipse/swt/custom/StyleRange;", "activeDocument", "Lnu/xom/Document;", "findButton", "Lorg/eclipse/swt/widgets/Text;", "open", "", "findNext", "findPrev", "findRed", "red", "setNode", "newNode", "setColorTagsEnabled", "enabled", "save", "Companion", "brailleblaster-debug-tools"})
@SourceDebugExtension(value={"SMAP\nXMLDebugger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMLDebugger.kt\norg/brailleblaster/debug/XMLDebugger\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,286:1\n479#2:287\n1342#2,2:288\n37#3,2:290\n*S KotlinDebug\n*F\n+ 1 XMLDebugger.kt\norg/brailleblaster/debug/XMLDebugger\n*L\n203#1:287\n205#1:288,2\n262#1:290,2\n*E\n"})
public final class XMLDebugger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Shell parent;
    @NotNull
    private final BBSimpleManager simpleManager;
    public Shell dialog;
    @Nullable
    private StyledText xmlViewer;
    private Node curNode;
    private boolean showBrlValue;
    private boolean formatXML;
    private boolean warnEmptyText;
    @Nullable
    private Button colorTagsButton;
    @NotNull
    private final List<StyleRange> styles;
    @Nullable
    private Document activeDocument;
    private Text findButton;
    private static final Logger log = LoggerFactory.getLogger(XMLDebugger.class);

    public XMLDebugger(@NotNull Shell parent, @NotNull BBSimpleManager simpleManager) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)simpleManager, (String)"simpleManager");
        this.parent = parent;
        this.simpleManager = simpleManager;
        this.showBrlValue = true;
        this.formatXML = true;
        this.warnEmptyText = true;
        this.styles = new ArrayList();
        this.open();
        this.setNode(this.simpleManager.getCurrentCaret().getNode());
    }

    @NotNull
    public final Shell getDialog() {
        Shell shell = this.dialog;
        if (shell != null) {
            return shell;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        return null;
    }

    public final void setDialog(@NotNull Shell shell) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"<set-?>");
        this.dialog = shell;
    }

    public final void open() {
        this.setDialog(EasySWT.INSTANCE.makeDialogFloating(this.parent));
        this.getDialog().setText("Debug: XML Viewer");
        int gridLayoutCols = 10;
        this.getDialog().setLayout((Layout)new GridLayout(gridLayoutCols, false));
        StyledText styledText = this.xmlViewer = new StyledText((Composite)this.getDialog(), 584);
        Intrinsics.checkNotNull((Object)styledText);
        styledText.setLayoutData((Object)new GridData(4, 4, true, true, gridLayoutCols, 1));
        Button updateButton = new Button((Composite)this.getDialog(), 8);
        updateButton.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        updateButton.setText("Update");
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ XMLDebugger this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setNode(XMLDebugger.access$getSimpleManager$p(this.this$0).getCurrentCaret().getNode());
            }
        });
        Button getParentButton = new Button((Composite)this.getDialog(), 8);
        getParentButton.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        getParentButton.setText("Get Parent");
        getParentButton.addSelectionListener(new SelectionListener(this){
            final /* synthetic */ XMLDebugger this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
            }

            public void widgetSelected(SelectionEvent arg0) {
                Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
                Node node = XMLDebugger.access$getCurNode$p(this.this$0);
                if (node == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"curNode");
                    node = null;
                }
                if (node.getParent() != null) {
                    Node node2 = XMLDebugger.access$getCurNode$p(this.this$0);
                    if (node2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"curNode");
                        node2 = null;
                    }
                    ParentNode parentNode = node2.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                    this.this$0.setNode((Node)parentNode);
                }
            }
        });
        Button showBrl = new Button((Composite)this.getDialog(), 32);
        showBrl.setText("Show <brl> tags");
        showBrl.setSelection(this.showBrlValue);
        EasySWT.addSelectionListener((Button)showBrl, arg_0 -> XMLDebugger.open$lambda$0(this, arg_0));
        Button button = this.colorTagsButton = new Button((Composite)this.getDialog(), 32);
        Intrinsics.checkNotNull((Object)button);
        button.setText("Show tags in different color");
        Button button2 = this.colorTagsButton;
        Intrinsics.checkNotNull((Object)button2);
        button2.setSelection(true);
        Button button3 = this.colorTagsButton;
        Intrinsics.checkNotNull((Object)button3);
        EasySWT.addSelectionListener((Button)button3, arg_0 -> XMLDebugger.open$lambda$1(this, arg_0));
        Button formattedButton = new Button((Composite)this.getDialog(), 32);
        formattedButton.setText("Format XML");
        formattedButton.setSelection(this.formatXML);
        EasySWT.addSelectionListener((Button)formattedButton, arg_0 -> XMLDebugger.open$lambda$2(this, arg_0));
        Button warnEmptyTextButton = new Button((Composite)this.getDialog(), 32);
        warnEmptyTextButton.setText("Warn Empty Text");
        warnEmptyTextButton.setSelection(this.warnEmptyText);
        EasySWT.addSelectionListener((Button)warnEmptyTextButton, arg_0 -> XMLDebugger.open$lambda$3(this, arg_0));
        Button saveButton = new Button((Composite)this.getDialog(), 8);
        saveButton.setText("Save this to BBX File");
        EasySWT.addSelectionListener((Button)saveButton, arg_0 -> XMLDebugger.open$lambda$4(this, arg_0));
        this.findButton = new Text((Composite)this.getDialog(), 2048);
        Text text = this.findButton;
        if (text == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
            text = null;
        }
        text.addKeyListener((KeyListener)new KeyAdapter(this){
            final /* synthetic */ XMLDebugger this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.keyCode == 13) {
                    if (e.stateMask == 131072) {
                        XMLDebugger.access$findPrev(this.this$0);
                    } else {
                        XMLDebugger.access$findNext(this.this$0);
                    }
                }
            }
        });
        Button nextButton = new Button((Composite)this.getDialog(), 0);
        nextButton.setText("Next");
        EasySWT.addSelectionListener((Button)nextButton, arg_0 -> XMLDebugger.open$lambda$5(this, arg_0));
        Button prevButton = new Button((Composite)this.getDialog(), 0);
        prevButton.setText("Previous");
        EasySWT.addSelectionListener((Button)prevButton, arg_0 -> XMLDebugger.open$lambda$6(this, arg_0));
        this.getDialog().open();
    }

    private final void findNext() {
        StyledText styledText = this.xmlViewer;
        Intrinsics.checkNotNull((Object)styledText);
        StyledText styledText2 = this.xmlViewer;
        Intrinsics.checkNotNull((Object)styledText2);
        int n = styledText2.getCaretOffset();
        StyledText styledText3 = this.xmlViewer;
        Intrinsics.checkNotNull((Object)styledText3);
        String relevantText = styledText.getText(n, styledText3.getCharCount() - 1);
        Intrinsics.checkNotNull((Object)relevantText);
        CharSequence charSequence = relevantText;
        Text text = this.findButton;
        if (text == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
            text = null;
        }
        String string = text.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int offset = StringsKt.indexOf$default((CharSequence)charSequence, (String)string, (int)0, (boolean)false, (int)6, null);
        if (offset == 0) {
            CharSequence charSequence2 = relevantText;
            Text text2 = this.findButton;
            if (text2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
                text2 = null;
            }
            String string2 = text2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            offset = StringsKt.indexOf$default((CharSequence)charSequence2, (String)string2, (int)1, (boolean)false, (int)4, null);
        }
        if (offset == -1) {
            this.findRed(true);
        } else {
            this.findRed(false);
            StyledText styledText4 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText4);
            StyledText styledText5 = styledText4;
            styledText5.setCaretOffset(styledText5.getCaretOffset() + offset);
            StyledText styledText6 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText6);
            EasySWT.INSTANCE.scrollViewToCursor(styledText6);
            StyledText styledText7 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText7);
            StyledText styledText8 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText8);
            int n2 = styledText8.getCaretOffset();
            Text text3 = this.findButton;
            if (text3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
                text3 = null;
            }
            styledText7.setSelectionRange(n2, text3.getText().length());
            StyledText styledText9 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText9);
            styledText9.setFocus();
        }
    }

    private final void findPrev() {
        StyledText styledText = this.xmlViewer;
        Intrinsics.checkNotNull((Object)styledText);
        StyledText styledText2 = this.xmlViewer;
        Intrinsics.checkNotNull((Object)styledText2);
        String relevantText = styledText.getText(0, styledText2.getCaretOffset());
        Intrinsics.checkNotNull((Object)relevantText);
        CharSequence charSequence = relevantText;
        Text text = this.findButton;
        if (text == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
            text = null;
        }
        String string = text.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int offset = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string, (int)0, (boolean)false, (int)6, null);
        StyledText styledText3 = this.xmlViewer;
        Intrinsics.checkNotNull((Object)styledText3);
        if (offset == styledText3.getCaretOffset()) {
            CharSequence charSequence2 = StringsKt.dropLast((String)relevantText, (int)1);
            Text text2 = this.findButton;
            if (text2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
                text2 = null;
            }
            String string2 = text2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            offset = StringsKt.lastIndexOf$default((CharSequence)charSequence2, (String)string2, (int)1, (boolean)false, (int)4, null);
        }
        if (offset == -1) {
            this.findRed(true);
        } else {
            this.findRed(false);
            StyledText styledText4 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText4);
            styledText4.setCaretOffset(offset);
            StyledText styledText5 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText5);
            EasySWT.INSTANCE.scrollViewToCursor(styledText5);
            StyledText styledText6 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText6);
            StyledText styledText7 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText7);
            int n = styledText7.getCaretOffset();
            Text text3 = this.findButton;
            if (text3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
                text3 = null;
            }
            styledText6.setSelectionRange(n, text3.getText().length());
            StyledText styledText8 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText8);
            styledText8.setFocus();
        }
    }

    private final void findRed(boolean red) {
        Text text;
        Color color;
        if (red) {
            Text text2 = this.findButton;
            if (text2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
                text2 = null;
            }
            v1 = ColorManager.INSTANCE.getColor(ColorManager.Colors.RED, (Control)text2);
        } else {
            Text text3 = this.findButton;
            if (text3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
                text3 = null;
            }
            v1 = color = ColorManager.INSTANCE.getColor(ColorManager.Colors.WHITE, (Control)text3);
        }
        if ((text = this.findButton) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"findButton");
            text = null;
        }
        text.setBackground(color);
    }

    /*
     * WARNING - void declaration
     */
    public final void setNode(@NotNull Node newNode) {
        String $i$f$forEach2;
        Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
        Node n = newNode;
        this.styles.clear();
        this.setColorTagsEnabled(false);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Serializer serial = new Serializer((OutputStream)bytes);
        if (this.formatXML) {
            serial.setIndent(4);
        }
        if (n instanceof nu.xom.Text) {
            n = (Node)((nu.xom.Text)n).getParent();
        }
        if (n == null) {
            return;
        }
        this.curNode = n;
        Node node = n;
        Document document = node instanceof Document ? (Document)node : null;
        if (document == null) {
            Node node2 = n.copy();
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
            document = this.activeDocument = new Document((Element)node2);
        }
        if (!this.showBrlValue) {
            UTDHelper.getDescendantBrlFast((Node)((Node)this.activeDocument), XMLDebugger::setNode$lambda$0);
        }
        if (this.warnEmptyText) {
            void $this$forEach$iv;
            Sequence $this$filterIsInstance$iv;
            Sequence sequence = FastXPath.descendant((Node)((Node)this.activeDocument));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)setNode$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.filter((Sequence)sequence2, XMLDebugger::setNode$lambda$1);
            boolean $i$f$forEach2 = false;
            for (String element$iv : $this$forEach$iv) {
                nu.xom.Text it = (nu.xom.Text)element$iv;
                boolean bl = false;
                it.setValue("[!!!! EMPTY TEXT NODE !!!!]");
            }
        }
        Document document2 = this.activeDocument;
        Intrinsics.checkNotNull((Object)document2);
        document2.getRootElement().addNamespaceDeclaration("utd", "http://brailleblaster.org/ns/utd");
        String newText = null;
        try {
            serial.write(this.activeDocument);
            $i$f$forEach2 = bytes.toString(StandardCharsets.UTF_8);
            Intrinsics.checkNotNull((Object)$i$f$forEach2);
        }
        catch (IOException e) {
            String element$iv;
            element$iv = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNull((Object)element$iv);
            $i$f$forEach2 = element$iv;
        }
        newText = $i$f$forEach2;
        if (StringsKt.contains$default((CharSequence)newText, (CharSequence)"?>", (boolean)false, (int)2, null)) {
            String string = newText.substring(StringsKt.indexOf$default((CharSequence)newText, (char)'>', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            newText = string;
        }
        StyledText styledText = this.xmlViewer;
        Intrinsics.checkNotNull((Object)styledText);
        styledText.setText(newText);
        char[] cArray = newText.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] textChars = cArray;
        int start = -1;
        int n2 = textChars.length;
        for (int i = 0; i < n2; ++i) {
            String content;
            char curChar = textChars[i];
            if (curChar == '<' && start == -1) {
                start = i;
                continue;
            }
            if (curChar != '>' || start == -1) continue;
            StyleRange range = new StyleRange();
            range.start = start;
            range.length = i - start + 1;
            Intrinsics.checkNotNullExpressionValue((Object)newText.substring(start, i), (String)"substring(...)");
            range.background = StringsKt.startsWith$default((String)content, (String)"<utd:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)content, (String)"</utd:", (boolean)false, (int)2, null) ? Display.getCurrent().getSystemColor(11) : Display.getCurrent().getSystemColor(5);
            this.styles.add(range);
            start = -1;
        }
        Button button = this.colorTagsButton;
        Intrinsics.checkNotNull((Object)button);
        this.setColorTagsEnabled(button.getSelection());
        EasySWT.INSTANCE.setLargeDialogSize(this.getDialog());
    }

    public final void setColorTagsEnabled(boolean enabled) {
        if (enabled) {
            StyledText styledText = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText);
            Collection $this$toTypedArray$iv = this.styles;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            styledText.setStyleRanges(thisCollection$iv.toArray(new StyleRange[0]));
        } else {
            StyledText styledText = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText);
            StyledText styledText2 = this.xmlViewer;
            Intrinsics.checkNotNull((Object)styledText2);
            styledText.replaceStyleRanges(0, styledText2.getCharCount(), new StyleRange[0]);
        }
    }

    private final void save() {
        FileDialog saveAs = new FileDialog(this.getDialog(), 8192);
        String[] stringArray = new String[]{"*.xml"};
        saveAs.setFilterExtensions(stringArray);
        String path = saveAs.open();
        if (path == null) {
            log.debug("canceled save");
        } else {
            Document doc = BBX.newDocument();
            Element root = BBX.SECTION.ROOT.create();
            Document document = this.activeDocument;
            Intrinsics.checkNotNull((Object)document);
            root.appendChild((Node)document.getRootElement().copy());
            doc.getRootElement().appendChild((Node)root);
            XMLHandler xMLHandler = new XMLHandler();
            Intrinsics.checkNotNull((Object)doc);
            xMLHandler.save(doc, new File(path));
        }
    }

    private static final void open$lambda$0(XMLDebugger this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.showBrlValue = !this$0.showBrlValue;
        Node node = this$0.curNode;
        if (node == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"curNode");
            node = null;
        }
        this$0.setNode(node);
    }

    private static final void open$lambda$1(XMLDebugger this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Button button = this$0.colorTagsButton;
        Intrinsics.checkNotNull((Object)button);
        this$0.setColorTagsEnabled(button.getSelection());
    }

    private static final void open$lambda$2(XMLDebugger this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.formatXML = !this$0.formatXML;
        Node node = this$0.curNode;
        if (node == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"curNode");
            node = null;
        }
        this$0.setNode(node);
    }

    private static final void open$lambda$3(XMLDebugger this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.warnEmptyText = !this$0.warnEmptyText;
        Node node = this$0.curNode;
        if (node == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"curNode");
            node = null;
        }
        this$0.setNode(node);
    }

    private static final void open$lambda$4(XMLDebugger this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.save();
    }

    private static final void open$lambda$5(XMLDebugger this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.findNext();
    }

    private static final void open$lambda$6(XMLDebugger this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.findPrev();
    }

    private static final void setNode$lambda$0(Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.detach();
    }

    private static final boolean setNode$lambda$1(nu.xom.Text it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return ((CharSequence)string).length() == 0;
    }

    public static final /* synthetic */ BBSimpleManager access$getSimpleManager$p(XMLDebugger $this) {
        return $this.simpleManager;
    }

    public static final /* synthetic */ Node access$getCurNode$p(XMLDebugger $this) {
        return $this.curNode;
    }

    public static final /* synthetic */ void access$findPrev(XMLDebugger $this) {
        $this.findPrev();
    }

    public static final /* synthetic */ void access$findNext(XMLDebugger $this) {
        $this.findNext();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/debug/XMLDebugger$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-debug-tools"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

