/*
 * Decompiled with CFR 0.152.
 */
package org.mwhapples.jlouis;

import com.google.common.io.Resources;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.mwhapples.jlouis.Louis;
import org.mwhapples.jlouis.TableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarResolver
implements TableResolver {
    private static final Logger log = LoggerFactory.getLogger(JarResolver.class);
    private static volatile File TABLE_TEMP_DIR = null;
    private static final List<String> EXTRACTED_FILES = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static File getTempTableDir() {
        if (TABLE_TEMP_DIR != null) return TABLE_TEMP_DIR;
        Class<JarResolver> clazz = JarResolver.class;
        synchronized (JarResolver.class) {
            if (TABLE_TEMP_DIR != null) return TABLE_TEMP_DIR;
            try {
                TABLE_TEMP_DIR = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create temp directory", e);
            }
            return TABLE_TEMP_DIR;
        }
    }

    @Override
    public File[] resolveTable(String tableList, String base) {
        String[] tables = tableList.split(",");
        ArrayList<File> files = new ArrayList<File>();
        String dataPath = new Louis().getDataPath();
        String[] louisDataPaths = dataPath != null ? dataPath.split(",") : new String[]{};
        for (String table : tables) {
            File file = new File(table);
            if (file.isAbsolute() && file.isFile()) {
                files.add(file);
                continue;
            }
            if (base != null) {
                File baseFile = new File(base);
                file = new File(baseFile.getParent(), table);
                log.debug("Checking if table {} is relative to base, absolute path tested is {}", (Object)table, (Object)file.getAbsolutePath());
                if (file.isFile()) {
                    log.debug("Table is relative");
                    files.add(file);
                    continue;
                }
            }
            file = null;
            log.debug("Checking for table on data path");
            for (int j = 0; j < louisDataPaths.length && file == null; ++j) {
                File louisDataPath = new File(louisDataPaths[j]);
                file = new File(louisDataPath, table);
                if (file.isFile() || (file = new File(new File(louisDataPath, "liblouis/tables"), table)).isFile()) continue;
                file = null;
            }
            if (file != null) {
                log.debug("Table found on data path");
                files.add(file);
                continue;
            }
            log.debug("Attempting to load table {} from classpath", (Object)table);
            File tmpDir = JarResolver.getTempTableDir();
            File tmpFile = new File(tmpDir, table);
            String tmpFilePath = tmpFile.getAbsolutePath();
            if (EXTRACTED_FILES.contains(tmpFilePath)) {
                log.debug("Table previously extracted");
                files.add(tmpFile);
                continue;
            }
            URL resourceTable = this.getClass().getResource("/org/mwhapples/jlouis/tables/" + table);
            if (resourceTable != null) {
                try (FileOutputStream os = new FileOutputStream(tmpFile);){
                    log.debug("Extracting from classpath");
                    Resources.copy((URL)resourceTable, (OutputStream)os);
                }
                catch (FileNotFoundException e) {
                    log.warn("Unable to create file when extracting table", (Throwable)e);
                    continue;
                }
                catch (IOException e) {
                    log.warn("Unable to extract table from jar", (Throwable)e);
                    continue;
                }
                log.debug("Extracted from classpath");
                files.add(tmpFile);
                tmpFile.deleteOnExit();
                EXTRACTED_FILES.add(tmpFilePath);
                continue;
            }
            throw new RuntimeException(String.format("Table %s not found", table));
        }
        return files.toArray(new File[0]);
    }
}

