/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.utils.LengthUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/utils/UnitConverter;", "", "isMetric", "", "<init>", "(Z)V", "()Z", "calculateLinesFromHeight", "", "height", "", "cell", "Lorg/brailleblaster/libembosser/spi/BrlCell;", "calculateCellsFromWidth", "width", "calculateWidthFromCells", "numberOfCells", "calculateHeightFromLines", "numberOfLines", "localUnitsToMM", "distance", "mmToLocalUnits", "Companion", "utils"})
public final class UnitConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isMetric;
    @NotNull
    public static final String NONMETRIC_COUNTRY = "US";

    @JvmOverloads
    public UnitConverter(boolean isMetric) {
        this.isMetric = isMetric;
    }

    public /* synthetic */ UnitConverter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = !Intrinsics.areEqual((Object)Locale.getDefault().getCountry(), (Object)NONMETRIC_COUNTRY);
        }
        this(bl);
    }

    public final boolean isMetric() {
        return this.isMetric;
    }

    public final int calculateLinesFromHeight(double height, @NotNull BrlCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        return cell.getLinesForHeight(new BigDecimal(String.valueOf(this.localUnitsToMM(height))));
    }

    public final int calculateCellsFromWidth(double width, @NotNull BrlCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        return cell.getCellsForWidth(new BigDecimal(String.valueOf(this.localUnitsToMM(width))));
    }

    public final double calculateWidthFromCells(int numberOfCells, @NotNull BrlCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        double width = cell.getWidthForCells(numberOfCells).doubleValue();
        return this.mmToLocalUnits(width);
    }

    public final double calculateHeightFromLines(int numberOfLines, @NotNull BrlCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        double height = cell.getHeightForLines(numberOfLines).doubleValue();
        return this.mmToLocalUnits(height);
    }

    public final double localUnitsToMM(double distance) {
        return !this.isMetric ? LengthUtils.inchesToMM(distance) : distance;
    }

    public final double mmToLocalUnits(double distance) {
        return !this.isMetric ? LengthUtils.mmToInches(distance) : distance;
    }

    @JvmOverloads
    public UnitConverter() {
        this(false, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final DecimalFormat newDecimalFormatUS(@Nullable String usFormattedPattern) {
        return Companion.newDecimalFormatUS(usFormattedPattern);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/utils/UnitConverter$Companion;", "", "<init>", "()V", "NONMETRIC_COUNTRY", "", "newDecimalFormatUS", "Ljava/text/DecimalFormat;", "usFormattedPattern", "utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DecimalFormat newDecimalFormatUS(@Nullable String usFormattedPattern) {
            return new DecimalFormat(usFormattedPattern, new DecimalFormatSymbols(Locale.ENGLISH));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

