/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils.xml;

import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0005\u0011\u0012\u0013\u0014\u0015B1\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/utils/xml/EntityMap;", "", "publicIdMap", "", "", "Lorg/brailleblaster/utils/xml/EntityMap$IEntitySource;", "systemIdMap", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "containsSystemId", "", "systemId", "containsPublicId", "publicId", "getByPublicId", "Lorg/xml/sax/InputSource;", "getBySystemId", "Builder", "IEntitySource", "JarEntity", "EmptyEntity", "Companion", "utils"})
public final class EntityMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, IEntitySource> publicIdMap;
    @NotNull
    private final Map<String, IEntitySource> systemIdMap;

    private EntityMap(Map<String, ? extends IEntitySource> publicIdMap, Map<String, ? extends IEntitySource> systemIdMap) {
        this.publicIdMap = publicIdMap;
        this.systemIdMap = systemIdMap;
    }

    public final boolean containsSystemId(@NotNull String systemId) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        return this.systemIdMap.containsKey(systemId);
    }

    public final boolean containsPublicId(@NotNull String publicId) {
        Intrinsics.checkNotNullParameter((Object)publicId, (String)"publicId");
        return this.publicIdMap.containsKey(publicId);
    }

    @NotNull
    public final InputSource getByPublicId(@NotNull String publicId) {
        Intrinsics.checkNotNullParameter((Object)publicId, (String)"publicId");
        IEntitySource iEntitySource = this.publicIdMap.get(publicId);
        Intrinsics.checkNotNull((Object)iEntitySource);
        return iEntitySource.getSource();
    }

    @NotNull
    public final InputSource getBySystemId(@NotNull String systemId) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        IEntitySource iEntitySource = this.systemIdMap.get(systemId);
        Intrinsics.checkNotNull((Object)iEntitySource);
        return iEntitySource.getSource();
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ EntityMap(Map publicIdMap, Map systemIdMap, DefaultConstructorMarker $constructor_marker) {
        this(publicIdMap, systemIdMap);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\t\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/utils/xml/EntityMap$Builder;", "", "<init>", "()V", "publicIdBuilder", "", "", "Lorg/brailleblaster/utils/xml/EntityMap$IEntitySource;", "systemIdBuilder", "put", "publicId", "systemId", "source", "build", "Lorg/brailleblaster/utils/xml/EntityMap;", "utils"})
    public static final class Builder {
        @NotNull
        private Map<String, IEntitySource> publicIdBuilder = new LinkedHashMap();
        @NotNull
        private Map<String, IEntitySource> systemIdBuilder = new LinkedHashMap();

        @NotNull
        public final Builder put(@Nullable String publicId, @Nullable String systemId, @NotNull IEntitySource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (publicId != null) {
                this.publicIdBuilder.put(publicId, source);
            }
            if (systemId != null) {
                this.systemIdBuilder.put(systemId, source);
            }
            return this;
        }

        @NotNull
        public final EntityMap build() {
            return new EntityMap(MapsKt.toMap(this.publicIdBuilder), MapsKt.toMap(this.systemIdBuilder), null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/utils/xml/EntityMap$Companion;", "", "<init>", "()V", "builder", "Lorg/brailleblaster/utils/xml/EntityMap$Builder;", "utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/utils/xml/EntityMap$EmptyEntity;", "Lorg/brailleblaster/utils/xml/EntityMap$IEntitySource;", "<init>", "()V", "source", "Lorg/xml/sax/InputSource;", "getSource", "()Lorg/xml/sax/InputSource;", "utils"})
    public static final class EmptyEntity
    implements IEntitySource {
        @Override
        @NotNull
        public InputSource getSource() {
            return new InputSource(new StringReader(""));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/brailleblaster/utils/xml/EntityMap$IEntitySource;", "", "source", "Lorg/xml/sax/InputSource;", "getSource", "()Lorg/xml/sax/InputSource;", "utils"})
    public static interface IEntitySource {
        @NotNull
        public InputSource getSource();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/utils/xml/EntityMap$JarEntity;", "Lorg/brailleblaster/utils/xml/EntityMap$IEntitySource;", "resourceName", "", "<init>", "(Ljava/lang/String;)V", "source", "Lorg/xml/sax/InputSource;", "getSource", "()Lorg/xml/sax/InputSource;", "utils"})
    @SourceDebugExtension(value={"SMAP\nEntityMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityMap.kt\norg/brailleblaster/utils/xml/EntityMap$JarEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
    public static final class JarEntity
    implements IEntitySource {
        @NotNull
        private final String resourceName;

        public JarEntity(@Nullable String resourceName) {
            if (resourceName == null) {
                boolean bl = false;
                String string = "Resource name cannot be null";
                throw new IllegalArgumentException(string.toString());
            }
            this.resourceName = resourceName;
        }

        @Override
        @NotNull
        public InputSource getSource() {
            return new InputSource(this.getClass().getResourceAsStream(this.resourceName));
        }
    }
}

