/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils.xml;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.utils.xml.EntityMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/utils/xml/LocalEntityMapHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "<init>", "()V", "entityMapBuilder", "Lorg/brailleblaster/utils/xml/EntityMap$Builder;", "startElement", "", "uri", "", "localName", "qName", "attributes", "Lorg/xml/sax/Attributes;", "resolveEntity", "Lorg/xml/sax/InputSource;", "publicId", "systemId", "entityMap", "Lorg/brailleblaster/utils/xml/EntityMap;", "getEntityMap", "()Lorg/brailleblaster/utils/xml/EntityMap;", "Companion", "utils"})
public final class LocalEntityMapHandler
extends DefaultHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private EntityMap.Builder entityMapBuilder;
    private static final Logger log = LoggerFactory.getLogger(LocalEntityMapHandler.class);
    @NotNull
    private static final String DTD_LOCATION = "/org/brailleblaster/utd/internal/xml/entity-map.dtd";

    @Override
    public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        switch (localName) {
            case "entities": {
                this.entityMapBuilder = EntityMap.Companion.builder();
                break;
            }
            case "jarEntity": {
                String publicId = attributes.getValue("publicId");
                String systemId = attributes.getValue("systemId");
                String localResourceName = attributes.getValue("resourceName");
                EntityMap.Builder builder = this.entityMapBuilder;
                Intrinsics.checkNotNull((Object)builder);
                builder.put(publicId, systemId, new EntityMap.JarEntity(localResourceName));
                break;
            }
            case "emptyEntity": {
                String publicId = attributes.getValue("publicId");
                String systemId = attributes.getValue("systemId");
                EntityMap.Builder builder = this.entityMapBuilder;
                Intrinsics.checkNotNull((Object)builder);
                builder.put(publicId, systemId, new EntityMap.EmptyEntity());
            }
        }
    }

    @Override
    @NotNull
    public InputSource resolveEntity(@NotNull String publicId, @NotNull String systemId) throws IOException, SAXException {
        InputSource inputSource;
        Intrinsics.checkNotNullParameter((Object)publicId, (String)"publicId");
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        log.debug("Resolving publicId=\"{}\" systemId=\"{}\"", (Object)publicId, (Object)systemId);
        if (Intrinsics.areEqual((Object)"-//utd//DTD Entity Map 1.0//EN", (Object)publicId) || Intrinsics.areEqual((Object)"entity-map.dtd", (Object)systemId)) {
            inputSource = new InputSource(this.getClass().getResourceAsStream(DTD_LOCATION));
        } else {
            InputSource inputSource2 = super.resolveEntity(publicId, systemId);
            inputSource = inputSource2;
            Intrinsics.checkNotNullExpressionValue((Object)inputSource2, (String)"resolveEntity(...)");
        }
        return inputSource;
    }

    @NotNull
    public final EntityMap getEntityMap() {
        EntityMap.Builder builder = this.entityMapBuilder;
        Intrinsics.checkNotNull((Object)builder);
        return builder.build();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/utils/xml/LocalEntityMapHandler$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "DTD_LOCATION", "", "utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

