/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fJH\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J*\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J<\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J0\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ^\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJh\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u001a\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u001a\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005J\"\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J \u0010#\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u001a\u0010$\u001a\u00020\u00172\b\u0010%\u001a\u0004\u0018\u00010\u00172\u0006\u0010&\u001a\u00020\u0017H\u0002J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017H\u0002J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170*2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/brailleblaster/utd/MetadataHelper;", "", "<init>", "()V", "PRINT", "", "BRL", "changePrintPageNumber", "", "doc", "Lnu/xom/Document;", "originalNum", "newNum", "volume", "skip", "", "newContLetter", "pageType", "markBlankPrintPageNumber", "changeBraillePageNumber", "runHead", "combinePrintPageNumbers", "addMeta", "Lnu/xom/Element;", "type", "originalStr", "newStr", "resetCL", "combined", "blank", "addNewChangeMeta", "findPrintPageChange", "findBraillePageChange", "findPrintPageCombiner", "findPageChange", "markUsed", "combineElementAttributes", "oldMeta", "newMeta", "adaptNewPageNumber", "baseMeta", "getUTDMeta", "", "utd"})
public final class MetadataHelper {
    @NotNull
    public static final MetadataHelper INSTANCE = new MetadataHelper();
    @NotNull
    private static final String PRINT = "printPage";
    @NotNull
    private static final String BRL = "braillePage";

    private MetadataHelper() {
    }

    @JvmStatic
    public static final void changePrintPageNumber(@NotNull Document doc, @NotNull String originalNum, @Nullable String newNum, @Nullable String volume, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        INSTANCE.addNewChangeMeta(doc, PRINT, originalNum, newNum, null, null, false, false, volume, skip, true);
    }

    public final void changePrintPageNumber(@NotNull Document doc, @NotNull String originalNum, @Nullable String newNum, @Nullable String newContLetter, @Nullable String volume, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        this.addNewChangeMeta(doc, PRINT, originalNum, newNum, newContLetter, null, false, false, volume, skip, true);
    }

    @JvmStatic
    public static final void changePrintPageNumber(@NotNull Document doc, @NotNull String originalNum, @Nullable String newNum, @Nullable String newContLetter, @Nullable String pageType, @Nullable String volume, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        INSTANCE.addNewChangeMeta(doc, PRINT, originalNum, newNum, newContLetter, pageType, false, false, volume, skip, true);
    }

    @JvmStatic
    public static final void markBlankPrintPageNumber(@NotNull Document doc, @NotNull String originalNum, @Nullable String volume, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        INSTANCE.addNewChangeMeta(doc, PRINT, originalNum, null, null, null, false, true, volume, skip, true);
    }

    @JvmStatic
    public static final void changeBraillePageNumber(@NotNull Document doc, @NotNull String originalNum, @Nullable String newNum, @Nullable String volume, boolean skip, boolean runHead) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        INSTANCE.addNewChangeMeta(doc, BRL, originalNum, newNum, null, null, false, false, volume, skip, runHead);
    }

    public final void combinePrintPageNumbers(@NotNull Document doc, @NotNull String originalNum, @Nullable String newNum, boolean skip, boolean runHead) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        this.addNewChangeMeta(doc, PRINT, originalNum, newNum, null, null, true, false, null, skip, runHead);
    }

    @NotNull
    public final Element addMeta(@NotNull String type, @NotNull String originalStr, @Nullable String newStr, @Nullable String resetCL, @Nullable String pageType, boolean combined, boolean blank, @Nullable String volume, boolean skip, boolean runHead) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)originalStr, (String)"originalStr");
        Element meta = UTDElements.META.create();
        meta.addAttribute(new Attribute("type", type));
        meta.addAttribute(new Attribute("original", originalStr));
        if (newStr != null) {
            meta.addAttribute(new Attribute("new", newStr));
        }
        if (resetCL != null) {
            meta.addAttribute(new Attribute("cl", resetCL));
        }
        if (pageType != null) {
            meta.addAttribute(new Attribute("pageType", pageType));
        }
        if (combined) {
            meta.addAttribute(new Attribute("combined", "true"));
        }
        if (blank) {
            meta.addAttribute(new Attribute("blank", "true"));
        }
        if (!((charSequence = (CharSequence)volume) == null || charSequence.length() == 0)) {
            meta.addAttribute(new Attribute("pageVolume", volume));
        }
        if (skip) {
            meta.addAttribute(new Attribute("skip", "true"));
        }
        if (!runHead) {
            meta.addAttribute(new Attribute("runHead", "false"));
        }
        return meta;
    }

    private final void addNewChangeMeta(Document doc, String type, String originalStr, String newStr, String resetCL, String pageType, boolean combined, boolean blank, String volume, boolean skip, boolean runHead) {
        block0: {
            Element head = UTDHelper.getDocumentHead(doc.getDocument());
            Element meta = this.addMeta(type, originalStr, newStr, resetCL, pageType, combined, blank, volume, skip, runHead);
            Element element = head;
            if (element == null) break block0;
            element.appendChild((Node)meta);
        }
    }

    @JvmStatic
    @Nullable
    public static final Element findPrintPageChange(@NotNull Document doc, @NotNull String originalNum) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        return INSTANCE.findPageChange(doc, originalNum, PRINT);
    }

    @JvmStatic
    @Nullable
    public static final Element findBraillePageChange(@NotNull Document doc, @NotNull String originalNum) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        return INSTANCE.findPageChange(doc, originalNum, BRL);
    }

    @Nullable
    public final Element findPrintPageCombiner(@Nullable Document doc, @NotNull String originalNum) {
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        List<Element> metas = MetadataHelper.getUTDMeta(doc);
        for (Element meta : metas) {
            if (!Intrinsics.areEqual((Object)PRINT, (Object)meta.getAttributeValue("type")) || !Intrinsics.areEqual((Object)originalNum, (Object)meta.getAttributeValue("original")) || !Intrinsics.areEqual((Object)"true", (Object)meta.getAttributeValue("combined"))) continue;
            return meta;
        }
        return null;
    }

    private final Element findPageChange(Document doc, String originalNum, String type) {
        String curOriginalNum = originalNum;
        List<Element> metas = MetadataHelper.getUTDMeta(doc);
        Element resultMeta = null;
        for (Element meta : metas) {
            if (!Intrinsics.areEqual((Object)type, (Object)meta.getAttributeValue("type"))) continue;
            if (Intrinsics.areEqual((Object)curOriginalNum, (Object)meta.getAttributeValue("original"))) {
                resultMeta = this.combineElementAttributes(resultMeta, meta);
            }
            if (resultMeta == null) continue;
            resultMeta = this.adaptNewPageNumber(resultMeta, meta);
            Intrinsics.checkNotNullExpressionValue((Object)resultMeta.getAttributeValue("original"), (String)"getAttributeValue(...)");
        }
        return resultMeta;
    }

    public final void markUsed(@Nullable Document doc, @NotNull String originalNum, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)originalNum, (String)"originalNum");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List<Element> metas = MetadataHelper.getUTDMeta(doc);
        if (!((Collection)metas).isEmpty()) {
            for (Element meta : metas) {
                if (!Intrinsics.areEqual((Object)type, (Object)meta.getAttributeValue("type")) || !Intrinsics.areEqual((Object)originalNum, (Object)meta.getAttributeValue("original"))) continue;
                meta.addAttribute(new Attribute("used", "true"));
            }
        }
    }

    private final Element combineElementAttributes(Element oldMeta, Element newMeta) {
        if (oldMeta == null) {
            return newMeta;
        }
        int n = oldMeta.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (newMeta.getAttribute(oldMeta.getAttribute(i).getLocalName()) != null || Intrinsics.areEqual((Object)oldMeta.getAttribute(i).getLocalName(), (Object)"runHead")) continue;
            Attribute temp = new Attribute(oldMeta.getAttribute(i).getLocalName(), oldMeta.getAttribute(i).getValue());
            newMeta.addAttribute(temp);
        }
        return newMeta;
    }

    private final Element adaptNewPageNumber(Element baseMeta, Element newMeta) {
        Element adaptedMeta = baseMeta.copy();
        if (baseMeta.getAttribute("new") != null && Intrinsics.areEqual((Object)baseMeta.getAttributeValue("new"), (Object)newMeta.getAttributeValue("original"))) {
            if (newMeta.getAttribute("new") != null) {
                adaptedMeta.addAttribute(new Attribute("new", newMeta.getAttributeValue("new")));
            }
            if (newMeta.getAttribute("cl") != null) {
                adaptedMeta.addAttribute(new Attribute("cl", newMeta.getAttributeValue("cl")));
            }
            if (newMeta.getAttribute("pageType") != null) {
                adaptedMeta.addAttribute(new Attribute("pageType", newMeta.getAttributeValue("pageType")));
            } else {
                adaptedMeta.addAttribute(new Attribute(newMeta.getAttribute(newMeta.getAttributeCount() - 1).getLocalName(), newMeta.getAttribute(newMeta.getAttributeCount() - 1).getValue()));
            }
            if (baseMeta.getAttribute("runHead") != null && newMeta.getAttribute("runHead") == null) {
                adaptedMeta.removeAttribute(adaptedMeta.getAttribute("runHead"));
            }
            if (newMeta.getAttribute("blank") == null) {
                newMeta.addAttribute(new Attribute("used", "true"));
            }
        }
        Intrinsics.checkNotNull((Object)adaptedMeta);
        return adaptedMeta;
    }

    @JvmStatic
    @NotNull
    public static final List<Element> getUTDMeta(@Nullable Document doc) {
        List returnList = new ArrayList();
        Element head = UTDHelper.getDocumentHead(doc);
        if (head != null) {
            int n = head.getChildElements().size();
            for (int i = 0; i < n; ++i) {
                if (!UTDElements.META.isA((Node)head.getChildElements().get(i))) continue;
                Element element = head.getChildElements().get(i);
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
                returnList.add(element);
            }
        }
        return returnList;
    }
}

