/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.properties.PageNumberType;
import org.brailleblaster.utd.utils.TextTranslator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\fJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010&\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010'\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0007J\u0016\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0007R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u001eR\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010$\u00a8\u0006)"}, d2={"Lorg/brailleblaster/utd/PageNumberTracker;", "", "numberType", "Lorg/brailleblaster/utd/properties/PageNumberType;", "<init>", "(Lorg/brailleblaster/utd/properties/PageNumberType;)V", "pageNumber", "", "isContinue", "", "(ILorg/brailleblaster/utd/properties/PageNumberType;Z)V", "old", "(Lorg/brailleblaster/utd/PageNumberTracker;)V", "pageNumbers", "", "value", "pageNumberType", "getPageNumberType", "()Lorg/brailleblaster/utd/properties/PageNumberType;", "padding", "getPadding", "()I", "resetOnNextPage", "nextPageNumberType", "resetNumberCounters", "", "resetNextPageNumberCounters", "page", "getPageNumber", "setPageNumber", "(I)V", "getBraillePageNumber", "", "engine", "Lorg/brailleblaster/utd/ITranslationEngine;", "braillePageNumber", "()Ljava/lang/String;", "nextPage", "setPageNumberType", "setPageNumberTypeContinue", "setPadding", "utd"})
public final class PageNumberTracker {
    @NotNull
    private final Map<PageNumberType, Integer> pageNumbers;
    private PageNumberType pageNumberType;
    private int padding;
    private boolean resetOnNextPage;
    @Nullable
    private PageNumberType nextPageNumberType;

    @NotNull
    public final PageNumberType getPageNumberType() {
        PageNumberType pageNumberType = this.pageNumberType;
        if (pageNumberType != null) {
            return pageNumberType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNumberType");
        return null;
    }

    public final int getPadding() {
        return this.padding;
    }

    @JvmOverloads
    public PageNumberTracker(@NotNull PageNumberType numberType) {
        Intrinsics.checkNotNullParameter((Object)((Object)numberType), (String)"numberType");
        this(1, numberType, false);
    }

    public /* synthetic */ PageNumberTracker(PageNumberType pageNumberType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pageNumberType = PageNumberType.NORMAL;
        }
        this(pageNumberType);
    }

    public PageNumberTracker(int pageNumber, @NotNull PageNumberType numberType, boolean isContinue) {
        Intrinsics.checkNotNullParameter((Object)((Object)numberType), (String)"numberType");
        this.pageNumbers = new EnumMap(PageNumberType.class);
        this.resetNumberCounters(pageNumber, numberType, isContinue);
        this.padding = 3;
    }

    private final void resetNumberCounters(int pageNumber, PageNumberType numberType, boolean isContinue) {
        for (PageNumberType nt : PageNumberType.getEntries()) {
            if (isContinue && nt == PageNumberType.NORMAL) continue;
            this.pageNumbers.put(nt, 0);
        }
        this.pageNumbers.put(numberType, pageNumber);
        this.pageNumberType = numberType;
    }

    public final void resetNumberCounters(@NotNull PageNumberType numberType, boolean isContinue) {
        Intrinsics.checkNotNullParameter((Object)((Object)numberType), (String)"numberType");
        this.resetNumberCounters(1, numberType, isContinue);
    }

    public final void resetNextPageNumberCounters(@NotNull PageNumberType numberType) {
        Intrinsics.checkNotNullParameter((Object)((Object)numberType), (String)"numberType");
        this.nextPageNumberType = numberType;
    }

    public PageNumberTracker(@NotNull PageNumberTracker old) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        this.pageNumbers = new HashMap<PageNumberType, Integer>(old.pageNumbers);
        this.pageNumberType = old.getPageNumberType();
        this.padding = old.padding;
    }

    public final int getPageNumber() {
        return ((Number)this.pageNumbers.getOrDefault((Object)this.getPageNumberType(), 0)).intValue();
    }

    public final void setPageNumber(int page) {
        this.setPageNumber(this.getPageNumberType(), page);
    }

    @NotNull
    public final String getBraillePageNumber(@NotNull ITranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getPageNumberType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return TextTranslator.translateText$default(this.getPageNumberType().getFormattedPageNumber(this.getPageNumber()), engine, (short)0, null, 12, null);
    }

    @NotNull
    public final String getBraillePageNumber() {
        return this.getPageNumberType().getFormattedPageNumber(this.getPageNumber());
    }

    @NotNull
    public final PageNumberTracker nextPage(@NotNull PageNumberType pageNumberType, boolean isContinue) {
        Intrinsics.checkNotNullParameter((Object)((Object)pageNumberType), (String)"pageNumberType");
        PageNumberTracker result = new PageNumberTracker(this);
        PageNumberType pageNumberType2 = this.nextPageNumberType;
        if (pageNumberType2 != null) {
            PageNumberType it = pageNumberType2;
            boolean bl = false;
            result.resetNumberCounters(1, it, isContinue);
            result.resetOnNextPage = false;
        }
        this.nextPageNumberType = null;
        int newPageNumber = this.getPageNumber() + 1;
        result.pageNumbers.put(pageNumberType, newPageNumber);
        result.pageNumberType = pageNumberType;
        return result;
    }

    public final void setPageNumberType(@NotNull PageNumberType pageNumberType, boolean isContinue) {
        Intrinsics.checkNotNullParameter((Object)((Object)pageNumberType), (String)"pageNumberType");
        if (!isContinue || pageNumberType != PageNumberType.NORMAL) {
            this.pageNumbers.put(pageNumberType, 1);
        }
        this.pageNumberType = pageNumberType;
    }

    public final void setPageNumberTypeContinue(@NotNull PageNumberType pageNumberType) {
        Intrinsics.checkNotNullParameter((Object)((Object)pageNumberType), (String)"pageNumberType");
        this.pageNumberType = pageNumberType;
        int pageNumber = this.getPageNumber();
        if (pageNumber == 0) {
            pageNumber = 1;
        }
        this.pageNumbers.put(pageNumberType, pageNumber);
    }

    @NotNull
    public final PageNumberTracker setPadding(int padding) {
        PageNumberTracker result = new PageNumberTracker(this);
        result.padding = padding;
        return result;
    }

    public final void setPageNumber(@NotNull PageNumberType pageNumberType, int page) {
        Intrinsics.checkNotNullParameter((Object)((Object)pageNumberType), (String)"pageNumberType");
        this.pageNumbers.put(pageNumberType, page);
    }

    @JvmOverloads
    public PageNumberTracker() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PageNumberType.values().length];
            try {
                nArray[PageNumberType.P_PAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PageNumberType.T_PAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PageNumberType.NORMAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

