/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import nu.xom.XPathContext;
import org.apache.commons.lang3.time.StopWatch;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.exceptions.UTDTranslateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010 \u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\tJ(\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u00112\b\u0010'\u001a\u0004\u0018\u00010\tJ \u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\t\u00a8\u0006-"}, d2={"Lorg/brailleblaster/utd/TableOfContents;", "", "<init>", "()V", "applyTOC", "", "keyword", "", "document", "Lnu/xom/Document;", "location", "Lnu/xom/Node;", "updatePrintTOC", "exploreList", "parentList", "Lnu/xom/Element;", "listNumber", "", "findTOCGuess", "doc", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "findTOCDocumentPearson", "findTOCDocumentDaisyOfficial", "findTOCDaisyOfficial", "context", "Lnu/xom/XPathContext;", "tocRoot", "depth", "results", "", "Lorg/brailleblaster/utd/TableOfContents$TOCEntry;", "generateTOC", "parseXML", "inputDocument", "exploreLevel", "rootElement", "listElement", "levelNum", "tocDocument", "addHeadingInfo", "heading", "appendTo", "TOCEntry", "Companion", "utd"})
@SourceDebugExtension(value={"SMAP\nTableOfContents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableOfContents.kt\norg/brailleblaster/utd/TableOfContents\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,579:1\n106#2:580\n78#2,22:581\n106#2:604\n78#2,22:605\n1#3:603\n*S KotlinDebug\n*F\n+ 1 TableOfContents.kt\norg/brailleblaster/utd/TableOfContents\n*L\n102#1:580\n102#1:581,22\n201#1:604\n201#1:605,22\n*E\n"})
public final class TableOfContents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> SIGNIFICANT_MARKUP;
    @NotNull
    private static final List<String> HEADER_MARKUP;
    @NotNull
    private static final List<String> TOP_STOP_TAGS;
    @NotNull
    private static final List<String> TOP_CONTAINS_TAGS;
    @NotNull
    private static final Pattern STRIP_TAGS;
    @NotNull
    private static final Logger log;

    public final void applyTOC(@NotNull String keyword, @NotNull Document document, @Nullable Node location) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (Intrinsics.areEqual((Object)keyword, (Object)"update")) {
            this.updatePrintTOC(document);
        } else if (Intrinsics.areEqual((Object)keyword, (Object)"generate")) {
            if (location == null) {
                this.generateTOC(document);
            } else {
                this.generateTOC(document, location);
            }
        } else {
            throw new IllegalArgumentException("Keywords accepted: update, generate.");
        }
    }

    public final void updatePrintTOC(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Nodes listNodes = document.query("descendant::*[contains(name(), 'list')][@class=\"toc\" and @depth=\"1\"]");
        int n = listNodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = listNodes.get(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            this.exploreList(document, (Element)node, 1);
        }
    }

    public final void exploreList(@NotNull Document document, @NotNull Element parentList, int listNumber) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)parentList, (String)"parentList");
        Nodes unitGroup = parentList.query("child::*[contains(name(), 'li')]");
        int n = unitGroup.size();
        for (int i = 0; i < n; ++i) {
            Element element;
            String str;
            String headText;
            Node heading;
            Nodes pages;
            String $this$trim$iv;
            Node tocTitle = unitGroup.get(i).query("child::*[contains(name(), 'lic')][@class='toc']").get(0);
            Node title = tocTitle.query("child::text()").get(0);
            Intrinsics.checkNotNullExpressionValue((Object)title.getValue(), (String)"getValue(...)");
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if ((pages = (heading = document.query(headText = "descendant::*[contains(name(), 'h" + listNumber + "')][contains(.,'" + (str = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()) + "')]").get(0)).query("descendant::*[contains(name(), 'newPage')][1]")).size() == 0) {
                Node node = heading.query("preceding::*[contains(name(), 'newPage')][1]").get(0);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                element = (Element)node;
            } else {
                Node node = pages.get(0);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                element = (Element)node;
            }
            Element newpage = element;
            Node node = unitGroup.get(i).query("child::*[contains(name(), 'lic')][@class=\"tocpage\"]").get(0);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element tocPage = (Element)node;
            tocPage.removeChildren();
            Node brlNumber = (Node)new Text(newpage.getAttributeValue("brlnum"));
            Node dots = (Node)new Element("dots");
            Element brlElement = new Element("brl");
            brlElement.appendChild(dots);
            brlElement.appendChild(brlNumber);
            tocPage.appendChild((Node)brlElement);
            Nodes hasList = unitGroup.get(i).query("child::*[contains(name(), 'list')]");
            if (hasList.size() <= 0) continue;
            Node node2 = unitGroup.get(i).query("child::*[contains(name(), 'list')]").get(0);
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element nextList = (Element)node2;
            String string = nextList.getAttributeValue("depth");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            int listNum = Integer.parseInt(string);
            this.exploreList(document, nextList, listNum);
        }
    }

    public final void findTOCGuess(@NotNull Document doc, @NotNull UTDTranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        XPathContext context = engine.getActionMap().getNamespaces().getXPathContext();
        Element rootElement = doc.getRootElement();
        Nodes tocRoots = rootElement.query("descendant::dsy:list[@class='toc' and @depth='1']", context);
        if (tocRoots.size() == 0) {
            log.warn("No TOC list found, using contents level");
            tocRoots = rootElement.query("descendant::dsy:*[contains(name(), 'level')][@class='contents'][1]", context);
            if (tocRoots.size() == 0) {
                throw new UTDTranslateException("Unable to find TOC");
            }
        }
        int n = tocRoots.size();
        block0: for (int i = 0; i < n; ++i) {
            Node node = tocRoots.get(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element curRoot = (Element)node;
            log.debug("Found {}", (Object)curRoot);
            TableOfContents.Companion.detachAll(curRoot, "descendant::dsy:*[@id='NIMAS9780133268195-lvl3-0001']", context);
            TableOfContents.Companion.detachAll(curRoot, "descendant::dsy:sidebar", context);
            TableOfContents.Companion.detachAll(curRoot, "descendant::dsy:pagenum", context);
            TableOfContents.Companion.detachAll(curRoot, "descendant::dsy:img", context);
            Nodes results = null;
            while (true) {
                String $this$trim$iv;
                String parentTag;
                Nodes nodes;
                Nodes it = nodes = curRoot.query("descendant::text()[1]");
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                results = it;
                if (nodes.size() == 0) continue block0;
                Node node2 = results.get(0);
                Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Text");
                Text curText = (Text)node2;
                ParentNode parentNode = curText.getParent();
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element searchParent = (Element)parentNode;
                Intrinsics.checkNotNullExpressionValue((Object)searchParent.getLocalName(), (String)"getLocalName(...)");
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string = bl.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (HEADER_MARKUP.contains(string)) {
                    log.debug("---HEADER--- {}", (Object)searchParent.toXML());
                    searchParent.detach();
                    continue;
                }
                while (!TOP_STOP_TAGS.contains(parentTag = searchParent.getLocalName())) {
                    ParentNode parentNode2 = searchParent.getParent();
                    Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
                    searchParent = (Element)parentNode2;
                }
                String value = searchParent.toXML();
                searchParent.detach();
                Intrinsics.checkNotNullExpressionValue((Object)STRIP_TAGS.matcher(value).replaceAll(""), (String)"replaceAll(...)");
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String numRaw = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                StringBuilder numBuilder = new StringBuilder();
                boolean inDigit = false;
                for (int k = numRaw.length() - 1; -1 < k; --k) {
                    char curChar = numRaw.charAt(k);
                    if (inDigit) {
                        if (!Character.isDigit(curChar)) break;
                        numBuilder.insert(0, curChar);
                        continue;
                    }
                    if (!Character.isDigit(curChar)) continue;
                    inDigit = true;
                    numBuilder.insert(0, curChar);
                }
                Intrinsics.checkNotNull((Object)value);
                String string2 = numBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String finalText = StringsKt.replace$default((String)value, (String)string2, (String)"", (boolean)false, (int)4, null);
                log.debug("Found digit {} in {}", (Object)numBuilder, (Object)finalText);
            }
        }
    }

    public final void findTOCDocumentPearson(@NotNull Document doc, @NotNull UTDTranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        XPathContext context = engine.getActionMap().getNamespaces().getXPathContext();
        Nodes rootResults = doc.getRootElement().query("descendant::dsy:*[contains(name(), 'level')][@class='contents']", context);
        if (rootResults.size() == 0) {
            throw new UTDTranslateException("Cannot find any TOC");
        }
        if (rootResults.size() > 1) {
            log.warn("Found {} levels with contents class", (Object)rootResults.size());
        }
        Node node = rootResults.get(0);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element root = (Element)node;
        log.debug("Found root {}", (Object)root);
    }

    public final void findTOCDocumentDaisyOfficial(@NotNull Document doc, @NotNull UTDTranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        XPathContext context = engine.getActionMap().getNamespaces().getXPathContext();
        StopWatch watch = new StopWatch();
        watch.start();
        Nodes tocRoots = doc.getRootElement().query("descendant::dsy:list[@class='toc' and @depth='1']", context);
        if (tocRoots.size() == 0) {
            throw new RuntimeException("Cannot find contents with size " + tocRoots.size());
        }
        List tocResults = new ArrayList();
        int n = tocRoots.size();
        for (int j = 0; j < n; ++j) {
            Node node = tocRoots.get(j);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            this.findTOCDaisyOfficial(context, (Element)node, 1, tocResults);
        }
        log.debug("------------");
        for (TOCEntry tOCEntry : tocResults) {
            int depth = tOCEntry.component1();
            String title = tOCEntry.component2();
            String page = tOCEntry.component3();
            Object[] objectArray = new Object[]{StringsKt.repeat((CharSequence)"-", (int)depth), page, title};
            log.debug("{} Page {} Title {}", objectArray);
        }
        log.debug("Finished in {}", (Object)watch);
    }

    private final void findTOCDaisyOfficial(XPathContext context, Element tocRoot, int depth, List<TOCEntry> results) {
        Elements childElements = tocRoot.getChildElements("li", context.lookup("dsy"));
        int n = childElements.size();
        for (int i = 0; i < n; ++i) {
            Element tocEntry = childElements.get(i);
            try {
                int nextDepth;
                Nodes subToc;
                String title = null;
                String page = null;
                Nodes titleResult = tocEntry.query("child::dsy:lic[@class='toc']", context);
                Nodes pageResult = tocEntry.query("child::dsy:lic[@class='tocpage']", context);
                if (titleResult.size() == 1 && pageResult.size() == 1) {
                    title = titleResult.get(0).getValue();
                    page = pageResult.get(0).getValue();
                } else if (titleResult.size() == 0 && pageResult.size() == 2) {
                    title = pageResult.get(0).getValue();
                    page = pageResult.get(1).getValue();
                    log.warn("Invalid markup (multiple pages) for TOC title {}", (Object)title);
                } else if (titleResult.size() == 2 && pageResult.size() == 0) {
                    title = titleResult.get(0).getValue();
                    page = titleResult.get(1).getValue();
                    log.warn("Invalid markup (multiple titles) for TOC title {}", (Object)title);
                } else {
                    title = null;
                    page = null;
                    log.warn("Invalid markup (no page or title)");
                }
                if (title != null) {
                    String query = "descendant::dsy:*[contains(name(), 'h')][contains(.,\"" + title + "\")]";
                    Nodes bodyLocationResult = tocEntry.getDocument().query(query, context);
                    Element bodyLocation = null;
                    if (bodyLocationResult.size() != 1) {
                        log.warn("Failed to find header at depth {} query {}", (Object)depth, (Object)query);
                        bodyLocation = null;
                    } else {
                        Node node = bodyLocationResult.get(0);
                        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                        bodyLocation = (Element)node;
                    }
                    if (!((Collection)results).isEmpty()) {
                        String oldpage = results.get(results.size() - 1).page();
                        try {
                            String string = page;
                            Intrinsics.checkNotNull((Object)string);
                            int pageint = Integer.parseInt(string);
                            String string2 = oldpage;
                            Intrinsics.checkNotNull((Object)string2);
                            int oldpageint = Integer.parseInt(string2);
                            if (pageint < oldpageint) {
                                log.warn("Pages out of order old page {} page {}", (Object)oldpage, (Object)page);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    Intrinsics.checkNotNull((Object)tocEntry);
                    results.add(new TOCEntry(depth, title, page, tocEntry, bodyLocation));
                }
                if ((subToc = tocEntry.query("child::dsy:list[@depth='" + (nextDepth = depth + 1) + "']", context)).size() != 1) continue;
                Node node = subToc.get(0);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                this.findTOCDaisyOfficial(context, (Element)node, nextDepth, results);
                continue;
            }
            catch (UTDTranslateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UTDTranslateException("Failed on node " + tocEntry.toXML(), e);
            }
        }
    }

    public final void generateTOC(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element newTOC = this.parseXML(document);
        Node node = document.query("descendant::*[contains(name(), 'frontmatter')]").get(0);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element frontmatter = (Element)node;
        Node newTOCNode = newTOC.getChild(0).copy();
        Element level1 = new Element("level1");
        Element h1 = new Element("h1");
        h1.appendChild("Table of Contents");
        level1.appendChild((Node)h1);
        level1.appendChild(newTOCNode);
        frontmatter.appendChild((Node)level1);
    }

    public final void generateTOC(@NotNull Document document, @NotNull Node location) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Element newTOC = this.parseXML(document);
        Node newTOCNode = newTOC.getChild(0).copy();
        ParentNode parent = location.getParent();
        parent.insertChild(newTOCNode, parent.indexOf(location));
    }

    @NotNull
    public final Element parseXML(@NotNull Document inputDocument) {
        Intrinsics.checkNotNullParameter((Object)inputDocument, (String)"inputDocument");
        Element root = new Element("table");
        Node node = inputDocument.query("descendant::*[contains(name(), 'book')]").get(0);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element rootElement = (Element)node;
        Element addOne = new Element("list");
        addOne.addAttribute(new Attribute("class", "toc"));
        addOne.addAttribute(new Attribute("depth", "1"));
        addOne.addAttribute(new Attribute("type", "ol"));
        root.appendChild((Node)addOne);
        this.exploreLevel(rootElement, addOne, 1, inputDocument);
        return root;
    }

    public final void exploreLevel(@NotNull Element rootElement, @NotNull Element listElement, int levelNum, @Nullable Document tocDocument) {
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        Intrinsics.checkNotNullParameter((Object)listElement, (String)"listElement");
        String searchLevel = "level" + levelNum;
        Nodes levelList = rootElement.query("descendant::*[contains(name(), '" + searchLevel + "')]");
        int n = levelList.size();
        for (int i = 0; i < n; ++i) {
            int next;
            String nextLevel;
            String xpath;
            Node node = levelList.get(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element levelE = (Element)node;
            Element li = new Element("li");
            li.addAttribute(new Attribute("semantics", "style, list"));
            listElement.appendChild((Node)li);
            String hTag = "h" + levelNum;
            Nodes headE = levelE.query("descendant::*[contains(name(), '" + hTag + "')]");
            if (headE.size() > 0) {
                Node node2 = headE.get(0);
                Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                this.addHeadingInfo((Element)node2, li, tocDocument);
            }
            if (levelE.query(xpath = "descendant::*[contains(name(), '" + (nextLevel = "level" + (next = levelNum + 1)) + "')]").size() == 0) continue;
            Element nextList = new Element("list");
            nextList.addAttribute(new Attribute("class", "toc"));
            nextList.addAttribute(new Attribute("depth", String.valueOf(next)));
            nextList.addAttribute(new Attribute("type", "ol"));
            li.appendChild((Node)nextList);
            this.exploreLevel(levelE, nextList, next, tocDocument);
        }
    }

    public final void addHeadingInfo(@NotNull Element heading, @NotNull Element appendTo, @Nullable Document tocDocument) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        Intrinsics.checkNotNullParameter((Object)appendTo, (String)"appendTo");
        Element lic = new Element("lic");
        lic.addAttribute(new Attribute("class", "toc"));
        Element licPage = new Element("lic");
        licPage.addAttribute(new Attribute("class", "tocpage"));
        int n = heading.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node addNode = heading.getChild(i).copy();
            if (addNode instanceof Text) {
                lic.appendChild(addNode);
            }
            if (!(addNode instanceof Element) || ((Element)addNode).query("self::*[contains(name(), 'brl')]").size() <= 0) continue;
            Nodes notText = ((Element)addNode).query("child::node()[not(self::text())]");
            if (notText.size() != 0) {
                int n2 = notText.size();
                for (int k = 0; k < n2; ++k) {
                    ((Element)addNode).removeChild(notText.get(k));
                }
            }
            lic.appendChild(addNode);
        }
        appendTo.appendChild((Node)lic);
        log.debug("Heading {}", (Object)heading.toXML());
        Nodes pages = heading.query("descendant::*[contains(name(), 'pagenum')][1]");
        if (pages.size() == 0) {
            Node node = heading.query("preceding::*[contains(name(), 'pagenum')]").get(0);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            element = (Element)node;
        } else {
            Node node = pages.get(0);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            element = (Element)node;
        }
        Element newpage = element;
        Node dots = (Node)new Element("dots");
        Element brlElement = new Element("brl");
        brlElement.appendChild(dots);
        brlElement.appendChild(newpage.getValue());
        licPage.appendChild((Node)brlElement);
        appendTo.appendChild((Node)licPage);
    }

    static {
        Object[] objectArray = new String[]{"em", "strong", "p"};
        SIGNIFICANT_MARKUP = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"h1", "h2", "h3", "h4", "hd"};
        HEADER_MARKUP = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"list", "level1", "level2", "level3", "level4", "level5", "li"};
        TOP_STOP_TAGS = CollectionsKt.listOf((Object[])objectArray);
        TOP_CONTAINS_TAGS = CollectionsKt.listOf((Object)"li");
        Pattern pattern = Pattern.compile("<.+?>");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        STRIP_TAGS = pattern;
        Logger logger = LoggerFactory.getLogger(TableOfContents.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/utd/TableOfContents$Companion;", "", "<init>", "()V", "SIGNIFICANT_MARKUP", "", "", "HEADER_MARKUP", "TOP_STOP_TAGS", "TOP_CONTAINS_TAGS", "STRIP_TAGS", "Ljava/util/regex/Pattern;", "detachAll", "", "root", "Lnu/xom/Element;", "xpath", "context", "Lnu/xom/XPathContext;", "log", "Lorg/slf4j/Logger;", "utd"})
    public static final class Companion {
        private Companion() {
        }

        private final void detachAll(Element root, String xpath, XPathContext context) {
            int i;
            Nodes results = root.query(xpath, context);
            for (i = 0; i < results.size(); ++i) {
                results.get(i).detach();
            }
            log.debug("Removed {} elements with query '{}'", (Object)i, (Object)xpath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u000f\u001a\u00020\u0005H\u0096\u0080\u0004J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u00c6\u0003J?\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0083\u0004J\n\u0010\u001a\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000eR\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/brailleblaster/utd/TableOfContents$TOCEntry;", "Ljava/lang/Record;", "depth", "", "title", "", "page", "tocElement", "Lnu/xom/Element;", "bookElement", "<init>", "(ILjava/lang/String;Ljava/lang/String;Lnu/xom/Element;Lnu/xom/Element;)V", "()I", "()Ljava/lang/String;", "()Lnu/xom/Element;", "toString", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "utd"})
    public static final class TOCEntry
    extends Record {
        private final int depth;
        @NotNull
        private final String title;
        @Nullable
        private final String page;
        @NotNull
        private final Element tocElement;
        @Nullable
        private final Element bookElement;

        public TOCEntry(int depth, @NotNull String title, @Nullable String page, @NotNull Element tocElement, @Nullable Element bookElement) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)tocElement, (String)"tocElement");
            this.depth = depth;
            this.title = title;
            this.page = page;
            this.tocElement = tocElement;
            this.bookElement = bookElement;
        }

        public final int depth() {
            return this.depth;
        }

        @NotNull
        public final String title() {
            return this.title;
        }

        @Nullable
        public final String page() {
            return this.page;
        }

        @NotNull
        public final Element tocElement() {
            return this.tocElement;
        }

        @Nullable
        public final Element bookElement() {
            return this.bookElement;
        }

        @Override
        @NotNull
        public String toString() {
            return "Depth " + this.depth + " Page " + this.page + " Title '" + this.title + "'";
        }

        public final int component1() {
            return this.depth;
        }

        @NotNull
        public final String component2() {
            return this.title;
        }

        @Nullable
        public final String component3() {
            return this.page;
        }

        @NotNull
        public final Element component4() {
            return this.tocElement;
        }

        @Nullable
        public final Element component5() {
            return this.bookElement;
        }

        @NotNull
        public final TOCEntry copy(int depth, @NotNull String title, @Nullable String page, @NotNull Element tocElement, @Nullable Element bookElement) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)tocElement, (String)"tocElement");
            return new TOCEntry(depth, title, page, tocElement, bookElement);
        }

        public static /* synthetic */ TOCEntry copy$default(TOCEntry tOCEntry, int n, String string, String string2, Element element, Element element2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = tOCEntry.depth;
            }
            if ((n2 & 2) != 0) {
                string = tOCEntry.title;
            }
            if ((n2 & 4) != 0) {
                string2 = tOCEntry.page;
            }
            if ((n2 & 8) != 0) {
                element = tOCEntry.tocElement;
            }
            if ((n2 & 0x10) != 0) {
                element2 = tOCEntry.bookElement;
            }
            return tOCEntry.copy(n, string, string2, element, element2);
        }

        @Override
        public int hashCode() {
            int result = Integer.hashCode(this.depth);
            result = result * 31 + this.title.hashCode();
            result = result * 31 + (this.page == null ? 0 : this.page.hashCode());
            result = result * 31 + this.tocElement.hashCode();
            result = result * 31 + (this.bookElement == null ? 0 : this.bookElement.hashCode());
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TOCEntry)) {
                return false;
            }
            TOCEntry tOCEntry = (TOCEntry)other;
            if (this.depth != tOCEntry.depth) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)tOCEntry.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.page, (Object)tOCEntry.page)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tocElement, (Object)tOCEntry.tocElement)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.bookElement, (Object)tOCEntry.bookElement);
        }
    }
}

