/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.actions;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.TextSpan;
import org.brailleblaster.utd.actions.GenericBlockAction;
import org.brailleblaster.utd.actions.IBlockAction;
import org.brailleblaster.utd.properties.BrailleTableType;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.TextTranslator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/utd/actions/InsertUncontractedAction;", "Lorg/brailleblaster/utd/actions/IBlockAction;", "<init>", "()V", "action", "Lorg/brailleblaster/utd/actions/GenericBlockAction;", "getAction", "()Lorg/brailleblaster/utd/actions/GenericBlockAction;", "setAction", "(Lorg/brailleblaster/utd/actions/GenericBlockAction;)V", "applyTo", "", "Lorg/brailleblaster/utd/TextSpan;", "node", "Lnu/xom/Node;", "context", "Lorg/brailleblaster/utd/ITranslationEngine;", "processNode", "element", "Lnu/xom/Element;", "engine", "utd"})
public final class InsertUncontractedAction
implements IBlockAction {
    @NotNull
    private GenericBlockAction action = new GenericBlockAction();

    @NotNull
    public final GenericBlockAction getAction() {
        return this.action;
    }

    public final void setAction(@NotNull GenericBlockAction genericBlockAction) {
        Intrinsics.checkNotNullParameter((Object)genericBlockAction, (String)"<set-?>");
        this.action = genericBlockAction;
    }

    @Override
    @NotNull
    public List<TextSpan> applyTo(@NotNull Node node, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (node instanceof Element && ((Element)node).getAttribute("translated") == null) {
            return this.processNode((Element)node, context);
        }
        return CollectionsKt.emptyList();
    }

    private final List<TextSpan> processNode(Element element, ITranslationEngine engine) {
        Element brl = UTDElements.BRL.create();
        Element span = new Element("span");
        span.addAttribute(new Attribute("type", "pronunciation"));
        span.addAttribute(new Attribute("translated", "true"));
        String string = element.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String translatedText = " " + TextTranslator.translateText$default(string, engine, (short)0, BrailleTableType.UNCONTRACTED, 4, null) + " ";
        element.appendChild((Node)span);
        brl.addAttribute(new Attribute("type", "pronunciation"));
        brl.addAttribute(new Attribute("value", translatedText));
        span.appendChild((Node)brl);
        return new ArrayList(this.action.applyTo((Node)element, engine));
    }
}

