/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.actions;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.MetadataHelper;
import org.brailleblaster.utd.TextSpan;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.TextTranslator;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0013H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/brailleblaster/utd/actions/PageAction;", "Lorg/brailleblaster/utd/actions/IAction;", "<init>", "()V", "printPage", "", "getPrintPage", "()Ljava/lang/String;", "setPrintPage", "(Ljava/lang/String;)V", "translatedPage", "applyTo", "", "Lorg/brailleblaster/utd/TextSpan;", "node", "Lnu/xom/Node;", "context", "Lorg/brailleblaster/utd/ITranslationEngine;", "processPageNode", "Lnu/xom/Element;", "engine", "translateTextChildren", "", "unwrap", "", "normalize", "getTypeForm", "", "emphasis", "getAttributeValue", "utd"})
public final class PageAction
implements IAction {
    @NotNull
    private String printPage = "";
    @NotNull
    private String translatedPage = "";

    @NotNull
    public final String getPrintPage() {
        return this.printPage;
    }

    public final void setPrintPage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.printPage = string;
    }

    @Override
    @NotNull
    public List<TextSpan> applyTo(@NotNull Node node, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.printPage = "";
        this.translatedPage = "";
        return node instanceof Element ? this.processPageNode((Element)node, context) : CollectionsKt.emptyList();
    }

    private final List<TextSpan> processPageNode(Element node, ITranslationEngine engine) {
        Text textChild = UTDHelper.getTextChild(node);
        if (UTDHelper.getAssociatedBrlElement((Node)textChild) != null) {
            return CollectionsKt.emptyList();
        }
        Element brl = UTDElements.BRL.create();
        String ppOverride = "";
        String translatedOverride = "";
        if (node.getAttribute("utd-pnOverride") != null) {
            String string = node.getAttributeValue("utd-pnOverride");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            ppOverride = string;
        }
        this.translateTextChildren(node, engine, false);
        this.normalize(node);
        if (((CharSequence)ppOverride).length() > 0) {
            translatedOverride = TextTranslator.translateText$default(ppOverride, engine, (short)0, null, 12, null);
        }
        brl.addAttribute(new Attribute("printPage", this.printPage));
        brl.addAttribute(new Attribute("printPageBrl", this.translatedPage));
        if (node.getAttribute("utd-pnOverride") != null) {
            brl.addAttribute(new Attribute("printPageOverride", node.getAttributeValue("utd-pnOverride")));
            brl.addAttribute(new Attribute("printPageOverrideBrl", translatedOverride));
        }
        String pageType = this.getAttributeValue(node);
        Element head = UTDHelper.getDocumentHead(node.getDocument());
        if (head != null) {
            Element meta;
            Document document = head.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Element element = meta = MetadataHelper.findPrintPageChange(document, this.translatedPage);
            if ((element != null ? element.getAttribute("pageType") : null) != null) {
                String string = meta.getAttributeValue("pageType");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                pageType = string;
            }
        }
        brl.addAttribute(new Attribute("pageType", pageType));
        node.appendChild((Node)brl);
        return CollectionsKt.emptyList();
    }

    private final void translateTextChildren(Element node, ITranslationEngine engine, boolean unwrap) {
        if (unwrap) {
            this.unwrap(node);
        }
        StringBuilder sb1 = new StringBuilder(this.printPage);
        StringBuilder sb2 = new StringBuilder(this.translatedPage);
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (node.getChild(i) instanceof Text) {
                sb1.append(node.getChild(i).getValue());
                short typeForm = 0;
                if (node.getAttribute("emphasis", node.getNamespaceURI()) != null) {
                    String string = node.getAttributeValue("emphasis", node.getNamespaceURI());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                    typeForm = this.getTypeForm(string);
                }
                String string = node.getChild(i).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                sb2.append(TextTranslator.translateText$default(string, engine, typeForm, null, 8, null));
                continue;
            }
            if (!(node.getChild(i) instanceof Element)) continue;
            Node node2 = node.getChild(i);
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
            this.translateTextChildren((Element)node2, engine, true);
        }
        String string = sb1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.printPage = string;
        String string2 = sb2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.translatedPage = string2;
    }

    private final void unwrap(Element node) {
        ParentNode parentNode = node.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        int index = parent.indexOf((Node)node);
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            parent.insertChild(node.getChild(i).copy(), index);
            ++index;
        }
        node.detach();
    }

    private final void normalize(Element node) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i) instanceof Text) {
                text.append(node.getChild(i).getValue());
                node.getChild(i).detach();
                --i;
                continue;
            }
            node.insertChild(text.toString(), i);
            text = new StringBuilder();
            ++i;
        }
        node.appendChild(text.toString());
    }

    private final short getTypeForm(String emphasis) {
        if (Intrinsics.areEqual((Object)emphasis, (Object)"NO_TRANSLATE")) {
            return 2048;
        }
        return Intrinsics.areEqual((Object)emphasis, (Object)"NO_CONTRACT") ? (short)4096 : 0;
    }

    private final String getAttributeValue(Element node) {
        String string;
        if (node.getAttributeValue("page") != null) {
            String string2 = node.getAttributeValue("page");
            if (Intrinsics.areEqual((Object)string2, (Object)"front")) {
                string = "P_PAGE";
            } else if (Intrinsics.areEqual((Object)string2, (Object)"bbAdded")) {
                Nodes pagesBefore = node.query("preceding::node()[@utd-action='PageAction']");
                if (pagesBefore.size() > 0) {
                    Node node2 = pagesBefore.get(pagesBefore.size() - 1);
                    Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                    if (((Element)node2).getAttribute("page") != null) {
                        Node node3 = pagesBefore.get(pagesBefore.size() - 1);
                        Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
                        return this.getAttributeValue((Element)node3);
                    }
                }
                string = "NORMAL";
            } else {
                string = "NORMAL";
            }
        } else {
            string = "NORMAL";
        }
        String pageType = string;
        return pageType;
    }
}

