/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.actions;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.Text;
import nu.xom.xslt.XSLException;
import nu.xom.xslt.XSLTransform;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.TextSpan;
import org.brailleblaster.utd.actions.GenericBlockAction;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.exceptions.UTDTranslateException;
import org.brailleblaster.utd.properties.BrailleTableType;
import org.brailleblaster.utils.MathMLConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010%\u001a\u00020\n2\b\u0010&\u001a\u0004\u0018\u00010'H\u0004J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J&\u0010/\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,2\u0006\u00100\u001a\u00020\u00032\u0006\u0010-\u001a\u00020.H\u0014J\n\u00101\u001a\u000202H\u0096\u0080\u0004J\u0014\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0096\u0082\u0004R\u001c\u0010\u0002\u001a\u00020\u00038\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR*\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R*\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u00138\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R*\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R*\u0010\"\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018\u00a8\u00067"}, d2={"Lorg/brailleblaster/utd/actions/XsltAction;", "Lorg/brailleblaster/utd/actions/GenericBlockAction;", "table", "Lorg/brailleblaster/utd/properties/BrailleTableType;", "<init>", "(Lorg/brailleblaster/utd/properties/BrailleTableType;)V", "getTable", "()Lorg/brailleblaster/utd/properties/BrailleTableType;", "setTable", "transform", "Lnu/xom/xslt/XSLTransform;", "getTransform", "()Lnu/xom/xslt/XSLTransform;", "setTransform", "(Lnu/xom/xslt/XSLTransform;)V", "altTransform", "getAltTransform", "setAltTransform", "value", "", "xsltUri", "getXsltUri", "()Ljava/lang/String;", "setXsltUri", "(Ljava/lang/String;)V", "xsltResource", "getXsltResource", "setXsltResource", "altTagName", "getAltTagName", "setAltTagName", "altXsltUri", "getAltXsltUri", "setAltXsltUri", "altXsltResource", "getAltXsltResource", "setAltXsltResource", "loadXslt", "inStream", "Ljava/io/InputStream;", "applyTo", "", "Lorg/brailleblaster/utd/TextSpan;", "node", "Lnu/xom/Node;", "context", "Lorg/brailleblaster/utd/ITranslationEngine;", "translate", "tableType", "hashCode", "", "equals", "", "other", "", "utd"})
@SourceDebugExtension(value={"SMAP\nXsltAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XsltAction.kt\norg/brailleblaster/utd/actions/XsltAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public class XsltAction
extends GenericBlockAction {
    @NotNull
    private BrailleTableType table;
    protected XSLTransform transform;
    @Nullable
    private XSLTransform altTransform;
    @Nullable
    private String xsltUri;
    @Nullable
    private String xsltResource;
    @Nullable
    private String altTagName;
    @Nullable
    private String altXsltUri;
    @Nullable
    private String altXsltResource;

    @JvmOverloads
    public XsltAction(@NotNull BrailleTableType table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.table = table;
        this.xsltResource = "/org/brailleblaster/utd/xslt/default.xsl";
    }

    public /* synthetic */ XsltAction(BrailleTableType brailleTableType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            brailleTableType = BrailleTableType.LITERARY;
        }
        this(brailleTableType);
    }

    @XmlAttribute
    @NotNull
    public final BrailleTableType getTable() {
        return this.table;
    }

    public final void setTable(@NotNull BrailleTableType brailleTableType) {
        Intrinsics.checkNotNullParameter((Object)((Object)brailleTableType), (String)"<set-?>");
        this.table = brailleTableType;
    }

    @NotNull
    protected final XSLTransform getTransform() {
        XSLTransform xSLTransform = this.transform;
        if (xSLTransform != null) {
            return xSLTransform;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        return null;
    }

    protected final void setTransform(@NotNull XSLTransform xSLTransform) {
        Intrinsics.checkNotNullParameter((Object)xSLTransform, (String)"<set-?>");
        this.transform = xSLTransform;
    }

    @Nullable
    protected final XSLTransform getAltTransform() {
        return this.altTransform;
    }

    protected final void setAltTransform(@Nullable XSLTransform xSLTransform) {
        this.altTransform = xSLTransform;
    }

    @XmlAttribute
    @Nullable
    public final String getXsltUri() {
        return this.xsltUri;
    }

    public final void setXsltUri(@Nullable String value) {
        if (value == null) {
            this.xsltUri = null;
        } else {
            try {
                URI uri = URI.create(value);
                URL url = uri.toURL();
                this.setTransform(this.loadXslt(url.openStream()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Problem loading specified XSLT", e);
            }
            this.xsltUri = value;
            this.setXsltResource(null);
        }
    }

    @XmlAttribute
    @Nullable
    public final String getXsltResource() {
        return this.xsltResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setXsltResource(@Nullable String value) {
        if (value == null) {
            this.xsltResource = null;
        } else {
            try {
                Closeable closeable = this.getClass().getResourceAsStream(value);
                Throwable throwable = null;
                try {
                    InputStream inStream = (InputStream)closeable;
                    boolean bl = false;
                    this.setTransform(this.loadXslt(inStream));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Problem loading specified XSLT", e);
            }
            this.xsltResource = value;
            this.setXsltUri(null);
        }
    }

    @XmlAttribute
    @Nullable
    public final String getAltTagName() {
        return this.altTagName;
    }

    public final void setAltTagName(@Nullable String string) {
        this.altTagName = string;
    }

    @XmlAttribute
    @Nullable
    public final String getAltXsltUri() {
        return this.altXsltUri;
    }

    public final void setAltXsltUri(@Nullable String value) {
        if (value == null) {
            this.altXsltUri = null;
        } else {
            try {
                URI uri = URI.create(value);
                URL url = uri.toURL();
                XSLTransform xSLTransform = this.altTransform = this.loadXslt(url.openStream());
                Intrinsics.checkNotNull((Object)xSLTransform);
                xSLTransform.setParameter("undefinedSymbol", (Object)"!UNDEFINED!");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Problem loading specified XSLT", e);
            }
            this.altXsltUri = value;
            this.setAltXsltResource(null);
        }
    }

    @XmlAttribute
    @Nullable
    public final String getAltXsltResource() {
        return this.altXsltResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAltXsltResource(@Nullable String value) {
        if (value == null) {
            this.altXsltResource = null;
        } else {
            try {
                Closeable closeable = this.getClass().getResourceAsStream(value);
                Throwable throwable = null;
                try {
                    InputStream inStream = (InputStream)closeable;
                    boolean bl = false;
                    XSLTransform xSLTransform = this.altTransform = this.loadXslt(inStream);
                    Intrinsics.checkNotNull((Object)xSLTransform);
                    xSLTransform.setParameter("undefinedSymbol", (Object)"!UNDEFINED!");
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Problem loading specified XSLT", e);
            }
            this.altXsltResource = value;
            this.setAltXsltUri(null);
        }
    }

    @NotNull
    protected final XSLTransform loadXslt(@Nullable InputStream inStream) throws IOException {
        XSLTransform xSLTransform;
        try {
            Builder builder = new Builder();
            Document xsltDoc = builder.build(inStream);
            xSLTransform = new XSLTransform(xsltDoc);
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException("Problem parsing specified XSLT", e);
        }
        catch (XSLException e) {
            throw new IllegalArgumentException("Problem creating XSLTransform", e);
        }
        return xSLTransform;
    }

    @Override
    @NotNull
    public List<TextSpan> applyTo(@NotNull Node node, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.translate(node, this.table, context);
    }

    @Override
    @NotNull
    protected List<TextSpan> translate(@NotNull Node node, @NotNull BrailleTableType tableType, @NotNull ITranslationEngine context) {
        Nodes nodes;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Nodes results = null;
        Text text = MathMLConverter.INSTANCE.convertMathML(node);
        if (text == null) {
            Nodes nodes2;
            try {
                nodes2 = this.getTransform().transform(new Nodes(node));
            }
            catch (XSLException e) {
                throw new RuntimeException("Problem applying the stylesheet", e);
            }
            Nodes nodes3 = nodes2;
            Intrinsics.checkNotNull((Object)nodes3);
            nodes = nodes3;
        } else {
            nodes = new Nodes((Node)text);
        }
        results = nodes;
        StringBuilder textToTranslate = new StringBuilder();
        int e = results.size();
        for (int i = 0; i < e; ++i) {
            Node curNode = results.get(i);
            if (curNode instanceof Text) {
                textToTranslate.append(((Text)curNode).getValue());
                continue;
            }
            if (!(curNode instanceof Element)) continue;
            IAction action = (IAction)context.getActionMap().findValueOrDefault(curNode);
            List<TextSpan> spans = action.applyTo(curNode, context);
            for (TextSpan span : spans) {
                textToTranslate.append(span.getText());
            }
        }
        String string = textToTranslate.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        TextSpan thisSpan = new TextSpan(node, string, null, 4, null);
        List spans = CollectionsKt.listOf((Object)thisSpan);
        try {
            this.translateString(spans, tableType, context);
        }
        catch (UTDTranslateException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new UTDTranslateException("Failed at processing node " + node.toXML(), e3);
        }
        thisSpan.setTranslated(true);
        return spans;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + this.table.hashCode();
        String string = this.xsltResource;
        result = prime * result + (string != null ? string.hashCode() : 0);
        String string2 = this.xsltUri;
        result = prime * result + (string2 != null ? string2.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        XsltAction o = (XsltAction)other;
        return this.table == o.table && Intrinsics.areEqual((Object)this.xsltResource, (Object)o.xsltResource) && Intrinsics.areEqual((Object)this.xsltUri, (Object)o.xsltUri);
    }

    @JvmOverloads
    public XsltAction() {
        this(null, 1, null);
    }
}

