/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.config;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.UnmarshallerHandler;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.converters.DOMConverter;
import nu.xom.converters.SAXConverter;
import org.apache.commons.lang3.StringUtils;
import org.brailleblaster.utd.ActionMap;
import org.brailleblaster.utd.BrailleSettings;
import org.brailleblaster.utd.IActionMap;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.StyleMap;
import org.brailleblaster.utd.config.StyleDefinitions;
import org.brailleblaster.utd.exceptions.UTDException;
import org.brailleblaster.utd.internal.ActionMapAdapter;
import org.brailleblaster.utd.internal.AdaptedActionMap;
import org.brailleblaster.utd.internal.AdaptedStyleMap;
import org.brailleblaster.utd.internal.JAXBUtils;
import org.brailleblaster.utd.internal.StyleMapAdapter;
import org.brailleblaster.utd.internal.StyleOptionsFactory;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 42\u00020\u0001:\u000234B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u001b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dJ$\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00012\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0002J7\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%2\u0006\u0010 \u001a\u00020\n2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0#2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010*\u001a\u00020)2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010+\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010\t\u001a\u00020\n2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030#J\u001a\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010\t\u001a\u00020\n2\b\u0010.\u001a\u0004\u0018\u00010\u0003J \u0010/\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u00100\u001a\u00020\u00032\b\u00101\u001a\u0004\u0018\u00010\u0003J\u001a\u00102\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\b\u00100\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/brailleblaster/utd/config/DocumentUTDConfig;", "", "rootElement", "", "rootNamespace", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "loadPageSettings", "Lorg/brailleblaster/utd/PageSettings;", "doc", "Lnu/xom/Document;", "savePageSettings", "", "pageSettings", "loadBrailleSettings", "Lorg/brailleblaster/utd/BrailleSettings;", "saveBrailleSettings", "brailleSettings", "loadActions", "Lorg/brailleblaster/utd/ActionMap;", "saveActions", "actionMap", "Lorg/brailleblaster/utd/IActionMap;", "loadStyle", "Lorg/brailleblaster/utd/StyleMap;", "styleDefs", "Lorg/brailleblaster/utd/config/StyleDefinitions;", "saveStyle", "styleMap", "Lorg/brailleblaster/utd/IStyleMap;", "saveStyleWithDefs", "saveToDoc", "xomDoc", "jaxbValue", "headClass", "Ljava/lang/Class;", "loadFromDoc", "V", "jaxbClass", "(Lnu/xom/Document;Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/Object;", "getHeadElement", "Lnu/xom/Element;", "getOrCreateHeadElement", "getRootNamespace", "getConfigElement", "tagClass", "elementName", "setSetting", "key", "value", "getSetting", "IgnoreNamespaceHandler", "Companion", "utd"})
@SourceDebugExtension(value={"SMAP\nDocumentUTDConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentUTDConfig.kt\norg/brailleblaster/utd/config/DocumentUTDConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1#2:306\n*E\n"})
public final class DocumentUTDConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootElement;
    @NotNull
    private final String rootNamespace;
    @NotNull
    private static final Logger log;
    @JvmField
    @NotNull
    public static final DocumentUTDConfig NIMAS;

    public DocumentUTDConfig(@NotNull String rootElement, @NotNull String rootNamespace) {
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        Intrinsics.checkNotNullParameter((Object)rootNamespace, (String)"rootNamespace");
        this.rootElement = rootElement;
        this.rootNamespace = rootNamespace;
    }

    @Nullable
    public final PageSettings loadPageSettings(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        log.debug("Loading Page Settings from file document config");
        return this.loadFromDoc(doc, PageSettings.class, PageSettings.class);
    }

    public final void savePageSettings(@NotNull Document doc, @NotNull PageSettings pageSettings) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)pageSettings, (String)"pageSettings");
        log.debug("Writing Page Settings to document config");
        this.saveToDoc(doc, pageSettings, PageSettings.class);
    }

    @Nullable
    public final BrailleSettings loadBrailleSettings(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        log.debug("Loading Braille Settings from document config");
        return this.loadFromDoc(doc, BrailleSettings.class, BrailleSettings.class);
    }

    public final void saveBrailleSettings(@NotNull Document doc, @NotNull BrailleSettings brailleSettings) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)brailleSettings, (String)"brailleSettings");
        log.debug("Writing Braille Settings to document config");
        this.saveToDoc(doc, brailleSettings, BrailleSettings.class);
    }

    @Nullable
    public final ActionMap loadActions(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        log.debug("Loading ActionMap from document config");
        ActionMapAdapter adapter = new ActionMapAdapter();
        return adapter.unmarshal(this.loadFromDoc(doc, AdaptedActionMap.class, ActionMap.class));
    }

    public final void saveActions(@NotNull Document doc, @NotNull IActionMap actionMap) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)actionMap, (String)"actionMap");
        log.debug("Writing ActionMap to document config");
        if (!(actionMap instanceof ActionMap)) {
            boolean bl = false;
            String string = "Only supports ActionMap, given " + actionMap + " " + actionMap.getClass();
            throw new IllegalArgumentException(string.toString());
        }
        ActionMapAdapter adapter = new ActionMapAdapter();
        AdaptedActionMap adaptedActionMap = adapter.marshal((ActionMap)actionMap);
        Intrinsics.checkNotNull((Object)adaptedActionMap);
        this.saveToDoc(doc, adaptedActionMap, ActionMap.class);
    }

    @Nullable
    public final StyleMap loadStyle(@NotNull Document doc, @Nullable StyleDefinitions styleDefs) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        log.debug("Loading StyleMap from document config");
        StyleMapAdapter adapter = new StyleMapAdapter(styleDefs);
        return adapter.unmarshal(this.loadFromDoc(doc, AdaptedStyleMap.class, StyleMap.class));
    }

    public final void saveStyle(@NotNull Document doc, @NotNull IStyleMap styleMap) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)styleMap, (String)"styleMap");
        log.debug("Writing StyleMap to document config");
        if (!(styleMap instanceof StyleMap)) {
            boolean bl = false;
            String string = "Only supports StyleMap, given " + styleMap + " " + styleMap.getClass();
            throw new IllegalArgumentException(string.toString());
        }
        StyleMapAdapter adapter = new StyleMapAdapter(false);
        AdaptedStyleMap adaptedStyleMap = adapter.marshal((StyleMap)styleMap);
        Intrinsics.checkNotNull((Object)adaptedStyleMap);
        this.saveToDoc(doc, adaptedStyleMap, StyleMap.class);
    }

    public final void saveStyleWithDefs(@NotNull Document doc, @NotNull IStyleMap styleMap) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)styleMap, (String)"styleMap");
        log.debug("Writing StyleMap with definitions to document config");
        if (!(styleMap instanceof StyleMap)) {
            boolean bl = false;
            String string = "Only supports StyleMap, given " + styleMap + " " + styleMap.getClass();
            throw new IllegalArgumentException(string.toString());
        }
        StyleMapAdapter adapter = new StyleMapAdapter(true);
        AdaptedStyleMap adaptedStyleMap = adapter.marshal((StyleMap)styleMap);
        Intrinsics.checkNotNull((Object)adaptedStyleMap);
        this.saveToDoc(doc, adaptedStyleMap, StyleMap.class);
    }

    private final void saveToDoc(Document xomDoc, Object jaxbValue, Class<?> headClass) {
        try {
            Class[] classArray = new Class[]{jaxbValue.getClass(), StyleOptionsFactory.class};
            JAXBContext jc = JAXBContext.newInstance((Class[])classArray);
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setEventHandler(JAXBUtils.FAIL_ON_EXCEPTIONS_HANDLER);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document jaxbDoc = documentBuilder.newDocument();
            marshaller.marshal(jaxbValue, (org.w3c.dom.Node)jaxbDoc);
            Document xomConfigDoc = DOMConverter.convert((org.w3c.dom.Document)jaxbDoc);
            Element xomConfig = xomConfigDoc.getRootElement().copy();
            xomConfig.detach();
            Intrinsics.checkNotNull((Object)xomConfig);
            XMLHandler.Companion.setNamespaceRecursive(xomConfig, "http://brailleblaster.org/ns/utd");
            Element headElem = this.getOrCreateHeadElement(xomDoc);
            String valueName = Companion.jaxbClassToElementName(headClass);
            Iterator iterator = headElem.getChildElements(valueName, "http://brailleblaster.org/ns/utd").iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Element curElem = (Element)iterator2.next();
                curElem.detach();
            }
            headElem.appendChild((Node)xomConfig);
        }
        catch (Exception e) {
            throw new UTDException("Cannot save settings", e);
        }
    }

    private final <V> V loadFromDoc(Document xomDoc, Class<V> jaxbClass, Class<?> headClass) {
        try {
            Element element = this.getConfigElement(xomDoc, headClass);
            if (element == null) {
                return null;
            }
            Element valueElem = element;
            Element element2 = valueElem.copy();
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"copy(...)");
            valueElem = element2;
            Document parsableXomDoc = new Document(valueElem);
            Class[] classArray = new Class[]{jaxbClass, StyleOptionsFactory.class};
            JAXBContext jc = JAXBContext.newInstance((Class[])classArray);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler(JAXBUtils.FAIL_ON_EXCEPTIONS_HANDLER);
            UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
            Intrinsics.checkNotNull((Object)unmarshallerHandler);
            String[] stringArray = new String[]{"http://brailleblaster.org/ns/utd"};
            SAXConverter converter = new SAXConverter((ContentHandler)new IgnoreNamespaceHandler((ContentHandler)unmarshallerHandler, stringArray));
            converter.convert(parsableXomDoc);
            Object result = unmarshallerHandler.getResult();
            if (jaxbClass.isInstance(result)) {
                return jaxbClass.cast(result);
            }
            throw new RuntimeException("Unexpected type for settings");
        }
        catch (Exception e) {
            throw new UTDException("Cannot load settings", e);
        }
    }

    @Nullable
    public final Element getHeadElement(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Element root = doc.getRootElement();
        Elements headResults = root.getChildElements(this.rootElement, this.getRootNamespace(doc));
        if (headResults.size() == 0) {
            return null;
        }
        return headResults.get(0);
    }

    @NotNull
    public final Element getOrCreateHeadElement(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Element root = doc.getRootElement();
        Elements headResults = root.getChildElements(this.rootElement, this.getRootNamespace(doc));
        if (headResults.size() == 0) {
            log.debug("Document doesn't have head element, creating one");
            Element headElem = new Element(this.rootElement, this.getRootNamespace(doc));
            root.insertChild((Node)headElem, 0);
            return headElem;
        }
        Element element = headResults.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
        return element;
    }

    @NotNull
    public final String getRootNamespace(@NotNull Document doc) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        CharSequence charSequence2 = this.rootNamespace;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            String string = doc.getRootElement().getNamespaceURI();
            charSequence = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespaceURI(...)");
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @Nullable
    public final Element getConfigElement(@NotNull Document doc, @NotNull Class<?> tagClass) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter(tagClass, (String)"tagClass");
        String tagName = Companion.jaxbClassToElementName(tagClass);
        return this.getConfigElement(doc, tagName);
    }

    @Nullable
    public final Element getConfigElement(@NotNull Document doc, @Nullable String elementName) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Element headElem = this.getHeadElement(doc);
        if (headElem == null) {
            log.debug("Failed to find Element {}, Document doesn't have head element", (Object)elementName);
            return null;
        }
        Elements headValueResults = headElem.getChildElements(elementName, "http://brailleblaster.org/ns/utd");
        if (headValueResults.size() == 0) {
            log.debug("Failed to find Element {} in document head", (Object)elementName);
            return null;
        }
        return headValueResults.get(0);
    }

    public final void setSetting(@NotNull Document doc, @NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Element settingElem = this.getConfigElement(doc, key);
        if (settingElem == null) {
            settingElem = new Element("utd:" + key, "http://brailleblaster.org/ns/utd");
            this.getOrCreateHeadElement(doc).appendChild((Node)settingElem);
        }
        settingElem.removeChildren();
        settingElem.appendChild(value);
        log.debug("Added UTD setting to document: {}", (Object)settingElem.toXML());
    }

    @Nullable
    public final String getSetting(@NotNull Document doc, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Element element = this.getConfigElement(doc, key);
        if (element == null) {
            return null;
        }
        Element settingElem = element;
        log.debug("Found setting key {} in document with value {}", (Object)key, (Object)settingElem.getValue());
        return settingElem.getValue();
    }

    static {
        Logger logger = LoggerFactory.getLogger(DocumentUTDConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        NIMAS = new DocumentUTDConfig("head", "");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/utd/config/DocumentUTDConfig$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "NIMAS", "Lorg/brailleblaster/utd/config/DocumentUTDConfig;", "jaxbClassToElementName", "", "tagClass", "Ljava/lang/Class;", "utd"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String jaxbClassToElementName(@NotNull Class<?> tagClass) {
            Intrinsics.checkNotNullParameter(tagClass, (String)"tagClass");
            String string = StringUtils.uncapitalize((String)tagClass.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uncapitalize(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\nH\u0016J(\u0010!\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/brailleblaster/utd/config/DocumentUTDConfig$IgnoreNamespaceHandler;", "Lorg/xml/sax/ContentHandler;", "handler", "namespaces", "", "", "<init>", "(Lorg/xml/sax/ContentHandler;[Ljava/lang/String;)V", "", "characters", "", "ch", "", "start", "", "length", "endDocument", "endElement", "uri", "localName", "qName", "endPrefixMapping", "prefix", "ignorableWhitespace", "processingInstruction", "target", "data", "setDocumentLocator", "locator", "Lorg/xml/sax/Locator;", "skippedEntity", "name", "startDocument", "startElement", "atts", "Lorg/xml/sax/Attributes;", "startPrefixMapping", "utd"})
    public static final class IgnoreNamespaceHandler
    implements ContentHandler {
        @NotNull
        private final ContentHandler handler;
        @NotNull
        private final List<String> namespaces;

        public IgnoreNamespaceHandler(@NotNull ContentHandler handler, String ... namespaces) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
            this.handler = handler;
            this.namespaces = ArraysKt.toList((Object[])namespaces);
        }

        @Override
        public void characters(@NotNull char[] ch, int start, int length) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
            this.handler.characters(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            this.handler.endDocument();
        }

        @Override
        public void endElement(@NotNull String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            if (this.namespaces.contains(uri)) {
                this.handler.endElement("", localName, qName);
            } else {
                this.handler.endElement(uri, localName, qName);
            }
        }

        @Override
        public void endPrefixMapping(@NotNull String prefix) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            this.handler.endPrefixMapping(prefix);
        }

        @Override
        public void ignorableWhitespace(@NotNull char[] ch, int start, int length) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
            this.handler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(@NotNull String target, @NotNull String data) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.handler.processingInstruction(target, data);
        }

        @Override
        public void setDocumentLocator(@NotNull Locator locator) {
            Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
            this.handler.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(@NotNull String name) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.handler.skippedEntity(name);
        }

        @Override
        public void startDocument() throws SAXException {
            this.handler.startDocument();
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes atts) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            Intrinsics.checkNotNullParameter((Object)atts, (String)"atts");
            if (this.namespaces.contains(uri)) {
                this.handler.startElement("", localName, qName, atts);
            } else {
                this.handler.startElement(uri, localName, qName, atts);
            }
        }

        @Override
        public void startPrefixMapping(@NotNull String prefix, @NotNull String uri) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.handler.startPrefixMapping(prefix, uri);
        }
    }
}

