/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.formatters;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0004J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0004J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017R\u0012\u0010\u0004\u001a\u00020\u00058\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/brailleblaster/utd/formatters/Formatter;", "", "<init>", "()V", "startNewBlock", "", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "processProcessingInstruction", "pi", "Lnu/xom/ProcessingInstruction;", "preFormat", "pageBuilder", "styleMap", "Lorg/brailleblaster/utd/IStyleMap;", "setAlignmentOptions", "", "addStartSeparator", "postFormat", "pb", "utd"})
public abstract class Formatter {
    @JvmField
    protected boolean startNewBlock;

    @NotNull
    public abstract Set<PageBuilder> format(@NotNull Node var1, @NotNull IStyle var2, @NotNull Set<PageBuilder> var3, @NotNull FormatSelector var4);

    @NotNull
    public final Set<PageBuilder> processProcessingInstruction(@NotNull ProcessingInstruction pi, @NotNull Set<PageBuilder> pageBuilders, @Nullable FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        String string = pi.getTarget();
        if (Intrinsics.areEqual((Object)string, (Object)"newBrlPage")) {
            pageBuilder.addExplicitPages(1);
        } else if (Intrinsics.areEqual((Object)string, (Object)"newBrlLine")) {
            // empty if block
        }
        return pageBuilders;
    }

    @NotNull
    public final Set<PageBuilder> preFormat(@Nullable Node node, @NotNull PageBuilder pageBuilder, @NotNull IStyle style, @NotNull IStyleMap styleMap) {
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)styleMap, (String)"styleMap");
        this.setAlignmentOptions(pageBuilder, style);
        pageBuilder.updatePendingSpaces(style.getLeftPadding());
        int linesBefore = style.getLinesBefore();
        pageBuilder.addAtLeastLinesBefore(linesBefore);
        int pagesBefore = style.getNewPagesBefore();
        pageBuilder.addAtLeastPages(pagesBefore);
        NamespaceMap namespaces = styleMap.getNamespaces();
        Integer linesRestrictions = style.getLinesBefore(node, namespaces);
        if (linesRestrictions != null) {
            pageBuilder.setMaxLines(linesRestrictions);
            if (linesRestrictions > 0) {
                this.startNewBlock = true;
            }
        }
        if (linesBefore > 0 || pagesBefore > 0) {
            this.startNewBlock = true;
        }
        return this.addStartSeparator(node, pageBuilder, style);
    }

    protected final void setAlignmentOptions(@NotNull PageBuilder pageBuilder, @NotNull IStyle style) {
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Integer n = style.getIndent();
        Integer n2 = style.getLineLength();
        PageBuilder pageBuilder2 = pageBuilder.setLeftIndent(n != null ? n : 0).setRightIndent(n2 != null ? n2 : 0).setFirstLineIndent(style.getFirstLineIndent()).setSkipNumberLines(style.getSkipNumberLines());
        Align align = style.getAlign();
        if (align == null) {
            align = Align.LEFT;
        }
        pageBuilder2.setAlignment(align);
    }

    @NotNull
    protected final Set<PageBuilder> addStartSeparator(@Nullable Node node, @NotNull PageBuilder pageBuilder, @NotNull IStyle style) {
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Set results = new LinkedHashSet();
        if (node instanceof Element && style.getStartSeparator() != null) {
            String color = style.getColor();
            String string = style.getStartSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStartSeparator(...)");
            String string2 = color;
            if (string2 == null) {
                string2 = "";
            }
            results.addAll((Collection)pageBuilder.insertStartSeparatorLine(string, string2, (ParentNode)node));
        }
        return results;
    }

    @NotNull
    public final Set<PageBuilder> postFormat(@NotNull Node node, @NotNull PageBuilder pb, @NotNull IStyle style, @NotNull IStyleMap styleMap) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)pb, (String)"pb");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)styleMap, (String)"styleMap");
        PageBuilder pageBuilder = pb;
        Set results = new LinkedHashSet();
        if (node instanceof Element && style.getEndSeparator() != null) {
            results.addAll((Collection)PageBuilderHelper.INSTANCE.forceNewLineIfNotEmpty(pageBuilder));
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
            String string = style.getEndSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEndSeparator(...)");
            Element brl = pageBuilder.insertEndSeparatorLine(string);
            brl.addAttribute(new Attribute("separator", "end"));
            ParentNode parent = ((Element)node).getParent();
            if (parent != null) {
                int nodeIndex = parent.indexOf(node);
                if (UTDHelper.getAssociatedBrlElement(node) != null) {
                    ++nodeIndex;
                }
                parent.insertChild((Node)brl, nodeIndex + 1);
            }
        }
        pageBuilder.updatePendingSpaces(style.getRightPadding());
        pageBuilder.addAtLeastLinesAfter(style.getLinesAfter());
        NamespaceMap namespaces = styleMap.getNamespaces();
        Integer maxLines = style.getLinesAfter(node, namespaces);
        if (maxLines != null) {
            pageBuilder.setMaxLines(maxLines);
        }
        pageBuilder.addAtLeastPages(style.getNewPagesAfter());
        return results;
    }
}

