/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.formatters;

import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.internal.PartialFormatNodeAncestor;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.properties.PageNumberType;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J@\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/utd/formatters/LiteraryFormatter;", "Lorg/brailleblaster/utd/formatters/Formatter;", "<init>", "()V", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "partialFormat", "pathToStart", "Ljava/util/Deque;", "Lorg/brailleblaster/utd/internal/PartialFormatNodeAncestor;", "startPoint", "utd"})
public class LiteraryFormatter
extends Formatter {
    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set mutPageBuilders = CollectionsKt.toMutableSet((Iterable)pageBuilders);
        if (mutPageBuilders.isEmpty()) {
            return mutPageBuilders;
        }
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        int prevLineSpacing = pageBuilder.getLineSpacing();
        pageBuilder.setLineSpacing(style.getLineSpacing());
        IStyleMap styleMap = formatSelector.styleMap;
        this.startNewBlock = false;
        mutPageBuilders.addAll((Collection)this.preFormat(node, pageBuilder, style, styleMap));
        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        if (style.isVolumeEnd()) {
            Element element = UTDHelper.getDescendantBrlFastFirst(node);
            Intrinsics.checkNotNull((Object)element);
            pageBuilder.setVolumeEndLength(element.getValue().length());
            pageBuilder.setVolumeEnd(true);
            mutPageBuilders.addAll((Collection)pageBuilder.addVolumeBlankLines());
            if (mutPageBuilders.size() > 1) {
                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
            }
            if (!formatSelector.engine.getPageSettings().isContinuePages()) {
                pageBuilder.resetPageNumbers();
            } else {
                pageBuilder.resetSpecialPageNumbers();
            }
            pageBuilder.setTitlePage(true);
            Align align = style.getAlign();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)align), (String)"getAlign(...)");
            pageBuilder.setAlignment(align);
            pageBuilder.setOverridePageType(false);
        }
        if (this.startNewBlock) {
            pageBuilder.setStartOfBlock(true);
        }
        if (node instanceof Text) {
            Element brl = UTDHelper.getAssociatedBrlElement(node);
            if (brl != null) {
                pageBuilder.setCurrBrl(brl);
                if (style.getBraillePageNumberFormat() != null && pageBuilder.getPendingPages() == 0 && !pageBuilder.isOverridePageType()) {
                    PageNumberType pageNumberType = style.getBraillePageNumberFormat();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)pageNumberType), (String)"getBraillePageNumberFormat(...)");
                    PageBuilderHelper.setPageNumberType(pageBuilder, pageNumberType, formatSelector);
                }
                if (PageBuilderHelper.isPageIndicator(brl)) {
                    mutPageBuilders.addAll((Collection)PageBuilderHelper.handlePageIndicator(pageBuilder, brl, style, formatSelector));
                    pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                } else {
                    if (style.isGuideWords()) {
                        ITranslationEngine iTranslationEngine = pageBuilder.getEngine();
                        Intrinsics.checkNotNull((Object)iTranslationEngine);
                        if (iTranslationEngine.getPageSettings().isGuideWords()) {
                            boolean go = true;
                            Nodes guideWords = node.query("ancestor::*[@guideWords][1]");
                            if (guideWords.size() > 0) {
                                Intrinsics.checkNotNull((Object)guideWords);
                                Element guideWordParent = (Element)CollectionsKt.firstOrNull((Iterable)((Iterable)guideWords));
                                if (guideWordParent != null && Intrinsics.areEqual((Object)guideWordParent.getAttributeValue("guideWords"), (Object)"false")) {
                                    go = false;
                                }
                            }
                            if (node.query("ancestor::*[@spacing][1]").size() > 0) {
                                Node node2 = brl.query("ancestor::node()[@spacing][1]").get(0);
                                Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                                Element spacingAttr = (Element)node2;
                                String string = spacingAttr.getAttributeValue("spacing");
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                                int spacing = Integer.parseInt(string) - 1;
                                brl.addAttribute(new Attribute("spacing", String.valueOf(spacing)));
                            }
                            if (go) {
                                pageBuilder.setSkipNumberLineBottom(true);
                                pageBuilder.setPadding(3);
                                pageBuilder.setGuideWordEnabled(true);
                                ParentNode parentNode = ((Text)node).getParent();
                                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                                Element guideWord = (Element)parentNode;
                                if (pageBuilder.getStartGuideWord() == null) {
                                    if (pageBuilder.getPendingPages() > 0) {
                                        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilder.processSpacing());
                                    }
                                    pageBuilder.setStartGuideWord(guideWord);
                                }
                                pageBuilder.setAltEndGuideWord(pageBuilder.getEndGuideWord());
                                pageBuilder.setEndGuideWord(guideWord);
                            }
                        }
                    }
                    if (node.query("ancestor::*[@type='pronunciation'][1]").size() > 0) {
                        Node node3 = node.query("ancestor::*[@type='pronunciation'][1]").get(0);
                        Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
                        Element pronunciation = (Element)node3;
                        brl.addAttribute(new Attribute("type", "pronunciation"));
                        brl.addAttribute(new Attribute("term", pronunciation.getAttributeValue("term")));
                    }
                    if (node.query("ancestor::*[@spaced='true'][1]").size() > 0) {
                        brl.addAttribute(new Attribute("spaced", "true"));
                    }
                    mutPageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder, brl, null, 2, null));
                    if (mutPageBuilders.size() > 1) {
                        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                    }
                }
            }
        } else if (node instanceof Element && !UTDElements.BRL.isA(node)) {
            boolean keepWithNext = style.isKeepWithNext();
            if (keepWithNext && !pageBuilder.getKeepWithNext()) {
                pageBuilder.setKeepWithNext(true);
            }
            if (style.isDontSplit() && !pageBuilder.getDontSplit()) {
                pageBuilder.setDontSplit(true);
            }
            if (((Element)node).getAttribute("pageSide") != null) {
                String string = ((Element)node).getAttributeValue("pageSide");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                PageBuilderHelper.verifyPageSide(pageBuilder, string);
            }
            if (((Element)node).getAttribute("pageType") != null) {
                pageBuilder.updatePageNumberType(PageNumberType.Companion.equivalentPage(((Element)node).getAttributeValue("pageType")));
            } else if (Intrinsics.areEqual((Object)((Element)node).getLocalName(), (Object)"BLOCK") && pageBuilder.isOverridePageType() && pageBuilder.getPageNumberType() == PageNumberType.T_PAGE) {
                PageNumberType pageNumberType = pageBuilder.getPreviousPageNumberType();
                Intrinsics.checkNotNull((Object)((Object)pageNumberType));
                pageBuilder.updatePageNumberType(pageNumberType);
                pageBuilder.setOverridePageType(false);
            }
            for (int i = 0; i < ((Element)node).getChildCount(); ++i) {
                Node child = ((Element)node).getChild(i);
                if (child instanceof ProcessingInstruction) {
                    int pageBuildersSize = mutPageBuilders.size();
                    if ((mutPageBuilders = CollectionsKt.toMutableSet((Iterable)this.processProcessingInstruction((ProcessingInstruction)child, mutPageBuilders, formatSelector))).size() > pageBuildersSize) {
                        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                    }
                } else if (!UTDElements.BRL.isA(child)) {
                    Intrinsics.checkNotNullExpressionValue((Object)Objects.requireNonNull(formatSelector.formatNode(child, mutPageBuilders)), (String)"requireNonNull(...)");
                    mutPageBuilders.add(pageBuilder);
                } else {
                    Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type nu.xom.Element");
                    Element brl = (Element)child;
                    if (PageBuilderHelper.isPageIndicator(brl) && (brl.getChildCount() == 0 || brl.getParent().getChildCount() == 1)) {
                        PageBuilderHelper.handlePageIndicator(pageBuilder, brl, style, formatSelector);
                    } else if (brl.getAttributeValue("tabValue") != null) {
                        int curX = pageBuilder.getX();
                        String string = brl.getAttributeValue("tabValue");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                        int tabValue = Integer.parseInt(string) - 1;
                        if (curX < tabValue) {
                            mutPageBuilders.addAll((Collection)pageBuilder.processSpacing());
                            if (mutPageBuilders.size() > 1) {
                                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                            }
                            pageBuilder.setTabbed(true);
                            pageBuilder.setX(tabValue);
                        } else {
                            pageBuilder.addAtLeastLinesBefore(1);
                            mutPageBuilders.addAll((Collection)pageBuilder.processSpacing());
                            if (mutPageBuilders.size() > 1) {
                                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                            }
                            pageBuilder.setX(tabValue);
                        }
                    }
                }
                if (!(!((Collection)UTDHelper.getDescendantBrlFast(child)).isEmpty()) || !(child instanceof Element) || UTDElements.BRL.isA(child) && PageBuilderHelper.isPageIndicator((Element)child) || ((Element)child).getAttribute("utd-action") != null && Intrinsics.areEqual((Object)((Element)child).getAttributeValue("utd-action"), (Object)"PageAction")) continue;
                pageBuilder.setStartOfBlock(false);
            }
            if (keepWithNext) {
                mutPageBuilders.forEach(LiteraryFormatter::format$lambda$0);
            }
            if (style.isDontSplit()) {
                mutPageBuilders.forEach(LiteraryFormatter::format$lambda$1);
            }
        }
        mutPageBuilders.addAll((Collection)this.postFormat(node, pageBuilder, style, styleMap));
        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        if (style.getLinesAfter() > 0) {
            pageBuilder.setStartOfBlock(true);
        }
        pageBuilder.setLineSpacing(prevLineSpacing);
        return mutPageBuilders;
    }

    @NotNull
    public final Set<PageBuilder> partialFormat(@NotNull Deque<PartialFormatNodeAncestor> pathToStart, @NotNull Node startPoint, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter(pathToStart, (String)"pathToStart");
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        PartialFormatNodeAncestor pathElement = pathToStart.pop();
        Node node = pathElement.getNode();
        boolean start = pathElement.isFirstBrailleAtStartPoint();
        this.setAlignmentOptions(pageBuilder, style);
        if (start) {
            pageBuilder.preparePage();
            pageBuilders.addAll((Collection<PageBuilder>)this.addStartSeparator(node, pageBuilder, style));
        }
        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        if (!pathToStart.isEmpty() && node instanceof ParentNode) {
            int startIndex;
            Node startChild = pathToStart.getFirst().getNode();
            boolean keepWithNext = style.isKeepWithNext();
            if (keepWithNext && !pageBuilder.getKeepWithNext()) {
                pageBuilder.setKeepWithNext(true);
            }
            pageBuilders.add(formatSelector.partialFormat(pathToStart, startPoint, pageBuilders));
            int n = ((ParentNode)node).getChildCount();
            for (int i = startIndex = ((ParentNode)node).indexOf(startChild) + 1; i < n; ++i) {
                Node nodeChild = ((ParentNode)node).getChild(i);
                if (UTDElements.BRL.isA(nodeChild)) continue;
                pageBuilders.add(formatSelector.formatNode(nodeChild, pageBuilders));
            }
            if (keepWithNext) {
                pageBuilders.forEach(LiteraryFormatter::partialFormat$lambda$0);
            }
        } else {
            ParentNode parentNode = startPoint.getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element brl = (Element)parentNode;
            if (PageBuilderHelper.isPageIndicator(brl)) {
                String string = brl.getAttributeValue("printPage");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                if (((CharSequence)string).length() == 0) {
                    PageBuilderHelper.handlePageIndicator(pageBuilder, brl, style, formatSelector);
                }
            }
            int startPointIndex = brl.indexOf(startPoint);
            if (pageBuilder.isStartOfBlock()) {
                if (pageBuilder.hasLeftPage(pageBuilder.getBraillePageNumber())) {
                    pageBuilder.setX(pageBuilder.getCornerPageLength());
                } else {
                    pageBuilder.setX(pageBuilder.getFirstLineIndent());
                }
            } else if (pageBuilder.hasLeftPage(pageBuilder.getBraillePageNumber())) {
                pageBuilder.setX(pageBuilder.getCornerPageLength());
            } else {
                pageBuilder.setX(pageBuilder.getLeftIndent());
            }
            pageBuilders.addAll((Collection<PageBuilder>)pageBuilder.addBrlFromChild(brl, startPointIndex));
            if (pageBuilders.size() > 1) {
                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
            }
            if (style.isGuideWords()) {
                pageBuilder.setPadding(3);
                pageBuilder.setGuideWordEnabled(true);
                if (pageBuilder.getStartGuideWord() == null || pageBuilder.getY() == pageBuilder.findFirstBlankLine() || pageBuilder.getY() == 0) {
                    if (pageBuilder.getPendingPages() > 0) {
                        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilder.processSpacing());
                    }
                    ParentNode parentNode2 = node.getParent();
                    Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
                    pageBuilder.setStartGuideWord((Element)parentNode2);
                }
                pageBuilder.setAltEndGuideWord(pageBuilder.getEndGuideWord());
                ParentNode parentNode3 = node.getParent();
                Intrinsics.checkNotNull((Object)parentNode3, (String)"null cannot be cast to non-null type nu.xom.Element");
                pageBuilder.setEndGuideWord((Element)parentNode3);
            }
        }
        pageBuilders.addAll((Collection<PageBuilder>)this.postFormat(node, pageBuilder, style, formatSelector.styleMap));
        return pageBuilders;
    }

    private static final void format$lambda$0(PageBuilder pb) {
        Intrinsics.checkNotNullParameter((Object)pb, (String)"pb");
        pb.setKeepWithNext(false);
    }

    private static final void format$lambda$1(PageBuilder pb) {
        Intrinsics.checkNotNullParameter((Object)pb, (String)"pb");
        pb.setDontSplit(false);
    }

    private static final void partialFormat$lambda$0(PageBuilder pb) {
        PageBuilder pageBuilder = pb;
        Intrinsics.checkNotNull((Object)pageBuilder);
        pageBuilder.setKeepWithNext(false);
    }
}

