/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.internal;

import java.io.Serializable;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/utd/internal/DocumentOrderComparator;", "Ljava/util/Comparator;", "Lnu/xom/Node;", "Lkotlin/Comparator;", "Ljava/io/Serializable;", "<init>", "()V", "compare", "", "o1", "o2", "utd"})
public final class DocumentOrderComparator
implements Comparator<Node>,
Serializable {
    @Override
    public int compare(@NotNull Node o1, @NotNull Node o2) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        if (Intrinsics.areEqual((Object)o1, (Object)o2)) {
            return 0;
        }
        Nodes o1Ancestors = new Nodes();
        for (node = o1; node != null; node = (Node)node.getParent()) {
            o1Ancestors.insert(node, 0);
        }
        Nodes o2Ancestors = new Nodes();
        for (node = o2; node != null; node = (Node)node.getParent()) {
            o2Ancestors.insert(node, 0);
        }
        int result = 0;
        if (o1Ancestors.size() < o2Ancestors.size()) {
            result = -1;
        } else if (o1Ancestors.size() > o2Ancestors.size()) {
            result = 1;
        }
        int searchDepth = Math.min(o1Ancestors.size(), o2Ancestors.size());
        ParentNode parent = null;
        for (int i = 0; i < searchDepth; ++i) {
            Node node2;
            Node node1 = o1Ancestors.get(i);
            if (node1 != (node2 = o2Ancestors.get(i))) {
                int n2Index;
                if (parent == null) {
                    throw new RuntimeException("Nodes do not belong to the same tree of nodes");
                }
                int n1Index = parent.indexOf(node1);
                result = n1Index < (n2Index = parent.indexOf(node2)) ? -1 : 1;
                break;
            }
            Intrinsics.checkNotNull((Object)node1, (String)"null cannot be cast to non-null type nu.xom.ParentNode");
            parent = (ParentNode)node1;
        }
        return result;
    }
}

