/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.pagelayout;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.utd.internal.elements.PageNumber;
import org.brailleblaster.utd.pagelayout.Cell;
import org.brailleblaster.utd.pagelayout.PageGrid$special$;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0003J+\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001fJ\u0016\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J\u0016\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0%2\u0006\u0010.\u001a\u00020\u0003J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e0)2\u0006\u00100\u001a\u000201R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010 \u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00062"}, d2={"Lorg/brailleblaster/utd/pagelayout/PageGrid;", "", "width", "", "height", "<init>", "(II)V", "other", "(Lorg/brailleblaster/utd/pagelayout/PageGrid;)V", "getWidth", "()I", "getHeight", "grid", "", "Lorg/brailleblaster/utd/pagelayout/Cell;", "[Lorg/brailleblaster/utd/pagelayout/Cell;", "getCell", "x", "y", "setCell", "", "cell", "overWrite", "isEmptyNumberLine", "line", "isEmptyLine", "clearLine", "", "setCells", "cells", "(II[Lorg/brailleblaster/utd/pagelayout/Cell;)V", "", "isBlankPage", "()Z", "isEmptyLines", "start", "end", "Ljava/util/stream/Stream;", "getCells", "()Ljava/util/stream/Stream;", "brlElementsOnPage", "", "Lnu/xom/Element;", "getBrlElementsOnPage", "()Ljava/lang/Iterable;", "getLine", "i", "getCellsForNode", "node", "Lnu/xom/Node;", "utd"})
@SourceDebugExtension(value={"SMAP\nPageGrid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageGrid.kt\norg/brailleblaster/utd/pagelayout/PageGrid\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n37#2,2:223\n479#3:225\n777#4:226\n873#4,2:227\n*S KotlinDebug\n*F\n+ 1 PageGrid.kt\norg/brailleblaster/utd/pagelayout/PageGrid\n*L\n172#1:223,2\n211#1:225\n220#1:226\n220#1:227,2\n*E\n"})
public final class PageGrid {
    private final int width;
    private final int height;
    @NotNull
    private final Cell[] grid;

    public PageGrid(int width, int height) {
        this.width = width;
        this.height = height;
        this.grid = new Cell[this.height * this.width];
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public PageGrid(@NotNull PageGrid other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this(other.width, other.height);
        ArraysKt.copyInto$default((Object[])other.grid, (Object[])this.grid, (int)0, (int)0, (int)0, (int)14, null);
    }

    @Nullable
    public final Cell getCell(int x, int y) {
        Preconditions.checkElementIndex((int)x, (int)this.width);
        Preconditions.checkElementIndex((int)y, (int)this.height);
        return this.grid[y * this.width + x];
    }

    public final boolean setCell(int x, int y, @Nullable Cell cell) {
        return this.setCell(x, y, cell, false);
    }

    public final boolean setCell(int x, int y, @Nullable Cell cell, boolean overWrite) {
        Preconditions.checkElementIndex((int)y, (int)this.height);
        Preconditions.checkElementIndex((int)x, (int)this.width);
        int index = y * this.width + x;
        boolean cellEmpty = true;
        if (this.grid[index] != null) {
            cellEmpty = false;
        }
        if (overWrite || cellEmpty) {
            this.grid[index] = cell;
        }
        return !cellEmpty;
    }

    public final boolean isEmptyNumberLine(int line) {
        Preconditions.checkElementIndex((int)line, (int)this.height);
        boolean result = true;
        int n = (line + 1) * this.width;
        for (int i = line * this.width; i < n; ++i) {
            if (this.grid[i] != null) {
                Cell cell = this.grid[i];
                Intrinsics.checkNotNull((Object)cell);
                if (cell.getNode() instanceof PageNumber) continue;
                Cell cell2 = this.grid[i];
                Intrinsics.checkNotNull((Object)cell2);
                if (cell2.getNode() == null) {
                    Cell cell3 = this.grid[i];
                    Intrinsics.checkNotNull((Object)cell3);
                    if (cell3.getIndex() == -1) continue;
                }
            }
            if (this.grid[i] == null) continue;
            result = false;
            break;
        }
        return result;
    }

    public final boolean isEmptyLine(int line) {
        Preconditions.checkElementIndex((int)line, (int)this.height);
        boolean result = true;
        int n = (line + 1) * this.width;
        for (int i = line * this.width; i < n; ++i) {
            if (this.grid[i] == null) continue;
            result = false;
            break;
        }
        return result;
    }

    public final void clearLine(int line) {
        Preconditions.checkElementIndex((int)line, (int)this.height);
        Arrays.fill(this.grid, line * this.width, (line + 1) * this.width, null);
    }

    public final void setCells(int x, int y, @NotNull Cell[] cells) {
        Intrinsics.checkNotNullParameter((Object)cells, (String)"cells");
        int newX = RangesKt.coerceAtLeast((int)x, (int)0);
        Preconditions.checkElementIndex((int)y, (int)this.height);
        if (cells.length == 0) {
            return;
        }
        if (!(newX + cells.length <= this.width)) {
            boolean bl = false;
            String string = "%d is too many cells to insert starting at position %d on line, line length is only %d";
            Object[] objectArray = new Object[]{cells.length, newX, this.width};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        System.arraycopy(cells, 0, this.grid, y * this.width + newX, cells.length);
    }

    public final void setCells(int x, int y, @NotNull List<Cell> cells) {
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        Collection $this$toTypedArray$iv = cells;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.setCells(x, y, thisCollection$iv.toArray(new Cell[0]));
    }

    public final boolean isBlankPage() {
        return this.isEmptyLines(0, this.height);
    }

    public final boolean isEmptyLines(int start, int end) {
        for (int i = start; i < end; ++i) {
            if (this.isEmptyNumberLine(i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Stream<Cell> getCells() {
        Stream<Cell> stream = Arrays.stream(this.grid);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    @NotNull
    public final Iterable<Element> getBrlElementsOnPage() {
        Sequence $this$filterIsInstance$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])this.grid), PageGrid::_get_brlElementsOnPage_$lambda$0)), PageGrid::_get_brlElementsOnPage_$lambda$1);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)special$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, PageGrid::_get_brlElementsOnPage_$lambda$2));
    }

    @NotNull
    public final Stream<Cell> getLine(int i) {
        Preconditions.checkElementIndex((int)i, (int)this.height);
        Stream<Cell> stream = Arrays.stream(this.grid, i * this.width, (i + 1) * this.width);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<Cell> getCellsForNode(@NotNull Node node) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Iterable $this$filter$iv = ArraysKt.filterNotNull((Object[])this.grid);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Cell it = (Cell)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getNode(), (Object)node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Node _get_brlElementsOnPage_$lambda$0(Cell it) {
        Cell cell = it;
        return cell != null ? cell.getNode() : null;
    }

    private static final ParentNode _get_brlElementsOnPage_$lambda$1(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final boolean _get_brlElementsOnPage_$lambda$2(Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UTDElements.BRL.isA((Node)it);
    }
}

