/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.tables;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.tables.TableFormat;
import org.brailleblaster.utd.utils.TableUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/utd/tables/AutoTableFormatter;", "Lorg/brailleblaster/utd/formatters/Formatter;", "<init>", "()V", "simpleTable", "getSimpleTable", "()Lorg/brailleblaster/utd/formatters/Formatter;", "listedTable", "getListedTable", "linearTable", "getLinearTable", "stairstepTable", "getStairstepTable", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "utd"})
public final class AutoTableFormatter
extends Formatter {
    private final Formatter getSimpleTable() {
        return TableFormat.SIMPLE.formatter;
    }

    private final Formatter getListedTable() {
        return TableFormat.LISTED.formatter;
    }

    private final Formatter getLinearTable() {
        return TableFormat.LINEAR.formatter;
    }

    private final Formatter getStairstepTable() {
        return TableFormat.STAIRSTEP.formatter;
    }

    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set mutPageBuilders = CollectionsKt.toMutableSet((Iterable)pageBuilders);
        if (!(node instanceof Element)) {
            return mutPageBuilders;
        }
        ITranslationEngine engine = formatSelector.engine;
        switch (WhenMappings.$EnumSwitchMapping$0[TableUtils.INSTANCE.detectType((Element)node, engine.getStyleMap(), engine.getBrailleSettings(), engine.getPageSettings()).ordinal()]) {
            case 1: {
                ((Element)node).addAttribute(new Attribute("format", "simple"));
                Element element = (Element)node;
                Style style2 = engine.getStyleDefinitions().getStyleByName("Simple Table");
                Intrinsics.checkNotNull((Object)style2);
                element.addAttribute(new Attribute("utd-style", style2.getName()));
                boolean bl = mutPageBuilders.addAll((Collection)this.getSimpleTable().format(node, style, mutPageBuilders, formatSelector));
                break;
            }
            case 2: {
                ((Element)node).addAttribute(new Attribute("format", "simple"));
                Element element = (Element)node;
                Style style3 = engine.getStyleDefinitions().getStyleByName("Linear Table");
                Intrinsics.checkNotNull((Object)style3);
                element.addAttribute(new Attribute("utd-style", style3.getName()));
                boolean bl = mutPageBuilders.addAll((Collection)this.getLinearTable().format(node, style, mutPageBuilders, formatSelector));
                break;
            }
            case 3: {
                ((Element)node).addAttribute(new Attribute("format", "stairstep"));
                Element element = (Element)node;
                Style style4 = engine.getStyleDefinitions().getStyleByName("Stairstep Table");
                Intrinsics.checkNotNull((Object)style4);
                element.addAttribute(new Attribute("utd-style", style4.getName()));
                boolean bl = mutPageBuilders.addAll((Collection)this.getStairstepTable().format(node, style, mutPageBuilders, formatSelector));
                break;
            }
            case 4: 
            case 5: {
                ((Element)node).addAttribute(new Attribute("format", "listed"));
                Element element = (Element)node;
                Style style5 = engine.getStyleDefinitions().getStyleByName("Listed Table");
                Intrinsics.checkNotNull((Object)style5);
                element.addAttribute(new Attribute("utd-style", style5.getName()));
                boolean bl = mutPageBuilders.addAll((Collection)this.getListedTable().format(node, style, mutPageBuilders, formatSelector));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mutPageBuilders;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TableUtils.TableTypes.values().length];
            try {
                nArray[TableUtils.TableTypes.SIMPLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableUtils.TableTypes.LINEAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableUtils.TableTypes.STAIRSTEP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableUtils.TableTypes.LISTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableUtils.TableTypes.NONTABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

