/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.utils;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.formatters.SkipLinesFormatter;
import org.brailleblaster.utd.properties.PageNumberPosition;
import org.brailleblaster.utd.properties.PageNumberType;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0016\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bJ \u0010\u0016\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010!H\u0007J8\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#2\b\u0010$\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0#2\b\u0010&\u001a\u0004\u0018\u00010\u0015J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020*H\u0007J\u0018\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020*H\u0007J\u000e\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u000202R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/brailleblaster/utd/utils/PageBuilderHelper;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "forceNewLineIfNotEmpty", "", "Lorg/brailleblaster/utd/PageBuilder;", "pageBuilder", "isPageIndicator", "", "brl", "Lnu/xom/Element;", "verifyPageIndicator", "pb", "changePageNumberType", "", "style", "Lorg/brailleblaster/utd/IStyle;", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "setPageNumberType", "pageType", "Lorg/brailleblaster/utd/properties/PageNumberType;", "isContinuePages", "isInterpoint", "handlePageIndicator", "verifyPageSide", "side", "", "isSkipLinesNode", "node", "Lnu/xom/Node;", "applySkipLinesNode", "", "element", "pageBuilders", "formatter", "getPageProperty", "Lorg/brailleblaster/utd/utils/PageBuilderHelper$Property;", "braillePageNumber", "", "getPrintPageNumberAt", "Lorg/brailleblaster/utd/properties/PageNumberPosition;", "pageSettings", "Lorg/brailleblaster/utd/PageSettings;", "getBraillePageNumberAt", "isDecimal", "input", "", "Property", "utd"})
@SourceDebugExtension(value={"SMAP\nPageBuilderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageBuilderHelper.kt\norg/brailleblaster/utd/utils/PageBuilderHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,365:1\n1#2:366\n*E\n"})
public final class PageBuilderHelper {
    @NotNull
    public static final PageBuilderHelper INSTANCE = new PageBuilderHelper();
    @NotNull
    private static final Logger log;

    private PageBuilderHelper() {
    }

    @NotNull
    public final Set<PageBuilder> forceNewLineIfNotEmpty(@NotNull PageBuilder pageBuilder) {
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        PageBuilder pb = pageBuilder;
        Set pages = new LinkedHashSet();
        pages.add(pb);
        while (true) {
            boolean bl = pb.isNumberLine() ? !pb.isEmptyNumberLine() : !pb.isEmptyLine();
            if (!bl) break;
            pb.setForceSpacing(true);
            pb.addAtLeastLinesAfter(1);
            pages.addAll((Collection)pb.processSpacing());
            pb = (PageBuilder)CollectionsKt.last((Iterable)pages);
        }
        return pages;
    }

    @JvmStatic
    public static final boolean isPageIndicator(@NotNull Element brl) {
        Intrinsics.checkNotNullParameter((Object)brl, (String)"brl");
        if (!UTDElements.BRL.isA((Node)brl)) {
            boolean bl = false;
            String string = "Expected brl, received " + brl;
            throw new IllegalArgumentException(string.toString());
        }
        return brl.getAttributeValue("printPageBrl") != null && brl.getAttributeValue("printPage") != null;
    }

    @Nullable
    public final PageBuilder verifyPageIndicator(@NotNull PageBuilder pb) {
        Intrinsics.checkNotNullParameter((Object)pb, (String)"pb");
        int curY = pb.getY();
        int pendingLines = pb.getPendingLinesBefore();
        if (curY >= pb.getLinesPerPage()) {
            return pb;
        }
        if (!pb.isEmptyLine() && pendingLines == 0) {
            ++pendingLines;
        }
        int pendingPages = pb.getPendingPages();
        int maxLines = pb.getTotalHeight() - 1;
        if (curY + pendingLines >= maxLines) {
            pb.addAtLeastPages(1);
            return pb;
        }
        return curY + pendingLines < maxLines && (pendingPages <= 0 || curY + pendingLines != pb.getLineSpacing()) ? null : pb;
    }

    public final void changePageNumberType(@NotNull PageBuilder pageBuilder, @NotNull Element brl, @NotNull IStyle style, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        Intrinsics.checkNotNullParameter((Object)brl, (String)"brl");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        if (!pageBuilder.isOverridePageType() || pageBuilder.getPageNumberTypeFromMetaData() != null) {
            String pageType = brl.getAttributeValue("pageType");
            if (pageBuilder.getPageNumberTypeFromMetaData() != null) {
                PageNumberType pageNumberType = pageBuilder.getPageNumberTypeFromMetaData();
                Intrinsics.checkNotNull((Object)((Object)pageNumberType));
                pageType = pageNumberType.name();
            }
            if (pageType == null) {
                pageType = "NORMAL";
            }
            if (pageBuilder.getPageNumberType() != PageNumberType.Companion.equivalentPage(pageType) && style.getBraillePageNumberFormat() == null || pageBuilder.isAfterVolume()) {
                PageBuilderHelper.setPageNumberType(pageBuilder, PageNumberType.Companion.equivalentPage(pageType), formatSelector);
            } else if (pageBuilder.isAfterTPage()) {
                pageBuilder.setPageNumberType(PageNumberType.Companion.equivalentPage(pageType));
            }
        }
    }

    public final void setPageNumberType(@NotNull PageBuilder pageBuilder, @NotNull PageNumberType pageType, boolean isContinuePages, boolean isInterpoint) {
        boolean isNotBlank;
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)pageType), (String)"pageType");
        boolean bl = isNotBlank = !pageBuilder.isBlankPageWithPageNumbers() || !pageBuilder.isBlankPage() || !pageBuilder.isBlankPageWithRunningHead();
        if (!isContinuePages) {
            if (pageBuilder.isAfterTPage()) {
                pageBuilder.getBraillePageNumber().resetNumberCounters(pageType, false);
            } else {
                pageBuilder.getBraillePageNumber().resetNextPageNumberCounters(pageType);
            }
        }
        if (isInterpoint && !pageBuilder.isFirstPage()) {
            if (pageBuilder.isRightPage()) {
                int toAdd = 2;
                if (pageBuilder.isBlankPageWithPageNumbers() || pageBuilder.isBlankPageWithSkipLine() || pageBuilder.isAfterTPage()) {
                    pageBuilder.removeExistingPageNumbers();
                    toAdd = 0;
                } else {
                    pageBuilder.setDecrementCont(true);
                }
                pageBuilder.addAtLeastPages(toAdd);
            } else {
                pageBuilder.addAtLeastPages(1);
            }
        } else if (isNotBlank && !pageBuilder.isAfterTPage()) {
            pageBuilder.addAtLeastPages(1);
        } else {
            pageBuilder.setPageNumberType(pageType);
            return;
        }
        pageBuilder.setNextPageNumberType(pageType);
    }

    @JvmStatic
    public static final void setPageNumberType(@NotNull PageBuilder pageBuilder, @NotNull PageNumberType pageType, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)pageType), (String)"pageType");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        if (pageBuilder.getPageNumberTypeFromMetaData() != null) {
            PageNumberType pageNumberType = pageBuilder.getPageNumberTypeFromMetaData();
            Intrinsics.checkNotNull((Object)((Object)pageNumberType));
            INSTANCE.setPageNumberType(pageBuilder, pageNumberType, formatSelector.engine.getPageSettings().isContinuePages(), formatSelector.engine.getPageSettings().getInterpoint());
        } else {
            INSTANCE.setPageNumberType(pageBuilder, pageType, formatSelector.engine.getPageSettings().isContinuePages(), formatSelector.engine.getPageSettings().getInterpoint());
        }
    }

    @JvmStatic
    @NotNull
    public static final Set<PageBuilder> handlePageIndicator(@NotNull PageBuilder pb, @NotNull Element brl, @NotNull IStyle style, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)pb, (String)"pb");
        Intrinsics.checkNotNullParameter((Object)brl, (String)"brl");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        PageBuilder pageBuilder = pb;
        Set results = new LinkedHashSet();
        results.add(pageBuilder);
        boolean addIndicator = true;
        if (!Intrinsics.areEqual((Object)pageBuilder.getPrintPageNumber(), (Object)brl.getAttributeValue("printPage"))) {
            String string = brl.getAttributeValue("printPage");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            pageBuilder.setPrintPageNumber(string);
            String string2 = brl.getAttributeValue("printPageBrl");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
            pageBuilder.setPrintPageBrl(string2);
        } else {
            String string = brl.getAttributeValue("printPage");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            if (((CharSequence)string).length() > 0) {
                addIndicator = false;
            }
        }
        if (brl.getAttribute("printPageOverride") != null) {
            String string = brl.getAttributeValue("printPageOverride");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            pageBuilder.setPrintPageNumberOverride(string);
            String string3 = brl.getAttributeValue("printPageOverrideBrl");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeValue(...)");
            pageBuilder.setPrintPageBrlOverride(string3);
        } else {
            pageBuilder.setPrintPageNumberOverride("");
            pageBuilder.setPrintPageBrlOverride("");
        }
        INSTANCE.changePageNumberType(pageBuilder, brl, style, formatSelector);
        if (addIndicator) {
            PageBuilder indicatorPB = INSTANCE.verifyPageIndicator(pageBuilder);
            if (indicatorPB == null) {
                if (!(((CharSequence)pageBuilder.getPrintPageNumber()).length() == 0) && !(((CharSequence)pageBuilder.getPrintPageValue()).length() == 0)) {
                    boolean isEmpty = true;
                    for (int i = 1; i <= pageBuilder.getY(); ++i) {
                        if (pageBuilder.isEmptyLine(i)) continue;
                        isEmpty = false;
                        break;
                    }
                    boolean bl = isEmpty = pageBuilder.hasRunningHead() ? isEmpty : pageBuilder.isEmptyNumberLine(0);
                    if (isEmpty && pageBuilder.hasAddedPageNumbers()) {
                        pageBuilder.decrementContinuationLetter();
                        pageBuilder.addPageNumbers();
                        addIndicator = false;
                    }
                }
                int insertedElements = 0;
                if (addIndicator) {
                    int linesBefore = pageBuilder.getPendingLinesBefore();
                    int linesAfter = pageBuilder.getPendingLinesAfter();
                    int indent = pageBuilder.getLeftIndent();
                    int firstLineIndent = pageBuilder.getFirstLineIndent();
                    pageBuilder.resetPendingLines();
                    results.addAll((Collection)INSTANCE.forceNewLineIfNotEmpty(pageBuilder));
                    pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
                    insertedElements = pageBuilder.insertPrintPageIndicator(brl);
                    pageBuilder.addAtLeastLinesBefore(linesBefore);
                    pageBuilder.addAtLeastLinesAfter(linesAfter);
                    pageBuilder.setLeftIndent(indent);
                    pageBuilder.setFirstLineIndent(firstLineIndent);
                }
                if (brl.getChildCount() > insertedElements) {
                    results.addAll((Collection)pageBuilder.addBrlFromChild(brl, insertedElements));
                }
            } else {
                pageBuilder = indicatorPB;
                results.addAll((Collection)pageBuilder.processSpacing());
                for (int child = brl.getChildCount() - 1; -1 < child; --child) {
                    brl.getChild(child).detach();
                }
            }
        } else {
            for (int child = brl.getChildCount() - 1; -1 < child; --child) {
                brl.getChild(child).detach();
            }
        }
        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
        pageBuilder.clearKeepWithNext();
        return results;
    }

    @JvmStatic
    public static final void verifyPageSide(@NotNull PageBuilder pageBuilder, @NotNull String side) {
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (Intrinsics.areEqual((Object)side, (Object)"right")) {
            if (!pageBuilder.isRightPage()) {
                pageBuilder.addAtLeastPages(1);
            }
        } else if (Intrinsics.areEqual((Object)side, (Object)"left") && pageBuilder.isRightPage()) {
            pageBuilder.addAtLeastPages(1);
        }
    }

    @JvmStatic
    public static final boolean isSkipLinesNode(@Nullable Node node) {
        return node instanceof Element && ((Element)node).getAttributeValue("skipLines", "http://brailleblaster.org/ns/utd") != null;
    }

    @NotNull
    public final Set<PageBuilder> applySkipLinesNode(@Nullable Element element, @Nullable IStyle style, @NotNull Set<PageBuilder> pageBuilders, @Nullable FormatSelector formatter) {
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        log.debug("About to format node with skipLines formatter");
        SkipLinesFormatter skipLinesFormatter = new SkipLinesFormatter();
        Element element2 = element;
        Intrinsics.checkNotNull((Object)element2);
        Node node = (Node)element2;
        IStyle iStyle = style;
        Intrinsics.checkNotNull((Object)iStyle);
        FormatSelector formatSelector = formatter;
        Intrinsics.checkNotNull((Object)formatSelector);
        return skipLinesFormatter.format(node, iStyle, pageBuilders, formatSelector);
    }

    @NotNull
    public final Property getPageProperty(int braillePageNumber) {
        if (braillePageNumber % 2 == 0) {
            return Property.EVEN;
        }
        return Property.ODD;
    }

    @JvmStatic
    @NotNull
    public static final PageNumberPosition getPrintPageNumberAt(@NotNull PageSettings pageSettings, int braillePageNumber) {
        Intrinsics.checkNotNullParameter((Object)pageSettings, (String)"pageSettings");
        if (INSTANCE.getPageProperty(braillePageNumber) == Property.EVEN) {
            return pageSettings.getEvenPrintPageNumberAt();
        }
        return pageSettings.getOddPrintPageNumberAt();
    }

    @JvmStatic
    @NotNull
    public static final PageNumberPosition getBraillePageNumberAt(@NotNull PageSettings pageSettings, int braillePageNumber) {
        Intrinsics.checkNotNullParameter((Object)pageSettings, (String)"pageSettings");
        if (INSTANCE.getPageProperty(braillePageNumber) == Property.EVEN) {
            return pageSettings.getEvenBraillePageNumberAt();
        }
        return pageSettings.getOddBraillePageNumberAt();
    }

    public final boolean isDecimal(char input) {
        return switch (input) {
            case '#', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ';' -> true;
            default -> false;
        };
    }

    static {
        Logger logger = LoggerFactory.getLogger(PageBuilderHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/utd/utils/PageBuilderHelper$Property;", "", "<init>", "(Ljava/lang/String;I)V", "EVEN", "ODD", "utd"})
    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property EVEN = new Property();
        public static final /* enum */ Property ODD = new Property();
        private static final /* synthetic */ Property[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String value) {
            return Enum.valueOf(Property.class, value);
        }

        @NotNull
        public static EnumEntries<Property> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = propertyArray = new Property[]{Property.EVEN, Property.ODD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

