/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.exceptions.UTDTranslateException;
import org.brailleblaster.utd.properties.BrailleTableType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mwhapples.jlouis.Louis;
import org.mwhapples.jlouis.TranslationException;
import org.mwhapples.jlouis.TranslationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010!\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001:B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J8\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007JD\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002JD\u0010\u001d\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J,\u0010\u001e\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J,\u0010*\u001a\u00020+2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\rH\u0007J4\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u00102\u001a\u00020\u0012J\u0018\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0012H\u0002J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006;\u00b2\u0006\u0010\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00120=X\u008a\u0084\u0002"}, d2={"Lorg/brailleblaster/utd/utils/TextTranslator;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "translateText", "", "context", "Lorg/brailleblaster/utd/ITranslationEngine;", "typeForm", "", "tableType", "Lorg/brailleblaster/utd/properties/BrailleTableType;", "translateIndexedText", "Lkotlin/Pair;", "", "startEmp", "", "translateEmpText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "j", "emphasisArr", "", "i", "prvEmp", "emp", "tag", "stopEmp", "lastEmp", "ITALIC", "UNDERLINE", "BOLD", "SCRIPT", "TRANS_NOTE", "TRANS_1", "TRANS_2", "TRANS_3", "TRANS_4", "TRANS_5", "NO_CONTRACT", "translateTextWithEmpArray", "Lorg/brailleblaster/utd/utils/TextTranslator$TranslationEmpResult;", "replaceUnknownCharacters", "result", "Lorg/mwhapples/jlouis/TranslationResult;", "translator", "Lorg/mwhapples/jlouis/Louis;", "transTable", "mode", "findUnknownCharacters", "text", "fromIndex", "isHex", "", "hex", "", "TranslationEmpResult", "utd", "inputPos", ""})
@SourceDebugExtension(value={"SMAP\nTextTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextTranslator.kt\norg/brailleblaster/utd/utils/TextTranslator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1#2:275\n*E\n"})
public final class TextTranslator {
    @NotNull
    public static final TextTranslator INSTANCE = new TextTranslator();
    @NotNull
    private static final Logger log;
    private static final short ITALIC = 1;
    private static final short UNDERLINE = 2;
    private static final short BOLD = 4;
    private static final short SCRIPT = 8;
    private static final short TRANS_NOTE = 16;
    private static final short TRANS_1 = 32;
    private static final short TRANS_2 = 64;
    private static final short TRANS_3 = 128;
    private static final short TRANS_4 = 256;
    private static final short TRANS_5 = 512;
    private static final short NO_CONTRACT = 4096;

    private TextTranslator() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String translateText(@NotNull String translateText, @NotNull ITranslationEngine context, short typeForm, @NotNull BrailleTableType tableType) {
        Intrinsics.checkNotNullParameter((Object)translateText, (String)"translateText");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        return (String)INSTANCE.translateIndexedText(translateText, context, typeForm, tableType).getSecond();
    }

    public static /* synthetic */ String translateText$default(String string, ITranslationEngine iTranslationEngine, short s, BrailleTableType brailleTableType, int n, Object object) {
        if ((n & 4) != 0) {
            s = 0;
        }
        if ((n & 8) != 0) {
            brailleTableType = BrailleTableType.LITERARY;
        }
        return TextTranslator.translateText(string, iTranslationEngine, s, brailleTableType);
    }

    @JvmOverloads
    @NotNull
    public final Pair<int[], String> translateIndexedText(@NotNull String translateText, @NotNull ITranslationEngine context, short typeForm, @NotNull BrailleTableType tableType) {
        Intrinsics.checkNotNullParameter((Object)translateText, (String)"translateText");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        Louis translator = context.getBrailleTranslator();
        short[] emphasisArr = new short[translateText.length()];
        Arrays.fill(emphasisArr, typeForm);
        int mode = 68;
        if (context.getBrailleSettings().isUseAsciiBraille()) {
            mode = 0;
        }
        try {
            String transTable = tableType.getTableName(context.getBrailleSettings());
            TranslationResult transResult = translator.translate(transTable, translateText, emphasisArr, 0, mode);
            Intrinsics.checkNotNull((Object)transResult);
            return this.replaceUnknownCharacters(transResult, translator, transTable, mode);
        }
        catch (TranslationException e) {
            throw new UTDTranslateException("Problem with Braille translation, see log for details", e);
        }
    }

    public static /* synthetic */ Pair translateIndexedText$default(TextTranslator textTranslator, String string, ITranslationEngine iTranslationEngine, short s, BrailleTableType brailleTableType, int n, Object object) {
        if ((n & 4) != 0) {
            s = 0;
        }
        if ((n & 8) != 0) {
            brailleTableType = BrailleTableType.LITERARY;
        }
        return textTranslator.translateIndexedText(string, iTranslationEngine, s, brailleTableType);
    }

    private final int startEmp(StringBuilder translateEmpText, int j, short[] emphasisArr, int i, short prvEmp, short emp, String tag) {
        if ((prvEmp & emp) == 0 && (emphasisArr[i] & emp) == emp) {
            translateEmpText.insert(j, "\uf002" + tag + "\uf002");
            return tag.length() + 2;
        }
        return 0;
    }

    private final int stopEmp(StringBuilder translateEmpText, int j, short[] emphasisArr, int i, short prvEmp, short emp, String tag) {
        if ((prvEmp & emp) == emp && (emphasisArr[i] & emp) == 0) {
            translateEmpText.insert(j, "\uf003" + tag + "\uf003");
            return tag.length() + 2;
        }
        return 0;
    }

    private final int lastEmp(StringBuilder translateEmpText, short prvEmp, short emp, String tag) {
        if ((prvEmp & emp) == emp) {
            translateEmpText.append("\uf003").append(tag).append("\uf003");
            return tag.length() + 2;
        }
        return 0;
    }

    @JvmStatic
    @NotNull
    public static final TranslationEmpResult translateTextWithEmpArray(@Nullable String translateText, @NotNull ITranslationEngine context, @Nullable short[] emphasisArr, @NotNull BrailleTableType tableType) throws UTDTranslateException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        String translated = "";
        int[] indexInts = null;
        try {
            Louis translator = context.getBrailleTranslator();
            int mode = 68;
            if (context.getBrailleSettings().isUseAsciiBraille()) {
                mode = 0;
            }
            String transTable = tableType.getTableName(context.getBrailleSettings());
            log.debug("About to use tables \"{}\" to translate text \"{}\"", (Object)transTable, (Object)translateText);
            try {
                TranslationResult transResult = translator.translate(transTable, translateText, emphasisArr, 0, mode);
                Intrinsics.checkNotNull((Object)transResult);
                Pair<int[], String> indexAndTrans = INSTANCE.replaceUnknownCharacters(transResult, translator, transTable, mode);
                translated = (String)indexAndTrans.getSecond();
                log.debug("Translated text is: \"{}\"", (Object)translated);
                if (((CharSequence)translated).length() > 0) {
                    indexInts = (int[])indexAndTrans.getFirst();
                }
            }
            catch (IllegalArgumentException e) {
                log.error("FTSFP", (Throwable)e);
            }
        }
        catch (TranslationException e) {
            throw new UTDTranslateException("Problem with Braille translation, see log for details", e);
        }
        return new TranslationEmpResult(translated, indexInts);
    }

    @NotNull
    public final Pair<int[], String> replaceUnknownCharacters(@NotNull TranslationResult result, @NotNull Louis translator, @Nullable String transTable, int mode) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        int offset = 0;
        Lazy inputPos$delegate = LazyKt.lazy(() -> TextTranslator.replaceUnknownCharacters$lambda$0(result));
        String translation = result.getTranslation();
        while (true) {
            int i;
            String hex;
            String liblouisCharacter;
            int n;
            String string = translation;
            Intrinsics.checkNotNull((Object)string);
            int it22 = n = this.findUnknownCharacters(string, offset);
            int n2 = 0;
            offset = it22;
            if (n == -1) break;
            String it22 = translation;
            Intrinsics.checkNotNull((Object)it22);
            n2 = offset;
            int n3 = offset + 8;
            Intrinsics.checkNotNullExpressionValue((Object)it22.substring(n2, n3), (String)"substring(...)");
            if (liblouisCharacter.length() != 8) {
                throw new AssertionError((Object)("Not enouch chars |" + liblouisCharacter + "|"));
            }
            if (liblouisCharacter.charAt(liblouisCharacter.length() - 1) != '\'') {
                throw new AssertionError((Object)("Wrong end |" + liblouisCharacter + "|"));
            }
            if (liblouisCharacter.charAt(0) != '\'') {
                throw new AssertionError((Object)("Wrong start |" + liblouisCharacter + "|"));
            }
            Intrinsics.checkNotNullExpressionValue((Object)liblouisCharacter.substring(3, 7), (String)"substring(...)");
            if (hex.length() != 4) {
                throw new AssertionError((Object)("invalid |" + hex + "|"));
            }
            int actualChar = Integer.parseInt(hex, CharsKt.checkRadix((int)16));
            String unicodeName = Character.getName(actualChar);
            String alternateString = "\uf000" + unicodeName + "\uf001";
            String alternateTrans = null;
            try {
                TranslationResult alternateResult = translator.translate(transTable, alternateString, new short[0], 0, mode);
                String string2 = alternateResult.getTranslation();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTranslation(...)");
                alternateTrans = string2;
            }
            catch (Exception e) {
                throw new UTDTranslateException("Problem with Braille translation, see log for details", e);
            }
            int ref = 0;
            int n4 = offset + liblouisCharacter.length();
            for (i = offset; i < n4; ++i) {
                int next = ((Number)TextTranslator.replaceUnknownCharacters$lambda$1((Lazy<? extends List<Integer>>)inputPos$delegate).remove(offset)).intValue();
                if (i != offset && next != ref) {
                    throw new AssertionError((Object)("expected " + ref + " but found " + next + " for " + i + " | " + CollectionsKt.joinToString$default((Iterable)TextTranslator.replaceUnknownCharacters$lambda$1((Lazy<? extends List<Integer>>)inputPos$delegate), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
                }
                ref = next;
            }
            n4 = ((CharSequence)alternateTrans).length();
            for (i = 0; i < n4; ++i) {
                TextTranslator.replaceUnknownCharacters$lambda$1((Lazy<? extends List<Integer>>)inputPos$delegate).add(offset + i, ref);
            }
            String string3 = translation;
            Intrinsics.checkNotNull((Object)string3);
            translation = StringsKt.replaceFirst$default((String)string3, (String)liblouisCharacter, (String)alternateTrans, (boolean)false, (int)4, null);
            offset += alternateTrans.length();
        }
        return TuplesKt.to((Object)CollectionsKt.toIntArray((Collection)TextTranslator.replaceUnknownCharacters$lambda$1((Lazy<? extends List<Integer>>)inputPos$delegate)), (Object)translation);
    }

    private final int findUnknownCharacters(String text, int fromIndex) {
        int start = 0;
        int wordLength = -1;
        int n = text.length();
        block10: for (int i = fromIndex; i < n; ++i) {
            char cur = text.charAt(i);
            switch (cur) {
                case '\n': 
                case '\r': {
                    continue block10;
                }
                default: {
                    switch (wordLength) {
                        case -1: {
                            if (cur != '\'') continue block10;
                            start = i;
                            wordLength = 0;
                            continue block10;
                        }
                        case 0: {
                            wordLength = cur == '\\' ? 1 : -1;
                            continue block10;
                        }
                        case 1: {
                            wordLength = cur == 'x' ? wordLength + 1 : -1;
                            continue block10;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            wordLength = this.isHex(cur) ? wordLength + 1 : -1;
                            continue block10;
                        }
                        case 6: {
                            if (cur == '\'') {
                                return start;
                            }
                            wordLength = -1;
                        }
                    }
                }
            }
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHex(char hex) {
        boolean bl;
        if ('0' <= hex) {
            if (hex < ':') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('a' > hex) return false;
        if (hex >= 'g') return false;
        return true;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String translateText(@NotNull String translateText, @NotNull ITranslationEngine context, short typeForm) {
        Intrinsics.checkNotNullParameter((Object)translateText, (String)"translateText");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return TextTranslator.translateText$default(translateText, context, typeForm, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String translateText(@NotNull String translateText, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)translateText, (String)"translateText");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return TextTranslator.translateText$default(translateText, context, (short)0, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final Pair<int[], String> translateIndexedText(@NotNull String translateText, @NotNull ITranslationEngine context, short typeForm) {
        Intrinsics.checkNotNullParameter((Object)translateText, (String)"translateText");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return TextTranslator.translateIndexedText$default(this, translateText, context, typeForm, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Pair<int[], String> translateIndexedText(@NotNull String translateText, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)translateText, (String)"translateText");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return TextTranslator.translateIndexedText$default(this, translateText, context, (short)0, null, 12, null);
    }

    private static final List<Integer> replaceUnknownCharacters$lambda$1(Lazy<? extends List<Integer>> $inputPos$delegate) {
        Lazy<? extends List<Integer>> lazy = $inputPos$delegate;
        return (List)lazy.getValue();
    }

    private static final List replaceUnknownCharacters$lambda$0(TranslationResult $result) {
        int[] nArray = $result.getInputPos();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getInputPos(...)");
        return ArraysKt.toMutableList((int[])nArray);
    }

    static {
        Logger logger = LoggerFactory.getLogger(TextTranslator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/utd/utils/TextTranslator$TranslationEmpResult;", "", "translation", "", "dotsToCharsMap", "", "<init>", "(Ljava/lang/String;[I)V", "utd"})
    public static final class TranslationEmpResult {
        @JvmField
        @NotNull
        public String translation;
        @JvmField
        @Nullable
        public int[] dotsToCharsMap;

        public TranslationEmpResult(@NotNull String translation, @Nullable int[] dotsToCharsMap) {
            Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
            this.translation = translation;
            this.dotsToCharsMap = dotsToCharsMap;
        }
    }
}

