/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.utils;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.SortedMap;
import org.brailleblaster.libembosser.utils.CharMapperFunction;

public class BlockCharMapper
implements CharMapperFunction {
    private int[] starts;
    private String[] blocks;
    private int[] ends;

    public BlockCharMapper(char startChar, String mapToChars) {
        this((SortedMap<Integer, String>)ImmutableSortedMap.of((Comparable)Integer.valueOf(startChar), (Object)mapToChars));
    }

    private BlockCharMapper(SortedMap<Integer, String> mappings) {
        int prevEnd = 0;
        int size = mappings.size();
        this.starts = new int[size];
        this.blocks = new String[size];
        this.ends = new int[size];
        int i = 0;
        for (Map.Entry<Integer, String> entry : mappings.entrySet()) {
            int start = entry.getKey();
            String block = entry.getValue();
            int end = start + block.length();
            if (start < prevEnd) {
                throw new IllegalStateException("Overlapping blocks in input characters");
            }
            this.starts[i] = start;
            this.blocks[i] = block;
            this.ends[i] = end;
            prevEnd = end;
            ++i;
        }
    }

    @Override
    public char applyAsChar(char operand) {
        for (int i = 0; i < this.starts.length; ++i) {
            int startChar = this.starts[i];
            int endChar = this.ends[i];
            if (operand < startChar || operand >= endChar) continue;
            return this.blocks[i].charAt(operand - startChar);
        }
        return operand;
    }

    public static class Builder {
        private ImmutableSortedMap.Builder<Integer, String> mappingsBuilder = ImmutableSortedMap.naturalOrder();

        public Builder add(char startChar, String mapToChars) {
            this.mappingsBuilder.put((Object)startChar, (Object)mapToChars);
            return this;
        }

        public BlockCharMapper build() {
            return new BlockCharMapper((SortedMap)this.mappingsBuilder.build());
        }
    }
}

